/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.business.service.integrate.draft.exrate.handler;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.ConvertRuleCache;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.tmc.fbp.common.errorcode.TmcErrorCode;
import kd.tmc.fbp.common.exception.TmcBizException;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mrm.business.service.integrate.draft.common.BotpConvertor;
import kd.tmc.mrm.business.service.integrate.draft.common.DataGetContext;
import kd.tmc.mrm.business.service.integrate.draft.common.DataGetResult;
import kd.tmc.mrm.business.service.integrate.draft.common.DataGetTaskLog;
import kd.tmc.mrm.business.service.integrate.draft.exrate.handler.ExRateDataGetHandler;
import kd.tmc.mrm.common.entry.DraftCfgEntry;
import kd.tmc.mrm.common.enums.ExecStatusEnum;
import kd.tmc.mrm.common.helper.ExRateDraftBotpHelper;

public class ExRateDataGetBotpDefault
extends ExRateDataGetHandler {
    private static Log logger = LogFactory.getLog(ExRateDataGetBotpDefault.class);
    private static final int BOTP_MAX_COUNT = 500;
    private Long lastBatchNo = 0L;
    private Long currentBatchNo = 0L;
    private DraftCfgEntry mappingCfg;

    @Override
    public void initContext(DataGetContext ctx) {
        super.initContext(ctx);
        this.mappingCfg = ctx.getCurrentRuleCfg();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int doExtract() {
        logger.info("\u5f00\u59cb\u62bd\u53d6\u4ece{}\u5230{}\u7684\u6570\u636e", (Object)this.getSourceEntity(), (Object)this.getTargetEntity());
        long beginTime = System.currentTimeMillis();
        DataGetTaskLog taskLog = this.getContext().getTaskLog();
        Long logEntrykey = this.mappingCfg.getSourceId();
        taskLog.beginSubTaskLog(logEntrykey);
        Long lastId = 0L;
        int totalCount = 0;
        int failedTotalCount = 0;
        ArrayList<String> errorMsgs = new ArrayList<String>(100);
        try (TXHandle tx = TX.requiresNew();){
            try {
                List<Object> listIds;
                QFilter qFilter = this.getQFilter();
                BotpConvertor botpConvertor = new BotpConvertor(this.getSourceEntity(), this.getTargetEntity(), this.getBotpRuleId());
                this.checkBotpEnable();
                this.initBatchNo();
                while (!(listIds = this.nextBatchIds(qFilter, lastId)).isEmpty()) {
                    DataGetResult dataGetResult = botpConvertor.doConvert(listIds);
                    List<DynamicObject> targetObjs = dataGetResult.getSuccessObjs();
                    int failedCount = botpConvertor.getFailedCount();
                    List<String> errorMsgList = botpConvertor.getErrorMsg();
                    List<Object> failedBillIds = botpConvertor.getFailedBillIds();
                    List<Object> failedBillNos = botpConvertor.getFailedBillNos();
                    if (!EmptyUtil.isEmpty(errorMsgList)) {
                        for (int i = 0; i < errorMsgList.size(); ++i) {
                            if (errorMsgs.size() > 100) continue;
                            errorMsgs.add("id=" + failedBillIds.get(i) + ",billno=" + failedBillNos.get(i) + ",msg=" + errorMsgList.get(i) + ";\n");
                        }
                    }
                    this.doOtherConvert(targetObjs);
                    this.saveResult(targetObjs);
                    totalCount += targetObjs.size();
                    failedTotalCount += failedCount;
                    if (listIds.size() < this.getPageSize()) break;
                    lastId = (Long)listIds.get(listIds.size() - 1);
                }
                this.deleteOldDraftData();
                this.setDeleteCount(this.deleteDuplicateData());
                taskLog.endSubTaskLog(logEntrykey, totalCount, failedTotalCount, errorMsgs);
            }
            catch (Exception e) {
                tx.markRollback();
                taskLog.endSubTaskLog(logEntrykey, ExecStatusEnum.FAILED.getValue(), ResManager.loadKDString((String)"\u5931\u8d25\u539f\u56e0\uff1a%s", (String)"ExRateDraftDataGetBotpDefault_0", (String)"tmc-mrm-business", (Object[])new Object[]{ExceptionUtils.getExceptionStackTraceMessage((Exception)e)}), 0, 0);
                logger.error((Throwable)e);
            }
            finally {
                taskLog.persist(true);
            }
            long endTime = System.currentTimeMillis();
            logger.info("\u5b8c\u6210\u62bd\u53d6\u4ece{}\u5230{}\u7684\u6570\u636e\uff0c\u8017\u65f6{}ms, \u603b\u5171\u53d6\u6570\u6761\u6570{}", new Object[]{this.getSourceEntity(), this.getTargetEntity(), endTime - beginTime, totalCount});
        }
        return totalCount;
    }

    protected int deleteDuplicateData() {
        return 0;
    }

    protected int deleteDuplicateData(DynamicObject draftDO, String billType) {
        QFilter qfilter = new QFilter("exratedraft", "=", (Object)draftDO.getLong("id"));
        qfilter.and("billtype", "=", (Object)billType);
        int deleteCount = 0;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"", (String)"mrm_exrate_draft_data", (String)"id,billtype.id billtype,bankaccount.id bankaccount,currency.id currency", (QFilter[])qfilter.toArray(), (String)"");){
            if (!dataSet.isEmpty()) {
                GroupbyDataSet groupbyDataSet = dataSet.groupBy(new String[]{"billtype", "bankaccount", "currency"});
                DataSet ds = groupbyDataSet.count().groupConcat("id").finish().filter("count > 1");
                ArrayList<Long> idList = new ArrayList<Long>();
                for (Row row : ds) {
                    String[] ids;
                    String id = row.getString("id");
                    for (String s : ids = id.split(",")) {
                        idList.add(Long.valueOf(s));
                    }
                }
                if (!idList.isEmpty()) {
                    QFilter qFilter = new QFilter("id", "in", idList);
                    qFilter.and("bizdatasource", "in", (Object)new String[]{"import", "manual"});
                    deleteCount = DeleteServiceHelper.delete((String)"mrm_exrate_draft_data", (QFilter[])qFilter.toArray());
                }
            }
        }
        return deleteCount;
    }

    private void checkBotpEnable() {
        ConvertRuleElement convertRuleElement = ConvertRuleCache.loadRule((String)this.mappingCfg.getBotpRuleId());
        if (convertRuleElement == null) {
            throw new TmcBizException(TmcErrorCode.COMMON, (Object[])new String[]{ResManager.loadKDString((String)"\u8f6c\u6362\u89c4\u5219\u4e0d\u5b58\u5728\uff0c\u8bf7\u7ef4\u62a4\u6c47\u7387\u5e95\u7a3f\u914d\u7f6e\u3002", (String)"ExRateDraftDataGetBotpDefault_2", (String)"tmc-mrm-business", (Object[])new Object[0])});
        }
        if (!convertRuleElement.isEnabled()) {
            throw new TmcBizException(TmcErrorCode.COMMON, (Object[])new String[]{ResManager.loadKDString((String)"\u8be5\u8f6c\u6362\u89c4\u5219\u88ab\u7981\u7528\uff0c\u65e0\u6cd5\u4e0b\u63a8\u3002", (String)"ExRateDraftDataGetBotpDefault_1", (String)"tmc-mrm-business", (Object[])new Object[0])});
        }
    }

    private void deleteOldDraftData() {
        if (this.getContext().isUpdateExecType()) {
            DynamicObject draftDO = this.getContext().getDraftDO();
            String execType = this.getContext().getExecType();
            QFilter qf = new QFilter("exratedraft", "=", (Object)draftDO.getLong("id"));
            qf.and("billtype", "=", (Object)this.getSourceType());
            qf.and("synbatchno", "<", (Object)this.getCurrentBathNo());
            qf.and("bizdatasource", "not in", Arrays.asList("manual", "import"));
            DeleteServiceHelper.delete((String)"mrm_exrate_draft_data", (QFilter[])qf.toArray());
        }
    }

    private void initBatchNo() {
        if (!this.getContext().isUpdateExecType()) {
            return;
        }
        DynamicObject draftDO = this.getContext().getDraftDO();
        QFilter qf = new QFilter("exratedraft", "=", (Object)draftDO.getLong("id"));
        qf.and("billtype", "=", (Object)this.getSourceType());
        DynamicObject oneData = QueryServiceHelper.queryOne((String)"mrm_exrate_draft_data", (String)"synbatchno", (QFilter[])qf.toArray());
        if (oneData != null) {
            this.lastBatchNo = oneData.getLong("synbatchno");
            this.currentBatchNo = this.lastBatchNo + 1L;
        }
    }

    protected void removeEntryByCondi(DynamicObject targetObj) {
        DynamicObjectCollection cEntrys = targetObj.getDynamicObjectCollection("capcashflowentry");
        DynamicObjectCollection inEntrys = targetObj.getDynamicObjectCollection("incashflowtentry");
        cEntrys.removeIf(o -> EmptyUtil.isEmpty((BigDecimal)o.getBigDecimal("capamount")));
        inEntrys.removeIf(o -> EmptyUtil.isEmpty((BigDecimal)o.getBigDecimal("inamount")));
    }

    private void saveResult(List<DynamicObject> targetObjs) {
        if (EmptyUtil.isEmpty(targetObjs)) {
            return;
        }
        HashMap<String, DynamicObject> combineId2DOMap = new HashMap<String, DynamicObject>(targetObjs.size());
        for (DynamicObject targetObj : targetObjs) {
            combineId2DOMap.put(targetObj.getString("combineid"), targetObj);
            this.removeEntryByCondi(targetObj);
        }
        if (this.getContext().isUpdateExecType()) {
            QFilter qF = new QFilter("combineid", "in", combineId2DOMap.keySet());
            qF.and("exratedraft", "=", targetObjs.get(0).getDynamicObject("exratedraft").getPkValue());
            DynamicObjectCollection existObjs = QueryServiceHelper.query((String)"mrm_exrate_draft_data", (String)"id,combineid", (QFilter[])qF.toArray());
            ArrayList<Object> existIds = new ArrayList<Object>(existObjs.size());
            for (DynamicObject existObj : existObjs) {
                String combineId = existObj.getString("combineid");
                DynamicObject newObj = (DynamicObject)combineId2DOMap.get(combineId);
                if (newObj == null) continue;
                Object existId = existObj.get("id");
                newObj.set("id", existId);
                existIds.add(existId);
            }
            if (existIds.size() > 0) {
                DeleteServiceHelper.delete((String)"mrm_exrate_draft_data", (QFilter[])new QFilter[]{new QFilter("id", "in", existIds)});
            }
        }
        SaveServiceHelper.save((DynamicObject[])targetObjs.toArray(new DynamicObject[0]));
    }

    protected void doOtherConvert(List<DynamicObject> targetObjs) {
        this.genBillNo(targetObjs);
        this.setCounterParty(targetObjs);
    }

    protected void genBillNo(List<DynamicObject> targetObjs) {
        DynamicObject draftDO = this.getContext().getDraftDO();
        int batchNum = 100;
        ArrayList<DynamicObject> emptyBillNoObs = new ArrayList<DynamicObject>(batchNum);
        for (DynamicObject targetObj : targetObjs) {
            targetObj.set("exratedraft", (Object)draftDO);
            String bizbillno = targetObj.getString("bizbillno");
            if (EmptyUtil.isEmpty((String)bizbillno)) {
                emptyBillNoObs.add(targetObj);
                if (emptyBillNoObs.size() == batchNum) {
                    this.setNumberFromCodeRule(emptyBillNoObs);
                    emptyBillNoObs.clear();
                }
            } else {
                targetObj.set("billno", (Object)("HLDG-" + bizbillno));
            }
            this.assignBatchNo(targetObj);
            this.assignCombineId(targetObj);
        }
        if (!emptyBillNoObs.isEmpty()) {
            this.setNumberFromCodeRule(emptyBillNoObs);
        }
    }

    private void setNumberFromCodeRule(List<DynamicObject> billObs) {
        if (EmptyUtil.isEmpty(billObs)) {
            return;
        }
        String[] billNumbers = CodeRuleServiceHelper.getBatchNumber((String)"mrm_exrate_draft_data", (DynamicObject)billObs.get(0), null, (int)billObs.size());
        for (int i = 0; i < billNumbers.length; ++i) {
            billObs.get(i).set("billno", (Object)billNumbers[i]);
        }
    }

    protected QFilter getQFilter() {
        QFilter qFilter = null;
        ConvertRuleElement convertRuleElement = ConvertMetaServiceHelper.loadRule((String)this.getBotpRuleId());
        if (convertRuleElement != null) {
            FilterCondition filterCondition = convertRuleElement.getFilterPolicy().getCondition().getFilterCondition();
            MainEntityType dataType = EntityMetadataCache.getDataEntityType((String)this.getSourceEntity());
            FilterBuilder fb = new FilterBuilder(dataType, filterCondition, true);
            fb.buildFilter(true);
            qFilter = fb.getQFilter();
            return qFilter;
        }
        return qFilter;
    }

    protected void assignCombineId(DynamicObject draftDataDO) {
        String combineId = this.createCombineId(draftDataDO);
        draftDataDO.set("combineid", (Object)combineId);
    }

    protected void assignBatchNo(DynamicObject draftDataDO) {
        Long synbatchno = this.getCurrentBathNo();
        draftDataDO.set("synbatchno", (Object)synbatchno);
    }

    private Long getLastBatchNo() {
        return this.lastBatchNo;
    }

    private Long getCurrentBathNo() {
        return this.currentBatchNo;
    }

    protected String createCombineId(DynamicObject draftDataDO) {
        StringBuilder sb = new StringBuilder();
        sb.append(draftDataDO.getDynamicObject("billtype").getString("number"));
        sb.append('|');
        sb.append(draftDataDO.getLong("sourcebillid"));
        sb.append('|');
        sb.append(draftDataDO.getLong("sourcebillentryid"));
        sb.append('|');
        sb.append(draftDataDO.getString("fxcurrencydirect"));
        return sb.toString();
    }

    public Long getSourceId() {
        return this.mappingCfg.getSourceId();
    }

    public String getSourceType() {
        return this.mappingCfg.getSourceType();
    }

    @Override
    public String getSourceEntity() {
        return this.mappingCfg.getSourceEntity();
    }

    public String getTargetEntity() {
        return this.mappingCfg.getTargetEntity();
    }

    public String getBotpRuleId() {
        return this.mappingCfg.getBotpRuleId();
    }

    protected int getBotpMaxCount() {
        return 500;
    }

    protected void setCounterParty(List<DynamicObject> targetObjs) {
        HashSet<Long> supplierIdList = new HashSet<Long>();
        HashSet<Long> customerIdList = new HashSet<Long>();
        HashSet<Long> userIdList = new HashSet<Long>();
        HashMap supplierBizPartnerMap = new HashMap();
        HashMap customerBizPartnerMap = new HashMap();
        HashMap userMap = new HashMap();
        for (DynamicObject targetObj : targetObjs) {
            Object bizPartner = null;
            String cpacttype = targetObj.getString("srccpartytype");
            if ("bd_supplier".equals(cpacttype)) {
                supplierIdList.add(targetObj.getLong("srccpartyid"));
                continue;
            }
            if ("bd_customer".equals(cpacttype)) {
                customerIdList.add(targetObj.getLong("srccpartyid"));
                continue;
            }
            if (!"bos_user".equals(cpacttype)) continue;
            userIdList.add(targetObj.getLong("srccpartyid"));
        }
        if (!EmptyUtil.isEmpty(supplierIdList)) {
            ExRateDraftBotpHelper.getSupplierBizPartnerId(supplierBizPartnerMap, new ArrayList(supplierIdList));
        }
        if (!EmptyUtil.isEmpty(customerIdList)) {
            ExRateDraftBotpHelper.getCustomerBizPartnerId(customerBizPartnerMap, new ArrayList(customerIdList));
        }
        if (!EmptyUtil.isEmpty(userIdList)) {
            ExRateDraftBotpHelper.getBosUser(userMap, new ArrayList(userIdList));
        }
        for (DynamicObject targetObj : targetObjs) {
            DynamicObject bizPartner;
            String srccpartytype = targetObj.getString("srccpartytype");
            Long srccpartyid = targetObj.getLong("srccpartyid");
            if ("bd_supplier".equals(srccpartytype)) {
                bizPartner = (DynamicObject)supplierBizPartnerMap.get(srccpartyid);
                targetObj.set("counterparty", (Object)bizPartner);
                this.setCounterPartyText(targetObj, bizPartner);
                continue;
            }
            if ("bd_customer".equals(srccpartytype)) {
                bizPartner = (DynamicObject)customerBizPartnerMap.get(srccpartyid);
                targetObj.set("counterparty", (Object)bizPartner);
                this.setCounterPartyText(targetObj, bizPartner);
                continue;
            }
            if (!"bos_user".equals(srccpartytype)) continue;
            DynamicObject user = (DynamicObject)userMap.get(srccpartyid);
            this.setCounterPartyText(targetObj, user);
        }
    }

    private void setCounterPartyText(DynamicObject targetObj, DynamicObject counterParty) {
        if (EmptyUtil.isEmpty((DynamicObject)counterParty)) {
            targetObj.set("counterpartytext", null);
        } else {
            targetObj.set("counterpartytext", (Object)counterParty.getString("name"));
        }
    }
}

