/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.business.service.integrate.draft.exrate.handler;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.OptionsTradeTypeEnum;
import kd.tmc.fbp.common.enums.TradeDirectionEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mrm.business.service.integrate.draft.exrate.handler.ExRateDataGetBotpDefault;
import kd.tmc.mrm.common.helper.DataGetDefFilterHelper;

public class ExRateDataGetForex
extends ExRateDataGetBotpDefault {
    private static Log logger = LogFactory.getLog(ExRateDataGetForex.class);
    private final String FOREX_COMMON_FIELD = "id, billno, org, tradedirect, protecttype, counterparty.name counterpartyname, bizdate startdate, pair,fxquote, currency,sellcurrency,tradetype";
    private Map<Long, DynamicObject> currencyCache = new HashMap<Long, DynamicObject>(15);

    private String getTradeSelectField() {
        return "id, billno, org, tradedirect, protecttype, counterparty.name counterpartyname, bizdate startdate, pair,fxquote, currency,sellcurrency,tradetype";
    }

    private Map<Long, List<Map<String, Object>>> getId2TradeSetMap(List<Long> ids) {
        QFilter bzQF = new QFilter("restamt", ">", (Object)0);
        bzQF.and("exrate", "!=", (Object)0);
        bzQF.and("tradebillid", "in", ids);
        DataSet bzDS = QueryServiceHelper.queryDataSet((String)"query-trade-bizrecord", (String)"tm_bizrecord", (String)"id bizid, tradebillid, srcbizbill, restamt, exrate, bizdate, enddate bizendate, currency, swapdir,desc", (QFilter[])bzQF.toArray(), null);
        DataSet busiBillIdDS = bzDS.copy().where("srcbizbill>0").select("srcbizbill");
        ArrayList<Long> busiBillIds = new ArrayList<Long>(20);
        for (Row r : busiBillIdDS) {
            busiBillIds.add(r.getLong("srcbizbill"));
        }
        DataSet busiBillDS = QueryServiceHelper.queryDataSet((String)"query-trade-businessbill", (String)"tm_businessbill", (String)"id,bizdate", (QFilter[])new QFilter[]{new QFilter("id", "in", busiBillIds)}, null);
        bzDS = bzDS.leftJoin(busiBillDS).on("srcbizbill", "id").select(new String[]{"bizid", "tradebillid", "restamt", "exrate", "bizdate", "bizendate", "desc", "swapdir"}, new String[]{"bizdate as busi_bizdate"}).finish();
        QFilter fxQF = new QFilter("id", "in", ids);
        DataSet tradeDS = QueryServiceHelper.queryDataSet((String)"query-trade", (String)this.getSourceEntity(), (String)this.getTradeSelectField(), (QFilter[])fxQF.toArray(), null);
        DataSet tdDS = tradeDS.join(bzDS).on("id", "tradebillid").select(new String[]{"id", "billno", "org", "tradedirect", "protecttype", "counterpartyname", "startdate", "fxquote", "pair", "currency", "sellcurrency", "tradetype"}, new String[]{"bizid", "restamt", "exrate", "busi_bizdate", "bizdate", "bizendate", "desc", "swapdir"}).finish();
        return this.toId2TradeSetMap(tdDS);
    }

    private List<DynamicObject> rebuildFxDraftData(DynamicObject draftDO, Map<Long, List<Map<String, Object>>> idTradeMap) {
        Long tradeid = draftDO.getLong("sourcebillid");
        List<Map<String, Object>> rows = idTradeMap.get(tradeid);
        if (rows != null && rows.size() > 0) {
            return this.extendFxDraftData(draftDO, rows);
        }
        return null;
    }

    private boolean isBuyDir(String dir) {
        return TradeDirectionEnum.buy.getValue().equals(dir);
    }

    private List<DynamicObject> extendFxDraftData(DynamicObject draftDO, List<Map<String, Object>> rows) {
        int num = rows.size();
        ArrayList<DynamicObject> listDO = new ArrayList<DynamicObject>(num);
        for (int i = 0; i < num; ++i) {
            Map<String, Object> row;
            Date busiBizDate;
            DynamicObject buyDO = draftDO;
            if (i < num - 1) {
                buyDO = TmcDataServiceHelper.clone((DynamicObject)draftDO);
            }
            if ((busiBizDate = (Date)(row = rows.get(i)).get("busi_bizdate")) != null) {
                buyDO.set("startdate", (Object)busiBizDate);
            } else {
                buyDO.set("startdate", (Object)((Date)row.get("startdate")));
            }
            buyDO.set("sourcebillentryid", row.get("bizid"));
            BigDecimal rate = (BigDecimal)row.get("exrate");
            BigDecimal baseRemainAmt = (BigDecimal)row.get("restamt");
            BigDecimal quoteRemainAmt = BigDecimal.ZERO;
            String pair = (String)row.get("pair");
            String fxquote = (String)row.get("fxquote");
            quoteRemainAmt = EmptyUtil.isNotEmpty((CharSequence)pair) && pair.equals(fxquote) ? baseRemainAmt.multiply(rate).setScale(10, RoundingMode.HALF_UP) : baseRemainAmt.divide(rate, 10, RoundingMode.HALF_UP);
            String contracttype = (String)row.get("desc");
            Object bizEndDate = row.get("bizendate");
            Object endDate = bizEndDate == null ? row.get("bizdate") : bizEndDate;
            buyDO.set("enddate", endDate);
            buyDO.set("contracttype", (Object)contracttype);
            DynamicObject sellDO = TmcDataServiceHelper.clone((DynamicObject)buyDO);
            this.setBuyAndSellAmount(buyDO, sellDO, row, baseRemainAmt, quoteRemainAmt);
            buyDO.set("fxcurrencydirect", (Object)"buy");
            sellDO.set("fxcurrencydirect", (Object)"sell");
            this.addCapEntry(buyDO);
            this.addCapEntry(sellDO);
            listDO.add(buyDO);
            listDO.add(sellDO);
        }
        return listDO;
    }

    private void addCapEntry(DynamicObject draft) {
        DynamicObjectCollection capcashflowentry = draft.getDynamicObjectCollection("capcashflowentry");
        int size = capcashflowentry.size();
        DynamicObject dynamicObject = capcashflowentry.addNew();
        dynamicObject.set("seq", (Object)(size + 1));
        dynamicObject.set("capdate", (Object)draft.getDate("enddate"));
        dynamicObject.set("capamount", (Object)draft.getBigDecimal("amount"));
    }

    private void setBuyAndSellAmount(DynamicObject buyDO, DynamicObject sellDO, Map<String, Object> row, BigDecimal baseRemainAmt, BigDecimal quoteRemainAmt) {
        BigDecimal buyAmt = BigDecimal.ZERO;
        Long buyCurrencyId = 0L;
        BigDecimal sellAmt = BigDecimal.ZERO;
        Long sellCurrencyId = 0L;
        boolean baseCcyAsBuy = true;
        String tradedir = (String)row.get("tradedirect");
        if (this.isFxOption()) {
            String tradeType = (String)row.get("tradetype");
            baseCcyAsBuy = OptionsTradeTypeEnum.call.getValue().equals(tradeType) && this.isBuyDir(tradedir) || OptionsTradeTypeEnum.put.getValue().equals(tradeType) && !this.isBuyDir(tradedir);
        } else if (this.isFxSwap()) {
            String swapdir = (String)row.get("swapdir");
            baseCcyAsBuy = "isnear".equals(swapdir) ? this.isBuyDir(tradedir) : !this.isBuyDir(tradedir);
            sellDO.set("swapdir", (Object)swapdir);
            buyDO.set("swapdir", (Object)swapdir);
        } else {
            baseCcyAsBuy = this.isBuyDir(tradedir);
        }
        if (baseCcyAsBuy) {
            buyAmt = baseRemainAmt;
            buyCurrencyId = (Long)row.get("currency");
            sellAmt = quoteRemainAmt;
            sellCurrencyId = (Long)row.get("sellcurrency");
        } else {
            buyAmt = quoteRemainAmt;
            buyCurrencyId = (Long)row.get("sellcurrency");
            sellAmt = baseRemainAmt;
            sellCurrencyId = (Long)row.get("currency");
        }
        DynamicObject buyCurrency = this.getCurrencyById(buyCurrencyId);
        if (buyCurrency != null) {
            buyAmt = buyAmt.setScale(buyCurrency.getInt("amtprecision"), 4);
        }
        buyDO.set("amount", (Object)buyAmt);
        buyDO.set("currency", (Object)buyCurrency);
        DynamicObject sellCurrency = this.getCurrencyById(sellCurrencyId);
        if (sellCurrency != null) {
            sellAmt = sellAmt.setScale(sellCurrency.getInt("amtprecision"), 4);
        }
        sellDO.set("currency", (Object)sellCurrency);
        sellDO.set("amount", (Object)sellAmt);
    }

    private DynamicObject getCurrencyById(Long ccyId) {
        DynamicObject ccyDO = this.currencyCache.get(ccyId);
        if (ccyDO != null) {
            return ccyDO;
        }
        ccyDO = TmcDataServiceHelper.loadSingleFromCache((Object)ccyId, (String)"bd_currency");
        this.currencyCache.put(ccyId, ccyDO);
        return ccyDO;
    }

    @Override
    protected void doOtherConvert(List<DynamicObject> targetObjs) {
        super.setCounterParty(targetObjs);
        ArrayList<Long> tradeIds = new ArrayList<Long>(targetObjs.size());
        for (DynamicObject targetObj : targetObjs) {
            Long sourcebillid = targetObj.getLong("sourcebillid");
            tradeIds.add(sourcebillid);
        }
        Map<Long, List<Map<String, Object>>> idTradeMap = this.getId2TradeSetMap(tradeIds);
        if (idTradeMap == null || idTradeMap.isEmpty()) {
            targetObjs.clear();
            return;
        }
        ArrayList<DynamicObject> resultObjs = new ArrayList<DynamicObject>(targetObjs.size());
        for (DynamicObject targetObj : targetObjs) {
            List<DynamicObject> fxDrafts = this.rebuildFxDraftData(targetObj, idTradeMap);
            if (!EmptyUtil.isNoEmpty(fxDrafts)) continue;
            resultObjs.addAll(fxDrafts);
        }
        targetObjs.clear();
        targetObjs.addAll(resultObjs);
        this.genBillNo(targetObjs);
    }

    private Map<Long, List<Map<String, Object>>> toId2TradeSetMap(DataSet ds) {
        HashMap<Long, List<Map<String, Object>>> id2TradeSetMap = new HashMap<Long, List<Map<String, Object>>>(16);
        Iterator itr = ds.iterator();
        RowMeta rowMeta = ds.getRowMeta();
        while (itr.hasNext()) {
            Row row = (Row)itr.next();
            Long tradeid = row.getLong("id");
            Map rowData = rowMeta.toMap(row);
            if (id2TradeSetMap.containsKey(tradeid)) {
                ((List)id2TradeSetMap.get(tradeid)).add(rowData);
                continue;
            }
            ArrayList<Map> rows = new ArrayList<Map>(3);
            rows.add(rowData);
            id2TradeSetMap.put(tradeid, rows);
        }
        return id2TradeSetMap;
    }

    private boolean isFxOption() {
        return "tm_forex_options".equals(this.getSourceEntity());
    }

    private boolean isFxSwap() {
        return "tm_forex_swaps".equals(this.getSourceEntity());
    }

    @Override
    protected QFilter getQFilter() {
        QFilter cusQF = super.getQFilter();
        QFilter defQF = DataGetDefFilterHelper.getDefQFilter((String)this.getSourceEntity(), (String)this.getSourceType());
        defQF.and(cusQF);
        return defQF;
    }
}

