/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.business.service.integrate.draft.intrate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.botp.ConvertRuleCache;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.tmc.fbp.common.errorcode.TmcErrorCode;
import kd.tmc.fbp.common.exception.TmcBizException;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mrm.business.service.integrate.draft.common.BotpConvertor;
import kd.tmc.mrm.business.service.integrate.draft.common.DataGetContext;
import kd.tmc.mrm.business.service.integrate.draft.common.DataGetParam;
import kd.tmc.mrm.business.service.integrate.draft.common.DataGetResult;
import kd.tmc.mrm.business.service.integrate.draft.common.DataGetTaskLog;
import kd.tmc.mrm.business.service.integrate.draft.common.IdPaginator;
import kd.tmc.mrm.business.service.integrate.draft.common.QFilterHelper;
import kd.tmc.mrm.common.entry.DraftCfgEntry;
import kd.tmc.mrm.common.enums.ExecOpEnum;
import kd.tmc.mrm.common.enums.ExecStatusEnum;
import kd.tmc.mrm.common.enums.RateBillTypeEnum;
import kd.tmc.mrm.common.enums.RateTypeEnum;
import kd.tmc.mrm.common.helper.DataGetDefFilterHelper;

public class IntRateDataGetHandler {
    private static Log logger = LogFactory.getLog(IntRateDataGetHandler.class);
    private DataGetContext context;
    private IdPaginator idPaginator;
    private BotpConvertor botpConvertor;
    private DraftCfgEntry mappingCfg;

    public DataGetContext getContext() {
        return this.context;
    }

    public void initContext(DataGetContext ctx) {
        this.context = ctx;
        this.mappingCfg = ctx.getCurrentRuleCfg();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doDataGet(boolean newTrans) {
        int totalCount = 0;
        if (newTrans) {
            DataGetTaskLog taskLog = this.getContext().getTaskLog();
            Long logEntrykey = this.mappingCfg.getSourceId();
            taskLog.beginSubTaskLog(logEntrykey);
            ArrayList<String> errorMsgs = new ArrayList<String>(100);
            try (TXHandle tx = TX.requiresNew((String)"mrm.dataget.reqnew");){
                try {
                    totalCount = this.doDataGet();
                    int failedCount = this.botpConvertor.getFailedCount();
                    List<String> errorMsgList = this.botpConvertor.getErrorMsg();
                    List<Object> failedBillIds = this.botpConvertor.getFailedBillIds();
                    List<Object> failedBillNos = this.botpConvertor.getFailedBillNos();
                    if (!EmptyUtil.isEmpty(errorMsgList)) {
                        for (int i = 0; i < errorMsgList.size(); ++i) {
                            if (errorMsgs.size() > 100) continue;
                            errorMsgs.add("id=" + failedBillIds.get(i) + ",billno=" + failedBillNos.get(i) + ",msg=" + errorMsgList.get(i) + ";\n");
                        }
                    }
                    taskLog.endSubTaskLog(logEntrykey, totalCount, failedCount, errorMsgs);
                }
                catch (Exception e) {
                    tx.markRollback();
                    taskLog.endSubTaskLog(logEntrykey, ExecStatusEnum.FAILED.getValue(), ResManager.loadKDString((String)"\u5931\u8d25\u539f\u56e0\uff1a%s", (String)"ExRateDraftDataGetBotpDefault_0", (String)"tmc-mrm-business", (Object[])new Object[]{ExceptionUtils.getExceptionStackTraceMessage((Exception)e)}), 0, 0);
                    logger.error((Throwable)e);
                }
                finally {
                    taskLog.persist(true);
                }
            }
        } else {
            try (TXHandle tx = TX.required();){
                totalCount = this.doDataGet();
            }
        }
        return totalCount;
    }

    protected int doDataGet() {
        List<Object> listIds;
        logger.info("\u5f00\u59cb\u62bd\u53d6\u4ece{}\u5230{}\u7684\u6570\u636e", (Object)this.getSourceEntity(), (Object)this.getTargetEntity());
        long beginTime = System.currentTimeMillis();
        QFilter qFilter = this.getQFilter();
        this.idPaginator = IdPaginator.createPaginatorBy(this.getSourceEntity(), qFilter);
        this.botpConvertor = new BotpConvertor(this.getSourceEntity(), this.getTargetEntity(), this.getBotpRuleId());
        int totalCount = 0;
        this.checkBotpEnable();
        this.deleteOldDatas();
        while (!(listIds = this.idPaginator.nextPageIds()).isEmpty()) {
            DataGetResult dataGetResult = this.botpConvertor.doConvert(listIds);
            List<DynamicObject> targetObjs = dataGetResult.getSuccessObjs();
            this.doOtherConvert(targetObjs);
            this.saveResult(targetObjs);
            totalCount += targetObjs.size();
            if (this.idPaginator.hasNext()) continue;
        }
        long endTime = System.currentTimeMillis();
        logger.info("\u5b8c\u6210\u62bd\u53d6\u4ece{}\u5230{}\u7684\u6570\u636e\uff0c\u8017\u65f6{}ms, \u603b\u5171\u53d6\u6570\u6761\u6570{}", new Object[]{this.getSourceEntity(), this.getTargetEntity(), endTime - beginTime, totalCount});
        return totalCount;
    }

    private void deleteOldDatas() {
        DataGetParam param = this.getContext().getParam();
        if (ExecOpEnum.isInratedraft_update((String)param.getExecOpEnum().getValue())) {
            Long draftId = param.getDraftId();
            QFilter qFilter = new QFilter("ratedraft", "=", (Object)draftId);
            qFilter.and("billtype.number", "=", (Object)this.getContext().getCurrentRuleCfg().getSourceType());
            qFilter.and("bizdatasource", "not in", Arrays.asList("manual", "import"));
            DeleteServiceHelper.delete((String)"mrm_rate_draft_data", (QFilter[])qFilter.toArray());
        }
    }

    private void checkBotpEnable() {
        ConvertRuleElement convertRuleElement = ConvertRuleCache.loadRule((String)this.mappingCfg.getBotpRuleId());
        if (convertRuleElement == null) {
            throw new TmcBizException(TmcErrorCode.COMMON, (Object[])new String[]{ResManager.loadKDString((String)"\u8f6c\u6362\u89c4\u5219\u4e0d\u5b58\u5728\uff0c\u8bf7\u7ef4\u62a4\u5229\u7387\u5e95\u7a3f\u914d\u7f6e\u3002", (String)"IntRateDataGetHandler_0", (String)"tmc-mrm-business", (Object[])new Object[0])});
        }
        if (!convertRuleElement.isEnabled()) {
            throw new TmcBizException(TmcErrorCode.COMMON, (Object[])new String[]{ResManager.loadKDString((String)"\u8be5\u8f6c\u6362\u89c4\u5219\u88ab\u7981\u7528\uff0c\u65e0\u6cd5\u4e0b\u63a8\u3002", (String)"ExRateDraftDataGetBotpDefault_1", (String)"tmc-mrm-business", (Object[])new Object[0])});
        }
    }

    private void saveResult(List<DynamicObject> targetObjs) {
        if (EmptyUtil.isEmpty(targetObjs)) {
            return;
        }
        SaveServiceHelper.save((DynamicObject[])targetObjs.toArray(new DynamicObject[0]));
    }

    protected void doOtherConvert(List<DynamicObject> targetObjs) {
        DynamicObject draftDO = this.getContext().getDraftDO();
        for (DynamicObject draftObject : targetObjs) {
            draftObject.set("ratedraft", (Object)draftDO);
            if (RateTypeEnum.FIXED.getValue().equals(draftObject.get("ratetype"))) {
                draftObject.set("referencerate", null);
            }
            if (!RateTypeEnum.FLOAT.getValue().equals(draftObject.get("ratetype")) || RateBillTypeEnum.isFinsubscribeBIllType((String)this.getSourceEntity())) continue;
            draftObject.set("fixrate", null);
        }
        this.generateBillNo(targetObjs);
    }

    protected void generateBillNo(List<DynamicObject> targetObjs) {
        int batchNum = 100;
        ArrayList<DynamicObject> emptyBillNoObs = new ArrayList<DynamicObject>(batchNum);
        for (DynamicObject targetObj : targetObjs) {
            String bizbillno = targetObj.getString("bizbillno");
            if (EmptyUtil.isEmpty((String)bizbillno)) {
                emptyBillNoObs.add(targetObj);
                if (emptyBillNoObs.size() != batchNum) continue;
                this.setNumberFromCodeRule(emptyBillNoObs);
                emptyBillNoObs.clear();
                continue;
            }
            targetObj.set("billno", (Object)("LLDG-" + bizbillno));
        }
        if (!emptyBillNoObs.isEmpty()) {
            this.setNumberFromCodeRule(emptyBillNoObs);
        }
    }

    private void setNumberFromCodeRule(List<DynamicObject> billObs) {
        if (EmptyUtil.isEmpty(billObs)) {
            return;
        }
        String[] billNumbers = CodeRuleServiceHelper.getBatchNumber((String)"mrm_rate_draft_data", (DynamicObject)billObs.get(0), null, (int)billObs.size());
        for (int i = 0; i < billNumbers.length; ++i) {
            billObs.get(i).set("billno", (Object)billNumbers[i]);
        }
    }

    protected QFilter getQFilter() {
        QFilter qFilter = QFilterHelper.getBotpFilter(this.getSourceEntity(), this.getBotpRuleId());
        QFilter defQF = DataGetDefFilterHelper.getDefQFilter((String)this.getSourceEntity(), (String)this.getSourceType());
        if (qFilter != null) {
            return qFilter.and(defQF);
        }
        return defQF;
    }

    public Long getSourceId() {
        return this.mappingCfg.getSourceId();
    }

    public String getSourceType() {
        return this.mappingCfg.getSourceType();
    }

    public String getSourceEntity() {
        return this.mappingCfg.getSourceEntity();
    }

    public String getTargetEntity() {
        return this.mappingCfg.getTargetEntity();
    }

    public String getBotpRuleId() {
        return this.mappingCfg.getBotpRuleId();
    }

    public IdPaginator getIdPaginator() {
        return this.idPaginator;
    }
}

