/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.business.service.integrate.draft.intrate;

import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mrm.business.service.integrate.draft.common.DataGetContext;
import kd.tmc.mrm.business.service.integrate.draft.common.DataGetParam;
import kd.tmc.mrm.business.service.integrate.draft.common.DataGetTaskLog;
import kd.tmc.mrm.business.service.integrate.draft.common.DraftCfgParser;
import kd.tmc.mrm.business.service.integrate.draft.intrate.IntRateDataGetHandler;
import kd.tmc.mrm.business.service.integrate.draft.intrate.IntRateDataGetHandlerFactory;
import kd.tmc.mrm.common.entry.DraftCfgEntry;
import kd.tmc.mrm.common.enums.DraftLogTypeEnum;
import kd.tmc.mrm.common.enums.DraftStatusEnum;
import kd.tmc.mrm.common.enums.ExecObjEnum;
import kd.tmc.mrm.common.enums.ExecOpEnum;
import kd.tmc.mrm.common.enums.ExecStatusEnum;
import kd.tmc.mrm.common.helper.ResManagerHelper;

public class IntRateDataGetService {
    private static Log logger = LogFactory.getLog(IntRateDataGetService.class);
    private static final String LOCKID = "inrate_drafttask_lockid";
    private static final String LOCKKEY = "GetInRateDraftData";
    private DynamicObject intRateDraftDO;
    private DataGetTaskLog taskLog = DataGetTaskLog.createTaskLog();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(DataGetParam param) {
        boolean isLock = MutexServiceHelper.request((String)LOCKID, (String)"mrm_rate_draft", (String)LOCKKEY);
        try {
            if (isLock) {
                this.doExecute(param);
            } else {
                Long draftId = param.getDraftId();
                DynamicObject draft = null;
                if (draftId != null && draftId > 0L) {
                    draft = TmcDataServiceHelper.loadSingle((Object)draftId, (String)"mrm_rate_draft");
                }
                DataGetTaskLog.createFailLog(draft, param.getTaskId(), DraftLogTypeEnum.INRATE.getValue(), ExecObjEnum.INRATE_DRAFT.getValue(), param.getExecTypeEnum().getValue(), DateUtils.getCurrentDate(), param.getExecOpEnum().getValue(), ResManagerHelper.getLocalString((LocaleString)ResManager.getLocaleString((String)"\u83b7\u53d6\u4e0d\u5230\u7f51\u7edc\u4e92\u65a5\uff0c\u53ef\u80fd\u5b58\u5728\u6b63\u5728\u6267\u884c\u7684\u4efb\u52a1\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ExRateDataGetService_7", (String)"tmc-mrm-business"), (Object[])new Object[0]));
            }
        }
        finally {
            if (isLock) {
                MutexServiceHelper.release((String)LOCKID, (String)"mrm_rate_draft", (String)LOCKKEY);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doExecute(DataGetParam param) throws KDException {
        boolean hasError;
        block30: {
            List<DraftCfgEntry> ruleCfgEntryList;
            String execType = param.getExecTypeEnum().getValue();
            this.taskLog.initMainTask(param.getTaskId(), DraftLogTypeEnum.INRATE.getValue(), ExecObjEnum.INRATE_DRAFT.getValue(), param.getExecTypeEnum().getValue(), DateUtils.getCurrentDate(), param.getExecOpEnum().getValue());
            try {
                DynamicObject draftCfg = this.readDraftCfg();
                ruleCfgEntryList = DraftCfgParser.parseInrateRuleCfg(draftCfg, IntRateDataGetService.getTargetEntity(), param);
                if (EmptyUtil.isEmpty(ruleCfgEntryList)) {
                    logger.info("\u6ca1\u6709\u914d\u7f6e\u6570\u636e\u6e90\u3002");
                    this.taskLog.endTaskLog(ExecStatusEnum.FAILED.getValue(), ResManagerHelper.getLocalString((LocaleString)ResManager.getLocaleString((String)"\u6ca1\u6709\u914d\u7f6e\u6570\u636e\u6e90\u3002", (String)"ExRateDataGetService_2", (String)"tmc-mrm-business"), (Object[])new Object[0]));
                    this.taskLog.persist(true);
                    return;
                }
            }
            catch (Exception e) {
                this.taskLog.endTaskLog(ExecStatusEnum.FAILED.getValue(), new LocaleString(e.getMessage()));
                this.taskLog.persist(true);
                return;
            }
            LocaleString errMsg = this.checkIfTaskRunning(param);
            if (errMsg != null) {
                this.taskLog.endTaskLog(ExecStatusEnum.FAILED.getValue(), errMsg);
                this.taskLog.persist(true);
                return;
            }
            hasError = false;
            int totalCount = 0;
            this.intRateDraftDO = this.buildRateDraft(param);
            this.taskLog.initSubTask(ruleCfgEntryList);
            this.taskLog.initDraft(this.intRateDraftDO);
            try (TXHandle tx = TX.requiresNew();){
                block29: {
                    try {
                        for (DraftCfgEntry cfg : ruleCfgEntryList) {
                            IntRateDataGetHandler handler = IntRateDataGetHandlerFactory.createDraftDataGetHandler(cfg);
                            DataGetContext cxt = new DataGetContext();
                            cxt.setDraftDO(this.intRateDraftDO);
                            cxt.setParam(param);
                            cxt.setCurrentRuleCfg(cfg);
                            cxt.setExecType(execType);
                            cxt.setTaskLog(this.taskLog);
                            handler.initContext(cxt);
                            int count = handler.doDataGet(true);
                            this.insertDraftEntry(this.intRateDraftDO, cfg.getSourceId(), count);
                            totalCount += count;
                        }
                        if (hasError) break block29;
                    }
                    catch (Exception e) {
                        block31: {
                            try {
                                tx.markRollback();
                                hasError = true;
                                this.taskLog.endTaskLog(ExecStatusEnum.FAILED.getValue(), this.failedMsg(e));
                                this.taskLog.persist(true);
                                logger.error((Throwable)e);
                                if (hasError) break block31;
                            }
                            catch (Throwable throwable) {
                                if (!hasError) {
                                    if (ExecOpEnum.isInratedraft_update((String)param.getExecOpEnum().getValue())) {
                                        this.taskLog.endTaskLog(null, ResManagerHelper.getLocalString((LocaleString)ResManager.getLocaleString((String)"\u672c\u6b21\u6210\u529f\u66f4\u65b0\u5e95\u7a3f\u5171\u3010%s\u3011\u6761\u5b58\u7eed\u5229\u7387\u4e1a\u52a1\u660e\u7ec6\u3002", (String)"IntRateDataGetService_9", (String)"tmc-mrm-business"), (Object[])new Object[]{totalCount}));
                                    } else {
                                        this.taskLog.endTaskLog(null, ResManagerHelper.getLocalString((LocaleString)ResManager.getLocaleString((String)"\u672c\u6b21\u6210\u529f\u53d6\u6570\u5171\u3010%s\u3011\u6761\u5b58\u7eed\u5229\u7387\u4e1a\u52a1\u660e\u7ec6\u3002", (String)"IntRateDataGetService_4", (String)"tmc-mrm-business"), (Object[])new Object[]{totalCount}));
                                    }
                                    this.taskLog.persist(true);
                                }
                                this.intRateDraftDO.set("draftstatus", (Object)DraftStatusEnum.FINISH.getValue());
                                this.intRateDraftDO.set("modifytime", (Object)new Date());
                                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.intRateDraftDO});
                                throw throwable;
                            }
                            if (ExecOpEnum.isInratedraft_update((String)param.getExecOpEnum().getValue())) {
                                this.taskLog.endTaskLog(null, ResManagerHelper.getLocalString((LocaleString)ResManager.getLocaleString((String)"\u672c\u6b21\u6210\u529f\u66f4\u65b0\u5e95\u7a3f\u5171\u3010%s\u3011\u6761\u5b58\u7eed\u5229\u7387\u4e1a\u52a1\u660e\u7ec6\u3002", (String)"IntRateDataGetService_9", (String)"tmc-mrm-business"), (Object[])new Object[]{totalCount}));
                            } else {
                                this.taskLog.endTaskLog(null, ResManagerHelper.getLocalString((LocaleString)ResManager.getLocaleString((String)"\u672c\u6b21\u6210\u529f\u53d6\u6570\u5171\u3010%s\u3011\u6761\u5b58\u7eed\u5229\u7387\u4e1a\u52a1\u660e\u7ec6\u3002", (String)"IntRateDataGetService_4", (String)"tmc-mrm-business"), (Object[])new Object[]{totalCount}));
                            }
                            this.taskLog.persist(true);
                        }
                        this.intRateDraftDO.set("draftstatus", (Object)DraftStatusEnum.FINISH.getValue());
                        this.intRateDraftDO.set("modifytime", (Object)new Date());
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.intRateDraftDO});
                        break block30;
                    }
                    if (ExecOpEnum.isInratedraft_update((String)param.getExecOpEnum().getValue())) {
                        this.taskLog.endTaskLog(null, ResManagerHelper.getLocalString((LocaleString)ResManager.getLocaleString((String)"\u672c\u6b21\u6210\u529f\u66f4\u65b0\u5e95\u7a3f\u5171\u3010%s\u3011\u6761\u5b58\u7eed\u5229\u7387\u4e1a\u52a1\u660e\u7ec6\u3002", (String)"IntRateDataGetService_9", (String)"tmc-mrm-business"), (Object[])new Object[]{totalCount}));
                    } else {
                        this.taskLog.endTaskLog(null, ResManagerHelper.getLocalString((LocaleString)ResManager.getLocaleString((String)"\u672c\u6b21\u6210\u529f\u53d6\u6570\u5171\u3010%s\u3011\u6761\u5b58\u7eed\u5229\u7387\u4e1a\u52a1\u660e\u7ec6\u3002", (String)"IntRateDataGetService_4", (String)"tmc-mrm-business"), (Object[])new Object[]{totalCount}));
                    }
                    this.taskLog.persist(true);
                }
                this.intRateDraftDO.set("draftstatus", (Object)DraftStatusEnum.FINISH.getValue());
                this.intRateDraftDO.set("modifytime", (Object)new Date());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.intRateDraftDO});
            }
        }
        if (!hasError) {
            this.updateAnalysisObj(param);
        }
    }

    private LocaleString failedMsg(Exception e) {
        return ResManagerHelper.getLocalString((LocaleString)ResManager.getLocaleString((String)"\u5931\u8d25\u539f\u56e0\uff1a%s", (String)"IntRateDataGetService_2", (String)"tmc-mrm-business"), (Object[])new Object[]{ExceptionUtils.getExceptionStackTraceMessage((Exception)e)});
    }

    protected LocaleString checkIfTaskRunning(DataGetParam param) {
        LocaleString msg = null;
        if (ExecOpEnum.isInratedraft_update((String)param.getExecOpEnum().getValue())) {
            Long draftId = param.getDraftId();
            QFilter filter = new QFilter("id", "=", (Object)draftId);
            DynamicObject draft = QueryServiceHelper.queryOne((String)"mrm_rate_draft", (String)"billno,draftstatus", (QFilter[])filter.toArray());
            if (draft != null) {
                String draftStatus = draft.getString("draftstatus");
                if (DraftStatusEnum.RUNNING.getValue().equals(draftStatus)) {
                    msg = ResManager.getLocaleString((String)"\u53d6\u6570\u5931\u8d25\uff0c\u5b58\u5728\u6b63\u5728\u6267\u884c\u7684\u5e95\u7a3f\u53d6\u6570\u4efb\u52a1\uff0c\u8bf7\u7ed3\u675f\u540e\u518d\u8bd5\u3002", (String)"ExRateDataGetService_3", (String)"tmc-mrm-business");
                }
            }
        } else {
            QFilter filter = new QFilter("draftcreatetime", "=", (Object)DateUtils.getCurrentDate());
            DynamicObject draft = QueryServiceHelper.queryOne((String)"mrm_rate_draft", (String)"billno,draftstatus", (QFilter[])filter.toArray());
            if (draft != null) {
                msg = ResManager.getLocaleString((String)"\u5f53\u524d\u7cfb\u7edf\u65e5\u671f\u5df2\u5b58\u5728\u5229\u7387\u5e95\u7a3f\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u6267\u884c\u3002", (String)"IntRateDataGetService_7", (String)"tmc-mrm-business");
            }
        }
        return msg;
    }

    private void insertDraftEntry(DynamicObject draft, Long sourceId, int count) {
        if (draft == null) {
            return;
        }
        DynamicObjectCollection entries = draft.getDynamicObjectCollection("entryentity");
        boolean insert = true;
        for (DynamicObject entry : entries) {
            DynamicObject data;
            Long datasourceId;
            Object datasource = entry.get("datasource");
            if (datasource instanceof Long && (datasourceId = (Long)datasource).equals(sourceId)) {
                entry.set("count", (Object)count);
                insert = false;
            }
            if (!(datasource instanceof DynamicObject) || (data = (DynamicObject)datasource).getLong("id") != sourceId.longValue()) continue;
            entry.set("count", (Object)count);
            insert = false;
        }
        if (insert) {
            DynamicObject dynamicObject = entries.addNew();
            dynamicObject.set("datasource", (Object)sourceId);
            dynamicObject.set("count", (Object)count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAnalysisObj(DataGetParam param) {
        QFilter filter = null;
        filter = !ExecOpEnum.isExratedraft_update((String)param.getExecOpEnum().getValue()) ? new QFilter("enable", "=", (Object)"1").and("isautoupdate", "=", (Object)"1") : new QFilter("isautoupdate", "=", (Object)"1").or("draft", "=", (Object)this.intRateDraftDO.getLong("id"));
        DataGetTaskLog anlTaskLog = DataGetTaskLog.createTaskLog();
        anlTaskLog.initMainTask("", DraftLogTypeEnum.INRATE.getValue(), ExecObjEnum.INRATE_ANALYSISOBJ.getValue(), param.getExecTypeEnum().getValue(), DateUtils.getCurrentDate(), param.getExecOpEnum().getValue());
        anlTaskLog.initDraft(this.intRateDraftDO);
        anlTaskLog.persist(true);
        try (TXHandle tx = TX.requiresNew();){
            try {
                Object[] anlyObjs = TmcDataServiceHelper.load((String)"mrm_analysisobj", (String)"draft,isautoupdate,modifytime", (QFilter[])(filter == null ? new QFilter[]{} : filter.toArray()));
                if (EmptyUtil.isEmpty((Object[])anlyObjs) || anlyObjs.length == 0) {
                    anlTaskLog.endTaskLog(ExecStatusEnum.SUCCESSFUL.getValue(), ResManagerHelper.getLocalString((LocaleString)ResManager.getLocaleString((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u9700\u8981\u66f4\u65b0\u7684\u5206\u6790\u5bf9\u8c61\u3002", (String)"IntRateDataGetService_3", (String)"tmc-mrm-business"), (Object[])new Object[0]));
                } else {
                    int count = 0;
                    long currDraftId = this.intRateDraftDO.getLong("id");
                    for (Object analysisObj : anlyObjs) {
                        long draftId = 0L;
                        if (!ExecOpEnum.isExratedraft_update((String)param.getExecOpEnum().getValue())) {
                            draftId = this.intRateDraftDO.getLong("id");
                            analysisObj.set("draft", (Object)draftId);
                        } else {
                            DynamicObject draft = analysisObj.getDynamicObject("draft");
                            if (draft != null) {
                                draftId = draft.getLong("id");
                            }
                        }
                        boolean isautoupdate = analysisObj.getBoolean("isautoupdate");
                        if (isautoupdate || draftId == currDraftId) {
                            ++count;
                        }
                        analysisObj.set("modifytime", (Object)new Date());
                    }
                    SaveServiceHelper.save((DynamicObject[])anlyObjs);
                    anlTaskLog.endTaskLog(ExecStatusEnum.SUCCESSFUL.getValue(), ResManagerHelper.getLocalString((LocaleString)ResManager.getLocaleString((String)"\u5e95\u7a3f\u7248\u672c\u6570\u636e\u66f4\u65b0\uff0c\u7cfb\u7edf\u81ea\u52a8\u66f4\u65b0\u3010%s\u3011\u6761\u5229\u7387\u4e1a\u52a1\u5206\u6790\u5bf9\u8c61\u3002", (String)"IntRateDataGetService_8", (String)"tmc-mrm-business"), (Object[])new Object[]{count}));
                }
            }
            catch (Exception e) {
                tx.markRollback();
                anlTaskLog.endTaskLog(ExecStatusEnum.FAILED.getValue(), this.failedMsg(e));
                logger.error((Throwable)e);
            }
            finally {
                anlTaskLog.persist(true);
            }
        }
    }

    private DynamicObject buildRateDraft(DataGetParam param) {
        Long draftid = param.getDraftId();
        if (draftid != null && draftid > 0L) {
            DynamicObject intRateDraft = TmcDataServiceHelper.loadSingle((Object)draftid, (String)"mrm_rate_draft");
            intRateDraft.set("draftstatus", (Object)DraftStatusEnum.RUNNING.getValue());
            this.save(intRateDraft, true);
            return intRateDraft;
        }
        DynamicObject intRateDraft = BusinessDataServiceHelper.newDynamicObject((String)"mrm_rate_draft");
        long id = DBServiceHelper.genGlobalLongId();
        intRateDraft.set("id", (Object)id);
        String billNo = CodeRuleServiceHelper.getNumber((String)"mrm_rate_draft", (DynamicObject)intRateDraft, null);
        intRateDraft.set("billno", (Object)billNo);
        intRateDraft.set("billstatus", (Object)TcBillStatusEnum.AUDIT.getValue());
        intRateDraft.set("creator", (Object)RequestContext.get().getCurrUserId());
        intRateDraft.set("draftcreatetime", (Object)DateUtils.getCurrentDate());
        intRateDraft.set("draftstatus", (Object)DraftStatusEnum.RUNNING.getValue());
        this.save(intRateDraft, true);
        return intRateDraft;
    }

    private void save(DynamicObject dyObj, boolean newTrans) {
        block15: {
            if (newTrans) {
                try (TXHandle tx = TX.requiresNew();){
                    try {
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyObj});
                        break block15;
                    }
                    catch (Exception e) {
                        tx.markRollback();
                        logger.error((Throwable)e);
                        throw e;
                    }
                }
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyObj});
        }
    }

    private DynamicObject readDraftCfg() {
        QFilter filter = new QFilter("enable", "=", (Object)true);
        DynamicObjectCollection configs = QueryServiceHelper.query((String)"mrm_rate_draft_cfg", (String)"id", (QFilter[])filter.toArray());
        if (EmptyUtil.isEmpty((DynamicObjectCollection)configs)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u542f\u7528\u7684\u201c\u5229\u7387\u5e95\u7a3f\u914d\u7f6e\u201d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"IntRateDataGetService_5", (String)"tmc-mrm-business", (Object[])new Object[0]));
        }
        if (configs.size() > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u591a\u6761\u542f\u7528\u7684\u201c\u5229\u7387\u5e95\u7a3f\u914d\u7f6e\u201d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"IntRateDataGetService_6", (String)"tmc-mrm-business", (Object[])new Object[0]));
        }
        return BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)configs.get(0)).get("id"), (String)"mrm_rate_draft_cfg");
    }

    protected static String getTargetEntity() {
        return "mrm_rate_draft_data";
    }
}

