/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.business.service.rateopen;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.tmc.fbp.common.helper.service.MarketDataServiceHelper;
import kd.tmc.fbp.common.model.ForexQuoteInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.mrm.common.enums.AnalysisObjTypeEnum;
import kd.tmc.mrm.common.enums.CounterPartyTypeEnum;
import kd.tmc.mrm.common.enums.RateTypeEnum;
import kd.tmc.mrm.common.helper.OrgHelper;
import kd.tmc.mrm.common.helper.QFilterHelper;
import kd.tmc.mrm.common.model.section.MatchResult;
import kd.tmc.mrm.common.model.section.SectionCfgModel;
import org.apache.commons.lang3.tuple.Pair;

public class GapAnalysisModel {
    private static final Log logger = LogFactory.getLog(GapAnalysisModel.class);
    private ConcurrentHashMap<String, Pair<BigDecimal, BigDecimal>> forexQuoteCache = new ConcurrentHashMap();
    private static final int BATCH_COUNT = 5000;
    private static final int THREAD_COUNT = 5;
    private static final ThreadPool threadPool = ThreadPools.getOrCreateFixedThreadPool((String)"GapAnalysis", (int)5);
    private Exception exception;
    public static final Long TOTAL_ENTRY_ROW_ID = 202210241024L;
    private Date draftTime;
    private SectionCfgModel sectionCfgModel;
    private Map<Object, Long> billTypeNumber2SubjectId = new HashMap<Object, Long>();
    private Map<Long, String> subjectId2SubjectName = new HashMap<Long, String>();
    private Map<Long, List<Long>> subSubjectsMap = new HashMap<Long, List<Long>>();
    private String[] titles;
    private Map<Long, BigDecimal[]> resultData = new LinkedHashMap<Long, BigDecimal[]>();
    private ConcurrentHashMap<String, DynamicObject> gapAnalysisDetails = new ConcurrentHashMap();
    private List<DynamicObject> gapAnalysisDetailList = new ArrayList<DynamicObject>();
    private DynamicObject gapAnalysisBill;
    private DynamicObject forexQuote;
    private DynamicObject analysisObj;
    private MulBasedataDynamicObjectCollection futureAnalysisObjCol;
    private DynamicObject subjectSystem;
    private DynamicObject sectionCfg;
    private DynamicObject reportCurrency;
    String appId;
    private Set<String> tipPairs;

    public String[] getTitles() {
        return this.titles;
    }

    public Map<Long, BigDecimal[]> getResultData() {
        return this.resultData;
    }

    public ConcurrentMap<String, DynamicObject> getGapAnalysisDetails() {
        return this.gapAnalysisDetails;
    }

    public Map<Long, List<Long>> getSubSubjectsMap() {
        return this.subSubjectsMap;
    }

    public Map<Long, String> getSubjectId2SubjectName() {
        return this.subjectId2SubjectName;
    }

    public DynamicObject getSubjectSystem() {
        return this.subjectSystem;
    }

    public GapAnalysisModel(DynamicObject gapAnalysisBill, DynamicObject analysisObj, DynamicObject subjectSystem, String appId) {
        if (gapAnalysisBill == null) {
            throw new KDBizException("Build Gap Analysis Model Exception");
        }
        DynamicObject forexQuote = gapAnalysisBill.getDynamicObject("forexquote");
        MulBasedataDynamicObjectCollection futureAnalysisObjCol = (MulBasedataDynamicObjectCollection)gapAnalysisBill.getDynamicObjectCollection("futureanalysisobj");
        DynamicObject sectionCfg = gapAnalysisBill.getDynamicObject("sectioncfg");
        DynamicObject reportCurrency = gapAnalysisBill.getDynamicObject("reportcurrency");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{forexQuote, analysisObj, subjectSystem, sectionCfg, reportCurrency, appId})) {
            throw new KDBizException("Build Gap Analysis Model Exception.");
        }
        this.gapAnalysisBill = gapAnalysisBill;
        this.forexQuote = forexQuote;
        this.analysisObj = analysisObj;
        this.futureAnalysisObjCol = futureAnalysisObjCol;
        this.subjectSystem = subjectSystem;
        this.sectionCfg = sectionCfg;
        this.reportCurrency = reportCurrency;
        this.appId = appId;
    }

    public GapAnalysisModel(Object gapAnalysisBillId, String appId) {
        if (EmptyUtil.isEmpty((Object)gapAnalysisBillId)) {
            throw new KDBizException("Build Gap Analysis Model Exception");
        }
        DynamicObject dbBill = QueryServiceHelper.queryOne((String)"mrm_gap_analysis", (String)"subjectSystem,sectionCfg", (QFilter[])new QFilter("id", "=", gapAnalysisBillId).toArray());
        DynamicObject subjectSystem = BusinessDataServiceHelper.loadSingle((Object)dbBill.getLong("subjectSystem"), (String)"mrm_subject_system");
        DynamicObject sectionCfg = BusinessDataServiceHelper.loadSingle((Object)dbBill.getLong("sectionCfg"), (String)"mrm_section_cfg");
        this.subjectSystem = subjectSystem;
        this.sectionCfg = sectionCfg;
        this.appId = appId;
    }

    public void analysis() {
        this.initParams();
        Object[] draftIds = this.queryDraftDataPks();
        int startIndex = 0;
        int endIndex = Math.min(draftIds.length - 1, 4999);
        while (endIndex >= 0) {
            logger.info("startIndex:" + startIndex + "  endIndex:" + endIndex);
            int len = endIndex - startIndex + 1;
            Object[] batchDraftIds = new Object[len];
            System.arraycopy(draftIds, startIndex, batchDraftIds, 0, len);
            DynamicObject[] draftData = this.queryDraftData(batchDraftIds);
            this.analysis_mulThread(draftData);
            if (this.tipPairs.size() == 0) {
                SaveServiceHelper.save((DynamicObject[])this.gapAnalysisDetailList.toArray(new DynamicObject[0]));
            }
            this.gapAnalysisDetailList.clear();
            if (endIndex == draftIds.length - 1) {
                endIndex = -1;
                continue;
            }
            startIndex = endIndex + 1;
            endIndex = Math.min(draftIds.length - 1, endIndex + 5000);
        }
        if (!this.tipPairs.isEmpty()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d27\u5e01\u5bf9\u201c%1$s\u201d\u5728\u5916\u6c47\u62a5\u4ef7\u201c%2$s\u201d\u4e2d\u672a\u8bbe\u7f6e\u62a5\u4ef7\u65b9\u5f0f\uff0c\u8bf7\u5148\u8bbe\u7f6e\u3002", (String)"GapAnalysisModel_5", (String)"tmc-mrm-business", (Object[])new Object[0]), String.join((CharSequence)"\u3001", this.tipPairs), this.forexQuote.getString("number")));
        }
    }

    public boolean queryResult(DynamicObject gapAnalysisBill, String appId) {
        DataSet dataSet;
        this.sectionCfgModel = new SectionCfgModel(this.sectionCfg, DateUtils.getCurrentDate());
        this.titles = this.sectionCfgModel.getSectionTitles();
        DynamicObjectCollection sectionEntry = this.sectionCfg.getDynamicObjectCollection("sectionentry");
        this.initSubjectInfo(sectionEntry.size());
        Object id = gapAnalysisBill.get("id");
        DynamicObject orgView = gapAnalysisBill.getDynamicObject("orgview");
        DynamicObjectCollection orgCol = gapAnalysisBill.getDynamicObjectCollection("orgs");
        List orgIds = OrgHelper.getPermOrgIds((DynamicObject)orgView, (DynamicObjectCollection)orgCol, (String)OrgViewTypeEnum.IS_BANKROLL.getViewType(), (String)appId, (String)"mrm_gap_analysis");
        MulBasedataDynamicObjectCollection referenceRateCol = (MulBasedataDynamicObjectCollection)gapAnalysisBill.getDynamicObjectCollection("referencerate");
        Set referenceRateIdSet = referenceRateCol.stream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
        MulBasedataDynamicObjectCollection currencyCol = (MulBasedataDynamicObjectCollection)gapAnalysisBill.getDynamicObjectCollection("currency");
        Set currencyIdSet = currencyCol.stream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
        MulBasedataDynamicObjectCollection subjectCol = (MulBasedataDynamicObjectCollection)gapAnalysisBill.getDynamicObjectCollection("subjects");
        Set<Object> subjectIdSet = subjectCol.stream().map(o -> o.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toSet());
        if (!subjectIdSet.isEmpty()) {
            this.reAssembleSubjectInfo(subjectIdSet);
        }
        boolean isCalcBalance = gapAnalysisBill.containsProperty("iscalcbalance_ext") ? gapAnalysisBill.getBoolean("iscalcbalance_ext") : false;
        QFilter qFilter = new QFilter("srcbillid", "=", id);
        if (EmptyUtil.isNoEmpty(referenceRateIdSet)) {
            qFilter.and("entryentity.draftdata.referencerate", "in", referenceRateIdSet);
        }
        if (EmptyUtil.isNoEmpty(currencyIdSet)) {
            qFilter.and("entryentity.entrycurrency", "in", currencyIdSet);
        }
        if (orgIds != null) {
            qFilter.and("entryentity.draftdata.org", "in", (Object)orgIds);
        }
        if (EmptyUtil.isNoEmpty(subjectIdSet)) {
            qFilter.and("subject", "in", subjectIdSet);
        }
        if ((dataSet = QueryServiceHelper.queryDataSet((String)"GapAnalysisEdit", (String)"mrm_gap_analysis_detail", (String)String.join((CharSequence)",", "sectionindex", "subject", "entryentity.gapamount as gapamount"), (QFilter[])qFilter.toArray(), null).groupBy(new String[]{"sectionindex", "subject"}).sum("gapamount").finish()).isEmpty()) {
            return false;
        }
        Integer sectionCount = this.sectionCfg.getDynamicObjectCollection("sectionentry").size();
        if (this.resultData.entrySet().iterator().next().getValue().length != sectionCount) {
            for (Map.Entry<Long, BigDecimal[]> entry : this.resultData.entrySet()) {
                entry.setValue(this.createArray(sectionCount));
            }
        }
        if (isCalcBalance) {
            Object balanceSubjectId = this.getBalanceSubjectId();
            boolean existsBalanceSubjectData = QueryServiceHelper.exists((String)"mrm_gap_analysis_detail", (QFilter[])qFilter.and("subject", "=", balanceSubjectId).toArray());
            if (existsBalanceSubjectData && EmptyUtil.isNoEmpty((Object)balanceSubjectId) && (subjectIdSet.isEmpty() || subjectIdSet.contains(balanceSubjectId))) {
                DataSet dataSetCopy = dataSet.copy();
                this.intoResultData(dataSet);
                this.calcBalance(balanceSubjectId, dataSetCopy);
            } else {
                this.intoResultData(dataSet);
            }
        } else {
            this.intoResultData(dataSet);
        }
        this.addUp();
        return true;
    }

    private void intoResultData(DataSet dataSet) {
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            Long subjectId = row.getLong("subject");
            if (this.resultData.get(subjectId) == null) continue;
            this.resultData.get((Object)subjectId)[row.getInteger((String)"sectionindex").intValue()] = row.getBigDecimal("gapamount");
        }
    }

    private void reAssembleSubjectInfo(Set<Object> subjectIdSet) {
        Integer maxLevel;
        HashMap<Long, Long> rowId2subjectId = new HashMap<Long, Long>();
        for (DynamicObject subjectTreeEntryRow : this.subjectSystem.getDynamicObjectCollection("subjecttreeentry")) {
            rowId2subjectId.put(subjectTreeEntryRow.getLong("id"), subjectTreeEntryRow.getDynamicObject("subject").getLong("id"));
        }
        Integer sectionCount = this.sectionCfg.getDynamicObjectCollection("sectionentry").size();
        this.resultData.clear();
        this.subSubjectsMap.clear();
        this.subSubjectsMap.put(TOTAL_ENTRY_ROW_ID, new ArrayList());
        Integer i = maxLevel = this.subjectSystem.getDynamicObjectCollection("subjecttreeentry").stream().map(o -> o.getInt("level")).max(Comparator.comparing(o -> o)).orElse(0);
        while (i >= 1) {
            for (DynamicObject subjectTreeEntryRow : this.subjectSystem.getDynamicObjectCollection("subjecttreeentry")) {
                if (subjectTreeEntryRow.getInt("level") != i.intValue()) continue;
                Long subjectId = subjectTreeEntryRow.getDynamicObject("subject").getLong("id");
                Long pid = subjectTreeEntryRow.getLong("pid");
                Long parentSubjectId = (Long)rowId2subjectId.get(pid);
                if (subjectTreeEntryRow.getBoolean("isleaf") && subjectIdSet.contains(subjectId)) {
                    this.subSubjectsMap.get(TOTAL_ENTRY_ROW_ID).add(subjectId);
                    this.resultData.put(subjectId, this.createArray(sectionCount));
                    if (!EmptyUtil.isNoEmpty((Long)parentSubjectId)) continue;
                    this.subSubjectsMap.computeIfAbsent(parentSubjectId, k -> new ArrayList());
                    this.subSubjectsMap.get(parentSubjectId).add(subjectId);
                    continue;
                }
                if (!this.subSubjectsMap.containsKey(subjectId)) continue;
                this.resultData.put(subjectId, this.createArray(sectionCount));
                if (!EmptyUtil.isNoEmpty((Long)parentSubjectId)) continue;
                this.subSubjectsMap.computeIfAbsent(parentSubjectId, k -> new ArrayList());
                this.subSubjectsMap.get(parentSubjectId).add(subjectId);
            }
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i - 1);
        }
        this.resultData.put(TOTAL_ENTRY_ROW_ID, this.createArray(sectionCount));
    }

    private BigDecimal[] createArray(Integer count) {
        BigDecimal[] array = new BigDecimal[count.intValue()];
        Integer i = 0;
        while (i < count) {
            array[i.intValue()] = BigDecimal.ZERO;
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        return array;
    }

    private void calcBalance(Object balanceSubjectId, DataSet dataSetCopy) {
        String filerStr = String.format("subject != %s", balanceSubjectId);
        DataSet otherSubjectDataSet = dataSetCopy.filter(filerStr).groupBy(new String[]{"sectionindex"}).sum("gapamount").finish();
        LinkedHashMap<Integer, BigDecimal> otherSubjectGapSumMap = new LinkedHashMap<Integer, BigDecimal>(8);
        while (otherSubjectDataSet.hasNext()) {
            Row row = otherSubjectDataSet.next();
            otherSubjectGapSumMap.put(row.getInteger("sectionindex"), row.getBigDecimal("gapamount"));
        }
        Integer maxIndex = this.sectionCfg.getDynamicObjectCollection("sectionentry").size() - 1;
        Integer i = 1;
        while (i <= maxIndex) {
            if (this.resultData.get(balanceSubjectId)[i].compareTo(BigDecimal.ZERO) <= 0) {
                BigDecimal otherSubjectLastSectionSumGap = otherSubjectGapSumMap.get(i - 1) != null ? (BigDecimal)otherSubjectGapSumMap.get(i - 1) : BigDecimal.ZERO;
                this.resultData.get((Object)balanceSubjectId)[i.intValue()] = this.resultData.get(balanceSubjectId)[i - 1].add(otherSubjectLastSectionSumGap);
            }
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
    }

    private Object getBalanceSubjectId() {
        for (DynamicObject subjectTreeEntryRow : this.subjectSystem.getDynamicObjectCollection("subjecttreeentry")) {
            if (!subjectTreeEntryRow.getBoolean("isleaf")) continue;
            FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)subjectTreeEntryRow.getString("mapping_tag"), FilterCondition.class);
            MainEntityType dataType = EntityMetadataCache.getDataEntityType((String)"mrm_rate_draft_data");
            FilterBuilder fb = new FilterBuilder(dataType, condition, true);
            fb.buildFilter(true);
            List filterRow = condition.getFilterRow();
            SimpleFilterRow simpleFilterRows = (SimpleFilterRow)filterRow.get(0);
            List baseDataIds = simpleFilterRows.getBaseDataIds();
            for (FilterValue baseDataId : baseDataIds) {
                if (!"bei_bankbalance".equals(baseDataId.getValue())) continue;
                return subjectTreeEntryRow.getDynamicObject("subject").getPkValue();
            }
        }
        return null;
    }

    private void initParams() {
        DynamicObject draft = this.analysisObj.getDynamicObject("draft");
        this.draftTime = draft.getDate("draftcreatetime");
        if (this.draftTime == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u5b58\u7eed\u5206\u6790\u5bf9\u8c61\u65e0\u5e95\u7a3f\u53d6\u6570\u65f6\u95f4\u3002", (String)"GapAnalysisModel_0", (String)"tmc-mrm-business", (Object[])new Object[0]));
        }
        this.draftTime = TcDateUtils.truncateDate((Date)this.draftTime);
        this.sectionCfgModel = new SectionCfgModel(this.sectionCfg, this.draftTime);
        this.titles = this.sectionCfgModel.getSectionTitles();
        DynamicObjectCollection sectionEntry = this.sectionCfg.getDynamicObjectCollection("sectionentry");
        this.initSubjectInfo(sectionEntry.size());
        this.tipPairs = new HashSet<String>(8);
    }

    public Long getTotalRowSubjectId() {
        return TOTAL_ENTRY_ROW_ID;
    }

    private Object[] queryDraftDataPks() {
        List orgIds;
        DynamicObject draft = this.analysisObj.getDynamicObject("draft");
        QFilter filter = new QFilter("ratedraft", "=", draft.getPkValue());
        String filterStr = this.analysisObj.getString("filterconditionstr_tag");
        QFilter schemaFilter = QFilterHelper.getFilter((String)"mrm_rate_draft_data", (String)filterStr);
        if (schemaFilter != null) {
            filter.and(schemaFilter);
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)this.futureAnalysisObjCol)) {
            Set futureAnalysisIdSet = this.futureAnalysisObjCol.stream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
            DynamicObject[] futureAnalysisObjs = BusinessDataServiceHelper.load((String)"mrm_analysisobj", (String)"filterconditionstr,filterconditionstr_tag", (QFilter[])new QFilter("id", "in", futureAnalysisIdSet).toArray());
            boolean b = Arrays.stream(futureAnalysisObjs).anyMatch(o -> EmptyUtil.isEmpty((String)o.getString("filterconditionstr_tag")));
            QFilter predictFilter = new QFilter("predict", "=", (Object)true);
            predictFilter.and(QFilter.isNull((String)"enddate").or("capcashflowentry.capdate", ">=", (Object)this.draftTime));
            if (!b) {
                QFilter futureAnalysisObjFilter = null;
                for (DynamicObject futureAnalysisObj : futureAnalysisObjs) {
                    String futureAnalysisObjFilterStr = futureAnalysisObj.getString("filterconditionstr_tag");
                    QFilter singleFilter = QFilterHelper.getFilter((String)"mrm_rate_draft_data", (String)futureAnalysisObjFilterStr);
                    if (singleFilter == null) {
                        futureAnalysisObjFilter = null;
                        break;
                    }
                    if (futureAnalysisObjFilter == null) {
                        futureAnalysisObjFilter = singleFilter;
                        continue;
                    }
                    futureAnalysisObjFilter.or(singleFilter);
                }
                if (futureAnalysisObjFilter != null) {
                    predictFilter.and(futureAnalysisObjFilter);
                }
            }
            filter.or(predictFilter);
        }
        if ((orgIds = OrgHelper.getPermOrgIds(null, null, (String)OrgViewTypeEnum.IS_BANKROLL.getViewType(), (String)this.appId, (String)"mrm_gap_analysis")) != null) {
            filter.and("org", "in", (Object)orgIds);
        } else {
            filter.and("org", ">", (Object)0L);
        }
        filter.and(QFilter.isNotNull((String)"currency.number"));
        if (!QueryServiceHelper.exists((String)"mrm_rate_draft_data", (QFilter[])filter.toArray())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u5206\u6790\u5bf9\u8c61\u65e0\u6570\u636e\uff0c\u91cd\u5b9a\u4ef7\u7f3a\u53e3\u8ba1\u7b97\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5206\u6790\u5bf9\u8c61\u3002", (String)"GapAnalysisModel_16", (String)"tmc-mrm-business", (Object[])new Object[0]));
        }
        String counterPartyType = this.gapAnalysisBill.getString("counterpartytype");
        String counterPartyText = null;
        Object[] counterPartyIds = null;
        if (CounterPartyTypeEnum.BD_FINORGINFO.getValue().equals(counterPartyType)) {
            DynamicObjectCollection counterPartyFinOrgCol = this.gapAnalysisBill.getDynamicObjectCollection("counterpartyfinorgs");
            counterPartyIds = counterPartyFinOrgCol.stream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).toArray();
        } else if (CounterPartyTypeEnum.BOS_ORG.getValue().equals(counterPartyType)) {
            DynamicObjectCollection counterPartyOrgCol = this.gapAnalysisBill.getDynamicObjectCollection("counterpartyorgs");
            counterPartyIds = counterPartyOrgCol.stream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).toArray();
        } else if (CounterPartyTypeEnum.BD_BIZPARTNER.getValue().equals(counterPartyType)) {
            DynamicObjectCollection counterPartyBizPartnerCol = this.gapAnalysisBill.getDynamicObjectCollection("counterpartybizpartners");
            counterPartyIds = counterPartyBizPartnerCol.stream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).toArray();
        } else if (CounterPartyTypeEnum.FBD_OTHER.getValue().equals(counterPartyType)) {
            counterPartyText = this.gapAnalysisBill.getString("counterpartyother");
        }
        if (EmptyUtil.isNoEmpty((String)counterPartyType)) {
            filter.and("counterpartytype", "=", (Object)counterPartyType);
        }
        if (EmptyUtil.isNoEmpty((Object[])counterPartyIds)) {
            filter.and("counterparty", "in", (Object)counterPartyIds);
        }
        if (EmptyUtil.isNoEmpty(counterPartyText)) {
            filter.and("counterpartytext", "=", (Object)counterPartyText);
        }
        HashSet<Object> idSet = new HashSet<Object>(999);
        DataSet rows = QueryServiceHelper.queryDataSet((String)"GapAnalysisModel.queryDraftDataPks", (String)"mrm_rate_draft_data", (String)"id", (QFilter[])filter.toArray(), null);
        while (rows.hasNext()) {
            Row row = rows.next();
            idSet.add(row.get("id"));
        }
        if (idSet.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6839\u636e\u9009\u62e9\u7684\u5206\u6790\u5bf9\u8c61\u548c\u4ea4\u6613\u5bf9\u624b\u6ca1\u6709\u67e5\u8be2\u5230\u6570\u636e,\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"GapAnalysisModel_17", (String)"tmc-mrm-business", (Object[])new Object[0]));
        }
        return idSet.stream().toArray();
    }

    private DynamicObject[] queryDraftData(Object[] draftIds) {
        QFilter filter = new QFilter("id", "in", (Object)draftIds);
        return BusinessDataServiceHelper.load((String)"mrm_rate_draft_data", (String)String.join((CharSequence)",", "billno", "predict", "currency", "enddate", "amount", "ratetype", "referencerate", "billtype", "capdate", "capamount", "raconfirmdate"), (QFilter[])new QFilter[]{filter});
    }

    private List<DynamicObject[]> split(DynamicObject[] draftData) {
        if (EmptyUtil.isEmpty((Object[])draftData) || draftData.length <= 1000) {
            return Collections.emptyList();
        }
        int i = draftData.length / 5;
        ArrayList<DynamicObject[]> list = new ArrayList<DynamicObject[]>(5);
        for (int j = 0; j < 5; ++j) {
            int min = j * i;
            int max = (j + 1) * i - 1;
            if (j == 4) {
                max += draftData.length % 5;
            }
            DynamicObject[] data = new DynamicObject[max - min + 1];
            list.add(data);
            int index = 0;
            for (int k = min; k <= max; ++k) {
                data[index] = draftData[k];
                ++index;
            }
        }
        return list;
    }

    private void analysis_mulThread(DynamicObject[] draftData) {
        List<DynamicObject[]> list = this.split(draftData);
        if (list.isEmpty()) {
            this.analysis(draftData);
        } else {
            CountDownLatch latch = new CountDownLatch(5);
            for (DynamicObject[] data : list) {
                threadPool.execute((Runnable)new Task(data, latch));
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                logger.error("GapAnalysisEdit Thread Sleep InterruptedException.");
                logger.error((Throwable)e);
                Thread.currentThread().interrupt();
                throw new KDBizException("Thread Sleep InterruptedException.");
            }
            if (this.exception != null) {
                logger.error((Throwable)this.exception);
                throw new KDBizException(this.exception.getMessage() + "");
            }
        }
    }

    private void analysis(DynamicObject[] draftData) {
        for (DynamicObject draftBill : draftData) {
            DynamicObject[] capCashFlowRows;
            String billTypeNumber = draftBill.getDynamicObject("billtype").getString("number");
            if (!this.billTypeNumber2SubjectId.containsKey(billTypeNumber)) continue;
            Long subjectId = this.billTypeNumber2SubjectId.get(billTypeNumber);
            Optional<DynamicObject> entryRowOptional = this.subjectSystem.getDynamicObjectCollection("subjecttreeentry").stream().filter(row -> subjectId.equals(row.getDynamicObject("subject").getLong("id"))).findFirst();
            DynamicObject entryRow = entryRowOptional.get();
            String inOrOut = entryRow.getString("direct");
            String billCurrency = draftBill.getDynamicObject("currency").getString("number");
            Date endDate = draftBill.getDate("enddate");
            if (!"ifm_accountbalance".equals(billTypeNumber) && !"bei_bankbalance".equals(billTypeNumber) && endDate == null) {
                draftBill.getDynamicObjectCollection("capcashflowentry").clear();
                draftBill.getDynamicObjectCollection("rateadjustentry").clear();
                DynamicObject capCashFlowRow = draftBill.getDynamicObjectCollection("capcashflowentry").addNew();
                capCashFlowRow.set("capamount", (Object)draftBill.getBigDecimal("amount"));
                capCashFlowRows = new DynamicObject[]{capCashFlowRow};
            } else {
                capCashFlowRows = (DynamicObject[])draftBill.getDynamicObjectCollection("capcashflowentry").stream().filter(o -> o.getDate("capdate") != null && !o.getDate("capdate").before(this.draftTime)).toArray(DynamicObject[]::new);
            }
            if (("cfm_loanbill_b_l".equals(billTypeNumber) || "cfm_loanbill_e_l".equals(billTypeNumber) || "cfm_loanbill_bond".equals(billTypeNumber)) && (RateTypeEnum.FIXED.getValue().equals(draftBill.get("ratetype")) || RateTypeEnum.AGREE.getValue().equals(draftBill.get("ratetype"))) || "cim_finsubscribe".equals(billTypeNumber) || "cim_deposit".equals(billTypeNumber) || "cim_noticedeposit".equals(billTypeNumber) || "bei_bankbalance".equals(billTypeNumber) || "ifm_accountbalance".equals(billTypeNumber)) {
                for (int cashFlowNo = 0; cashFlowNo < capCashFlowRows.length; ++cashFlowNo) {
                    DynamicObject capCashFlowRow = capCashFlowRows[cashFlowNo];
                    MatchResult matchResult = this.sectionCfgModel.get(capCashFlowRow.getDate("capdate"));
                    int index = matchResult.getIndex();
                    String rule = matchResult.getDesc();
                    BigDecimal gapAmount = this.getGapAmount(capCashFlowRow, index, inOrOut, billCurrency);
                    this.createGapAnalysisDetail(draftBill, subjectId, inOrOut, null, capCashFlowRow.getDate("capdate"), cashFlowNo, capCashFlowRow, index, gapAmount, rule);
                }
                continue;
            }
            Optional<Date> dateOptional = draftBill.getDynamicObjectCollection("rateadjustentry").stream().map(o -> o.getDate("raconfirmdate")).filter(o -> o != null && this.draftTime.before((Date)o)).min(Comparator.naturalOrder());
            if (dateOptional.isPresent()) {
                Date rateAdjustDate = dateOptional.get();
                for (int cashFlowNo = 0; cashFlowNo < capCashFlowRows.length; ++cashFlowNo) {
                    BigDecimal gapAmount;
                    String rule;
                    int index;
                    MatchResult matchResult;
                    DynamicObject capCashFlowRow = capCashFlowRows[cashFlowNo];
                    Date date = capCashFlowRow.getDate("capdate");
                    if (date != null && date.compareTo(rateAdjustDate) <= 0) {
                        matchResult = this.sectionCfgModel.get(capCashFlowRow.getDate("capdate"));
                        index = matchResult.getIndex();
                        rule = matchResult.getDesc();
                        gapAmount = this.getGapAmount(capCashFlowRow, index, inOrOut, billCurrency);
                        this.createGapAnalysisDetail(draftBill, subjectId, inOrOut, rateAdjustDate, capCashFlowRow.getDate("capdate"), cashFlowNo, capCashFlowRow, index, gapAmount, rule);
                        continue;
                    }
                    matchResult = this.sectionCfgModel.get(rateAdjustDate);
                    index = matchResult.getIndex();
                    rule = matchResult.getDesc();
                    gapAmount = this.getGapAmount(capCashFlowRow, index, inOrOut, billCurrency);
                    this.createGapAnalysisDetail(draftBill, subjectId, inOrOut, rateAdjustDate, rateAdjustDate, cashFlowNo, capCashFlowRow, index, gapAmount, rule);
                }
                continue;
            }
            for (int cashFlowNo = 0; cashFlowNo < capCashFlowRows.length; ++cashFlowNo) {
                DynamicObject capCashFlowRow = capCashFlowRows[cashFlowNo];
                MatchResult matchResult = this.sectionCfgModel.get(capCashFlowRow.getDate("capdate"));
                int index = matchResult.getIndex();
                String rule = matchResult.getDesc();
                BigDecimal gapAmount = this.getGapAmount(capCashFlowRow, index, inOrOut, billCurrency);
                this.createGapAnalysisDetail(draftBill, subjectId, inOrOut, null, capCashFlowRow.getDate("capdate"), cashFlowNo, capCashFlowRow, index, gapAmount, rule);
            }
        }
    }

    private void createGapAnalysisDetail(DynamicObject draftBill, Object subjectId, String inOrOut, Date rateAdjustDate, Date gapDate, int cashFlowNo, DynamicObject capCashFlowRow, int index, BigDecimal gapAmount, String rule) {
        String k = "" + index + subjectId;
        if (this.gapAnalysisDetails.get(k) == null) {
            DynamicObject gapAnalysisDetail = BusinessDataServiceHelper.newDynamicObject((String)"mrm_gap_analysis_detail");
            long[] ids = DBServiceHelper.genLongIds((String)"mrm_gap_analysis_detail", (int)1);
            gapAnalysisDetail.set("id", (Object)ids[0]);
            gapAnalysisDetail.set("section", (Object)this.titles[index]);
            gapAnalysisDetail.set("subject", subjectId);
            gapAnalysisDetail.set("currency", this.reportCurrency.getPkValue());
            gapAnalysisDetail.set("subjecttype", (Object)inOrOut);
            gapAnalysisDetail.set("sectionindex", (Object)index);
            this.gapAnalysisDetails.putIfAbsent(k, gapAnalysisDetail);
        }
        DynamicObject detailRow = this.newDetailRow();
        detailRow.set("pid", this.gapAnalysisDetails.get(k).get("id"));
        detailRow.set("viewdraftdata", (Object)"view");
        detailRow.set("draftdata", draftBill.getPkValue());
        detailRow.set("entrycurrency", draftBill.getDynamicObject("currency").getPkValue());
        if (EmptyUtil.isNoEmpty((Object)capCashFlowRow.getDate("capdate"))) {
            detailRow.set("capcashflowno", (Object)(cashFlowNo + 1));
        }
        detailRow.set("date", (Object)capCashFlowRow.getDate("capdate"));
        detailRow.set("nextdate", (Object)rateAdjustDate);
        detailRow.set("gapdate", (Object)gapDate);
        detailRow.set("amount", (Object)capCashFlowRow.getBigDecimal("capamount"));
        detailRow.set("ruledesc", (Object)rule);
        detailRow.set("gapamount", (Object)gapAmount.setScale(2, RoundingMode.HALF_UP));
        detailRow.set("datatype", (Object)(draftBill.getBoolean("predict") ? AnalysisObjTypeEnum.FUTURE.getValue() : AnalysisObjTypeEnum.CURRENT.getValue()));
    }

    private synchronized DynamicObject newDetailRow() {
        DynamicObject detailRow = BusinessDataServiceHelper.newDynamicObject((String)"mrm_gap_analysis_detail_e");
        this.gapAnalysisDetailList.add(detailRow);
        return detailRow;
    }

    private BigDecimal exChangeAmount(String billCurrency, String reportCurrency, DynamicObject forexQuote, BigDecimal amount) {
        BigDecimal buyPrice;
        BigDecimal sellPrice;
        String fxQuote;
        if (EmptyUtil.isEmpty((String)billCurrency)) {
            return amount;
        }
        String pair = billCurrency + "/" + reportCurrency;
        String inversePair = reportCurrency + "/" + billCurrency;
        if (this.forexQuoteCache.containsKey(pair)) {
            Pair<BigDecimal, BigDecimal> v = this.forexQuoteCache.get(pair);
            fxQuote = pair;
            sellPrice = (BigDecimal)v.getKey();
            buyPrice = (BigDecimal)v.getValue();
        } else if (this.forexQuoteCache.containsKey(inversePair)) {
            Pair<BigDecimal, BigDecimal> v = this.forexQuoteCache.get(inversePair);
            fxQuote = inversePair;
            sellPrice = (BigDecimal)v.getKey();
            buyPrice = (BigDecimal)v.getValue();
        } else {
            ForexQuoteInfo info = MarketDataServiceHelper.getForexQuoteInfoWithoutThrow((Long)forexQuote.getLong("id"), (String)pair, null, null);
            if (info == null) {
                this.tipPairs.add(pair);
                this.forexQuoteCache.put(pair, (Pair<BigDecimal, BigDecimal>)Pair.of((Object)BigDecimal.ONE, (Object)BigDecimal.ONE));
                return amount;
            }
            fxQuote = info.getFxquote();
            sellPrice = info.getSellPrice();
            buyPrice = info.getBuyPrice();
            this.forexQuoteCache.put(fxQuote, (Pair<BigDecimal, BigDecimal>)Pair.of((Object)sellPrice, (Object)buyPrice));
        }
        if (fxQuote.startsWith(reportCurrency)) {
            if (EmptyUtil.isEmpty((BigDecimal)sellPrice)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5916\u6c47\u62a5\u4ef7\u3010%1s\u3011\u4e2d\u8d27\u5e01\u5bf9\u4e3a\u3010%2s\u3011\u7684\u5356\u51fa\u4ef7\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"GapAnalysisModel_4", (String)"tmc-mrm-business", (Object[])new Object[0]), forexQuote.get("number"), pair));
            }
            return amount.divide(sellPrice, 10, RoundingMode.HALF_UP);
        }
        return amount.multiply(buyPrice);
    }

    private BigDecimal getGapAmount(DynamicObject capCashFlowRow, int index, String inOrOut, String billCurrency) {
        if (index != -1) {
            BigDecimal amount = capCashFlowRow.getBigDecimal("capamount");
            if (!this.reportCurrency.getString("number").equals(billCurrency)) {
                amount = this.exChangeAmount(billCurrency, this.reportCurrency.getString("number"), this.forexQuote, amount);
            }
            if ("out".equals(inOrOut)) {
                amount = amount.negate();
            }
            return amount;
        }
        return BigDecimal.ZERO;
    }

    private void addUp() {
        Optional<Integer> maxSubjectLevelOptional = this.subjectSystem.getDynamicObjectCollection("subjecttreeentry").stream().map(row -> row.getInt("level")).max(Comparator.comparingInt(o -> o));
        if (!maxSubjectLevelOptional.isPresent()) {
            throw new KDBizException("max subject level not find.");
        }
        int maxSubjectLevel = maxSubjectLevelOptional.get();
        for (int i = maxSubjectLevel - 1; i >= 1; --i) {
            for (DynamicObject row2 : this.subjectSystem.getDynamicObjectCollection("subjecttreeentry")) {
                Long subjectId;
                List<Long> subSubjectIds;
                if (i != row2.getInt("level") || (subSubjectIds = this.subSubjectsMap.get(subjectId = Long.valueOf(row2.getDynamicObject("subject").getLong("id")))) == null) continue;
                BigDecimal[] amounts = this.resultData.get(subjectId);
                for (Long subSubjectId : subSubjectIds) {
                    BigDecimal[] subAmounts = this.resultData.get(subSubjectId);
                    for (int j = 0; j < subAmounts.length; ++j) {
                        if (amounts[j] == null) {
                            amounts[j] = BigDecimal.ZERO;
                        }
                        if (subAmounts[j] == null) {
                            subAmounts[j] = BigDecimal.ZERO;
                        }
                        amounts[j] = amounts[j].add(subAmounts[j]);
                    }
                }
            }
        }
        this.addUpTotalRow();
    }

    private void addUpTotalRow() {
        BigDecimal[] amounts = this.resultData.get(TOTAL_ENTRY_ROW_ID);
        List<Long> subSubjectIds = this.subSubjectsMap.get(TOTAL_ENTRY_ROW_ID);
        for (Long subSubjectId : subSubjectIds) {
            BigDecimal[] subAmounts = this.resultData.get(subSubjectId);
            for (int j = 0; j < subAmounts.length; ++j) {
                if (amounts[j] == null) {
                    amounts[j] = BigDecimal.ZERO;
                }
                if (subAmounts[j] == null) {
                    subAmounts[j] = BigDecimal.ZERO;
                }
                amounts[j] = amounts[j].add(subAmounts[j]);
            }
        }
    }

    private void initSubjectInfo(int sectionCount) {
        HashMap<Long, Long> rowId2subjectId = new HashMap<Long, Long>();
        for (DynamicObject subjectTreeEntryRow : this.subjectSystem.getDynamicObjectCollection("subjecttreeentry")) {
            rowId2subjectId.put(subjectTreeEntryRow.getLong("id"), subjectTreeEntryRow.getDynamicObject("subject").getLong("id"));
        }
        this.subSubjectsMap.put(TOTAL_ENTRY_ROW_ID, new ArrayList());
        this.subjectId2SubjectName.put(TOTAL_ENTRY_ROW_ID, ResManager.loadKDString((String)"\u51c0\u7f3a\u53e3", (String)"GapAnalysisModel_14", (String)"tmc-mrm-business", (Object[])new Object[0]));
        for (DynamicObject subjectTreeEntryRow : this.subjectSystem.getDynamicObjectCollection("subjecttreeentry")) {
            Long pid;
            String subjectName = ((OrmLocaleValue)subjectTreeEntryRow.getDynamicObject("subject").get("name")).getLocaleValue();
            if (EmptyUtil.isEmpty((String)subjectName)) {
                subjectName = ((OrmLocaleValue)subjectTreeEntryRow.getDynamicObject("subject").get("name")).getDefaultItem();
            }
            Long subjectId = subjectTreeEntryRow.getDynamicObject("subject").getLong("id");
            this.subjectId2SubjectName.put(subjectId, subjectName);
            if (subjectTreeEntryRow.getBoolean("isleaf") && EmptyUtil.isNoEmpty((String)subjectTreeEntryRow.getString("mapping_tag"))) {
                FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)subjectTreeEntryRow.getString("mapping_tag"), FilterCondition.class);
                List filterRow = condition.getFilterRow();
                SimpleFilterRow simpleFilterRows = (SimpleFilterRow)filterRow.get(0);
                List baseDataIds = simpleFilterRows.getBaseDataIds();
                for (FilterValue baseDataId : baseDataIds) {
                    this.billTypeNumber2SubjectId.put(baseDataId.getValue(), subjectId);
                }
                this.subSubjectsMap.get(TOTAL_ENTRY_ROW_ID).add(subjectId);
            }
            if (EmptyUtil.isNoEmpty((Long)(pid = Long.valueOf(subjectTreeEntryRow.getLong("pid"))))) {
                Long parentSubjectId = (Long)rowId2subjectId.get(pid);
                this.subSubjectsMap.computeIfAbsent(parentSubjectId, k -> new ArrayList());
                this.subSubjectsMap.get(parentSubjectId).add(subjectId);
            }
            this.resultData.put(subjectId, this.createArray(sectionCount));
        }
        this.resultData.put(TOTAL_ENTRY_ROW_ID, this.createArray(sectionCount));
    }

    private class Task
    implements Runnable {
        private DynamicObject[] data;
        private CountDownLatch latch;

        public Task(DynamicObject[] data, CountDownLatch latch) {
            this.data = data;
            this.latch = latch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                GapAnalysisModel.this.analysis(this.data);
            }
            catch (Exception e) {
                GapAnalysisModel.this.exception = e;
                for (long i = 0L; i < 5L; ++i) {
                    this.latch.countDown();
                }
            }
            finally {
                this.latch.countDown();
            }
        }
    }
}

