/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.business.service.scenariosimulation;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TermUtils;
import kd.tmc.mrm.common.enums.ExScenarioMethodEnum;
import kd.tmc.mrm.common.enums.ExSectionTypeEnum;
import kd.tmc.mrm.common.enums.ExSimulateFormEnum;
import kd.tmc.mrm.common.model.section.MatchResult;
import kd.tmc.mrm.common.model.section.SectionCfgModel;

public class ExScenarioSimulationService {
    private Date draftDate;
    private DynamicObject entity;
    private int simulateNum;
    private Set<Long> currencySet;
    private List<BigDecimal> nonSectionNonCurrSimulateList;
    private List<List<BigDecimal>> sectionNonCurrSimulateList;
    private List<Map<Long, List<BigDecimal>>> sectionCurr2SimulateList;
    private SectionCfgModel sectionCfgModel;
    private boolean isDefineScenarioType;
    private boolean isMutilSection;
    private boolean isSingleSection;
    private boolean isPercentSimulateForm;
    private String sectionvalue;
    private int rankcount;

    public String[] getSimulateNameArr() {
        String[] simulateNameArr = new String[this.simulateNum];
        if (!this.isMutilSection && !this.isDefineScenarioType) {
            for (int i = 0; i < this.simulateNum; ++i) {
                BigDecimal simulateExRate = this.nonSectionNonCurrSimulateList.get(i);
                String str = this.isPercentSimulateForm ? "%" : "";
                BigDecimal exRate = simulateExRate.stripTrailingZeros();
                simulateNameArr[i] = String.format(ResManager.loadKDString((String)"\u6a21\u62df\u6c47\u7387(%1$s%2$s)", (String)"ExScenarioSimulationService_0", (String)"tmc-mrm-business", (Object[])new Object[0]), exRate.toPlainString(), str);
            }
        } else {
            for (int i = 0; i < this.simulateNum; ++i) {
                simulateNameArr[i] = String.format(ResManager.loadKDString((String)"\u6a21\u62df\u6c47\u7387%s", (String)"ExScenarioSimulationService_1", (String)"tmc-mrm-business", (Object[])new Object[0]), i + 1);
            }
        }
        return simulateNameArr;
    }

    public Set<Long> getCurrencySet() {
        if (EmptyUtil.isEmpty(this.currencySet)) {
            return null;
        }
        return this.currencySet;
    }

    public List<BigDecimal> getSimulateExRateList(Long currenyId, Date date, BigDecimal exrate) {
        ArrayList<BigDecimal> simulateList;
        block14: {
            boolean inSingleSection;
            block15: {
                block12: {
                    int index;
                    block13: {
                        Map<Long, List<BigDecimal>> curr2SimulateList;
                        List<BigDecimal> simulateExRateList;
                        if (this.entity == null) {
                            return null;
                        }
                        exrate = exrate == null ? BigDecimal.ZERO : exrate;
                        simulateList = new ArrayList<BigDecimal>(this.simulateNum);
                        if (!this.isMutilSection) break block12;
                        if (this.sectionCfgModel == null) {
                            return simulateList;
                        }
                        MatchResult matchResult = this.sectionCfgModel.get(date);
                        index = matchResult.getIndex();
                        if (!this.isDefineScenarioType) break block13;
                        if (date == null) {
                            index = this.sectionCurr2SimulateList.size() - 1;
                        }
                        if (EmptyUtil.isEmpty(simulateExRateList = (curr2SimulateList = this.sectionCurr2SimulateList.get(index)).get(currenyId))) break block14;
                        for (BigDecimal simulate : simulateExRateList) {
                            if (this.isPercentSimulateForm) {
                                simulateList.add(exrate.multiply(BigDecimal.ONE.add(simulate.divide(BigDecimal.valueOf(100L), RoundingMode.HALF_UP))));
                                continue;
                            }
                            simulateList.add(simulate);
                        }
                        break block14;
                    }
                    if (date == null) {
                        index = this.sectionNonCurrSimulateList.size() - 1;
                    }
                    List<BigDecimal> sectionSimulateList = this.sectionNonCurrSimulateList.get(index);
                    for (BigDecimal simulateExRate : sectionSimulateList) {
                        if (this.isPercentSimulateForm) {
                            simulateList.add(exrate.multiply(BigDecimal.ONE.add(simulateExRate.divide(BigDecimal.valueOf(100L), RoundingMode.HALF_UP))));
                            continue;
                        }
                        simulateList.add(simulateExRate);
                    }
                    break block14;
                }
                inSingleSection = this.isInSingleSection(date);
                if (!this.isDefineScenarioType) break block15;
                Map<Long, List<BigDecimal>> curr2SimulateList = this.sectionCurr2SimulateList.get(0);
                List<BigDecimal> simulateExRateList = curr2SimulateList.get(currenyId);
                if (EmptyUtil.isEmpty(simulateExRateList)) break block14;
                for (BigDecimal simulate : simulateExRateList) {
                    BigDecimal simulateExRate = this.isPercentSimulateForm ? exrate.multiply(BigDecimal.ONE.add(simulate.divide(BigDecimal.valueOf(100L), RoundingMode.HALF_UP))) : simulate;
                    if (this.isSingleSection && !inSingleSection) {
                        simulateExRate = exrate;
                    }
                    simulateList.add(simulateExRate);
                }
                break block14;
            }
            for (BigDecimal nonSectionNonCurrExRate : this.nonSectionNonCurrSimulateList) {
                BigDecimal simulateExRate = this.isPercentSimulateForm ? exrate.multiply(BigDecimal.ONE.add(nonSectionNonCurrExRate.divide(BigDecimal.valueOf(100L), RoundingMode.HALF_UP))) : nonSectionNonCurrExRate;
                if (this.isSingleSection && !inSingleSection) {
                    simulateExRate = exrate;
                }
                simulateList.add(simulateExRate);
            }
        }
        return simulateList;
    }

    public BigDecimal getSimulateExRateByIndex(Long currenyId, Date date, BigDecimal exrate, int simulateIndex) {
        if (this.entity == null) {
            return null;
        }
        if (simulateIndex > this.simulateNum || simulateIndex < 1) {
            return null;
        }
        List<BigDecimal> simulateExRateList = this.getSimulateExRateList(currenyId, date, exrate);
        if (!EmptyUtil.isEmpty(simulateExRateList)) {
            return simulateExRateList.get(simulateIndex - 1);
        }
        return null;
    }

    public ExScenarioSimulationService(Long id, Date draftDate) {
        block9: {
            block10: {
                this.draftDate = draftDate;
                this.entity = TmcDataServiceHelper.loadSingle((Object)id, (String)"mrm_ex_scenario_sim");
                if (this.entity == null) break block9;
                String scenarioMethod = this.entity.getString("scenariomethod");
                String sectiontype = this.entity.getString("sectiontype");
                String simulateForm = this.entity.getString("simulateform");
                this.sectionvalue = this.entity.getString("sectionvalue");
                this.rankcount = this.entity.getInt("rankcount");
                this.simulateNum = this.entity.getInt("simulatenum");
                this.isDefineScenarioType = ExScenarioMethodEnum.isDefine((String)scenarioMethod);
                this.isPercentSimulateForm = ExSimulateFormEnum.isPercent((String)simulateForm);
                this.isMutilSection = ExSectionTypeEnum.isMutilSection((String)sectiontype);
                if (this.isMutilSection) {
                    this.sectionCfgModel = new SectionCfgModel(this.entity, draftDate);
                }
                this.isSingleSection = ExSectionTypeEnum.isSingleSection((String)sectiontype);
                if (!ExSectionTypeEnum.isMutilSection((String)sectiontype)) break block10;
                DynamicObjectCollection sectionEntryList = this.entity.getDynamicObjectCollection("sectionentry");
                this.sectionCurr2SimulateList = new ArrayList<Map<Long, List<BigDecimal>>>(sectionEntryList.size());
                this.sectionNonCurrSimulateList = new ArrayList<List<BigDecimal>>(sectionEntryList.size());
                for (int z = 0; z < sectionEntryList.size(); ++z) {
                    DynamicObject sectionEntry = (DynamicObject)sectionEntryList.get(z);
                    DynamicObjectCollection simulateSubEntryList = sectionEntry.getDynamicObjectCollection("simulatesubentry");
                    HashMap subSimulateExrateMap = new HashMap(simulateSubEntryList.size());
                    if (z == 0) {
                        this.currencySet = new HashSet<Long>(simulateSubEntryList.size() * 2);
                    }
                    for (int i = 0; i < simulateSubEntryList.size(); ++i) {
                        DynamicObject simulateSubEntry = (DynamicObject)simulateSubEntryList.get(i);
                        ArrayList<BigDecimal> simulateList = new ArrayList<BigDecimal>(this.simulateNum);
                        for (int j = 0; j < this.simulateNum; ++j) {
                            BigDecimal subSimulateExRate = simulateSubEntry.getBigDecimal("subsimulateexrate" + (j + 1));
                            simulateList.add(subSimulateExRate);
                        }
                        if (this.isDefineScenarioType) {
                            DynamicObject currency = simulateSubEntry.getDynamicObject("subsimulatecurrency");
                            if (currency == null) continue;
                            long currId = currency.getLong("id");
                            subSimulateExrateMap.put(currId, simulateList);
                            if (z != 0) continue;
                            this.currencySet.add(currId);
                            continue;
                        }
                        this.sectionNonCurrSimulateList.add(simulateList);
                    }
                    if (!this.isDefineScenarioType) continue;
                    this.sectionCurr2SimulateList.add(subSimulateExrateMap);
                }
                break block9;
            }
            DynamicObjectCollection simulateeEntryList = this.entity.getDynamicObjectCollection("simulateentry");
            this.sectionCurr2SimulateList = new ArrayList<Map<Long, List<BigDecimal>>>(1);
            this.currencySet = new HashSet<Long>(simulateeEntryList.size());
            if (EmptyUtil.isEmpty((DynamicObjectCollection)simulateeEntryList)) break block9;
            HashMap<Long, ArrayList<BigDecimal>> subSimulateExrateMap = new HashMap<Long, ArrayList<BigDecimal>>(simulateeEntryList.size());
            for (DynamicObject simulateeEntry : simulateeEntryList) {
                ArrayList<BigDecimal> simulateList = new ArrayList<BigDecimal>(this.simulateNum);
                for (int i = 0; i < this.simulateNum; ++i) {
                    BigDecimal simulateExRate = simulateeEntry.getBigDecimal("simulateexrate" + (i + 1));
                    simulateList.add(simulateExRate);
                }
                if (this.isDefineScenarioType) {
                    DynamicObject currency = simulateeEntry.getDynamicObject("simulatecurrency");
                    if (currency == null) continue;
                    this.currencySet.add(currency.getLong("id"));
                    subSimulateExrateMap.put(currency.getLong("id"), simulateList);
                    this.sectionCurr2SimulateList.add(subSimulateExrateMap);
                    continue;
                }
                this.nonSectionNonCurrSimulateList = simulateList;
            }
        }
    }

    public int getRankcount() {
        return this.rankcount;
    }

    private boolean isInSingleSection(Date date) {
        if (EmptyUtil.isEmpty((String)this.sectionvalue)) {
            return false;
        }
        Date endDate = TermUtils.getDateByBaseDate4ymd((String)this.sectionvalue, (Date)this.draftDate);
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{date, endDate})) {
            return date.before(endDate);
        }
        return false;
    }
}

