/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.business.service.scenariosimulation;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.enums.TradeToolEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.mrm.common.enums.RateChangeModeEnum;
import kd.tmc.mrm.common.enums.ScenarioTypeEnum;
import kd.tmc.mrm.common.enums.UpOrDownEnum;
import kd.tmc.mrm.common.helper.YieldCurveCreatorHelper;

public class ScenarioSimulationService {
    private static final String FBASEDATAID = "fbasedataid";
    private static final String STANDARD_RATE_KEY = "standard_rate";
    private DynamicObject scenarioSimulationObj;
    private Date draftTime;
    private BigDecimal bp;
    private Map<Object, BigDecimal> refRateToBpMap = new HashMap<Object, BigDecimal>(8);
    private Map<Object, Object> refRateToYieldCurveMap = new HashMap<Object, Object>(8);
    private Map<Object, Map<Date, BigDecimal>> yieldCurveMap = new HashMap<Object, Map<Date, BigDecimal>>(8);
    private Map<Object, Object[][]> yieldCurveToBpInfoMap = new HashMap<Object, Object[][]>(8);
    private Map<Object, String> yieldCurveIdToNumberMap = new HashMap<Object, String>(8);
    private Map<Object, Object[][]> refRateToBpInfoMap = new HashMap<Object, Object[][]>(8);
    private Map<Object, String> refRateIdToNumberMap = new HashMap<Object, String>(8);
    private Map<Object, List<Date>> structDateCache = new HashMap<Object, List<Date>>(8);
    private Map<Object, Map<Date, BigDecimal>> structInfoCache = new HashMap<Object, Map<Date, BigDecimal>>(8);
    private Map<Object, DynamicObject> yieldCurveInfo = new HashMap<Object, DynamicObject>(8);

    public ScenarioSimulationService(Date draftTime, Long scenarioSimulationId) {
        this.draftTime = draftTime;
        this.build(scenarioSimulationId);
    }

    public void changeScenario(Long scenarioSimulationId) {
        this.refRateToBpMap.clear();
        this.refRateToYieldCurveMap.clear();
        this.yieldCurveMap.clear();
        this.yieldCurveToBpInfoMap.clear();
        this.refRateToBpInfoMap.clear();
        this.build(scenarioSimulationId);
    }

    public Map<String, Object> getRate(Date date, Long refRateId) {
        BigDecimal basePoint = BigDecimal.ZERO;
        String scenarioType = this.scenarioSimulationObj.getString("scenariotype");
        String rateChangeMode = this.scenarioSimulationObj.getString("ratechangemode");
        boolean byRate = this.scenarioSimulationObj.getBoolean("byrate");
        HashMap<String, Object> data = new HashMap<String, Object>(4);
        if (ScenarioTypeEnum.INTEREST_CHANGE.getValue().equals(scenarioType)) {
            if (RateChangeModeEnum.PARALLEL.getValue().equals(this.scenarioSimulationObj.getString("ratechangemode1"))) {
                basePoint = byRate ? (this.refRateToBpMap.get(refRateId) != null ? this.refRateToBpMap.get(refRateId) : this.bp) : this.bp;
            } else {
                String key = byRate ? (this.refRateToBpInfoMap.get(refRateId) != null ? refRateId : STANDARD_RATE_KEY) : STANDARD_RATE_KEY;
                Object[][] array = this.refRateToBpInfoMap.get(key);
                Object[] bpInfo = this.getBp(array, date);
                if (bpInfo != null) {
                    basePoint = (BigDecimal)bpInfo[0];
                    data.put("date_match_desc", bpInfo[1]);
                }
            }
            if (this.refRateIdToNumberMap.get(refRateId) != null) {
                data.put("ref_rate", this.refRateIdToNumberMap.get(refRateId));
            }
            data.put("bp", basePoint);
        } else if (RateChangeModeEnum.PARALLEL.getValue().equals(rateChangeMode)) {
            data.put("before_rate", this.calcZeroRate(this.getYieldCurve(this.scenarioSimulationObj.getDynamicObject("yieldcurve").getPkValue()), date));
            data.put("bp", byRate ? (this.refRateToBpMap.get(refRateId) != null ? this.refRateToBpMap.get(refRateId) : this.bp) : this.bp);
            DynamicObject yieldCurve = this.scenarioSimulationObj.getDynamicObject("yieldcurve");
            Object yieldCurveId = byRate ? (this.refRateToYieldCurveMap.get(refRateId) != null ? this.refRateToYieldCurveMap.get(refRateId) : yieldCurve.getPkValue()) : yieldCurve.getPkValue();
            data.put("yield_curve", this.yieldCurveIdToNumberMap.get(yieldCurveId));
        } else {
            Object[] bpInfo;
            byRate = this.scenarioSimulationObj.getBoolean("yieldcurvebyrate");
            DynamicObject yieldCurve = this.scenarioSimulationObj.getDynamicObject("yieldcurve");
            Object yieldCurveId = byRate ? (this.refRateToYieldCurveMap.get(refRateId) != null ? this.refRateToYieldCurveMap.get(refRateId) : yieldCurve.getPkValue()) : yieldCurve.getPkValue();
            Object[][] array = this.yieldCurveToBpInfoMap.get(yieldCurveId);
            BigDecimal rate = this.calcZeroRate(this.getYieldCurve(yieldCurveId), date);
            if (rate == null) {
                rate = BigDecimal.ZERO;
            }
            if ((bpInfo = this.getBp(array, date)) != null) {
                basePoint = (BigDecimal)bpInfo[0];
                data.put("date_match_desc", bpInfo[1]);
            }
            data.put("before_rate", rate);
            data.put("bp", basePoint);
            data.put("yield_curve", this.yieldCurveIdToNumberMap.get(yieldCurveId));
        }
        if (this.refRateIdToNumberMap.get(refRateId) != null) {
            data.put("ref_rate", this.refRateIdToNumberMap.get(refRateId));
        }
        return data;
    }

    private void build(Long scenarioSimulationId) {
        this.scenarioSimulationObj = BusinessDataServiceHelper.loadSingle((Object)scenarioSimulationId, (String)"mrm_scenario_simulation");
        if (ScenarioTypeEnum.INTEREST_CHANGE.getValue().equals(this.scenarioSimulationObj.getString("scenariotype"))) {
            this.initCase1();
        } else {
            DynamicObject yieldCurve = this.scenarioSimulationObj.getDynamicObject("yieldcurve");
            this.putIdToNumber(this.yieldCurveIdToNumberMap, yieldCurve);
            if (RateChangeModeEnum.PARALLEL.getValue().equals(this.scenarioSimulationObj.getString("ratechangemode"))) {
                this.initCase2();
            } else {
                this.initCase3(this.draftTime, yieldCurve);
            }
        }
    }

    private void initCase1() {
        block8: {
            block7: {
                if (!RateChangeModeEnum.PARALLEL.getValue().equals(this.scenarioSimulationObj.getString("ratechangemode1"))) break block7;
                boolean byRate = this.scenarioSimulationObj.getBoolean("byrate");
                this.bp = this.scenarioSimulationObj.getBigDecimal("ratebp");
                if (UpOrDownEnum.DOWN.getValue().equals(this.scenarioSimulationObj.getString("rateupordown"))) {
                    this.bp = this.bp.negate();
                }
                if (!byRate) break block8;
                for (DynamicObject row : this.scenarioSimulationObj.getDynamicObjectCollection("entryentity1")) {
                    BigDecimal rowBp = row.getBigDecimal("e_bp1");
                    if (UpOrDownEnum.DOWN.getValue().equals(row.getString("e_upordown1"))) {
                        rowBp = rowBp.negate();
                    }
                    DynamicObjectCollection refRateCol = row.getDynamicObjectCollection("e_refrate1");
                    for (DynamicObject refRate : refRateCol) {
                        this.putIdToNumber(this.refRateIdToNumberMap, refRate);
                        this.refRateToBpMap.put(refRate.getDynamicObject(FBASEDATAID).getPkValue(), rowBp);
                    }
                }
                break block8;
            }
            DynamicObjectCollection entryEntity5 = this.scenarioSimulationObj.getDynamicObjectCollection("entryentity5");
            for (int i = 0; i < entryEntity5.size(); ++i) {
                DynamicObject card = (DynamicObject)entryEntity5.get(i);
                DynamicObjectCollection entryEntity6 = card.getDynamicObjectCollection("entryentity6");
                Object[][] array = new Object[entryEntity6.size()][5];
                this.assemble(this.draftTime, entryEntity6, array, "entryentity6");
                if (i == 0) {
                    this.refRateToBpInfoMap.put(STANDARD_RATE_KEY, array);
                    continue;
                }
                DynamicObjectCollection refRateCol = card.getDynamicObjectCollection("e_refrate5");
                for (DynamicObject refRate : refRateCol) {
                    this.refRateToBpInfoMap.put(refRate.getDynamicObject(FBASEDATAID).getPkValue(), array);
                    this.putIdToNumber(this.refRateIdToNumberMap, refRate);
                }
            }
        }
    }

    private void initCase2() {
        boolean byRate = this.scenarioSimulationObj.getBoolean("byrate");
        this.bp = this.scenarioSimulationObj.getBigDecimal("yieldcurvebp");
        if (UpOrDownEnum.DOWN.getValue().equals(this.scenarioSimulationObj.getString("yieldcurveupordown"))) {
            this.bp = this.bp.negate();
        }
        if (byRate) {
            for (DynamicObject row : this.scenarioSimulationObj.getDynamicObjectCollection("entryentity2")) {
                DynamicObject e_yieldCurve2 = row.getDynamicObject("e_yieldcurve2");
                this.putIdToNumber(this.yieldCurveIdToNumberMap, e_yieldCurve2);
                BigDecimal rowBp = row.getBigDecimal("e_bp2");
                if (UpOrDownEnum.DOWN.getValue().equals(row.getString("e_upordown2"))) {
                    rowBp = rowBp.negate();
                }
                DynamicObjectCollection refRateCol = row.getDynamicObjectCollection("e_refrate2");
                for (DynamicObject refRate : refRateCol) {
                    this.putIdToNumber(this.refRateIdToNumberMap, refRate);
                    this.refRateToYieldCurveMap.put(refRate.getDynamicObject(FBASEDATAID).getPkValue(), e_yieldCurve2.getPkValue());
                    this.refRateToBpMap.put(refRate.getDynamicObject(FBASEDATAID).getPkValue(), rowBp);
                }
            }
        }
    }

    private void initCase3(Date draftTime, DynamicObject yieldCurve) {
        boolean byRate = this.scenarioSimulationObj.getBoolean("yieldcurvebyrate");
        DynamicObjectCollection sectionEntry = ((DynamicObject)this.scenarioSimulationObj.getDynamicObjectCollection("entryentity3").get(0)).getDynamicObjectCollection("entryentity4");
        Object[][] array = new Object[sectionEntry.size()][5];
        this.assemble(draftTime, sectionEntry, array, "entryentity4");
        this.yieldCurveToBpInfoMap.put(yieldCurve.getPkValue(), array);
        if (byRate) {
            for (int i = 1; i < this.scenarioSimulationObj.getDynamicObjectCollection("entryentity3").size(); ++i) {
                DynamicObject row = (DynamicObject)this.scenarioSimulationObj.getDynamicObjectCollection("entryentity3").get(i);
                DynamicObject e_yieldCurve3 = row.getDynamicObject("e_yieldcurve3");
                this.putIdToNumber(this.yieldCurveIdToNumberMap, e_yieldCurve3);
                DynamicObjectCollection refRateCol = row.getDynamicObjectCollection("e_refrate3");
                for (DynamicObject refRate : refRateCol) {
                    this.putIdToNumber(this.refRateIdToNumberMap, refRate);
                    this.refRateToYieldCurveMap.put(refRate.getDynamicObject(FBASEDATAID).getPkValue(), e_yieldCurve3.getPkValue());
                }
                sectionEntry = row.getDynamicObjectCollection("entryentity4");
                array = new Object[sectionEntry.size()][5];
                this.assemble(draftTime, sectionEntry, array, "entryentity4");
                this.yieldCurveToBpInfoMap.put(e_yieldCurve3.getPkValue(), array);
            }
        }
    }

    private void assemble(Date draftTime, DynamicObjectCollection sectionEntry, Object[][] array, String entryProp) {
        String bpProp;
        String upOrDownProp;
        String isContainsProp;
        String unitProp;
        String leftProp;
        if ("entryentity4".equals(entryProp)) {
            leftProp = "left";
            unitProp = "unit";
            isContainsProp = "iscontains";
            upOrDownProp = "e_upordown4";
            bpProp = "e_bp4";
        } else {
            leftProp = "left6";
            unitProp = "unit6";
            isContainsProp = "iscontains6";
            upOrDownProp = "e_upordown6";
            bpProp = "e_bp6";
        }
        String unit = ((DynamicObject)sectionEntry.get(0)).getString(unitProp);
        array[0][2] = true;
        for (int i = 0; i < sectionEntry.size(); ++i) {
            int x;
            BigDecimal e_bp4;
            DynamicObject row = (DynamicObject)sectionEntry.get(i);
            BigDecimal bigDecimal = e_bp4 = row.get(bpProp) != null ? row.getBigDecimal(bpProp) : BigDecimal.ZERO;
            if (UpOrDownEnum.DOWN.getValue().equals(row.getString(upOrDownProp))) {
                e_bp4 = e_bp4.negate();
            } else if (EmptyUtil.isEmpty((String)row.getString(upOrDownProp))) {
                e_bp4 = BigDecimal.ZERO;
            }
            array[i][4] = e_bp4;
            int n = x = row.get(leftProp) != null ? row.getInt(leftProp) : 0;
            Date leftDate = "m".equals(unit) ? TcDateUtils.getNextMonth((Date)draftTime, (int)x) : ("d".equals(unit) ? TcDateUtils.getNextDay((Date)draftTime, (int)x) : TcDateUtils.getNextYear((Date)draftTime, (int)x));
            array[i][0] = leftDate;
            array[i][3] = ((DynamicObject)sectionEntry.get(i)).getBoolean(isContainsProp);
            if (i != 0) {
                array[i - 1][1] = leftDate;
            }
            if (i <= 0) continue;
            array[i][2] = !((DynamicObject)sectionEntry.get(i - 1)).getBoolean(isContainsProp);
        }
    }

    private void putIdToNumber(Map<Object, String> map, DynamicObject obj) {
        if (obj.containsProperty(FBASEDATAID)) {
            map.put(obj.getDynamicObject(FBASEDATAID).getPkValue(), obj.getDynamicObject(FBASEDATAID).getString("number"));
        } else {
            map.put(obj.getPkValue(), obj.getString("number"));
        }
    }

    private Object[] getBp(Object[][] array, Date date) {
        for (Object[] subArray : array) {
            Date startDate = (Date)subArray[0];
            Date endDate = (Date)subArray[1];
            if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{startDate, endDate}) && startDate.compareTo(endDate) >= 0) continue;
            boolean isLeftContains = subArray[2] == null || (Boolean)subArray[2] != false;
            boolean isRightContains = (Boolean)subArray[3];
            if ((date != null || endDate != null) && (date == null || !date.after(startDate) && (!isLeftContains || date.compareTo(startDate) != 0) || endDate != null && !date.before(endDate) && (!isRightContains || date.compareTo(endDate) != 0))) continue;
            String matchRule = TcDateUtils.formatString((Date)startDate, (String)"yyyy-MM-dd") + "<" + (isLeftContains ? "=" : "") + (date == null ? "DATE" : TcDateUtils.formatString((Date)date, (String)"yyyy-MM-dd")) + (endDate == null ? "" : "<" + (isRightContains ? "=" : "") + TcDateUtils.formatString((Date)endDate, (String)"yyyy-MM-dd"));
            return new Object[]{subArray[4], matchRule};
        }
        return new Object[]{BigDecimal.ZERO, ""};
    }

    private BigDecimal calcZeroRate(DynamicObject obj, Date date) {
        Map<Date, BigDecimal> map = this.yieldCurveMap.get(obj.getPkValue());
        if (map == null) {
            this.yieldCurveMap.put(obj.getPkValue(), new HashMap());
        } else if (map.containsKey(date)) {
            return map.get(date);
        }
        DynamicObject dateRow = obj.getDynamicObjectCollection("zeroentry").stream().filter(o -> date.compareTo(o.getDate("date_zero")) == 0).findAny().orElse(null);
        if (dateRow != null) {
            return dateRow.getBigDecimal("zerorate_zero");
        }
        List<Date> dateList = this.structDateCache.get(obj.getPkValue());
        Map<Date, BigDecimal> result = this.structInfoCache.get(obj.getPkValue());
        if (EmptyUtil.isEmpty(dateList)) {
            dateList = new ArrayList<Date>(8);
            result = new HashMap<Date, BigDecimal>(8);
            this.validate(obj);
            YieldCurveCreatorHelper.fillAllDFByFintool((DynamicObject)obj, (Date)this.draftTime, dateList, result);
            for (Map.Entry<Date, BigDecimal> dateBigDecimalEntry : result.entrySet()) {
                dateBigDecimalEntry.setValue(dateBigDecimalEntry.getValue().setScale(10, RoundingMode.HALF_UP));
            }
            this.structDateCache.put(obj.getPkValue(), dateList);
            this.structInfoCache.put(obj.getPkValue(), result);
        }
        if (dateList.size() <= 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6536\u76ca\u7387\u66f2\u7ebf\u6784\u9020\u53ca\u8ba1\u7b97\u81f3\u5c11\u9700\u8981\u4e24\u4e2a\u6298\u73b0\u56e0\u5b50\uff0c\u8bf7\u6dfb\u52a0\u91d1\u878d\u5de5\u5177\u3002", (String)"ScenarioSimulationService_10", (String)"tmc-mrm-business", (Object[])new Object[0]));
        }
        BigDecimal df = YieldCurveCreatorHelper.zero_getDfByDate((DynamicObject)obj, (Date)dateList.get(0), (Date)dateList.get(dateList.size() - 1), (Date)this.draftTime, (Date)date, dateList, result);
        BigDecimal rate = YieldCurveCreatorHelper.struct_calZeroRate((DynamicObject)obj, (Date)this.draftTime, (Date)date, (BigDecimal)df).setScale(10, RoundingMode.HALF_UP);
        this.yieldCurveMap.get(obj.getPkValue()).put(date, rate);
        return rate;
    }

    private void validate(DynamicObject obj) {
        DynamicObjectCollection finToolEntry = obj.getDynamicObjectCollection("fintoolentry");
        block4: for (int i = 0; i < finToolEntry.size(); ++i) {
            Boolean isForCurve = ((DynamicObject)finToolEntry.get(i)).getBoolean("isforcurve_fin");
            if (!isForCurve.booleanValue()) continue;
            String finTool = ((DynamicObject)finToolEntry.get(i)).getString("fintool_fin");
            boolean isMidRate = ((DynamicObject)finToolEntry.get(i)).getBoolean("ismidrate_fin");
            if (isMidRate) {
                if (EmptyUtil.isEmpty((Object)((DynamicObject)finToolEntry.get(i)).get("midrate_fin"))) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u7684\u91d1\u878d\u5de5\u5177\u5f55\u5165\u7684\u7b2c%2$s\u884c\uff1a\u4e2d\u95f4\u5229\u7387\u4e0d\u80fd\u4e3a0\u3002", (String)"ScenarioSimulationService_4", (String)"tmc-mrm-business", (Object[])new Object[0]), obj.getString("number"), i + 1));
                }
            } else if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{((DynamicObject)finToolEntry.get(i)).get("buyrate_fin"), ((DynamicObject)finToolEntry.get(i)).get("sellrate_fin")})) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u7684\u91d1\u878d\u5de5\u5177\u5f55\u5165\u7684\u7b2c%2$s\u884c\uff1a\u4e70\u5165\u5229\u7387\u3001\u5356\u51fa\u5229\u7387\u4e0d\u80fd\u4e3a0\u3002", (String)"ScenarioSimulationService_5", (String)"tmc-mrm-business", (Object[])new Object[0]), obj.getString("number"), i + 1));
            }
            if (EmptyUtil.isEmpty((Object)((DynamicObject)finToolEntry.get(i)).get("adjmethod_fin"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u7684\u91d1\u878d\u5de5\u5177\u5f55\u5165\u7684\u7b2c%2$s\u884c\uff1a\u65e5\u671f\u8c03\u6574\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ScenarioSimulationService_6", (String)"tmc-mrm-business", (Object[])new Object[0]), obj.getString("number"), i + 1));
            }
            TradeToolEnum finToolEnum = TradeToolEnum.valueOf((String)finTool);
            switch (finToolEnum) {
                case Future: {
                    if (EmptyUtil.isEmpty((Object)((DynamicObject)finToolEntry.get(i)).get("futureenddate_fin"))) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u7684\u91d1\u878d\u5de5\u5177\u5f55\u5165\u7684\u7b2c%2$s\u884c\uff1a\u671f\u8d27\u5230\u671f\u65e5\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ScenarioSimulationService_7", (String)"tmc-mrm-business", (Object[])new Object[0]), obj.getString("number"), i + 1));
                    }
                    if (!EmptyUtil.isEmpty((Object)((DynamicObject)finToolEntry.get(i)).get("price_fin"))) continue block4;
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u7684\u91d1\u878d\u5de5\u5177\u5f55\u5165\u7684\u7b2c%2$s\u884c\uff1a\u4ef7\u683c\u4e0d\u80fd\u4e3a0\u3002", (String)"ScenarioSimulationService_8", (String)"tmc-mrm-business", (Object[])new Object[0]), obj.getString("number"), i + 1));
                }
                case Bond: {
                    if (EmptyUtil.isEmpty((Object)((DynamicObject)finToolEntry.get(i)).get("price_fin"))) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u7684\u91d1\u878d\u5de5\u5177\u5f55\u5165\u7684\u7b2c%2$s\u884c\uff1a\u4ef7\u683c\u4e0d\u80fd\u4e3a0\u3002", (String)"ScenarioSimulationService_8", (String)"tmc-mrm-business", (Object[])new Object[0]), obj.getString("number"), i + 1));
                    }
                    if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{((DynamicObject)finToolEntry.get(i)).get("issuedate_fin"), ((DynamicObject)finToolEntry.get(i)).get("enddate_fin")})) continue block4;
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u7684\u91d1\u878d\u5de5\u5177\u5f55\u5165\u7684\u7b2c%2$s\u884c\uff1a\u53d1\u884c\u65e5\u3001\u5230\u671f\u65e5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ScenarioSimulationService_9", (String)"tmc-mrm-business", (Object[])new Object[0]), obj.getString("number"), i + 1));
                }
            }
        }
    }

    private DynamicObject getYieldCurve(Object pk) {
        DynamicObject yieldCurve = this.yieldCurveInfo.get(pk);
        if (yieldCurve != null) {
            return yieldCurve;
        }
        yieldCurve = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"md_yieldline");
        this.yieldCurveInfo.put(pk, yieldCurve);
        return yieldCurve;
    }
}

