/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.business.service.sensitivityanalysis;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.service.MarketDataServiceHelper;
import kd.tmc.fbp.common.model.ForexQuoteInfo;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.mrm.business.service.scenariosimulation.ScenarioSimulationService;
import kd.tmc.mrm.common.enums.RateTypeEnum;
import kd.tmc.mrm.common.enums.ScenarioTypeEnum;
import org.apache.commons.lang3.tuple.Pair;

public class SensitivityAnalysisService {
    private SensitivityAnalysisService() {
    }

    public static boolean analysis(Set<String> tipPairs, Date draftTime, Date evaluateEndDate, Boolean isContains, DynamicObject[] gapAnalysisDetails, DynamicObject[] senAnalysisDetails, ScenarioSimulationService scenarioSimulationService, Long scenarioSimulationId, String scenarioType, DynamicObject reportCurrency, DynamicObject forexQuote) {
        boolean isEmpty = true;
        HashMap<String, Pair<BigDecimal, BigDecimal>> forexQuoteCache = new HashMap<String, Pair<BigDecimal, BigDecimal>>();
        String evaluateEndDateStr = TcDateUtils.formatString((Date)evaluateEndDate, (String)"yyyy-MM-dd");
        for (DynamicObject gapAnalysisDetail : gapAnalysisDetails) {
            DynamicObject sensitivityObj = Arrays.stream(senAnalysisDetails).filter(o -> o.getDynamicObject("subject").getPkValue().equals(gapAnalysisDetail.getDynamicObject("subject").getPkValue()) && o.get("sectionindex").equals(gapAnalysisDetail.get("sectionindex"))).findFirst().orElse(null);
            if (sensitivityObj == null) {
                throw new KDBizException("sensitivity obj is null");
            }
            sensitivityObj.set("scenariosimulationf7", (Object)scenarioSimulationId);
            DynamicObjectCollection entryEntity = gapAnalysisDetail.getDynamicObjectCollection("entryentity");
            for (DynamicObject gapAnalysisDetailRow : entryEntity) {
                String basisStr;
                DynamicObjectCollection sensitivityEntryEntity = sensitivityObj.getDynamicObjectCollection("entryentity");
                DynamicObject sensitivityDetailRow = sensitivityEntryEntity.addNew();
                sensitivityDetailRow.set("draftdata", gapAnalysisDetailRow.get("draftdata"));
                sensitivityDetailRow.set("entrycurrency", gapAnalysisDetailRow.get("entrycurrency"));
                sensitivityDetailRow.set("capcashflowno", gapAnalysisDetailRow.get("capcashflowno"));
                sensitivityDetailRow.set("date", gapAnalysisDetailRow.get("date"));
                sensitivityDetailRow.set("nextdate", gapAnalysisDetailRow.get("nextdate"));
                sensitivityDetailRow.set("amount", gapAnalysisDetailRow.get("amount"));
                sensitivityDetailRow.set("ruledesc", gapAnalysisDetailRow.get("ruledesc"));
                BigDecimal gapAmount = !reportCurrency.getPkValue().equals(gapAnalysisDetailRow.getDynamicObject("entrycurrency").getPkValue()) ? SensitivityAnalysisService.exChangeAmount(tipPairs, forexQuoteCache, gapAnalysisDetailRow.getDynamicObject("entrycurrency").getString("number"), reportCurrency.getString("number"), forexQuote, gapAnalysisDetailRow.getBigDecimal("amount")).setScale(2, RoundingMode.HALF_UP) : gapAnalysisDetailRow.getBigDecimal("amount");
                if (gapAnalysisDetailRow.getBigDecimal("gapamount").compareTo(BigDecimal.ZERO) < 0) {
                    gapAmount = gapAmount.negate();
                }
                sensitivityDetailRow.set("gapamount", (Object)gapAmount);
                sensitivityDetailRow.set("datatype", gapAnalysisDetailRow.get("datatype"));
                sensitivityDetailRow.set("viewdraftdata", (Object)"view");
                Date gapDate = gapAnalysisDetailRow.getDate("gapdate");
                String rateType = gapAnalysisDetailRow.getDynamicObject("draftdata").getString("ratetype");
                if (!RateTypeEnum.FLOAT.getValue().equals(rateType) || gapDate == null || (!isContains.booleanValue() || gapDate.compareTo(evaluateEndDate) >= 0) && (isContains.booleanValue() || gapDate.compareTo(evaluateEndDate) >= 0) || gapDate.compareTo(draftTime) == 0) continue;
                if (gapDate.compareTo(draftTime) < 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u7684\u201c\u91cd\u5b9a\u4ef7\u7f3a\u53e3\u5206\u6790\u201d\u5bf9\u8c61\u91cc\u7684\u201c\u5b58\u7eed\u4e1a\u52a1\u5206\u6790\u5bf9\u8c61\u201d\u5df2\u66f4\u65b0\uff0c\u8bf7\u5148\u91cd\u65b0\u8fdb\u884c\u7f3a\u53e3\u8ba1\u7b97\uff0c\u518d\u8fdb\u884c\u654f\u611f\u6027\u5206\u6790\u3002", (String)"SensitivityAnalysisService_8", (String)"tmc-mrm-business", (Object[])new Object[0]));
                }
                isEmpty = false;
                DynamicObject referenceRate = gapAnalysisDetailRow.getDynamicObject("draftdata").getDynamicObject("referencerate");
                Map<String, Object> rateInfo = scenarioSimulationService.getRate(TcDateUtils.truncateDate((Date)gapDate), referenceRate != null ? Long.valueOf(referenceRate.getLong("id")) : null);
                BigDecimal beforeRate = rateInfo.get("before_rate") != null ? (BigDecimal)rateInfo.get("before_rate") : BigDecimal.ZERO;
                BigDecimal bp = rateInfo.get("bp") != null ? (BigDecimal)rateInfo.get("bp") : BigDecimal.ZERO;
                BigDecimal afterRate = beforeRate.add(bp.divide(Constants.ONE_HUNDRED, 10, RoundingMode.HALF_UP));
                String calcParam = String.format("Interest Period: From %s to %s", TcDateUtils.formatString((Date)gapDate, (String)"yyyy-MM-dd"), evaluateEndDateStr) + "; \n";
                if (!ScenarioTypeEnum.INTEREST_CHANGE.getValue().equals(scenarioType)) {
                    calcParam = calcParam + "Pre-Change Interest Rate:" + beforeRate.stripTrailingZeros().toPlainString() + "%; \n";
                    calcParam = calcParam + "Post-Change Interest Rate:" + afterRate.stripTrailingZeros().toPlainString() + "%; \n";
                }
                calcParam = calcParam + String.format("Interest Rate Change: %s basis points (bp)", bp.stripTrailingZeros().toPlainString()) + "; \n";
                if (rateInfo.get("yield_curve") != null) {
                    calcParam = calcParam + "Yield Curve:" + rateInfo.get("yield_curve") + "; \n";
                }
                if (rateInfo.get("ref_rate") != null) {
                    calcParam = calcParam + "Reference Rate:" + rateInfo.get("ref_rate") + "; \n";
                }
                BasisEnum basis = EmptyUtil.isNoEmpty((String)(basisStr = gapAnalysisDetailRow.getDynamicObject("draftdata").getString("basis"))) ? BasisEnum.valueOf((String)basisStr) : BasisEnum.Actual_360;
                BigDecimal yrBasis = TermHelper.getBaseBasis((Date)gapDate, (Date)evaluateEndDate, (BasisEnum)basis, null);
                beforeRate = beforeRate.divide(Constants.ONE_HUNDRED, 10, RoundingMode.HALF_UP);
                afterRate = afterRate.divide(Constants.ONE_HUNDRED, 10, RoundingMode.HALF_UP);
                sensitivityDetailRow.set("condition", (Object)calcParam);
                BigDecimal beforeAmount = gapAmount.multiply(beforeRate).multiply(yrBasis);
                BigDecimal afterAmount = gapAmount.multiply(afterRate).multiply(yrBasis);
                beforeAmount = beforeAmount.setScale(2, RoundingMode.HALF_UP);
                afterAmount = afterAmount.setScale(2, RoundingMode.HALF_UP);
                sensitivityDetailRow.set("beforeamount", (Object)beforeAmount);
                sensitivityDetailRow.set("afteramount", (Object)afterAmount);
                sensitivityDetailRow.set("changeamt", (Object)afterAmount.subtract(beforeAmount));
            }
        }
        return isEmpty;
    }

    private static BigDecimal exChangeAmount(Set<String> tipPairs, Map<String, Pair<BigDecimal, BigDecimal>> forexQuoteCache, String billCurrency, String reportCurrency, DynamicObject forexQuote, BigDecimal amount) {
        BigDecimal buyPrice;
        BigDecimal sellPrice;
        String fxQuote;
        String pair = billCurrency + "/" + reportCurrency;
        String inversePair = reportCurrency + "/" + billCurrency;
        if (forexQuoteCache.containsKey(pair)) {
            Pair<BigDecimal, BigDecimal> v = forexQuoteCache.get(pair);
            fxQuote = pair;
            sellPrice = (BigDecimal)v.getKey();
            buyPrice = (BigDecimal)v.getValue();
        } else if (forexQuoteCache.containsKey(inversePair)) {
            Pair<BigDecimal, BigDecimal> v = forexQuoteCache.get(inversePair);
            fxQuote = inversePair;
            sellPrice = (BigDecimal)v.getKey();
            buyPrice = (BigDecimal)v.getValue();
        } else {
            ForexQuoteInfo info = MarketDataServiceHelper.getForexQuoteInfoWithoutThrow((Long)forexQuote.getLong("id"), (String)pair, null, null);
            if (info == null) {
                tipPairs.add(pair);
                forexQuoteCache.put(pair, (Pair<BigDecimal, BigDecimal>)Pair.of((Object)BigDecimal.ONE, (Object)BigDecimal.ONE));
                return amount;
            }
            fxQuote = info.getFxquote();
            sellPrice = info.getSellPrice();
            buyPrice = info.getBuyPrice();
            forexQuoteCache.put(fxQuote, (Pair<BigDecimal, BigDecimal>)Pair.of((Object)sellPrice, (Object)buyPrice));
        }
        if (fxQuote.startsWith(reportCurrency)) {
            if (EmptyUtil.isEmpty((BigDecimal)sellPrice)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5916\u6c47\u62a5\u4ef7\u3010%1s\u3011\u4e2d\u8d27\u5e01\u5bf9\u4e3a\u3010%2s\u3011\u7684\u5356\u51fa\u4ef7\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"SensitivityAnalysisService_10", (String)"tmc-mrm-business", (Object[])new Object[0]), forexQuote.get("number"), pair));
            }
            return amount.divide(sellPrice, 10, RoundingMode.HALF_UP);
        }
        return amount.multiply(buyPrice);
    }
}

