/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.business.task;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ClearHisDraftTask
extends AbstractTask {
    public void execute(RequestContext requestContext, Map<String, Object> paramMap) throws KDException {
        String pdays;
        Date pdate = DateUtils.getCurrentDate();
        int days = 365;
        if (paramMap != null && EmptyUtil.isNoEmpty((String)(pdays = (String)paramMap.get("daysago")))) {
            int pd = Integer.parseInt(pdays);
            days = pd > 0 ? pd : days;
        }
        pdate = DateUtils.getLastDay((Date)pdate, (int)days);
        this.clearInrateDraft(pdate);
        this.clearExrateDraft(pdate);
    }

    private void clearInrateDraft(Date pdate) {
        QFilter qf = new QFilter("draftcreatetime", "<", (Object)pdate);
        ArrayList drafIds = new ArrayList(10);
        DataSet ds = QueryServiceHelper.queryDataSet((String)"query-hist-draft", (String)"mrm_rate_draft", (String)"id", (QFilter[])qf.toArray(), null);
        ds.forEach(v -> drafIds.add(v.getLong("id")));
        if (drafIds.size() > 0) {
            DataSet anlyDraftDS = QueryServiceHelper.queryDataSet((String)"query", (String)"mrm_analysisobj", (String)"draft.id", (QFilter[])new QFilter("draft.id", "in", drafIds).toArray(), null).distinct();
            anlyDraftDS.forEach(v -> drafIds.remove(v.getLong("draft.id")));
            DataSet gapDraftDS = QueryServiceHelper.queryDataSet((String)"query", (String)"mrm_gap_analysis", (String)"draft.id", (QFilter[])new QFilter("draft.id", "in", drafIds).toArray(), null).distinct();
            gapDraftDS.forEach(v -> drafIds.remove(v.getLong("draft.id")));
        }
        if (drafIds.size() > 0) {
            OperateOption delOption = OperateOption.create();
            delOption.setVariableValue("bycleartask", "true");
            TmcOperateServiceHelper.execOperateWithoutThrow((String)"delete", (String)"mrm_rate_draft", (Object[])drafIds.toArray(), (OperateOption)delOption);
        }
    }

    private void clearExrateDraft(Date pdate) {
        QFilter qf = new QFilter("draftcreatedate", "<", (Object)pdate);
        ArrayList drafIds = new ArrayList(10);
        DataSet ds = QueryServiceHelper.queryDataSet((String)"query-hist-draft", (String)"mrm_exrate_draft", (String)"id", (QFilter[])qf.toArray(), null);
        ds.forEach(v -> drafIds.add(v.getLong("id")));
        if (drafIds.size() > 0) {
            DataSet anlyDraftDS = QueryServiceHelper.queryDataSet((String)"query", (String)"mrm_exrate_analysisobj", (String)"draft.id", (QFilter[])new QFilter("draft.id", "in", drafIds).toArray(), null).distinct();
            anlyDraftDS.forEach(v -> drafIds.remove(v.getLong("draft.id")));
            DataSet gapDraftDS = QueryServiceHelper.queryDataSet((String)"query", (String)"mrm_exrate_gap_analysis", (String)"draft.id", (QFilter[])new QFilter("draft.id", "in", drafIds).toArray(), null).distinct();
            gapDraftDS.forEach(v -> drafIds.remove(v.getLong("draft.id")));
        }
        if (drafIds.size() > 0) {
            OperateOption delOption = OperateOption.create();
            delOption.setVariableValue("bycleartask", "true");
            TmcOperateServiceHelper.execOperateWithoutThrow((String)"delete", (String)"mrm_exrate_draft", (Object[])drafIds.toArray(), (OperateOption)delOption);
        }
    }
}

