/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.business.validate.analysisobj;

import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class AnalysisObjUpdateAndSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("enable");
        selector.add("objtype");
        selector.add("filterconditionstr_tag");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            DynamicObject entityDataEntity = extendedDataEntity.getDataEntity();
            boolean enable = entityDataEntity.getBoolean("enable");
            String objType = entityDataEntity.getString("objtype");
            if (EmptyUtil.isEmpty((String)objType)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5206\u6790\u5bf9\u8c61\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AnalysisObjUpdateAndSaveValidator_0", (String)"tmc-mrm-business", (Object[])new Object[0]));
            } else {
                SimpleFilterRow simpleFilterRow;
                List value;
                String filterconditionstr = entityDataEntity.getString("filterconditionstr_tag");
                FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)filterconditionstr, FilterCondition.class);
                List filterRow = condition.getFilterRow();
                Optional<SimpleFilterRow> counterpartytypeFilter = filterRow.stream().filter(e -> "counterpartytype".equals(e.getFieldName())).findFirst();
                if (counterpartytypeFilter.isPresent() && (value = (simpleFilterRow = counterpartytypeFilter.get()).getValue()).size() > 1) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4ea4\u6613\u5bf9\u624b\u7c7b\u578b\u53ea\u80fd\u5355\u9009\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AnalysisObjUpdateAndSaveValidator_2", (String)"tmc-mrm-business", (Object[])new Object[0]));
                }
            }
            if (enable) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u542f\u7528\u72b6\u6001\u4e0b\u7684\u5206\u6790\u5bf9\u8c61\u624d\u5141\u8bb8\u66f4\u65b0\u5e76\u4fdd\u5b58\u3002", (String)"AnalysisObjUpdateAndSaveValidator_1", (String)"tmc-mrm-business", (Object[])new Object[0]));
        }
    }
}

