/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.business.validate.draft;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.ConvertRuleCache;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ExRateDraftConfigSaveValidator
extends AbstractTmcBizOppValidator {
    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            DynamicObjectCollection entryentity = dataEntity.getDynamicObjectCollection("entryentity");
            if (entryentity.isEmpty()) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u7ef4\u5ea6\u914d\u7f6e\u672a\u586b\u5199\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ExRateDraftConfigSaveValidator_0", (String)"tmc-mrm-business", (Object[])new Object[0]));
                continue;
            }
            boolean containEmpty = entryentity.stream().anyMatch(e -> EmptyUtil.isEmpty((String)e.getString("ruleid")));
            if (containEmpty) continue;
            ArrayList<String> list = new ArrayList<String>();
            Map<String, String> map = entryentity.stream().collect(Collectors.toMap(e -> e.getString("ruleid"), e -> e.getDynamicObject("sourcebill").getString("name")));
            Set<Map.Entry<String, String>> entries = map.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                String datasource = entry.getValue();
                String key = entry.getKey();
                ConvertRuleElement convertRuleElement = ConvertRuleCache.loadRule((String)key);
                if (convertRuleElement == null) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"%s \u5bf9\u5e94\u7684\u8f6c\u6362\u89c4\u5219\u4e0d\u5b58\u5728\u3002", (String)"ExRateDraftConfigSaveValidator_2", (String)"tmc-mrm-business", (Object[])new Object[]{datasource}));
                    continue;
                }
                if (convertRuleElement.isEnabled()) continue;
                String id = convertRuleElement.getId();
                list.add(map.get(id));
            }
            if (EmptyUtil.isEmpty(list)) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"%s \u5bf9\u5e94\u7684\u8f6c\u6362\u89c4\u5219\u5df2\u7981\u7528\u3002", (String)"ExRateDraftConfigSaveValidator_1", (String)"tmc-mrm-business", (Object[])new Object[]{String.join((CharSequence)"\u3001", list)}));
        }
    }
}

