/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.business.validate.draft;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ExRateDraftDelValidator
extends AbstractTmcBizOppValidator {
    private static final int TOP = 11;

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            List<String> sensList;
            List<String> gapAnlys;
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            Long id = dataEntity.getLong("id");
            List<String> anlys = this.getUseBillNoList(id, "mrm_exrate_analysisobj", 11);
            if (EmptyUtil.isNoEmpty(anlys)) {
                String anlysBillnoStr = this.subListStr(anlys);
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8be5\u6c47\u7387\u4e1a\u52a1\u5e95\u7a3f\u5df2\u751f\u6210\u5206\u6790\u5bf9\u8c61: %s\u3002\u5220\u9664\u5e95\u7a3f\u524d\u8bf7\u5148\u5220\u9664\u5173\u8054\u5206\u6790\u5bf9\u8c61\u3002", (String)"ExRateDraftDelValidator_0", (String)"tmc-mrm-business", (Object[])new Object[]{anlysBillnoStr}));
            }
            if (EmptyUtil.isNoEmpty(gapAnlys = this.getUseBillNoList(id, "mrm_exrate_gap_analysis", 11))) {
                String gapBillnoStr = this.subListStr(gapAnlys);
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8be5\u6c47\u7387\u4e1a\u52a1\u5e95\u7a3f\u5df2\u88ab\u655e\u53e3\u5206\u6790\u5f15\u7528: %s\u3002\u5220\u9664\u5e95\u7a3f\u524d\u8bf7\u5148\u5220\u9664\u655e\u53e3\u5206\u6790\u3002", (String)"ExRateDraftDelValidator_1", (String)"tmc-mrm-business", (Object[])new Object[]{gapBillnoStr}));
            }
            if (!EmptyUtil.isNoEmpty(sensList = this.getUseBillNoList(id, "mrm_exrate_sensitivity", 11))) continue;
            String sensBillnoStr = this.subListStr(sensList);
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8be5\u6c47\u7387\u4e1a\u52a1\u5e95\u7a3f\u5df2\u88ab\u654f\u611f\u6027\u5206\u6790\u5f15\u7528: %s\u3002\u5220\u9664\u5e95\u7a3f\u524d\u8bf7\u5148\u5220\u9664\u654f\u611f\u6027\u5206\u6790\u3002", (String)"ExRateDraftDelValidator_2", (String)"tmc-mrm-business", (Object[])new Object[]{sensBillnoStr}));
        }
    }

    private String subListStr(List<String> strList) {
        ArrayList<String> result = new ArrayList<String>(10);
        if (EmptyUtil.isNoEmpty(strList)) {
            int size = strList.size();
            result.addAll(strList.subList(0, Math.min(size, 10)));
            if (size > 10) {
                result.add("...");
            }
        }
        return String.join((CharSequence)",", result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getUseBillNoList(Object draftid, String billEntity, int top) {
        ArrayList<String> billNoList = new ArrayList<String>(top);
        try (DataSet billNoDS = null;){
            String selectProps = "billno";
            if ("mrm_exrate_analysisobj".equals(billEntity)) {
                selectProps = "number as billno";
            }
            billNoDS = QueryServiceHelper.queryDataSet((String)"query", (String)billEntity, (String)selectProps, (QFilter[])new QFilter("draft.id", "=", draftid).toArray(), null, (int)top);
            for (Row row : billNoDS) {
                billNoList.add(row.getString("billno"));
            }
            ArrayList<String> arrayList = billNoList;
            return arrayList;
        }
    }
}

