/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.business.validate.draft;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RateDraftDelValidator
extends AbstractTmcBizOppValidator {
    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        Object[] ids = Arrays.stream(extendedDataEntities).map(v -> v.getDataEntity().getPkValue()).toArray();
        Map<Long, List<String>> anlyObs = this.getUseBills(ids, "mrm_analysisobj");
        Map<Long, List<String>> gapAnlyObs = this.getUseBills(ids, "mrm_gap_analysis");
        Map<Long, List<String>> sensAnlyObs = this.getUseBills(ids, "mrm_sensitivity");
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            Long id = dataEntity.getLong("id");
            List<String> anlys = anlyObs.get(id);
            List<String> gapAnlys = gapAnlyObs.get(id);
            List<String> sensAnlys = sensAnlyObs.get(id);
            if (EmptyUtil.isNoEmpty(anlys)) {
                String anlysBillnoStr = this.subListStr(anlys);
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8be5\u5229\u7387\u4e1a\u52a1\u5e95\u7a3f\u5df2\u751f\u6210\u5206\u6790\u5bf9\u8c61: %s\u3002\u5220\u9664\u5e95\u7a3f\u524d\u8bf7\u5148\u5220\u9664\u5173\u8054\u5206\u6790\u5bf9\u8c61\u3002", (String)"RateDraftDelValidator_0", (String)"tmc-mrm-business", (Object[])new Object[]{anlysBillnoStr}));
            }
            if (EmptyUtil.isNoEmpty(gapAnlys)) {
                String gapBillnoStr = this.subListStr(gapAnlys);
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8be5\u5229\u7387\u4e1a\u52a1\u5e95\u7a3f\u5df2\u88ab\u7f3a\u53e3\u5206\u6790\u5f15\u7528: %s\u3002\u5220\u9664\u5e95\u7a3f\u524d\u8bf7\u5148\u5220\u9664\u7f3a\u53e3\u5206\u6790\u3002", (String)"RateDraftDelValidator_1", (String)"tmc-mrm-business", (Object[])new Object[]{gapBillnoStr}));
            }
            if (!EmptyUtil.isNoEmpty(sensAnlys)) continue;
            String sensBillnoStr = this.subListStr(sensAnlys);
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8be5\u5229\u7387\u4e1a\u52a1\u5e95\u7a3f\u5df2\u88ab\u654f\u611f\u6027\u5206\u6790\u5f15\u7528: %s\u3002\u5220\u9664\u5e95\u7a3f\u524d\u8bf7\u5148\u5220\u9664\u654f\u611f\u6027\u5206\u6790\u3002", (String)"RateDraftDelValidator_2", (String)"tmc-mrm-business", (Object[])new Object[]{sensBillnoStr}));
        }
    }

    private String subListStr(List<String> strList) {
        ArrayList<String> result = new ArrayList<String>(10);
        if (EmptyUtil.isNoEmpty(strList)) {
            int size = strList.size();
            result.addAll(strList.subList(0, Math.min(size, 10)));
            if (size > 10) {
                result.add("...");
            }
        }
        return String.join((CharSequence)",", result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Long, List<String>> getUseBills(Object[] ids, String billEntity) {
        try (DataSet anlyDraftDS = null;){
            String selectProps = "billno, draft.id";
            if ("mrm_analysisobj".equals(billEntity)) {
                selectProps = "number as billno, draft.id";
            }
            anlyDraftDS = QueryServiceHelper.queryDataSet((String)"query", (String)billEntity, (String)selectProps, (QFilter[])new QFilter("draft.id", "in", (Object)ids).toArray(), null);
            HashMap<Long, List<String>> draftId2BillNo = new HashMap<Long, List<String>>(10);
            for (Row row : anlyDraftDS) {
                Long draftId = row.getLong("draft.id");
                ArrayList<String> associateBills = (ArrayList<String>)draftId2BillNo.get(draftId);
                if (associateBills == null) {
                    associateBills = new ArrayList<String>(10);
                    draftId2BillNo.put(draftId, associateBills);
                }
                associateBills.add(row.getString("billno"));
            }
            HashMap<Long, List<String>> hashMap = draftId2BillNo;
            return hashMap;
        }
    }
}

