/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.business.validate.draft;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mrm.common.enums.CounterPartyTypeEnum;
import kd.tmc.mrm.common.enums.ExRateDraftBizStatusEnum;
import kd.tmc.mrm.common.enums.RateTypeEnum;

public class RateDraftDetailSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("ratedraft");
        selector.add("currency");
        selector.add("bankaccount");
        selector.add("org");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        String exrateNo = null;
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        qFilter.and("type", "=", (Object)"rate");
        DynamicObjectCollection sourceBill = QueryServiceHelper.query((String)"mrm_draft_datasource", (String)"sourcebill.number", (QFilter[])qFilter.toArray());
        List<String> bizTypeNumbers = sourceBill.stream().map(a -> a.getString("sourcebill.number")).collect(Collectors.toList());
        for (ExtendedDataEntity data : dataEntity) {
            boolean billTypeMustInputValid;
            DynamicObject rateDraft = data.getDataEntity().getDynamicObject("ratedraft");
            if (EmptyUtil.isEmpty((DynamicObject)rateDraft)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5e95\u7a3f\u5df2\u5220\u9664\u3002", (String)"ExRateDraftSaveValidator_21", (String)"tmc-mrm-business", (Object[])new Object[0]));
                continue;
            }
            if (exrateNo != null) {
                if (!exrateNo.equals(rateDraft.getString("billno"))) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u53ea\u80fd\u66f4\u65b0\u540c\u4e00\u4e2a\u5e95\u7a3f\u3002", (String)"ExRateDraftSaveValidator_3", (String)"tmc-mrm-business", (Object[])new Object[0]));
                    continue;
                }
            } else {
                exrateNo = rateDraft.getString("billno");
            }
            if (!(billTypeMustInputValid = this.validateMustInput(data, "billno", "billtype")) || !this.validateBizType(data, bizTypeNumbers)) continue;
            this.clearImportFieldsByBillType(data.getDataEntity());
            this.truncateDate(data.getDataEntity());
            boolean valid = this.validateByType(data);
            if (!valid) continue;
            this.validateForImport(data);
        }
    }

    private boolean validateBizType(ExtendedDataEntity dataEntity, List<String> bizTypeNumbers) {
        DynamicObject entityDataEntity = dataEntity.getDataEntity();
        DynamicObject billType = entityDataEntity.getDynamicObject("billtype");
        String billTypeNumber = billType.getString("number");
        if (!EmptyUtil.isEmpty(bizTypeNumbers) && !bizTypeNumbers.contains(billTypeNumber)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u7c7b\u578b\u4e0d\u5408\u6cd5\u3002", (String)"ExRateDraftSaveValidator_22", (String)"tmc-mrm-business", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean validateByType(ExtendedDataEntity data) {
        String billTypeNumber;
        DynamicObject dynamicObject = data.getDataEntity();
        DynamicObject billType = dynamicObject.getDynamicObject("billtype");
        switch (billTypeNumber = billType.getString("number")) {
            case "bei_bankbalance": 
            case "ifm_accountbalance": {
                boolean mustInput = this.validateMustInput(data, "billtype", "org", "currency", "amount", "startdate", "bankaccount", "counterpartytype");
                if (!mustInput) {
                    return false;
                }
                boolean counterpartyTypeValid = this.validateBalanceCounterpartyType(data);
                if (!counterpartyTypeValid) {
                    return false;
                }
                mustInput = this.validateMustInput(data, "counterparty");
                if (!mustInput) {
                    return false;
                }
                this.validateBalanceBillType(data);
                this.validateBank(data);
                break;
            }
            default: {
                boolean mustInput = this.validateMustInput(data, "billtype", "org", "currency", "amount", "startdate", "ratetype");
                if (!mustInput) {
                    return false;
                }
                this.validateAmount(data);
                this.validateDate(data);
                this.validateRateType(data);
            }
        }
        return true;
    }

    private void validateDate(ExtendedDataEntity data) {
        OperateOption option;
        DynamicObject dynamicObject = data.getDataEntity();
        DynamicObject[] rateDrafts = BusinessDataServiceHelper.load((String)"mrm_rate_draft", (String)"id,billno,draftcreatetime ", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)dynamicObject.getDynamicObject("ratedraft").getLong("id"))});
        DynamicObject rateDraft = rateDrafts[0];
        DynamicObjectCollection capcashflowentry = dynamicObject.getDynamicObjectCollection("capcashflowentry");
        DynamicObjectCollection incashflowentry = dynamicObject.getDynamicObjectCollection("incashflowtentry");
        DynamicObjectCollection rateadjustentry = dynamicObject.getDynamicObjectCollection("rateadjustentry");
        Date draftcreatetime = rateDraft.getDate("draftcreatetime");
        Date draftCreateDate = DateUtils.truncateDate((Date)draftcreatetime);
        Date enddate = dynamicObject.getDate("enddate");
        if (!EmptyUtil.isEmpty((Object)enddate) && draftCreateDate.after(enddate)) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u5230\u671f\u65e5\u9700\u5927\u4e8e\u6216\u7b49\u4e8e\u5e95\u7a3f\u53d6\u6570\u65e5\u671f\u3002", (String)"ExRateDraftSaveValidator_14", (String)"tmc-mrm-business", (Object[])new Object[0]));
        }
        Boolean importtag = (option = this.validateContext.getOption()).containsVariable("importtag_of_datasource") ? Boolean.valueOf(option.getVariableValue("importtag_of_datasource")) : Boolean.FALSE;
        this.capcashDateValid(data, capcashflowentry, draftCreateDate, importtag);
        this.incashDateValid(data, incashflowentry, draftCreateDate, importtag);
        this.rateAdjustDateValid(data, rateadjustentry, draftCreateDate, importtag);
    }

    private void incashDateValid(ExtendedDataEntity data, DynamicObjectCollection incashflowentry, Date draftcreatetime, Boolean importtag) {
        HashSet<Date> incashDateSet = new HashSet<Date>();
        boolean incashDateErr = false;
        boolean incashDateRepErr = false;
        boolean incashDateEmptyErr = false;
        for (DynamicObject incashflow : incashflowentry) {
            if (EmptyUtil.isEmpty((DynamicObject)incashflow) || importtag.booleanValue() && !EmptyUtil.isEmpty((Object)incashflow.get("id"))) continue;
            if (EmptyUtil.isEmpty((Object)incashflow.getDate("indate"))) {
                if (incashDateEmptyErr) continue;
                incashDateEmptyErr = true;
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5229\u606f\u73b0\u91d1\u6d41\u65e5\u671f\u5fc5\u586b\u3002", (String)"ExRateDraftSaveValidator_9", (String)"tmc-mrm-business", (Object[])new Object[0]));
                continue;
            }
            Date date = incashflow.getDate("indate");
            if (draftcreatetime.after(date) && !incashDateErr) {
                incashDateErr = true;
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5229\u606f\u73b0\u91d1\u6d41\u65e5\u671f\u9700\u5927\u4e8e\u6216\u7b49\u4e8e\u5e95\u7a3f\u53d6\u6570\u65e5\u671f\u3002", (String)"ExRateDraftSaveValidator_7", (String)"tmc-mrm-business", (Object[])new Object[0]));
            }
            if (incashDateSet.contains(date) && !incashDateRepErr) {
                incashDateRepErr = true;
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5229\u606f\u73b0\u91d1\u6d41\u5206\u5f55\u884c\u65e5\u671f\u4e0d\u5141\u8bb8\u91cd\u590d\u3002", (String)"ExRateDraftSaveValidator_8", (String)"tmc-mrm-business", (Object[])new Object[0]));
            }
            incashDateSet.add(date);
        }
    }

    private void capcashDateValid(ExtendedDataEntity data, DynamicObjectCollection capcashflowentry, Date draftcreatetime, Boolean importtag) {
        HashSet<Date> capcashDateSet = new HashSet<Date>();
        boolean capcashDateErr = false;
        boolean capcashDateRepErr = false;
        boolean capcashDateEmptyErr = false;
        for (DynamicObject capcashflow : capcashflowentry) {
            if (EmptyUtil.isEmpty((DynamicObject)capcashflow) || importtag.booleanValue() && !EmptyUtil.isEmpty((Object)capcashflow.get("id"))) continue;
            if (EmptyUtil.isEmpty((Object)capcashflow.getDate("capdate"))) {
                if (capcashDateEmptyErr) continue;
                capcashDateEmptyErr = true;
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u672c\u91d1\u73b0\u91d1\u6d41\u65e5\u671f\u5fc5\u586b\u3002", (String)"ExRateDraftSaveValidator_6", (String)"tmc-mrm-business", (Object[])new Object[0]));
                continue;
            }
            Date date = capcashflow.getDate("capdate");
            if (draftcreatetime.after(date) && !capcashDateErr) {
                capcashDateErr = true;
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u672c\u91d1\u73b0\u91d1\u6d41\u65e5\u671f\u9700\u5927\u4e8e\u6216\u7b49\u4e8e\u5e95\u7a3f\u53d6\u6570\u65e5\u671f\u3002", (String)"ExRateDraftSaveValidator_4", (String)"tmc-mrm-business", (Object[])new Object[0]));
            }
            if (capcashDateSet.contains(date) && !capcashDateRepErr) {
                capcashDateRepErr = true;
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u672c\u91d1\u73b0\u91d1\u6d41\u5206\u5f55\u884c\u65e5\u671f\u4e0d\u5141\u8bb8\u91cd\u590d\u3002", (String)"ExRateDraftSaveValidator_5", (String)"tmc-mrm-business", (Object[])new Object[0]));
            }
            capcashDateSet.add(date);
        }
    }

    private void rateAdjustDateValid(ExtendedDataEntity data, DynamicObjectCollection rateadjustentry, Date draftcreatetime, Boolean importtag) {
        HashSet<Date> rateadjustDateSet = new HashSet<Date>();
        boolean rateadjustDateErr = false;
        boolean rateadjustDateRepErr = false;
        boolean rateadjustDateEmptyErr = false;
        for (DynamicObject rateadjustflow : rateadjustentry) {
            if (EmptyUtil.isEmpty((DynamicObject)rateadjustflow) || importtag.booleanValue() && !EmptyUtil.isEmpty((Object)rateadjustflow.get("id"))) continue;
            if (EmptyUtil.isEmpty((Object)rateadjustflow.getDate("raconfirmdate"))) {
                if (rateadjustDateEmptyErr) continue;
                rateadjustDateEmptyErr = true;
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5229\u7387\u91cd\u7f6e\u5206\u5f55\u65e5\u671f\u5fc5\u586b\u3002", (String)"RateDraftSaveValidator_1", (String)"tmc-mrm-business", (Object[])new Object[0]));
                continue;
            }
            Date date = rateadjustflow.getDate("raconfirmdate");
            if (draftcreatetime.after(date) && !rateadjustDateErr) {
                rateadjustDateErr = true;
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5229\u7387\u786e\u5b9a\u65e5\u9700\u5927\u4e8e\u7b49\u4e8e\u5e95\u7a3f\u53d6\u6570\u65e5\u671f\u3002", (String)"RateDraftSaveValidator_2", (String)"tmc-mrm-business", (Object[])new Object[0]));
            }
            if (rateadjustDateSet.contains(date) && !rateadjustDateRepErr) {
                rateadjustDateRepErr = true;
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5229\u7387\u91cd\u7f6e\u8bb0\u5f55\u5206\u5f55\u884c\u65e5\u671f\u4e0d\u5141\u8bb8\u91cd\u590d\u3002", (String)"RateDraftSaveValidator_3", (String)"tmc-mrm-business", (Object[])new Object[0]));
            }
            rateadjustDateSet.add(date);
        }
    }

    private void validateAmount(ExtendedDataEntity data) {
        DynamicObject dynamicObject = data.getDataEntity();
        BigDecimal entryAmount = BigDecimal.ZERO;
        DynamicObjectCollection capcashflowentry = dynamicObject.getDynamicObjectCollection("capcashflowentry");
        OperateOption option = this.validateContext.getOption();
        Boolean importtag = option.containsVariable("importtag_of_datasource") ? Boolean.valueOf(option.getVariableValue("importtag_of_datasource")) : Boolean.FALSE;
        boolean capcashAmountEmptyErr = false;
        for (DynamicObject capcashflow : capcashflowentry) {
            if (EmptyUtil.isEmpty((DynamicObject)capcashflow) || importtag.booleanValue() && !EmptyUtil.isEmpty((Object)capcashflow.get("id"))) continue;
            if (!EmptyUtil.isEmpty((BigDecimal)capcashflow.getBigDecimal("capamount"))) {
                entryAmount = entryAmount.add(capcashflow.getBigDecimal("capamount"));
                continue;
            }
            if (capcashAmountEmptyErr) continue;
            capcashAmountEmptyErr = true;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u672c\u91d1\u73b0\u91d1\u6d41\u91d1\u989d\u5fc5\u586b\u3002", (String)"ExRateDraftSaveValidator_10", (String)"tmc-mrm-business", (Object[])new Object[0]));
        }
        if (entryAmount.compareTo(dynamicObject.getBigDecimal("amount")) != 0) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u672c\u91d1\u73b0\u91d1\u6d41\u5206\u5f55\u91d1\u989d\u5408\u8ba1\u503c\u5fc5\u987b\u7b49\u4e8e\u57fa\u672c\u4fe1\u606f\u7684\u91d1\u989d\u3002", (String)"ExRateDraftSaveValidator_11", (String)"tmc-mrm-business", (Object[])new Object[0]));
        }
        DynamicObjectCollection incashflowentry = dynamicObject.getDynamicObjectCollection("incashflowtentry");
        boolean incashAmountEmptyErr = false;
        for (DynamicObject incashflow : incashflowentry) {
            if (EmptyUtil.isEmpty((DynamicObject)incashflow) || importtag.booleanValue() && !EmptyUtil.isEmpty((Object)incashflow.get("id")) || !EmptyUtil.isEmpty((BigDecimal)incashflow.getBigDecimal("inamount")) || incashAmountEmptyErr) continue;
            incashAmountEmptyErr = true;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u5229\u606f\u73b0\u91d1\u6d41\u91d1\u989d\u5fc5\u586b\u3002", (String)"ExRateDraftSaveValidator_12", (String)"tmc-mrm-business", (Object[])new Object[0]));
        }
        DynamicObjectCollection rateadjustentry = dynamicObject.getDynamicObjectCollection("rateadjustentry");
        boolean rateadjustAmountEmptyErr = false;
        for (DynamicObject rateadjust : rateadjustentry) {
            if (EmptyUtil.isEmpty((DynamicObject)rateadjust) || importtag.booleanValue() && !EmptyUtil.isEmpty((Object)rateadjust.get("id")) || !EmptyUtil.isEmpty((BigDecimal)rateadjust.getBigDecimal("rarate")) || rateadjustAmountEmptyErr) continue;
            rateadjustAmountEmptyErr = true;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u5229\u7387\u91cd\u7f6e\u8bb0\u5f55\u7684\u5229\u7387\u5fc5\u586b\u3002", (String)"RateDraftSaveValidator_4", (String)"tmc-mrm-business", (Object[])new Object[0]));
        }
    }

    private boolean validateMustInput(ExtendedDataEntity dataEntity, String ... columnKeys) {
        StringBuilder keyName = new StringBuilder();
        DynamicObject dynamicObject = dataEntity.getDataEntity();
        for (String columnKey : columnKeys) {
            if (!EmptyUtil.isEmpty((Object)dynamicObject.get(columnKey))) continue;
            keyName.append("\"");
            IDataEntityProperty column = (IDataEntityProperty)dynamicObject.getDataEntityType().getProperties().get((Object)columnKey);
            LocaleString displayName = column.getDisplayName();
            if (displayName != null) {
                keyName.append(displayName.getLocaleValue());
            } else {
                keyName.append(column.getName());
            }
            keyName.append("\"");
        }
        if (!EmptyUtil.isEmpty((String)keyName.toString())) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"%s\u672a\u586b\u5199\u3002", (String)"ExRateDraftSaveValidator_13", (String)"tmc-mrm-business", (Object[])new Object[]{keyName.toString()}));
            return false;
        }
        return true;
    }

    private void validateBalanceBillType(ExtendedDataEntity data) {
        boolean exists;
        DynamicObject dynamicObject = data.getDataEntity();
        DynamicObject[] rateDrafts = BusinessDataServiceHelper.load((String)"mrm_rate_draft", (String)"id,billno,draftcreatetime", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)dynamicObject.getDynamicObject("ratedraft").getLong("id"))});
        String billTypeNumber = dynamicObject.getDynamicObject("billtype").getString("number");
        if (("bei_bankbalance".equals(billTypeNumber) || "ifm_accountbalance".equals(billTypeNumber)) && (exists = QueryServiceHelper.exists((String)"mrm_rate_draft_data", (QFilter[])new QFilter[]{new QFilter("ratedraft", "=", (Object)dynamicObject.getDynamicObject("ratedraft").getLong("id")), new QFilter("currency", "=", (Object)dynamicObject.getDynamicObject("currency").getLong("id")), new QFilter("bankaccount", "=", (Object)dynamicObject.getDynamicObject("bankaccount").getLong("id")), new QFilter("billtype", "=", (Object)dynamicObject.getDynamicObject("billtype").getString("number")), new QFilter("id", "!=", (Object)dynamicObject.getLong("id"))}))) {
            this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u8be5%1$s\u8d26\u6237%2$s\u5e01\u79cd\u5df2\u5728%3$s\u5e95\u7a3f\u7f16\u53f7\u5b58\u5728\u76f8\u540c\u5355\u636e\u7c7b\u578b\u7684\u4e1a\u52a1\u660e\u7ec6\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u8d26\u6237\u6216\u5e01\u79cd\u3002", (String)"ExRateDraftSaveValidator_20", (String)"tmc-mrm-business", (Object[])new Object[0]), dynamicObject.getDynamicObject("bankaccount").getString("number"), dynamicObject.getDynamicObject("currency").getString("number"), rateDrafts[0].getString("billno")));
        }
    }

    private void validateForImport(ExtendedDataEntity data) {
        Boolean importtag;
        OperateOption option = this.validateContext.getOption();
        Boolean bl = importtag = option.containsVariable("importtag_of_datasource") ? Boolean.valueOf(option.getVariableValue("importtag_of_datasource")) : Boolean.FALSE;
        if (!importtag.booleanValue()) {
            return;
        }
        this.validateBizbillStatus(data);
        this.validateBalance(data);
        this.validateOrgPermission(data);
    }

    private void validateOrgPermission(ExtendedDataEntity data) {
        Long orgId;
        DynamicObject dynamicObject = data.getDataEntity();
        List comIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)"mrm", (String)data.getDataEntity().getDynamicObjectType().getName(), (String)"47150e89000000ac");
        if (!comIdList.contains(orgId = Long.valueOf(dynamicObject.getDynamicObject("org").getLong("id")))) {
            this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u7528\u6237\u65e0\u6b64\u7ec4\u7ec7\uff1a%s\u6743\u9650\u3002", (String)"RateDraftSaveValidator_8", (String)"tmc-mrm-business", (Object[])new Object[0]), dynamicObject.getDynamicObject("org").getString("name")));
        }
    }

    private void validateBalance(ExtendedDataEntity data) {
        DynamicObject dynamicObject = data.getDataEntity();
        DynamicObject billType = dynamicObject.getDynamicObject("billtype");
        if (!"bei_bankbalance".equals(billType.getString("number")) && !"ifm_accountbalance".equals(billType.getString("number"))) {
            return;
        }
        this.validateBalanceAccountCurrency(data);
    }

    private void validateBank(ExtendedDataEntity data) {
        DynamicObject dynamicObject = data.getDataEntity();
        String billTypeNumber = dynamicObject.getDynamicObject("billtype").getString("number");
        if ("bei_bankbalance".equals(billTypeNumber)) {
            boolean openOrgExists;
            boolean exists = QueryServiceHelper.exists((String)"bd_accountbanks", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)dynamicObject.getDynamicObject("bankaccount").getLong("id")), new QFilter("bank", "=", (Object)dynamicObject.getDynamicObject("counterparty").getLong("id"))});
            if (!exists) {
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u8d26\u53f7\uff1a%s\u4ea4\u6613\u5bf9\u624b\u9519\u8bef\u3002", (String)"ExRateDraftSaveValidator_18", (String)"tmc-mrm-business", (Object[])new Object[0]), dynamicObject.getDynamicObject("bankaccount").getString("number")));
            }
            if (!(openOrgExists = QueryServiceHelper.exists((String)"bd_accountbanks", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)dynamicObject.getDynamicObject("bankaccount").getLong("id")), new QFilter("openorg", "=", (Object)dynamicObject.getDynamicObject("org").getLong("id"))}))) {
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff08\u5f00\u6237\u516c\u53f8\uff09\uff1a%1$s\u65e0\u6b64\u8d26\u53f7\uff1a%2$s\u3002", (String)"RateDraftSaveValidator_6", (String)"tmc-mrm-business", (Object[])new Object[0]), dynamicObject.getDynamicObject("org").getString("name"), dynamicObject.getDynamicObject("bankaccount").getString("number")));
            }
        } else if ("ifm_accountbalance".equals(billTypeNumber)) {
            DynamicObject account = QueryServiceHelper.queryOne((String)"bd_accountbanks", (String)"id,openorg,inneracct", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)dynamicObject.getDynamicObject("bankaccount").getLong("id"))});
            long counterPartyId = dynamicObject.getDynamicObject("counterparty").getLong("id");
            long openorgId = account.getLong("openorg");
            Long inneracct = account.getLong("inneracct");
            if (counterPartyId != openorgId) {
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u8d26\u53f7\uff1a%s\u4ea4\u6613\u5bf9\u624b\u9519\u8bef\u3002", (String)"ExRateDraftSaveValidator_18", (String)"tmc-mrm-business", (Object[])new Object[0]), dynamicObject.getDynamicObject("bankaccount").getString("number")));
            }
            if (EmptyUtil.isEmpty((Long)inneracct)) {
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u8d26\u53f7\uff1a%s\u975e\u5185\u90e8\u8d26\u6237\u3002", (String)"RateDraftSaveValidator_5", (String)"tmc-mrm-business", (Object[])new Object[0]), dynamicObject.getDynamicObject("bankaccount").getString("number")));
            } else {
                QFilter orgFilter = new QFilter("org", "=", (Object)dynamicObject.getDynamicObject("org").getLong("id"));
                boolean orgExist = QueryServiceHelper.exists((String)"ifm_inneracct", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)inneracct), orgFilter});
                if (!orgExist) {
                    this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff08\u7ed3\u7b97\u4e2d\u5fc3\u7ec4\u7ec7\uff09\uff1a%1$s\u65e0\u6b64\u8d26\u53f7\uff1a%2$s\u3002", (String)"RateDraftSaveValidator_7", (String)"tmc-mrm-business", (Object[])new Object[0]), dynamicObject.getDynamicObject("org").getString("name"), dynamicObject.getDynamicObject("bankaccount").getString("number")));
                }
            }
        }
    }

    private void validateBalanceAccountCurrency(ExtendedDataEntity data) {
        DynamicObject dynamicObject = data.getDataEntity();
        DynamicObjectCollection currencyIdList = QueryServiceHelper.query((String)"bd_accountbanks", (String)"currency.fbasedataid_id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)dynamicObject.getDynamicObject("bankaccount").getLong("id"))});
        List currencyIds = currencyIdList.stream().map(c -> c.getLong("currency.fbasedataid_id")).collect(Collectors.toList());
        if (!currencyIds.contains(dynamicObject.getDynamicObject("currency").getLong("id"))) {
            this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u8d26\u53f7%1$s\u65e0\u5e01\u79cd:%2$s\u3002", (String)"ExRateDraftSaveValidator_17", (String)"tmc-mrm-business", (Object[])new Object[0]), dynamicObject.getDynamicObject("bankaccount").getString("number"), dynamicObject.getDynamicObject("currency").getString("name")));
        }
    }

    private void validateBizbillStatus(ExtendedDataEntity data) {
        DynamicObject dynamicObject = data.getDataEntity();
        DynamicObject billType = dynamicObject.getDynamicObject("billtype");
        String billTypeNumber = billType.getString("number");
        String bizStatus = dynamicObject.getString("bizstaus");
        if (EmptyUtil.isEmpty((String)bizStatus)) {
            return;
        }
        boolean validBizStatus = true;
        switch (billTypeNumber) {
            case "cfm_loanbill_e_l": 
            case "cfm_loanbill_b_l": {
                validBizStatus = Arrays.asList(ExRateDraftBizStatusEnum.CFM_DRAWED.getValue(), ExRateDraftBizStatusEnum.CFM_PARTPAYMENT.getValue()).contains(bizStatus);
                break;
            }
            case "cim_noticedeposit": 
            case "cim_deposit": {
                validBizStatus = Arrays.asList(ExRateDraftBizStatusEnum.DEPOSIT_SUBSCRIBE_DONE.getValue(), ExRateDraftBizStatusEnum.DEPOSIT_SUBSCRIBE_PART.getValue()).contains(bizStatus);
                break;
            }
            case "cim_finsubscribe": {
                validBizStatus = Arrays.asList(ExRateDraftBizStatusEnum.FIN_SUBSCRIBE_DONE.getValue(), ExRateDraftBizStatusEnum.FIN_SUBSCRIBE_PART.getValue()).contains(bizStatus);
                break;
            }
            case "cfm_loanbill_bond": {
                validBizStatus = Arrays.asList(ExRateDraftBizStatusEnum.BOND_DRAWED.getValue(), ExRateDraftBizStatusEnum.BOND_PARTPAYMENT.getValue()).contains(bizStatus);
            }
        }
        if (!validBizStatus) {
            this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u72b6\u6001\u4e0d\u7b26\u3002", (String)"ExRateDraftSaveValidator_16", (String)"tmc-mrm-business", (Object[])new Object[0]), dynamicObject.getString("billno")));
        }
    }

    private void clearImportFieldsByBillType(DynamicObject data) {
        String billtype;
        Boolean importtag;
        OperateOption option = this.validateContext.getOption();
        Boolean bl = importtag = option.containsVariable("importtag_of_datasource") ? Boolean.valueOf(option.getVariableValue("importtag_of_datasource")) : Boolean.FALSE;
        if (!importtag.booleanValue()) {
            return;
        }
        switch (billtype = ((DynamicObject)data.get("billtype")).getString("number")) {
            case "bei_bankbalance": 
            case "ifm_accountbalance": {
                this.clearField(data, "bizstaus", "interestdate", "term", "enddate", "ratetype", "incashflowtentry", "rateadjustentry", "basis");
                break;
            }
            case "cim_noticedeposit": {
                this.clearField(data, "bankaccount", "enddate", "term", "rateadjustentry");
                break;
            }
            case "cfm_loanbill_e_l": 
            case "cfm_loanbill_b_l": {
                this.clearField(data, "bankaccount");
                break;
            }
            case "cim_deposit": {
                this.clearField(data, "bankaccount", "rateadjustentry");
                break;
            }
            case "cim_finsubscribe": {
                this.clearField(data, "bankaccount", "referencerate", "basepoint", "rateadjustentry");
                break;
            }
            case "cfm_loanbill_bond": {
                this.clearField(data, "counterpartytype", "counterparty", "bankaccount");
            }
        }
        this.clearCounterParty(data);
        this.clearRateByType(data);
    }

    private void clearRateByType(DynamicObject data) {
        if (EmptyUtil.isEmpty((Object)data.get("ratetype"))) {
            this.clearField(data, "fixrate", "referencerate", "basepoint");
        } else if (RateTypeEnum.FIXED.getValue().equals(data.get("ratetype")) || RateTypeEnum.AGREE.getValue().equals(data.get("ratetype")) || RateTypeEnum.RANGE.getValue().equals(data.get("ratetype"))) {
            this.clearField(data, "referencerate", "basepoint");
        } else if (RateTypeEnum.FLOAT.getValue().equals(data.get("ratetype"))) {
            this.clearField(data, "fixrate");
        }
    }

    private void clearCounterParty(DynamicObject data) {
        if (EmptyUtil.isEmpty((Object)data.get("counterpartytype"))) {
            this.clearField(data, "counterparty", "counterpartytext");
        }
    }

    private void clearField(DynamicObject data, String ... fields) {
        for (String field : fields) {
            if (EmptyUtil.isEmpty((Object)data.get(field))) continue;
            data.set(field, null);
        }
    }

    private void truncateDate(DynamicObject data) {
        DynamicObjectCollection rateadjustentry;
        DynamicObjectCollection incashflowentry;
        DynamicObjectCollection capcashflowentry = data.getDynamicObjectCollection("capcashflowentry");
        if (!EmptyUtil.isEmpty((DynamicObjectCollection)capcashflowentry)) {
            capcashflowentry.forEach(capcashflow -> capcashflow.set("capdate", (Object)DateUtils.truncateDate((Date)capcashflow.getDate("capdate"))));
        }
        if (!EmptyUtil.isEmpty((DynamicObjectCollection)(incashflowentry = data.getDynamicObjectCollection("incashflowtentry")))) {
            incashflowentry.forEach(incashflow -> incashflow.set("indate", (Object)DateUtils.truncateDate((Date)incashflow.getDate("indate"))));
        }
        if (!EmptyUtil.isEmpty((DynamicObjectCollection)(rateadjustentry = data.getDynamicObjectCollection("rateadjustentry")))) {
            rateadjustentry.forEach(rateadjust -> rateadjust.set("raconfirmdate", (Object)DateUtils.truncateDate((Date)rateadjust.getDate("raconfirmdate"))));
        }
        data.set("startdate", (Object)DateUtils.truncateDate((Date)data.getDate("startdate")));
        data.set("enddate", (Object)DateUtils.truncateDate((Date)data.getDate("enddate")));
        data.set("interestdate", (Object)DateUtils.truncateDate((Date)data.getDate("interestdate")));
    }

    private boolean validateBalanceCounterpartyType(ExtendedDataEntity data) {
        DynamicObject dynamicObject = data.getDataEntity();
        String billTypeNumber = dynamicObject.getDynamicObject("billtype").getString("number");
        String counterpartyType = dynamicObject.getString("counterpartytype");
        if ("bei_bankbalance".equals(billTypeNumber) && !CounterPartyTypeEnum.BD_FINORGINFO.getValue().equals(counterpartyType) || "ifm_accountbalance".equals(billTypeNumber) && !CounterPartyTypeEnum.BOS_ORG.getValue().equals(counterpartyType)) {
            this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u5bf9\u624b\u7c7b\u578b\u4e0d\u7b26\u3002", (String)"ExRateDraftSaveValidator_19", (String)"tmc-mrm-business", (Object[])new Object[0]), dynamicObject.getString("billno")));
            return false;
        }
        return true;
    }

    private void validateRateType(ExtendedDataEntity data) {
        DynamicObject dynamicObject = data.getDataEntity();
        String rateType = dynamicObject.getString("ratetype");
        DynamicObject billType = dynamicObject.getDynamicObject("billtype");
        String billTypeNumber = billType.getString("number");
        if (RateTypeEnum.FLOAT.getValue().equals(rateType) && !"cim_finsubscribe".equals(billTypeNumber)) {
            this.validateMustInput(data, "referencerate");
        }
    }
}

