/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.business.validate.rateopen;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SectionCfgSaveValidator
extends AbstractTmcBizOppValidator {
    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            DynamicObject data = dataEntity.getDataEntity();
            if (!this.validateReference(dataEntity)) continue;
            if (data.getDynamicObjectCollection("sectionentry").size() > 50) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7f3a\u53e3\u533a\u95f4\u6bb5\u4e2a\u6570\u4e0d\u80fd\u8d85\u8fc750\u3002", (String)"SectionCfgSaveValidator_3", (String)"tmc-mrm-business", (Object[])new Object[0]));
                continue;
            }
            if (data.getDynamicObjectCollection("sectionentry").size() == 1) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u81f3\u5c11\u8bbe\u7f6e2\u4e2a\u7f3a\u53e3\u533a\u95f4\u6bb5\u3002", (String)"SectionCfgSaveValidator_4", (String)"tmc-mrm-business", (Object[])new Object[0]));
                continue;
            }
            if (data.getDynamicObjectCollection("sectionentry").size() == 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7f3a\u53e3\u533a\u95f4\u6bb5\u6ca1\u6709\u8bbe\u7f6e\u3002", (String)"SectionCfgSaveValidator_1", (String)"tmc-mrm-business", (Object[])new Object[0]));
                continue;
            }
            for (int i = 1; i < data.getDynamicObjectCollection("sectionentry").size(); ++i) {
                if (((DynamicObject)data.getDynamicObjectCollection("sectionentry").get(i)).getInt("left") != 0) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7b2c%s\u884c\u7684\u533a\u95f4\u6bb5\u5de6\u4fa7\u70b9\u6ca1\u6709\u8bbe\u7f6e\u3002", (String)"SectionCfgSaveValidator_0", (String)"tmc-mrm-business", (Object[])new Object[]{i + 1}));
            }
            if (!EmptyUtil.isEmpty((Object)((DynamicObject)data.getDynamicObjectCollection("sectionentry").get(0)).get("unit"))) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u533a\u95f4\u6bb5\u65f6\u95f4\u957f\u5ea6\u6ca1\u6709\u8bbe\u7f6e\u3002", (String)"SectionCfgSaveValidator_2", (String)"tmc-mrm-business", (Object[])new Object[0]));
        }
    }

    private boolean validateReference(ExtendedDataEntity extendedDataEntity) {
        List list;
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        Object id = dataEntity.getPkValue();
        if (EmptyUtil.isNoEmpty((Object)id) && !(list = BaseDataRefrenceHelper.getAllRefs((String)dataEntity.getDataEntityType().getName(), (Object)id)).isEmpty()) {
            Set refEntitySet = list.stream().map(o -> o.getRefEntityKey()).collect(Collectors.toSet());
            Set<String> bills = new HashSet<String>(3);
            if (refEntitySet.contains("mrm_gap_analysis")) {
                bills.add(MetadataServiceHelper.getDataEntityType((String)"mrm_gap_analysis").getDisplayName().getLocaleValue());
            }
            if (refEntitySet.contains("mrm_sensitivity")) {
                bills.add(MetadataServiceHelper.getDataEntityType((String)"mrm_sensitivity").getDisplayName().getLocaleValue());
            }
            if (refEntitySet.contains("mrm_exrate_gap_analysis")) {
                bills.add(MetadataServiceHelper.getDataEntityType((String)"mrm_exrate_gap_analysis").getDisplayName().getLocaleValue());
            }
            if (refEntitySet.contains("mrm_exrate_sensitivity")) {
                bills.add(MetadataServiceHelper.getDataEntityType((String)"mrm_exrate_sensitivity").getDisplayName().getLocaleValue());
            }
            if (!bills.isEmpty()) {
                bills = bills.stream().map(o -> "\u201c" + o + "\u201d").collect(Collectors.toSet());
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8be5\u7f3a\u53e3\u533a\u95f4\u6bb5\u914d\u7f6e\u5df2\u88ab%s\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"SectionCfgSaveValidator_6", (String)"tmc-mrm-business", (Object[])new Object[]{String.join((CharSequence)"\u3001", bills)}));
                return false;
            }
        }
        return true;
    }
}

