/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.business.validate.scenariosimulation;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mrm.common.enums.ExScenarioMethodEnum;
import kd.tmc.mrm.common.enums.ExSectionTypeEnum;
import kd.tmc.mrm.common.enums.ExSimulateFormEnum;

public class ExScenarioSimulationSaveValidator
extends AbstractTmcBizOppValidator {
    public static final int MAX_SIMULATE_EXRATE_COLUMN_COUNT = 5;

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("org");
        selector.add("currency");
        selector.add("scenariomethod");
        selector.add("sectiontype");
        selector.add("sectionvalue");
        selector.add("rankcount");
        selector.add("simulateform");
        selector.add("simulatenum");
        selector.add("simulateentry");
        selector.add("simulatesubentry");
        selector.add("simulatesubentry.subsimulatecurrency");
        selector.add("simulateentry.simulatecurrency");
        for (int i = 0; i < 5; ++i) {
            selector.add("simulateentry.simulateexrate" + (i + 1));
            selector.add("simulatesubentry.subsimulateexrate" + (i + 1));
        }
        selector.add("sectionentry");
        selector.add("sectiondesc");
        selector.add("left");
        selector.add("unit");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            this.validateCurrency(extendedDataEntity, dataEntity);
            this.validateRankCount(extendedDataEntity, dataEntity);
            this.validateSectionValue(extendedDataEntity, dataEntity);
            this.validateSecion(extendedDataEntity, dataEntity);
            this.validateRefered(extendedDataEntity, dataEntity);
            this.validateSimulateExRate(extendedDataEntity, dataEntity);
        }
    }

    private void validateSectionValue(ExtendedDataEntity extendedDataEntity, DynamicObject dataEntity) {
        String sectionValue;
        String sectionType = dataEntity.getString("sectiontype");
        if (ExSectionTypeEnum.isSingleSection((String)sectionType) && EmptyUtil.isEmpty((String)(sectionValue = dataEntity.getString("sectionvalue")))) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6c47\u7387\u6ce2\u52a8\u533a\u95f4(ymd)\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ExScenarioSimulationSaveValidator_7", (String)"tmc-mrm-business", (Object[])new Object[0]));
        }
    }

    private void validateRankCount(ExtendedDataEntity extendedDataEntity, DynamicObject dataEntity) {
        Long rankCount;
        String scenarioMethod = dataEntity.getString("scenariomethod");
        if (ExScenarioMethodEnum.isRank((String)scenarioMethod) && EmptyUtil.isEmpty((Long)(rankCount = Long.valueOf(dataEntity.getLong("rankcount"))))) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u51c0\u655e\u53e3\u6392\u540d\u9760\u524d\u5e01\u79cd\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ExScenarioSimulationSaveValidator_6", (String)"tmc-mrm-business", (Object[])new Object[0]));
        }
    }

    private void validateCurrency(ExtendedDataEntity extendedDataEntity, DynamicObject dataEntity) {
        DynamicObject org = dataEntity.getDynamicObject("org");
        DynamicObject currency = dataEntity.getDynamicObject("currency");
        if (org != null && currency == null) {
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u201d%s\u201d\u5206\u6790\u4e3b\u4f53\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7684\u672c\u4f4d\u5e01\uff0c\u8bf7\u5148\u7ef4\u62a4\u672c\u4f4d\u5e01\u3002", (String)"ExScenarioSimulationSaveValidator_0", (String)"tmc-mrm-business", (Object[])new Object[0]), org.getString("name")));
        }
    }

    private void validateRefered(ExtendedDataEntity extendedDataEntity, DynamicObject data) {
        List allRefs;
        Long id = (Long)data.getPkValue();
        if (!EmptyUtil.isEmpty((Long)id) && !EmptyUtil.isEmpty((Collection)(allRefs = BaseDataRefrenceHelper.getAllRefs((String)"mrm_ex_scenario_sim", (Object)data.getPkValue())))) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5df2\u88ab\u654f\u611f\u6027\u5206\u6790\u5355\u636e\u5f15\u7528\uff0c\u4e0d\u80fd\u4fee\u6539\u3002", (String)"ExScenarioSimulationSaveValidator_1", (String)"tmc-mrm-business", (Object[])new Object[0]));
        }
    }

    private void validateSimulateExRate(ExtendedDataEntity extendedDataEntity, DynamicObject dataEntity) {
        String scenarioMethod = dataEntity.getString("scenariomethod");
        String sectionType = dataEntity.getString("sectiontype");
        String simulateForm = dataEntity.getString("simulateform");
        int simulatenum = dataEntity.getInt("simulatenum");
        boolean isPercentSimulateFormEnum = ExSimulateFormEnum.isPercent((String)simulateForm);
        if (ExScenarioMethodEnum.isDefine((String)scenarioMethod)) {
            if (ExSectionTypeEnum.isMutilSection((String)sectionType)) {
                this.defineMutilSectionValidation(extendedDataEntity, dataEntity, isPercentSimulateFormEnum, simulatenum);
            } else {
                this.defineUnMutilSectionValidation(extendedDataEntity, dataEntity, isPercentSimulateFormEnum, simulatenum);
            }
        } else if (ExSectionTypeEnum.isMutilSection((String)sectionType)) {
            this.unDefineMutilSectionValidation(extendedDataEntity, dataEntity, isPercentSimulateFormEnum, simulatenum);
        } else {
            this.unDefineUnMutilSectionValidation(extendedDataEntity, dataEntity, isPercentSimulateFormEnum, simulatenum);
        }
    }

    private void unDefineUnMutilSectionValidation(ExtendedDataEntity extendedDataEntity, DynamicObject dataEntity, boolean isPercentSimulateFormEnum, int simulatenum) {
        DynamicObjectCollection simulateentryList = dataEntity.getDynamicObjectCollection("simulateentry");
        if (simulateentryList.size() <= 0) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6a21\u62df\u6c47\u7387\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ExScenarioSimulationSaveValidator_4", (String)"tmc-mrm-business", (Object[])new Object[0]));
        } else if (simulateentryList.size() > 1) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6a21\u62df\u6c47\u7387\u5206\u5f55\u6700\u591a\u53ea\u80fd\u6709\u4e00\u884c\u3002", (String)"ExScenarioSimulationSaveValidator_5", (String)"tmc-mrm-business", (Object[])new Object[0]));
        } else {
            DynamicObject simulateEntry = (DynamicObject)simulateentryList.get(0);
            if (isPercentSimulateFormEnum) {
                for (int j = 0; j < simulatenum; ++j) {
                    BigDecimal subSimulateExrate = simulateEntry.getBigDecimal("simulateexrate" + (j + 1));
                    if (subSimulateExrate.compareTo(BigDecimal.valueOf(-100L)) >= 0 && subSimulateExrate.compareTo(BigDecimal.valueOf(100L)) <= 0) continue;
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u6a21\u62df\u6c47\u7387\u5206\u5f55\u7b2c%s\u884c\u7684\u6a21\u62df\u6c47\u7387\u8981\u5927\u4e8e\u7b49\u4e8e-100\u4e14\u5c0f\u4e8e\u7b49\u4e8e100\u3002", (String)"ExScenarioSimulationSaveValidator_11", (String)"tmc-mrm-business", (Object[])new Object[0]), 1));
                    break;
                }
            } else {
                for (int j = 0; j < simulatenum; ++j) {
                    BigDecimal subSimulateExrate = simulateEntry.getBigDecimal("simulateexrate" + (j + 1));
                    if (subSimulateExrate.compareTo(BigDecimal.ZERO) > 0) continue;
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u6a21\u62df\u6c47\u7387\u5206\u5f55\u7b2c%s\u884c\u7684\u6a21\u62df\u6c47\u7387\u8981\u5927\u4e8e0\u3002", (String)"ExScenarioSimulationSaveValidator_13", (String)"tmc-mrm-business", (Object[])new Object[0]), 1));
                    break;
                }
            }
        }
    }

    private void unDefineMutilSectionValidation(ExtendedDataEntity extendedDataEntity, DynamicObject dataEntity, boolean isPercentSimulateFormEnum, int simulatenum) {
        DynamicObjectCollection sectionentryList = dataEntity.getDynamicObjectCollection("sectionentry");
        block0: for (DynamicObject sectionentry : sectionentryList) {
            BigDecimal subSimulateExrate;
            int j;
            String sectionDesc = sectionentry.getString("sectiondesc");
            DynamicObjectCollection simulatesubentryList = sectionentry.getDynamicObjectCollection("simulatesubentry");
            if (simulatesubentryList.size() <= 0) {
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"%1$s\u533a\u95f4\u6bb5\u7684\u6a21\u62df\u6c47\u7387\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ExScenarioSimulationSaveValidator_10", (String)"tmc-mrm-business", (Object[])new Object[0]), sectionDesc));
                continue;
            }
            if (simulatesubentryList.size() > 1) {
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"%1$s\u533a\u95f4\u6bb5\u7684\u6a21\u62df\u6c47\u7387\u5206\u5f55\u6700\u591a\u53ea\u80fd\u6709\u4e00\u884c\u3002", (String)"ExScenarioSimulationSaveValidator_9", (String)"tmc-mrm-business", (Object[])new Object[0]), sectionDesc));
                continue;
            }
            DynamicObject subSimulateEntry = (DynamicObject)simulatesubentryList.get(0);
            if (isPercentSimulateFormEnum) {
                for (j = 0; j < simulatenum; ++j) {
                    subSimulateExrate = subSimulateEntry.getBigDecimal("subsimulateexrate" + (j + 1));
                    if (subSimulateExrate.compareTo(BigDecimal.valueOf(-100L)) >= 0 && subSimulateExrate.compareTo(BigDecimal.valueOf(100L)) <= 0) continue;
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"%1$s\u533a\u95f4\u6bb5\u7684\u6a21\u62df\u6c47\u7387\u5206\u5f55\u7b2c%2$s\u884c\u7684\u6a21\u62df\u6c47\u7387\u8981\u5927\u4e8e\u7b49\u4e8e-100\u4e14\u5c0f\u4e8e\u7b49\u4e8e100\u3002", (String)"ExScenarioSimulationSaveValidator_8", (String)"tmc-mrm-business", (Object[])new Object[0]), sectionDesc, 1));
                    continue block0;
                }
                continue;
            }
            for (j = 0; j < simulatenum; ++j) {
                subSimulateExrate = subSimulateEntry.getBigDecimal("subsimulateexrate" + (j + 1));
                if (subSimulateExrate.compareTo(BigDecimal.ZERO) > 0) continue;
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"%1$s\u533a\u95f4\u6bb5\u7684\u6a21\u62df\u6c47\u7387\u5206\u5f55\u7b2c%2$s\u884c\u7684\u6a21\u62df\u6c47\u7387\u8981\u5927\u4e8e0\u3002", (String)"ExScenarioSimulationSaveValidator_12", (String)"tmc-mrm-business", (Object[])new Object[0]), sectionDesc, 1));
                continue block0;
            }
        }
    }

    private void defineUnMutilSectionValidation(ExtendedDataEntity extendedDataEntity, DynamicObject dataEntity, boolean isPercentSimulateFormEnum, int simulatenum) {
        DynamicObjectCollection simulateentryList = dataEntity.getDynamicObjectCollection("simulateentry");
        if (simulateentryList.size() <= 0) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6a21\u62df\u6c47\u7387\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ExScenarioSimulationSaveValidator_4", (String)"tmc-mrm-business", (Object[])new Object[0]));
        }
        block0: for (int i = 0; i < simulateentryList.size(); ++i) {
            BigDecimal subSimulateExrate;
            int j;
            DynamicObject simulateEntry = (DynamicObject)simulateentryList.get(i);
            DynamicObject currency = simulateEntry.getDynamicObject("simulatecurrency");
            if (currency == null) {
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u6a21\u62df\u6c47\u7387\u5206\u5f55\u7b2c%s\u884c\u5e01\u79cd\u672a\u586b\u3002", (String)"ExScenarioSimulationSaveValidator_3", (String)"tmc-mrm-business", (Object[])new Object[0]), i + 1));
            }
            if (isPercentSimulateFormEnum) {
                for (j = 0; j < simulatenum; ++j) {
                    subSimulateExrate = simulateEntry.getBigDecimal("simulateexrate" + (j + 1));
                    if (subSimulateExrate.compareTo(BigDecimal.valueOf(-100L)) >= 0 && subSimulateExrate.compareTo(BigDecimal.valueOf(100L)) <= 0) continue;
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u6a21\u62df\u6c47\u7387\u5206\u5f55\u7b2c%s\u884c\u7684\u6a21\u62df\u6c47\u7387\u8981\u5927\u4e8e\u7b49\u4e8e-100\u4e14\u5c0f\u4e8e\u7b49\u4e8e100\u3002", (String)"ExScenarioSimulationSaveValidator_11", (String)"tmc-mrm-business", (Object[])new Object[0]), i + 1));
                    continue block0;
                }
                continue;
            }
            for (j = 0; j < simulatenum; ++j) {
                subSimulateExrate = simulateEntry.getBigDecimal("simulateexrate" + (j + 1));
                if (subSimulateExrate.compareTo(BigDecimal.ZERO) > 0) continue;
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u6a21\u62df\u6c47\u7387\u5206\u5f55\u7b2c%s\u884c\u7684\u6a21\u62df\u6c47\u7387\u8981\u5927\u4e8e0\u3002", (String)"ExScenarioSimulationSaveValidator_13", (String)"tmc-mrm-business", (Object[])new Object[0]), i + 1));
                continue block0;
            }
        }
    }

    private void defineMutilSectionValidation(ExtendedDataEntity extendedDataEntity, DynamicObject dataEntity, boolean isPercentSimulateFormEnum, int simulatenum) {
        DynamicObjectCollection sectionentryList = dataEntity.getDynamicObjectCollection("sectionentry");
        for (DynamicObject sectionentry : sectionentryList) {
            String sectionDesc = sectionentry.getString("sectiondesc");
            DynamicObjectCollection simulatesubentryList = sectionentry.getDynamicObjectCollection("simulatesubentry");
            if (simulatesubentryList.size() <= 0) {
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"%1$s\u533a\u95f4\u6bb5\u7684\u6a21\u62df\u6c47\u7387\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ExScenarioSimulationSaveValidator_10", (String)"tmc-mrm-business", (Object[])new Object[0]), sectionDesc));
                continue;
            }
            block1: for (int i = 0; i < simulatesubentryList.size(); ++i) {
                BigDecimal subSimulateExrate;
                int j;
                DynamicObject simulateentry = (DynamicObject)simulatesubentryList.get(i);
                DynamicObject currency = simulateentry.getDynamicObject("subsimulatecurrency");
                if (currency == null) {
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"%1$s\u533a\u95f4\u6bb5\u7684\u6a21\u62df\u6c47\u7387\u5206\u5f55\u7b2c%2$s\u884c\u5e01\u79cd\u672a\u586b\u3002", (String)"ExScenarioSimulationSaveValidator_2", (String)"tmc-mrm-business", (Object[])new Object[0]), sectionDesc, i + 1));
                }
                if (isPercentSimulateFormEnum) {
                    for (j = 0; j < simulatenum; ++j) {
                        subSimulateExrate = simulateentry.getBigDecimal("subsimulateexrate" + (j + 1));
                        if (subSimulateExrate.compareTo(BigDecimal.valueOf(-100L)) >= 0 && subSimulateExrate.compareTo(BigDecimal.valueOf(100L)) <= 0) continue;
                        this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"%1$s\u533a\u95f4\u6bb5\u7684\u6a21\u62df\u6c47\u7387\u5206\u5f55\u7b2c%2$s\u884c\u7684\u6a21\u62df\u6c47\u7387\u8981\u5927\u4e8e\u7b49\u4e8e-100\u4e14\u5c0f\u4e8e\u7b49\u4e8e100\u3002", (String)"ExScenarioSimulationSaveValidator_8", (String)"tmc-mrm-business", (Object[])new Object[0]), sectionDesc, i + 1));
                        continue block1;
                    }
                    continue;
                }
                for (j = 0; j < simulatenum; ++j) {
                    subSimulateExrate = simulateentry.getBigDecimal("subsimulateexrate" + (j + 1));
                    if (subSimulateExrate.compareTo(BigDecimal.ZERO) > 0) continue;
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"%1$s\u533a\u95f4\u6bb5\u7684\u6a21\u62df\u6c47\u7387\u5206\u5f55\u7b2c%2$s\u884c\u7684\u6a21\u62df\u6c47\u7387\u8981\u5927\u4e8e0\u3002", (String)"ExScenarioSimulationSaveValidator_12", (String)"tmc-mrm-business", (Object[])new Object[0]), sectionDesc, i + 1));
                    continue block1;
                }
            }
        }
    }

    private void validateSecion(ExtendedDataEntity extendedDataEntity, DynamicObject data) {
        String sectiontype = data.getString("sectiontype");
        if (ExSectionTypeEnum.isMutilSection((String)sectiontype)) {
            if (data.getDynamicObjectCollection("sectionentry").size() > 50) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u7f3a\u53e3\u533a\u95f4\u6bb5\u4e2a\u6570\u4e0d\u80fd\u8d85\u8fc750\u3002", (String)"SectionCfgSaveValidator_3", (String)"tmc-mrm-business", (Object[])new Object[0]));
                return;
            }
            if (data.getDynamicObjectCollection("sectionentry").size() == 1) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u81f3\u5c11\u8bbe\u7f6e2\u4e2a\u7f3a\u53e3\u533a\u95f4\u6bb5\u3002", (String)"SectionCfgSaveValidator_4", (String)"tmc-mrm-business", (Object[])new Object[0]));
                return;
            }
            if (data.getDynamicObjectCollection("sectionentry").size() == 0) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u7f3a\u53e3\u533a\u95f4\u6bb5\u6ca1\u6709\u8bbe\u7f6e\u3002", (String)"SectionCfgSaveValidator_1", (String)"tmc-mrm-business", (Object[])new Object[0]));
                return;
            }
            for (int i = 1; i < data.getDynamicObjectCollection("sectionentry").size(); ++i) {
                if (((DynamicObject)data.getDynamicObjectCollection("sectionentry").get(i)).getInt("left") != 0) continue;
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u7b2c%s\u884c\u7684\u533a\u95f4\u6bb5\u5de6\u4fa7\u70b9\u6ca1\u6709\u8bbe\u7f6e\u3002", (String)"SectionCfgSaveValidator_0", (String)"tmc-mrm-business", (Object[])new Object[]{i + 1}));
            }
            if (EmptyUtil.isEmpty((Object)((DynamicObject)data.getDynamicObjectCollection("sectionentry").get(0)).get("unit"))) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u533a\u95f4\u6bb5\u65f6\u95f4\u957f\u5ea6\u6ca1\u6709\u8bbe\u7f6e\u3002", (String)"SectionCfgSaveValidator_2", (String)"tmc-mrm-business", (Object[])new Object[0]));
            }
        }
    }
}

