/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.business.validate.sensitivityanalysis;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ExRateSensitivityAnalysisSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("org");
        selector.add("basecurrency");
        selector.add("name");
        selector.add("amtunit");
        selector.add("useexsitgap");
        selector.add("exrategap");
        selector.add("subjectsystem");
        selector.add("sectioncfg");
        selector.add("currentanalysisobj");
        selector.add("forexquote");
        selector.add("scenariosimulation");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            this.validateMustInput(extendedDataEntity, "name");
            if (this.validateMustInput(extendedDataEntity, "org") && dataEntity.get("basecurrency") == null) {
                DynamicObject org = dataEntity.getDynamicObject("org");
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u201d%s\u201d\u5206\u6790\u4e3b\u4f53\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7684\u672c\u4f4d\u5e01\uff0c\u8bf7\u5148\u7ef4\u62a4\u672c\u4f4d\u5e01\u3002", (String)"ExRateSensitivityAnalysisSaveValidator_0", (String)"tmc-mrm-business", (Object[])new Object[]{org.getString("name")}));
            }
            this.validateMustInput(extendedDataEntity, "amtunit");
            if (dataEntity.getBoolean("useexsitgap")) {
                this.validateMustInput(extendedDataEntity, "exrategap");
            } else {
                this.validateMustInput(extendedDataEntity, "subjectsystem");
                this.validateMustInput(extendedDataEntity, "sectioncfg");
                this.validateMustInput(extendedDataEntity, "currentanalysisobj");
            }
            this.validateMustInput(extendedDataEntity, "forexquote");
            this.validateMustInput(extendedDataEntity, "scenariosimulation");
        }
    }

    private boolean validateMustInput(ExtendedDataEntity dataEntity, String columnKey) {
        Object v = dataEntity.getDataEntity().get(columnKey);
        if (EmptyUtil.isEmpty((Object)v) || v instanceof OrmLocaleValue && ((OrmLocaleValue)v).isEmpty()) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c%s\u201d\u3002", (String)"ExRateSensitivityAnalysisSaveValidator_1", (String)"tmc-mrm-business", (Object[])new Object[]{((IDataEntityProperty)dataEntity.getDataEntity().getDataEntityType().getProperties().get((Object)columnKey)).getDisplayName()}));
            return false;
        }
        return true;
    }
}

