/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.business.validate.sensitivityanalysis;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;

public class SensitivityAnalysisSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("scenariosimulation.scenariotype");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            this.validateSensitivityAnalysis(extendedDataEntity);
        }
    }

    private void validateSensitivityAnalysis(ExtendedDataEntity extendedDataEntity) {
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        DynamicObjectCollection scenariosimulations = dataEntity.getDynamicObjectCollection("scenariosimulation");
        Set collect = scenariosimulations.stream().map(e -> e.getDynamicObject("fbasedataid").getString("scenariotype")).collect(Collectors.toSet());
        if (collect.size() > 1) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u591a\u9009\u60c5\u666f\u65f6\u8bf7\u9009\u62e9\u540c\u4e00\u7c7b\u578b\u7684\u60c5\u666f\u3002", (String)"SensitivityAnalysisSaveValidator_0", (String)"tmc-mrm-business", (Object[])new Object[0]));
        }
        if (scenariosimulations.size() > 5) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u60c5\u666f\u6a21\u62df\u6700\u591a\u9009\u62e95\u4e2a\u3002", (String)"SensitivityAnalysisSaveValidator_1", (String)"tmc-mrm-business", (Object[])new Object[0]));
        }
    }
}

