/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.business.validate.subject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SubjectSystemSaveValidator
extends AbstractTmcBizOppValidator {
    private static List<String> FOREX_BILLS = new ArrayList<String>(4);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("enable");
        selector.add("subjecttreeentry");
        selector.add("subjecttreeentry.subject");
        selector.add("subjecttreeentry.ordernum");
        selector.add("subjecttreeentry.seq");
        selector.add("subjecttreeentry.mapping_tag");
        selector.add("subjecttreeentry.isleaf");
        selector.add("subjecttreeentry.level");
        selector.add("subjecttreeentry.direct");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            if (!this.validateReference(extendedDataEntity)) continue;
            DynamicObjectCollection subjectEntryColl = dataEntity.getDynamicObjectCollection("subjecttreeentry");
            HashMap<String, Set<DynamicObject>> billType2EntryMapForDup = new HashMap<String, Set<DynamicObject>>(10);
            if (!subjectEntryColl.isEmpty()) {
                ArrayList<Long> list = new ArrayList<Long>(subjectEntryColl.size());
                boolean isTip = false;
                for (DynamicObject subjectEntryDO : subjectEntryColl) {
                    String direct;
                    String mappingTag;
                    boolean isLeaf;
                    DynamicObject subject = subjectEntryDO.getDynamicObject("subject");
                    if (subject != null) {
                        Long id = (Long)subject.getPkValue();
                        if (!list.contains(id)) {
                            list.add(id);
                        } else {
                            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"%s\u7684\u79d1\u76ee\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"SubjectSystemSaveValidator_0", (String)"tmc-mrm-business", (Object[])new Object[]{subjectEntryDO.getString("ordernum")}));
                        }
                    }
                    if (isLeaf = subjectEntryDO.getBoolean("isleaf")) {
                        mappingTag = subjectEntryDO.getString("mapping_tag");
                        if (EmptyUtil.isEmpty((String)mappingTag)) {
                            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"%s\u7684\u6620\u5c04\u672a\u7ef4\u62a4\uff0c\u8bf7\u7ef4\u62a4\u3002", (String)"SubjectSystemSaveValidator_1", (String)"tmc-mrm-business", (Object[])new Object[]{subjectEntryDO.getString("ordernum")}));
                        } else {
                            this.toBillType2EntryMap(billType2EntryMapForDup, subjectEntryDO, mappingTag);
                        }
                        if (!EmptyUtil.isEmpty((String)(direct = subjectEntryDO.getString("direct")))) continue;
                        this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"%s\u7684\u5230\u671f\u73b0\u91d1\u6d41\u65b9\u5411\u672a\u7ef4\u62a4\uff0c\u8bf7\u7ef4\u62a4\u3002", (String)"SubjectSystemSaveValidator_4", (String)"tmc-mrm-business", (Object[])new Object[]{subjectEntryDO.getString("ordernum")}));
                        continue;
                    }
                    mappingTag = subjectEntryDO.getString("mapping_tag");
                    direct = subjectEntryDO.getString("direct");
                    if (!EmptyUtil.isNotEmpty((CharSequence)mappingTag) && !EmptyUtil.isNotEmpty((CharSequence)direct)) continue;
                    isTip = true;
                }
                if (isTip) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4ec5\u6700\u5b50\u7ea7\u8282\u70b9\u53ef\u8bbe\u7f6e\u5230\u671f\u73b0\u91d1\u6d41\u65b9\u5411\u548c\u6620\u5c04\uff0c\u8bf7\u4fee\u6539\u3002", (String)"SubjectSystemSaveValidator_6", (String)"tmc-mrm-business", (Object[])new Object[0]));
                }
            } else {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u79d1\u76ee\u4f53\u7cfb\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SubjectSystemSaveValidator_3", (String)"tmc-mrm-business", (Object[])new Object[0]));
            }
            this.checkDupOnCashFlowDirect(extendedDataEntity, billType2EntryMapForDup);
        }
    }

    private boolean validateReference(ExtendedDataEntity extendedDataEntity) {
        List list;
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        Object id = dataEntity.getPkValue();
        if (EmptyUtil.isNoEmpty((Object)id) && !(list = BaseDataRefrenceHelper.getAllRefs((String)dataEntity.getDataEntityType().getName(), (Object)id)).isEmpty()) {
            Set refEntitySet = list.stream().map(o -> o.getRefEntityKey()).collect(Collectors.toSet());
            Set<String> bills = new HashSet<String>(3);
            if (refEntitySet.contains("mrm_gap_analysis")) {
                bills.add(MetadataServiceHelper.getDataEntityType((String)"mrm_gap_analysis").getDisplayName().getLocaleValue());
            }
            if (refEntitySet.contains("mrm_exrate_gap_analysis")) {
                bills.add(MetadataServiceHelper.getDataEntityType((String)"mrm_exrate_gap_analysis").getDisplayName().getLocaleValue());
            }
            if (refEntitySet.contains("mrm_exrate_sensitivity")) {
                bills.add(MetadataServiceHelper.getDataEntityType((String)"mrm_exrate_sensitivity").getDisplayName().getLocaleValue());
            }
            if (!bills.isEmpty()) {
                bills = bills.stream().map(o -> "\u201c" + o + "\u201d").collect(Collectors.toSet());
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8be5\u98ce\u9669\u5206\u6790\u79d1\u76ee\u4f53\u7cfb\u5df2\u88ab%s\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"SubjectSystemSaveValidator_11", (String)"tmc-mrm-business", (Object[])new Object[]{String.join((CharSequence)"\u3001", bills)}));
                return false;
            }
        }
        return true;
    }

    private void checkDupOnCashFlowDirect(ExtendedDataEntity extendedDataEntity, Map<String, Set<DynamicObject>> billType2EntryMapForDup) {
        ArrayList<String> dupBillSet = new ArrayList<String>();
        for (Map.Entry<String, Set<DynamicObject>> entry : billType2EntryMapForDup.entrySet()) {
            String btype;
            String billTypeStr = entry.getKey();
            Set<DynamicObject> mapps = entry.getValue();
            if (mapps.size() <= 1 || !FOREX_BILLS.contains(btype = billTypeStr.split("#")[0])) continue;
            dupBillSet.add(btype);
        }
        if (dupBillSet.size() > 0) {
            DynamicObject[] billNames = TmcDataServiceHelper.load((String)"bos_formmeta", (String)"name", (QFilter[])new QFilter[]{new QFilter("number", "in", dupBillSet)});
            ArrayList<String> nameList = new ArrayList<String>(billNames.length);
            for (DynamicObject nameDO : billNames) {
                nameList.add(nameDO.getLocaleString("name").getLocaleValue());
            }
            this.addErrorMessage(extendedDataEntity, String.format("%s%s", String.join((CharSequence)",", nameList), ResManager.loadKDString((String)"\u76f8\u540c\u7684\u5230\u671f\u73b0\u91d1\u6d41\u65b9\u5411\u4e0d\u80fd\u6709\u76f8\u540c\u7684\u79d1\u76ee\u6620\u5c04\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"SubjectSystemSaveValidator_7", (String)"tmc-mrm-business", (Object[])new Object[0])));
        }
    }

    private void toBillType2EntryMap(Map<String, Set<DynamicObject>> billType2EntryMapForDup, DynamicObject subjectEntryDO, String mappingTag) {
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)mappingTag, FilterCondition.class);
        List filterRow = filterCondition.getFilterRow();
        ArrayList billTypes = new ArrayList(10);
        for (SimpleFilterRow simpleFilterRow : filterRow) {
            List value = simpleFilterRow.getBaseDataIds();
            List collect = value.stream().map(a -> (String)a.getValue()).collect(Collectors.toList());
            billTypes.addAll(collect);
        }
        for (String billType : billTypes) {
            Set<DynamicObject> entrySet = billType2EntryMapForDup.get(billType = String.join((CharSequence)"#", billType, subjectEntryDO.getString("direct")));
            if (entrySet == null) {
                entrySet = new HashSet<DynamicObject>(5);
                billType2EntryMapForDup.put(billType, entrySet);
            }
            entrySet.add(subjectEntryDO);
        }
    }

    static {
        FOREX_BILLS.add("tm_forex");
        FOREX_BILLS.add("tm_forex_forward");
        FOREX_BILLS.add("tm_forex_options");
        FOREX_BILLS.add("tm_forex_swaps");
    }
}

