/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.formplugin.analysisobj;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.control.FilterGrid;
import kd.bos.lang.Lang;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mrm.common.enums.AnalysisObjTypeEnum;

public class AbstractAnalysisObjEdit
extends AbstractBasePlugIn {
    protected void initFilterControl(String objType) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergrid");
        filterGrid.SetValue(new FilterCondition());
        if (AnalysisObjTypeEnum.CURRENT.getValue().equals(objType)) {
            List<String> noFilterFields = Arrays.asList("ratedraft", "billno");
            this.setFilterControl(filterGrid, "mrm_rate_draft_data", noFilterFields);
        } else if (AnalysisObjTypeEnum.EXRATE.getValue().equals(objType)) {
            List<String> noFilterFields = Arrays.asList("billstatus", "exratedraft", "billno");
            this.setFilterControl(filterGrid, "mrm_exrate_draft_data", noFilterFields);
        } else {
            List<String> noFilterFields = Arrays.asList("ratedraft", "bizbillno", "bankaccount.number", "bankaccount.name");
            this.setFilterControl(filterGrid, "mrm_rate_predict_data", noFilterFields);
        }
        this.getView().updateView("filtergrid");
    }

    private void setFilterControl(FilterGrid filterGrid, String entity, List<String> noFilterFields) {
        filterGrid.setEntityNumber(entity);
        Map<String, List<String>> filterFieldMap = this.getFilterFields(entity);
        List<String> fieldNameList = filterFieldMap.get("FieldNameList");
        List<String> fieldCaptionList = filterFieldMap.get("FieldCaptionList");
        filterGrid.setFilterFieldKeys(fieldNameList);
        EntityTypeUtil entityTypeUtil = new EntityTypeUtil();
        Map<String, Map> filterColumnsTemp = entityTypeUtil.createFilterColumns((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)entity), false).stream().filter(m -> fieldNameList.contains(m.get("fieldName"))).collect(Collectors.toMap(m -> (String)m.get("fieldName"), m -> m));
        ArrayList<Map> filterColumns = new ArrayList<Map>(fieldNameList.size());
        for (int i = 0; i < fieldNameList.size(); ++i) {
            String fieldName = fieldNameList.get(i);
            String fieldCaption = fieldCaptionList.get(i);
            if (noFilterFields.contains(fieldName)) continue;
            Map filterColumn = filterColumnsTemp.get(fieldName);
            if (EmptyUtil.isEmpty((String)fieldCaption)) {
                filterColumns.add(filterColumn);
                continue;
            }
            filterColumn.put("fieldCaption", fieldCaption);
            filterColumns.add(filterColumn);
        }
        filterGrid.setFilterColumns(filterColumns);
    }

    private Map<String, List<String>> getFilterFields(String entity) {
        HashMap<String, List<String>> FilterMap = new HashMap<String, List<String>>();
        Map filterMeta = FormMetadataCache.getFilterMeta((String)entity);
        String filterContainer = (String)filterMeta.get("FilterContainer");
        Map filterContainerMap = (Map)SerializationUtils.fromJsonString((String)filterContainer, Map.class);
        List items = (List)filterContainerMap.get("Items");
        ArrayList<String> fieldNameList = new ArrayList<String>();
        ArrayList<String> fieldCaptionList = new ArrayList<String>();
        for (Map item : items) {
            String key = (String)item.get("Key");
            if (!"schemefilterview".equals(key)) continue;
            List items1 = (List)item.get("Items");
            for (Map map : items1) {
                String fieldName = (String)map.get("FieldName");
                Map caption = (Map)map.get("Caption");
                Lang lang = Lang.get();
                fieldNameList.add(fieldName);
                if (!EmptyUtil.isEmpty((Object)caption) && caption.containsKey(lang.toString())) {
                    fieldCaptionList.add((String)caption.get(lang.toString()));
                    continue;
                }
                fieldCaptionList.add("");
            }
            FilterMap.put("FieldNameList", fieldNameList);
            FilterMap.put("FieldCaptionList", fieldCaptionList);
        }
        return FilterMap;
    }

    protected void initCondition() {
        FilterCondition filterCondition;
        this.getModel().getDataEntityType();
        String filterConditionStr = (String)this.getModel().getValue("filterconditionstr_tag");
        if (EmptyUtil.isNoEmpty((String)filterConditionStr) && (filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterConditionStr, FilterCondition.class)) != null) {
            FilterGrid filterControl = (FilterGrid)this.getView().getControl("filtergrid");
            filterControl.SetValue(filterCondition);
        }
    }

    protected String getFilterConditionStr() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergrid");
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        return SerializationUtils.toJsonString((Object)filterGridState.getFilterCondition());
    }

    protected List<Long> getPermOrgIds() {
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)"08", (String)this.getView().getFormShowParameter().getAppId(), (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
        if (result != null && !result.hasAllOrgPerm()) {
            return result.getHasPermOrgs();
        }
        return null;
    }
}

