/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.formplugin.analysisobj;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeF7ViewDetailEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.RateSignEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mrm.common.enums.AnalysisObjTypeEnum;
import kd.tmc.mrm.formplugin.analysisobj.AbstractAnalysisObjEdit;

public class AnalysisObjEdit
extends AbstractAnalysisObjEdit
implements HyperLinkClickListener,
BeforeF7SelectListener {
    public static final String CALL_BACK_OBJTYPE = "call_back_objtype";

    public void registerListener(EventObject e) {
        BillList predictdatalist;
        super.registerListener(e);
        BasedataEdit draft = (BasedataEdit)this.getControl("draft");
        draft.addBeforeF7ViewDetailListener(this::beforeF7ViewDetail);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        BillList draftdatalist = (BillList)this.getControl("draftdatalist");
        if (draftdatalist != null) {
            draftdatalist.addHyperClickListener((HyperLinkClickListener)this);
        }
        if ((predictdatalist = (BillList)this.getControl("predictdatalist")) != null) {
            predictdatalist.addHyperClickListener((HyperLinkClickListener)this);
        }
        this.initDatalistFilter(this.getFilterConditionStr(), false);
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        String fieldName = event.getFieldName();
        if (StringUtils.equals((CharSequence)"billno", (CharSequence)fieldName)) {
            String objType = (String)this.getModel().getValue("objtype");
            String entity = AnalysisObjTypeEnum.CURRENT.getValue().equals(objType) ? "mrm_rate_draft_data" : "mrm_rate_predict_data";
            BillList billList = (BillList)event.getSource();
            BillShowParameter parameter = new BillShowParameter();
            parameter.setPkId(billList.getFocusRowPkId());
            parameter.setFormId(entity);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setStatus(OperationStatus.VIEW);
            parameter.setBillStatus(BillOperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent f7Evt) {
        String propName;
        switch (propName = f7Evt.getProperty().getName()) {
            case "org": {
                this.orgF7Evt(f7Evt);
                break;
            }
        }
    }

    public void orgF7Evt(BeforeF7SelectEvent f7Evt) {
        ListShowParameter showParameter = (ListShowParameter)f7Evt.getFormShowParameter();
        List qFilters = showParameter.getListFilterParameter().getQFilters();
        qFilters.removeIf(e -> "id".equals(e.getProperty()));
        String appId = this.getView().getFormShowParameter().getAppId();
        List comIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
        qFilters.add(new QFilter("id", "in", (Object)comIdList));
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object org = this.getModel().getValue("org");
        if (EmptyUtil.isEmpty((Object)org)) {
            String appId = this.getView().getFormShowParameter().getAppId();
            DynamicObject currentPermOrg = TmcOrgDataHelper.getCurrentPermOrg((String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47156aff000000ac");
            this.getModel().setValue("org", (Object)currentPermOrg);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        switch (name) {
            case "objtype": {
                String newobjtype = (String)newValue;
                String oldobjtype = (String)oldValue;
                this.getPageCache().put("newobjtype", newobjtype);
                this.getPageCache().put("oldobjtype", oldobjtype);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5206\u6790\u5bf9\u8c61\u7c7b\u578b\u53d1\u751f\u6539\u53d8\u5c06\u6e05\u7a7a\u5206\u5f55\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"AnalysisObjEdit_1", (String)"tmc-mrm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(CALL_BACK_OBJTYPE, (IFormPlugin)this));
                break;
            }
            case "isautoupdate": {
                Object[] maxDrafts;
                boolean isautoupdate = (Boolean)newValue;
                if (!isautoupdate || EmptyUtil.isEmpty((Object[])(maxDrafts = TmcDataServiceHelper.load((String)"mrm_rate_draft", (String)"id,billno", null, (String)"draftcreatetime desc", (int)1)))) break;
                Object draftDb = maxDrafts[0];
                this.getModel().setValue("draft", draftDb);
                break;
            }
        }
    }

    private void beforeF7ViewDetail(BeforeF7ViewDetailEvent event) {
        Object pkId = event.getPkId();
        BasedataEdit source = (BasedataEdit)event.getSource();
        String key = source.getKey();
        if ("draft".equals(key)) {
            event.setCancel(true);
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.setFormId("mrm_rate_draft");
            billShowParameter.setPkId(pkId);
            billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            billShowParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)billShowParameter);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initDatalistFilter((String)this.getModel().getValue("filterconditionstr_tag"), true);
        String objType = (String)this.getModel().getValue("objtype");
        this.controlDataList(objType);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String objtype = (String)this.getModel().getValue("objtype");
        this.setObjTypeVisible(objtype);
        this.setObjTypeEnable(objtype);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        if ("updateandsave".equals(key)) {
            String filterConditionStr = this.getFilterConditionStr();
            this.getModel().setValue("filterconditionstr_tag", (Object)filterConditionStr);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        OperationResult operationResult;
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if (("disable".equals(operateKey) || "enable".equals(operateKey) || "updateandsave".equals(operateKey)) && (operationResult = e.getOperationResult()).isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (CALL_BACK_OBJTYPE.equals(callBackId)) {
            String newobjtype = this.getPageCache().get("newobjtype");
            String oldobjtype = this.getPageCache().get("oldobjtype");
            if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
                QFilter qFilter;
                Long id = (Long)this.getModel().getValue("id");
                if (!EmptyUtil.isEmpty((Long)id) && QueryServiceHelper.exists((String)"mrm_gap_analysis", (QFilter[])(qFilter = AnalysisObjTypeEnum.FUTURE.getValue().equals(oldobjtype) ? new QFilter("futureanalysisobj.fbasedataid.id", "=", (Object)id) : new QFilter("currentanalysisobj", "=", (Object)id)).toArray())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5206\u6790\u5bf9\u8c61\u88ab\u5f15\u7528\uff0c\u4e0d\u80fd\u5207\u6362\u5206\u6790\u5bf9\u8c61\u7c7b\u578b\u3002", (String)"AnalysisObjEdit_2", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"objtype", (Object)oldobjtype);
                    if (AnalysisObjTypeEnum.FUTURE.getValue().equals(oldobjtype)) {
                        this.getView().setVisible(Boolean.FALSE, new String[]{"isautoupdate", "draft", "draftdatetime"});
                    }
                    return;
                }
                this.initFilterControl(newobjtype);
                this.controlDataList(newobjtype);
                this.setObjTypeVisible(newobjtype);
            } else {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"objtype", (Object)oldobjtype);
                this.setObjTypeVisible(oldobjtype);
            }
        }
    }

    private void controlDataList(String objType) {
        if (AnalysisObjTypeEnum.CURRENT.getValue().equals(objType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"apratedraft"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"apratepredict"});
            BillList datalist = (BillList)this.getControl("predictdatalist");
            datalist.addSetFilterListener(evt -> evt.getQFilters().add(QFilter.of((String)"1!=1", (Object[])new Object[0])));
            datalist.clearData();
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"apratedraft"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"apratepredict"});
            BillList draftdatalist = (BillList)this.getControl("draftdatalist");
            draftdatalist.addSetFilterListener(evt -> evt.getQFilters().add(QFilter.of((String)"1!=1", (Object[])new Object[0])));
            draftdatalist.clearData();
        }
    }

    private void setObjTypeEnable(String objtype) {
        Long id = (Long)this.getModel().getValue("id");
        if (!EmptyUtil.isEmpty((Long)id)) {
            QFilter qFilter = AnalysisObjTypeEnum.FUTURE.getValue().equals(objtype) ? new QFilter("futureanalysisobj.fbasedataid.id", "=", (Object)id) : new QFilter("currentanalysisobj", "=", (Object)id);
            this.getView().setEnable(Boolean.valueOf(!QueryServiceHelper.exists((String)"mrm_gap_analysis", (QFilter[])qFilter.toArray())), new String[]{"objtype"});
        }
    }

    private void setObjTypeVisible(String objtype) {
        if (AnalysisObjTypeEnum.FUTURE.getValue().equals(objtype)) {
            this.getModel().setValue("draft", null);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"isautoupdate", (Object)false);
            this.getView().setVisible(Boolean.FALSE, new String[]{"isautoupdate", "draft", "draftdatetime"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"isautoupdate", "draft", "draftdatetime"});
        }
    }

    private void addDatalistFilter(BillList draftdatalist, DynamicObject draft, String filterStr, String entity, boolean clearFilter) {
        QFilter conditionFilter;
        List<Long> orgIds = this.getPermOrgIds();
        QFilter filter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        if (draft != null) {
            filter.and(new QFilter("ratedraft", "=", draft.getPkValue()));
        }
        if ((conditionFilter = this.getFilter(entity, filterStr)) != null) {
            filter.and(conditionFilter);
        }
        if (!EmptyUtil.isEmpty(orgIds)) {
            filter.and("org", "in", orgIds);
        }
        draftdatalist.addSetFilterListener(evt -> {
            List qFilters = evt.getQFilters();
            if (clearFilter) {
                qFilters.removeIf(e -> !e.getProperty().equals("predict"));
            }
            qFilters.add(filter);
        });
    }

    private void initDatalistFilter(String filterStr, boolean clearFilter) {
        String objType = (String)this.getModel().getValue("objtype");
        if (AnalysisObjTypeEnum.CURRENT.getValue().equals(objType)) {
            BillList draftdatalist = (BillList)this.getControl("draftdatalist");
            if (draftdatalist == null) {
                return;
            }
            DynamicObject draft = (DynamicObject)this.getModel().getValue("draft");
            if (draft != null) {
                this.addDatalistFilter(draftdatalist, draft, filterStr, "mrm_rate_draft_data", clearFilter);
            } else {
                draftdatalist.addSetFilterListener(evt -> evt.getQFilters().add(QFilter.of((String)"1!=1", (Object[])new Object[0])));
            }
        } else {
            BillList draftdatalist = (BillList)this.getControl("predictdatalist");
            if (draftdatalist == null) {
                return;
            }
            this.addDatalistFilter(draftdatalist, null, filterStr, "mrm_rate_predict_data", clearFilter);
            draftdatalist.addBeforePackageDataListener(evt -> {
                DynamicObjectCollection pageDatas = evt.getPageData();
                Set ids = pageDatas.stream().map(DataEntityBase::getPkValue).collect(Collectors.toSet());
                DynamicObjectCollection predicts = QueryServiceHelper.query((String)"mrm_rate_predict_data", (String)"id,ratesign,basepoint", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
                for (DynamicObject predict : predicts) {
                    Optional<DynamicObject> firstDataOptional;
                    String rateSign = predict.getString("ratesign");
                    BigDecimal basepoint = predict.getBigDecimal("basepoint");
                    if (!RateSignEnum.isSubtract((String)rateSign) || !(firstDataOptional = pageDatas.stream().filter(e -> e.getLong("id") == predict.getLong("id")).findFirst()).isPresent()) continue;
                    DynamicObject dynamicObject = firstDataOptional.get();
                    dynamicObject.set("basepoint", (Object)basepoint.negate());
                }
            });
        }
    }

    private QFilter getFilter(String entryName, String filterConditionStr) {
        if (EmptyUtil.isEmpty((String)filterConditionStr)) {
            return null;
        }
        FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)filterConditionStr, FilterCondition.class);
        MainEntityType dataType = EntityMetadataCache.getDataEntityType((String)entryName);
        FilterBuilder fb = new FilterBuilder(dataType, condition, true);
        fb.buildFilter(true);
        return fb.getQFilter();
    }
}

