/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.formplugin.analysisobj;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mrm.common.enums.AnalysisObjTypeEnum;
import kd.tmc.mrm.formplugin.analysisobj.AbstractAnalysisObjEdit;

public class AnalysisObjFilterEdit
extends AbstractAnalysisObjEdit
implements BeforeFilterF7SelectListener {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String objType = (String)this.getModel().getValue("objtype");
        this.initFilterControl(objType);
        this.initCondition();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergrid");
        filterGrid.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent e) {
        List<Long> permOrgIds;
        String fieldName = e.getFieldName();
        if (EmptyUtil.isNoEmpty((String)fieldName) && fieldName.startsWith("org.")) {
            String appId = this.getView().getFormShowParameter().getAppId();
            List orgIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"mrm_rate_draft_data", (String)"47150e89000000ac");
            e.getQfilters().add(new QFilter("id", "in", (Object)orgIdList));
        }
        if (EmptyUtil.isNoEmpty((String)fieldName) && fieldName.startsWith("billtype.")) {
            QFilter qFilter = new QFilter("enable", "=", (Object)"1");
            qFilter.and("type", "=", (Object)"rate");
            DynamicObjectCollection sourceBill = QueryServiceHelper.query((String)"mrm_draft_datasource", (String)"sourcebill.number", (QFilter[])qFilter.toArray());
            List numbers = sourceBill.stream().map(a -> a.getString("sourcebill.number")).collect(Collectors.toList());
            e.getQfilters().add(new QFilter("number", "in", numbers));
        }
        if (EmptyUtil.isNoEmpty((String)fieldName) && fieldName.startsWith("bankaccount.") && !EmptyUtil.isEmpty(permOrgIds = this.getPermOrgIds())) {
            e.getQfilters().add(new QFilter("openorg", "in", permOrgIds));
        }
        if (EmptyUtil.isNoEmpty((String)fieldName) && fieldName.startsWith("counterparty.")) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergrid");
            FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
            List filterRow = filterCondition.getFilterRow();
            String counterpartytype = "";
            for (SimpleFilterRow simpleFilterRow : filterRow) {
                String name = simpleFilterRow.getFieldName();
                if (!"counterpartytype".equals(name)) continue;
                List value = simpleFilterRow.getValue();
                counterpartytype = (String)((FilterValue)value.get(0)).getValue();
                break;
            }
            if ("bos_org".equals(counterpartytype)) {
                String objType = (String)this.getModel().getValue("objtype");
                if (AnalysisObjTypeEnum.FUTURE.getValue().equals(objType)) {
                    Map customParams = e.getCustomParams();
                    customParams.put("orgViewSchemeNumber", "08");
                }
            }
            if ("fbd_other".equals(counterpartytype)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ea4\u6613\u5bf9\u624b\u7c7b\u578b\u4e3a\u5176\u4ed6\uff0c\u8bf7\u7528\u201c\u5176\u4ed6\u4ea4\u6613\u5bf9\u624b\u201d\u8fdb\u884c\u8fc7\u6ee4\u3002", (String)"AnalysisObjFilterEdit_0", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
            }
        }
    }
}

