/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.formplugin.analysisobj;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeF7ViewDetailEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mrm.common.enums.DraftStatusEnum;
import kd.tmc.mrm.common.helper.OrgHelper;

public class ExAnalysisObjEdit
extends AbstractBasePlugIn
implements HyperLinkClickListener,
BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit draftdatabillno = (BasedataEdit)this.getControl("draft");
        draftdatabillno.addBeforeF7ViewDetailListener(this::beforeF7ViewDetail);
        BillList draftdatalist = (BillList)this.getControl("draftdatalist");
        if (draftdatalist != null) {
            draftdatalist.addHyperClickListener((HyperLinkClickListener)this);
            DynamicObject draft = (DynamicObject)this.getModel().getValue("draft");
            List orgIds = OrgHelper.getPermOrgIds(null, null, null, (String)this.getView().getFormShowParameter().getAppId(), (String)this.getModel().getDataEntityType().getName());
            if (draft != null) {
                QFilter schemaFilter;
                QFilter filter = new QFilter("exratedraft", "=", draft.getPkValue());
                if (!EmptyUtil.isEmpty((Collection)orgIds)) {
                    filter.and("org", "in", (Object)orgIds);
                }
                if ((schemaFilter = this.getFilter("mrm_exrate_draft_data", this.getFilterConditionStr())) != null) {
                    filter.and(schemaFilter);
                }
                draftdatalist.addSetFilterListener(evt -> {
                    List qFilters = evt.getQFilters();
                    qFilters.add(filter);
                });
            }
        }
        OrgEdit org = (OrgEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    private void beforeF7ViewDetail(BeforeF7ViewDetailEvent event) {
        Object pkId = event.getPkId();
        BasedataEdit source = (BasedataEdit)event.getSource();
        String key = source.getKey();
        if ("draft".equals(key)) {
            event.setCancel(true);
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.setFormId("mrm_exrate_draft");
            billShowParameter.setPkId(pkId);
            billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            billShowParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)billShowParameter);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object org = this.getModel().getValue("org");
        if (EmptyUtil.isEmpty((Object)org)) {
            String appId = this.getView().getFormShowParameter().getAppId();
            DynamicObject currentPermOrg = TmcOrgDataHelper.getCurrentPermOrg((String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47156aff000000ac");
            this.getModel().setValue("org", (Object)currentPermOrg);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initDraftdatalistFilter((String)this.getModel().getValue("filterconditionstr_tag"));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        switch (name) {
            case "isautoupdate": {
                QFilter qFilter;
                Object[] maxDrafts;
                boolean isautoupdate = (Boolean)newValue;
                if (!isautoupdate || EmptyUtil.isEmpty((Object[])(maxDrafts = TmcDataServiceHelper.load((String)"mrm_exrate_draft", (String)"id,billno", (QFilter[])(qFilter = new QFilter("draftstatus", "=", (Object)DraftStatusEnum.FINISH.getValue())).toArray(), (String)"draftcreatedate desc", (int)1)))) break;
                Object draftDb = maxDrafts[0];
                this.getModel().setValue("draft", draftDb);
                break;
            }
        }
    }

    private List<Long> getPermOrgIds() {
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)"08", (String)this.getView().getFormShowParameter().getAppId(), (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
        if (result != null && !result.hasAllOrgPerm()) {
            return result.getHasPermOrgs();
        }
        return null;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        if ("updateandsave".equals(op.getOperateKey())) {
            String filterConditionStr = this.getFilterConditionStr();
            this.getModel().setValue("filterconditionstr_tag", (Object)filterConditionStr);
        }
    }

    private String getFilterConditionStr() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergrid");
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        return SerializationUtils.toJsonString((Object)filterGridState.getFilterCondition());
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        OperationResult operationResult;
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if (("disable".equals(operateKey) || "enable".equals(operateKey) || "updateandsave".equals(operateKey)) && (operationResult = e.getOperationResult()).isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void initDraftdatalistFilter(String filterStr) {
        BillList draftdatalist = (BillList)this.getControl("draftdatalist");
        if (draftdatalist == null) {
            return;
        }
        DynamicObject draft = (DynamicObject)this.getModel().getValue("draft");
        List orgIds = OrgHelper.getPermOrgIds(null, null, null, (String)this.getView().getFormShowParameter().getAppId(), (String)this.getModel().getDataEntityType().getName());
        if (draft != null) {
            QFilter schemaFilter;
            QFilter filter = new QFilter("exratedraft", "=", draft.getPkValue());
            if (!EmptyUtil.isEmpty((Collection)orgIds)) {
                filter.and("org", "in", (Object)orgIds);
            }
            if ((schemaFilter = this.getFilter("mrm_exrate_draft_data", filterStr)) != null) {
                filter.and(schemaFilter);
            }
            draftdatalist.addSetFilterListener(evt -> {
                List qFilters = evt.getQFilters();
                qFilters.clear();
                qFilters.add(filter);
            });
        } else {
            draftdatalist.addSetFilterListener(evt -> evt.getQFilters().add(QFilter.of((String)"1!=1", (Object[])new Object[0])));
        }
    }

    private QFilter getFilter(String entryName, String filterConditionStr) {
        if (EmptyUtil.isEmpty((String)filterConditionStr)) {
            return null;
        }
        FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)filterConditionStr, FilterCondition.class);
        MainEntityType dataType = EntityMetadataCache.getDataEntityType((String)entryName);
        FilterBuilder fb = new FilterBuilder(dataType, condition, true);
        fb.buildFilter(true);
        return fb.getQFilter();
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        String fieldName = event.getFieldName();
        if (StringUtils.equals((CharSequence)"billno", (CharSequence)fieldName)) {
            BillList billList = (BillList)event.getSource();
            BillShowParameter parameter = new BillShowParameter();
            parameter.setPkId(billList.getFocusRowPkId());
            parameter.setFormId("mrm_exrate_draft_data");
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setStatus(OperationStatus.VIEW);
            parameter.setBillStatus(BillOperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String name;
        switch (name = event.getProperty().getName()) {
            case "org": {
                List<Long> permOrgIds = this.getPermOrgIds();
                if (EmptyUtil.isEmpty(permOrgIds)) break;
                ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
                QFilter qFilter = new QFilter("id", "in", permOrgIds);
                showParameter.getListFilterParameter().getQFilters().add(qFilter);
                break;
            }
        }
    }
}

