/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.formplugin.draft;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;
import kd.tmc.mrm.common.helper.RateDraftHelper;

public class DraftConfigEdit
extends AbstractTmcBillEdit
implements BeforeF7SelectListener {
    private static final String BOTP_CONVERTRULE = "botp_convertrule";
    private static final String RATECONFIG_SAVE_CONFIRM = "rateconfig_save_confirm";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"ruletext"});
        BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl("sourcebill");
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String ruleId;
        DynamicObject sourceBill;
        super.afterDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        if ("draftview".equals(key) && args.getOperationResult().isSuccess()) {
            if (this.getModel().getEntryRowCount("entryentity") <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u7ef4\u5ea6\u914d\u7f6e\u4fe1\u606f\u3002", (String)"DraftConfigEdit_5", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
                return;
            }
            for (int i = 0; i < this.getModel().getEntryRowCount("entryentity"); ++i) {
                DynamicObject row = this.getModel().getEntryRowEntity("entryentity", i);
                if (!EmptyUtil.isEmpty((Object)row.get("ruleid"))) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ef4\u5ea6\u914d\u7f6e\u7b2c%s\u884c\u672a\u9009\u62e9\u5339\u914d\u89c4\u5219\u3002", (String)"DraftConfigEdit_6", (String)"tmc-mrm-formplugin", (Object[])new Object[]{i + 1}));
                return;
            }
            Map map = RateDraftHelper.genRateDraftDataExample((DynamicObject)this.getModel().getDataEntity());
            String error = (String)map.get("error");
            Long rateDraftId = (Long)map.get("rateDraftId");
            if (EmptyUtil.isNoEmpty((String)error)) {
                this.getView().showTipNotification(error);
            } else {
                ListShowParameter param = ShowFormHelper.createShowListForm((String)"mrm_rate_draft_data", (boolean)true, (int)0, (boolean)false);
                QFilter qFilter = new QFilter("ratedraft", "=", (Object)rateDraftId);
                ListFilterParameter filterParameter = new ListFilterParameter();
                filterParameter.setFilter(qFilter);
                param.setListFilterParameter(filterParameter);
                param.setCustomParam("draftview", (Object)"draftview");
                param.setShowFilter(false);
                this.getView().showForm((FormShowParameter)param);
            }
        }
        if ("select_rule".equals(key)) {
            int index = this.getModel().getEntryCurrentRowIndex("entryentity");
            sourceBill = (DynamicObject)this.getModel().getValue("sourcebill", index);
            ruleId = (String)this.getModel().getValue("ruleid", index);
            if (EmptyUtil.isEmpty((DynamicObject)sourceBill)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c%s\u201d\u3002", (String)"DraftConfigEdit_0", (String)"tmc-mrm-formplugin", (Object[])new Object[]{this.getModel().getProperty("sourcebill").getDisplayName().getLocaleValue()}));
                return;
            }
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("mrm_ruleselect");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            Map sourceBillNumber = RateDraftHelper.getSourceBillNumber((DynamicObject)sourceBill);
            showParameter.setCustomParam("sourceEntityNumber", sourceBillNumber.get("number"));
            showParameter.setCustomParam("sourceBotpEntityNumber", sourceBillNumber.get("baseDataNumber"));
            showParameter.setCustomParam("targetEntityNumber", (Object)"mrm_rate_draft_data");
            showParameter.setCustomParam("ruleid", (Object)ruleId);
            boolean preset = (Boolean)this.getModel().getValue("preset");
            if (preset) {
                showParameter.setCustomParam("preset", (Object)true);
            }
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "ruletext"));
            this.getView().showForm(showParameter);
        }
        if ("config_rule".equals(key)) {
            int index = this.getModel().getEntryCurrentRowIndex("entryentity");
            if (EmptyUtil.isEmpty((Object)this.getModel().getValue("sourcebill", index))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c%s\u201d\u3002", (String)"DraftConfigEdit_0", (String)"tmc-mrm-formplugin", (Object[])new Object[]{this.getModel().getProperty("sourcebill").getDisplayName().getLocaleValue()}));
                return;
            }
            sourceBill = (DynamicObject)this.getModel().getValue("sourcebill", index);
            ruleId = (String)this.getModel().getValue("ruleid", index);
            Map sourceBillNumber = RateDraftHelper.getSourceBillNumber((DynamicObject)sourceBill);
            this.showRuleForm((String)sourceBillNumber.get("baseDataNumber"), "mrm_rate_draft_data", ruleId);
        }
        if ("saveconfig".equals(key) && args.getOperationResult().isSuccess()) {
            OperationStatus status = this.getView().getFormShowParameter().getShowParameter().getStatus();
            if (OperationStatus.ADDNEW == status) {
                QFilter filter = new QFilter("enable", "=", (Object)true);
                DynamicObjectCollection draftCfg = QueryServiceHelper.query((String)"mrm_rate_draft_cfg", (String)"number", (QFilter[])filter.toArray());
                String numbers = draftCfg.stream().map(e -> e.getString("number")).collect(Collectors.joining(","));
                if (EmptyUtil.isNotEmpty((CharSequence)numbers)) {
                    this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u5df2\u542f\u7528\u7684%s\u5e95\u7a3f\u914d\u7f6e\uff0c\u7cfb\u7edf\u5c06\u7981\u7528\u540e\u518d\u4fdd\u5b58\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"DraftConfigEdit_1", (String)"tmc-mrm-formplugin", (Object[])new Object[0]), numbers), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(RATECONFIG_SAVE_CONFIRM, (IFormPlugin)this));
                } else {
                    OperateOption option = OperateOption.create();
                    this.getView().invokeOperation("save", option);
                }
            } else {
                OperateOption option = OperateOption.create();
                this.getView().invokeOperation("save", option);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (RATECONFIG_SAVE_CONFIRM.equals(callBackId) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("operateStatus", "addnew");
            this.getView().invokeOperation("save", option);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        int rowIndex = changeData[0].getRowIndex();
        if ("ruletext".equals(name) && EmptyUtil.isEmpty((Object)newValue)) {
            this.getModel().setValue("ruleid", null, rowIndex);
        }
        if ("sourcebill".equals(name)) {
            this.getModel().setValue("ruleid", null, rowIndex);
            this.getModel().setValue("ruletext", null, rowIndex);
        }
    }

    private void showRuleForm(String sourceBill, String targetBill, Object ruleId) {
        if (!StringUtils.isBlank((CharSequence)sourceBill) && !StringUtils.isBlank((CharSequence)targetBill)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(BOTP_CONVERTRULE);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setCustomParam("SourceBill", (Object)sourceBill);
            showParameter.setCustomParam("TargetBill", (Object)targetBill);
            showParameter.setCustomParam("ruleId", ruleId);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "ruleid"));
            showParameter.getCustomParams().put("checkRightAppId", this.getView().getFormShowParameter().getAppId());
            this.getView().showForm(showParameter);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        String fieldKey = arg0.getProperty().getName();
        if ("sourcebill".equals(fieldKey)) {
            ListShowParameter listShowParameter = (ListShowParameter)arg0.getFormShowParameter();
            QFilter filter = new QFilter("type", "=", (Object)"rate");
            DynamicObjectCollection entities = this.getModel().getEntryEntity("entryentity");
            int currIdx = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject sourceBill = (DynamicObject)this.getModel().getValue("sourcebill", currIdx);
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entities)) {
                ArrayList<Long> ids = new ArrayList<Long>(entities.size());
                for (DynamicObject row : entities) {
                    DynamicObject bill = row.getDynamicObject("sourcebill");
                    if (bill == null || sourceBill != null && Objects.equals(sourceBill.getString("id"), bill.getString("id"))) continue;
                    ids.add(bill.getLong("id"));
                }
                if (EmptyUtil.isNoEmpty(ids)) {
                    filter.and("id", "not in", ids);
                }
            }
            listShowParameter.setCaption(ResManager.loadKDString((String)"\u6570\u636e\u6e90", (String)"ExRateDraftConfigEdit_4", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
            listShowParameter.getListFilterParameter().getQFilters().add(filter);
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        this.getModel().beginInit();
        for (int i = 0; i < entryEntity.size(); ++i) {
            ConvertRuleElement convertRuleElement;
            String ruleId = ((DynamicObject)entryEntity.get(i)).getString("ruleid");
            if (EmptyUtil.isEmpty((String)ruleId) || (convertRuleElement = ConvertMetaServiceHelper.loadRule((String)ruleId)) == null) continue;
            String localeValue = convertRuleElement.getName().getLocaleValue();
            this.getModel().setValue("ruletext", (Object)localeValue, i);
        }
        this.getModel().endInit();
        this.getModel().setDataChanged(false);
        this.getView().updateView("entryentity");
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object rtn = e.getReturnData();
        if (rtn != null && "ruletext".equals(e.getActionId())) {
            int index = this.getModel().getEntryCurrentRowIndex("entryentity");
            Map map = (Map)rtn;
            this.getModel().setValue("ruleid", map.get("ruleid"), index);
            this.getModel().setValue("ruletext", map.get("ruletext"), index);
        }
    }
}

