/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.formplugin.draft;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mrm.common.enums.CounterPartyTypeEnum;
import kd.tmc.mrm.common.enums.ExRateDraftBizStatusEnum;

public class ExRateDraftDataEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit billType = (BasedataEdit)this.getControl("billtype");
        billType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit bankAccount = (BasedataEdit)this.getControl("bankaccount");
        bankAccount.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit currency = (BasedataEdit)this.getControl("currency");
        currency.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"billtype", "org", "currency", "amount", "startdate"});
        DynamicObject billType = (DynamicObject)this.getModel().getValue("billtype");
        if ("manual".equals(this.getModel().getValue("bizdatasource")) || "import".equals(this.getModel().getValue("bizdatasource"))) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"bizbillno", "bizbillstatus", "bizstatus", "counterpartytype", "counterparty", "counterpartytext", "currency"});
            if (!EmptyUtil.isEmpty((DynamicObject)billType)) {
                this.bizstatusItemChg(billType.getString("number"));
            }
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"bizbillno", "bizbillstatus", "bizstatus", "counterpartytype", "counterparty", "counterpartytext", "currency"});
        }
        if (!EmptyUtil.isEmpty((DynamicObject)billType) && ("bei_bankbalance".equals(billType.getString("number")) || "ifm_accountbalance".equals(billType.getString("number")))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"counterpartytype", "counterparty", "capcashflowentry"});
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs evt) {
        Map srcData = evt.getSourceData();
        Object exdraft = srcData.get("exratedraft");
        if (exdraft instanceof Long) {
            this.getModel().setValue("exratedraft", (Object)TmcDataServiceHelper.loadSingle(exdraft, (String)"mrm_exrate_draft"));
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("billstatus", (Object)"A");
        if (this.getModel().getValue("org") == null) {
            Long loginOrg = RequestContext.get().getOrgId();
            this.getModel().setValue("org", (Object)loginOrg);
        }
        if (OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            this.getModel().setValue("exratedraft", this.getView().getFormShowParameter().getCustomParam("exratedraft"));
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.getModel().setValue("billstatus", (Object)"A");
        if (this.getModel().getValue("org") == null) {
            Long loginOrg = RequestContext.get().getOrgId();
            this.getModel().setValue("org", (Object)loginOrg);
        }
        this.getModel().setValue("bizdatasource", (Object)"manual");
        DynamicObject billType = (DynamicObject)this.getModel().getValue("billtype");
        this.billTypeChgEvt(billType.getString("number"), true);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (key) {
            case "billtype": {
                DynamicObject billType = (DynamicObject)e.getChangeSet()[0].getNewValue();
                if (EmptyUtil.isEmpty((DynamicObject)billType)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u5355\u636e\u7c7b\u578b\u3002", (String)"ExRateDraftEdit_0", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.billTypeChgEvt(billType.getString("number"), false);
                break;
            }
            case "startdate": {
                String billTypeNumber;
                DynamicObject billTypeDo = (DynamicObject)this.getModel().getValue("billtype");
                switch (billTypeNumber = billTypeDo.getString("number")) {
                    case "cfm_loanbill_e_l": 
                    case "cfm_loanbill_b_l": 
                    case "cim_invest_loanbill": 
                    case "cfm_loanbill_bond": 
                    case "cim_deposit": 
                    case "cim_noticedeposit": 
                    case "cim_finsubscribe": 
                    case "fbd_suretybill": {
                        Date startDate = (Date)this.getModel().getValue("startdate");
                        Date interestDate = (Date)this.getModel().getValue("interestdate");
                        if (startDate == null || interestDate != null) break;
                        this.getModel().setValue("interestdate", (Object)startDate);
                    }
                }
                break;
            }
            case "bankaccount": {
                DynamicObject bankAccount = (DynamicObject)e.getChangeSet()[0].getNewValue();
                TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String[])new String[]{"counterparty", "currency"});
                DynamicObject billTypeBankAccount = (DynamicObject)this.getModel().getValue("billtype");
                if (EmptyUtil.isEmpty((DynamicObject)bankAccount)) break;
                if ("ifm_accountbalance".equals(billTypeBankAccount.getString("number"))) {
                    this.getModel().setValue("counterparty", (Object)bankAccount.getDynamicObject("openorg"));
                } else if ("bei_bankbalance".equals(billTypeBankAccount.getString("number"))) {
                    this.getModel().setValue("counterparty", (Object)bankAccount.getDynamicObject("bank"));
                }
                this.getModel().setValue("currency", (Object)bankAccount.getDynamicObject("defaultcurrency"));
                break;
            }
            case "org": {
                DynamicObject billTypeOrg = (DynamicObject)this.getModel().getValue("billtype");
                if (!"bei_bankbalance".equals(billTypeOrg.getString("number")) && !"ifm_accountbalance".equals(billTypeOrg.getString("number"))) break;
                this.getModel().setValue("bankaccount", null);
                break;
            }
            case "amount": {
                DynamicObject billTypeAmount = (DynamicObject)this.getModel().getValue("billtype");
                if (!"bei_bankbalance".equals(billTypeAmount.getString("number")) && !"ifm_accountbalance".equals(billTypeAmount.getString("number"))) break;
                this.getModel().setValue("capamount", this.getModel().getValue("amount"), 0);
                break;
            }
            case "counterparty": {
                if ("fbd_other".equals(this.getModel().getValue("counterpartytype"))) break;
                if (EmptyUtil.isEmpty((Object)newValue)) {
                    this.getModel().setValue("counterpartytext", null);
                    break;
                }
                DynamicObject counterParty = (DynamicObject)this.getModel().getValue("counterparty");
                this.getModel().setValue("counterpartytext", (Object)counterParty.getString("name"));
                break;
            }
            case "counterpartytype": {
                this.getModel().setValue("counterparty", null);
                this.getModel().setValue("counterpartytext", null);
            }
        }
    }

    private void billTypeChgEvt(String billtype, boolean fromCopyData) {
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"fxcurrencydirect", "bankaccount", "counterparty"});
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"counterpartytype", "counterparty", "capcashflowentry"});
        switch (billtype) {
            case "tm_forex_swaps": 
            case "tm_forex_options": 
            case "tm_forex_forward": 
            case "tm_forex": {
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"fxcurrencydirect"});
                this.getModel().setValue("contracttype", (Object)"original");
                if (fromCopyData) break;
                TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String[])new String[]{"bizstatus", "bankaccount", "counterparty", "interestdate"});
                this.getModel().deleteEntryData("incashflowtentry");
                break;
            }
            case "bei_bankbalance": 
            case "ifm_accountbalance": {
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"bankaccount", "counterparty"});
                if (!fromCopyData) {
                    TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String[])new String[]{"bizstatus", "counterparty", "counterpartytext", "contracttype", "interestdate", "enddate", "ratetype", "fxcurrencydirect", "swapdir"});
                    TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String[])new String[]{"bankaccount", "currency"});
                    this.getModel().deleteEntryData("incashflowtentry");
                }
                this.setBankbalanceDefaultValue();
                break;
            }
            case "lc_receipt": 
            case "lc_lettercredit": 
            case "lc_present": 
            case "lc_arrival": 
            case "ar_finarbill": 
            case "ap_finapbill": {
                if (!fromCopyData) {
                    TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String[])new String[]{"bankaccount", "counterparty", "contracttype", "interestdate", "ratetype", "fxcurrencydirect", "swapdir"});
                    this.getModel().deleteEntryData("incashflowtentry");
                }
                this.bizstatusItemChg(billtype);
                break;
            }
            case "cim_noticedeposit": {
                if (!fromCopyData) {
                    TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String[])new String[]{"bankaccount", "counterparty", "contracttype", "fxcurrencydirect", "swapdir", "enddate"});
                }
                this.bizstatusItemChg(billtype);
                break;
            }
            case "cfm_loanbill_e_l": 
            case "cfm_loanbill_b_l": 
            case "cim_invest_loanbill": 
            case "cfm_loanbill_bond": 
            case "cim_deposit": 
            case "cim_finsubscribe": 
            case "fbd_suretybill": {
                if (!fromCopyData) {
                    TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String[])new String[]{"bankaccount", "counterparty", "contracttype", "fxcurrencydirect", "swapdir"});
                }
                this.bizstatusItemChg(billtype);
                break;
            }
        }
    }

    private void setBankbalanceDefaultValue() {
        DynamicObject exrateDraft = (DynamicObject)this.getModel().getValue("exratedraft");
        DynamicObject draft = QueryServiceHelper.queryOne((String)"mrm_exrate_draft", (String)"id,billno,draftcreatedate", (QFilter[])new QFilter[]{new QFilter("id", "=", exrateDraft.get("id"))});
        this.getModel().setValue("startdate", (Object)draft.getDate("draftcreatedate"));
        this.getModel().deleteEntryData("capcashflowentry");
        this.getModel().createNewEntryRow("capcashflowentry");
        this.getModel().setValue("capdate", (Object)DateUtils.getNextDay((Date)draft.getDate("draftcreatedate"), (int)1), 0);
        this.getModel().setValue("capamount", this.getModel().getValue("amount"), 0);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"counterpartytype", "counterparty", "capcashflowentry"});
        this.getView().updateView("capcashflowentry");
        String billTypeNumber = ((DynamicObject)this.getModel().getValue("billtype")).getString("number");
        if ("bei_bankbalance".equals(billTypeNumber)) {
            this.getModel().setValue("counterpartytype", (Object)CounterPartyTypeEnum.BD_FINORGINFO.getValue());
        } else if ("ifm_accountbalance".equals(billTypeNumber)) {
            this.getModel().setValue("counterpartytype", (Object)CounterPartyTypeEnum.BOS_ORG.getValue());
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        super.beforeFieldPostBack(e);
        String key = ((Control)e.getSource()).getKey();
        if (!"billtype".equals(key) && EmptyUtil.isEmpty((Object)this.getModel().getValue("billtype"))) {
            e.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u5355\u636e\u7c7b\u578b\u3002", (String)"ExRateDraftEdit_0", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String propName;
        switch (propName = evt.getProperty().getName()) {
            case "billtype": {
                ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
                QFilter qFilter = new QFilter("enable", "=", (Object)"1");
                qFilter.and("type", "=", (Object)"exrate");
                DynamicObjectCollection sourceBill = QueryServiceHelper.query((String)"mrm_draft_datasource", (String)"sourcebill.number", (QFilter[])qFilter.toArray());
                List numbers = sourceBill.stream().map(a -> a.getString("sourcebill.number")).collect(Collectors.toList());
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("number", "in", numbers));
                break;
            }
            case "bankaccount": {
                this.addAccountFilter(evt);
                break;
            }
            case "currency": {
                this.bankbalanceCurrencyFilter(evt);
            }
        }
    }

    private void bankbalanceCurrencyFilter(BeforeF7SelectEvent evt) {
        DynamicObject bankAccount;
        DynamicObject billType = (DynamicObject)this.getModel().getValue("billtype");
        if (!EmptyUtil.isEmpty((DynamicObject)billType) && ("bei_bankbalance".equals(billType.getString("number")) || "ifm_accountbalance".equals(billType.getString("number"))) && !EmptyUtil.isEmpty((DynamicObject)(bankAccount = (DynamicObject)this.getModel().getValue("bankaccount")))) {
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            DynamicObjectCollection currencyCollection = bankAccount.getDynamicObjectCollection("currency");
            ArrayList<Long> currencyList = new ArrayList<Long>();
            for (DynamicObject currency : currencyCollection) {
                currencyList.add(currency.getLong("fbasedataid_id"));
            }
            QFilter qFilter = new QFilter("id", "in", currencyList);
            showParameter.getListFilterParameter().getQFilters().add(qFilter);
        }
    }

    private void addAccountFilter(BeforeF7SelectEvent evt) {
        QFilter orgFilter;
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (EmptyUtil.isEmpty((DynamicObject)org)) {
            evt.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ec4\u7ec7\u3002", (String)"ExRateDraftEdit_1", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        showParameter.setCustomParam("isclearcorefilter", (Object)true);
        ArrayList<QFilter> acctFilters = new ArrayList<QFilter>();
        QFilter statusFilter = new QFilter("acctstatus", "!=", (Object)"closed");
        acctFilters.add(statusFilter);
        DynamicObject billTypeBankAccount = (DynamicObject)this.getModel().getValue("billtype");
        if (billTypeBankAccount != null && "bei_bankbalance".equals(billTypeBankAccount.getString("number"))) {
            orgFilter = new QFilter("openorg", "=", (Object)org.getLong("id"));
            acctFilters.add(orgFilter);
        } else if (billTypeBankAccount != null && "ifm_accountbalance".equals(billTypeBankAccount.getString("number"))) {
            orgFilter = new QFilter("org", "=", (Object)org.getLong("id"));
            DynamicObjectCollection inneracctIds = QueryServiceHelper.query((String)"ifm_inneracct", (String)"id,org", (QFilter[])orgFilter.toArray());
            HashSet<Long> innerAcctSet = new HashSet<Long>();
            for (DynamicObject innerAcct : inneracctIds) {
                innerAcctSet.add(innerAcct.getLong("id"));
            }
            QFilter innerUnitFilter = new QFilter("inneracct", "in", innerAcctSet);
            acctFilters.add(innerUnitFilter);
        }
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (!EmptyUtil.isEmpty((Object)this.getModel().getValue("currency"))) {
            QFilter currencyFilter = new QFilter("currency.fbasedataid_id", "=", (Object)currency.getLong("id"));
            acctFilters.add(currencyFilter);
        }
        showParameter.getListFilterParameter().setQFilters(acctFilters);
    }

    private void bizstatusItemChg(String billType) {
        List<Object> comboItemValues = new ArrayList(10);
        switch (billType) {
            case "lc_receipt": 
            case "lc_lettercredit": {
                comboItemValues = Collections.singletonList(ExRateDraftBizStatusEnum.LC_DONE_REGISTER.getValue());
                break;
            }
            case "cfm_loanbill_e_l": 
            case "cfm_loanbill_b_l": {
                comboItemValues = Arrays.asList(ExRateDraftBizStatusEnum.CFM_DRAWED.getValue(), ExRateDraftBizStatusEnum.CFM_PARTPAYMENT.getValue());
                break;
            }
            case "cim_noticedeposit": 
            case "cim_deposit": {
                comboItemValues = Arrays.asList(ExRateDraftBizStatusEnum.DEPOSIT_SUBSCRIBE_DONE.getValue(), ExRateDraftBizStatusEnum.DEPOSIT_SUBSCRIBE_PART.getValue());
                break;
            }
            case "ar_finarbill": 
            case "ap_finapbill": {
                comboItemValues = Arrays.asList(ExRateDraftBizStatusEnum.UNSETTLE.getValue(), ExRateDraftBizStatusEnum.PARTSETTLE.getValue());
                break;
            }
            case "cim_invest_loanbill": {
                comboItemValues = Arrays.asList(ExRateDraftBizStatusEnum.CIM_DRAWED.getValue(), ExRateDraftBizStatusEnum.CIM_PARTPAYMENT.getValue());
                break;
            }
            case "cim_finsubscribe": {
                comboItemValues = Arrays.asList(ExRateDraftBizStatusEnum.FIN_SUBSCRIBE_DONE.getValue(), ExRateDraftBizStatusEnum.FIN_SUBSCRIBE_PART.getValue());
                break;
            }
            case "cfm_loanbill_bond": {
                comboItemValues = Arrays.asList(ExRateDraftBizStatusEnum.BOND_DRAWED.getValue(), ExRateDraftBizStatusEnum.BOND_PARTPAYMENT.getValue());
                break;
            }
            case "lc_present": {
                comboItemValues = Arrays.asList(ExRateDraftBizStatusEnum.PRESENT_REGISTER.getValue(), ExRateDraftBizStatusEnum.PRESENT_CONFIRM.getValue());
                break;
            }
            case "lc_arrival": {
                comboItemValues = Arrays.asList(ExRateDraftBizStatusEnum.ARRIVAL_REGISTER.getValue(), ExRateDraftBizStatusEnum.ARRIVAL_CONFIRM.getValue());
                break;
            }
            case "fbd_suretybill": {
                comboItemValues = Arrays.asList(ExRateDraftBizStatusEnum.SURETY_DONE.getValue(), ExRateDraftBizStatusEnum.SURETY_PART.getValue());
            }
        }
        if (!EmptyUtil.isEmpty(comboItemValues)) {
            TmcViewInputHelper.resetComboItems(comboItemValues, (String)"bizstatus", (IFormView)this.getView());
            if (OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
                this.getModel().setValue("bizstatus", comboItemValues.get(0));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            switch (operateKey) {
                case "save": {
                    this.getView().invokeOperation("refresh");
                }
            }
        }
    }
}

