/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.formplugin.draft;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcListPlugin;

public class ExRateDraftDataList
extends AbstractTmcListPlugin
implements ItemClickListener,
BeforeFilterF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        FilterContainer filterContainer = (FilterContainer)this.getView().getControl("filtercontainerap");
        filterContainer.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if ("draftview".equals(this.getView().getFormShowParameter().getShowParameter().getCustomParam("draftview"))) {
            Map barMap = FormMetadataCache.getListToolBar((String)this.getBillFormId());
            List barItems = (List)barMap.get("items");
            if (barItems != null && barItems.size() > 0) {
                ArrayList<String> barItemToHide = new ArrayList<String>(barItems.size());
                for (Map item : barItems) {
                    if ("tblclose".equals(item.get("id"))) continue;
                    barItemToHide.add((String)item.get("id"));
                }
                barItemToHide.forEach(v -> this.getView().setVisible(Boolean.valueOf(false), new String[]{v}));
            }
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"filtercontainerap"});
        }
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent event) {
        String fieldName = event.getFieldName();
        if ("billtype.name".equals(fieldName)) {
            this.filterBillType(event.getQfilters());
        }
        if ("bankaccount.bankaccountnumber".equals(fieldName)) {
            List qfilters = event.getQfilters();
            List<Long> permOrgIds = this.getPermOrgIds();
            if (!EmptyUtil.isEmpty(permOrgIds)) {
                qfilters.add(new QFilter("openorg", "in", permOrgIds));
            }
        }
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        String fieldName = args.getFieldName();
        if ("billtype.name".equals(fieldName)) {
            List qFilters = args.getQFilters();
            this.filterBillType(qFilters);
        }
    }

    private void filterBillType(List<QFilter> qFilters) {
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        qFilter.and("type", "=", (Object)"exrate");
        DynamicObjectCollection sourceBill = QueryServiceHelper.query((String)"mrm_draft_datasource", (String)"sourcebill.number", (QFilter[])qFilter.toArray());
        List numbers = sourceBill.stream().map(e -> e.getString("sourcebill.number")).collect(Collectors.toList());
        qFilters.add(new QFilter("number", "in", numbers));
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        IFormView parentView = this.getView().getParentView();
        if (parentView instanceof ListView && "mrm_exrate_gap_detail".equals(((ListView)parentView).getBillFormId())) {
            for (FilterColumn commonFilterColumn : args.getCommonFilterColumns()) {
                if (!commonFilterColumn.getFilterField().getFieldName().contains("org")) continue;
                commonFilterColumn.getDefaultValues().clear();
            }
        }
        if ("draftview".equals(this.getView().getFormShowParameter().getShowParameter().getCustomParam("draftview"))) {
            for (FilterColumn commonFilterColumn : args.getCommonFilterColumns()) {
                if (!"org.id".equals(commonFilterColumn.getFilterFieldName())) continue;
                commonFilterColumn.setDefaultValue(null);
                break;
            }
        }
    }

    protected List<Long> getPermOrgIds() {
        String appId = this.getView().getFormShowParameter().getAppId();
        List comIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"mrm_exrate_draft_data", (String)"47150e89000000ac");
        return comIdList;
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        if ("bizbillno".equals(fieldName)) {
            args.setCancel(true);
            BillListHyperLinkClickEvent e = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
            ListSelectedRow currentRow = e.getCurrentRow();
            DynamicObject row = BusinessDataServiceHelper.loadSingle((String)"mrm_exrate_draft_data", (String)"sourcebillid,billtype,bizdatasource", (QFilter[])new QFilter[]{new QFilter("id", "=", currentRow.getPrimaryKeyValue())});
            if ("manual".equals(row.getString("bizdatasource")) || "import".equals(row.getString("bizdatasource"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u624b\u5de5\u65b0\u589e\u6216\u6570\u636e\u5bfc\u5165\u7684\u4e1a\u52a1\u660e\u7ec6\uff0c\u4e0d\u652f\u6301\u67e5\u770b\u4e1a\u52a1\u6e90\u5355\u3002", (String)"ExRateDraftDataList_0", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
                return;
            }
            String billType = row.getDynamicObject("billtype").getString("number");
            if (EmptyUtil.isEmpty((Long)row.getLong("sourcebillid"))) {
                return;
            }
            if ("bei_bankbalance".equals(billType)) {
                ListShowParameter para = new ListShowParameter();
                para.setLookUp(false);
                para.setBillFormId("bei_bankbalance");
                FormConfig formConfig = FormMetadataCache.getListFormConfig((String)"bei_bankbalance");
                para.setFormId(formConfig.getListFormId());
                para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                para.addLinkQueryPkId((Object)row.getLong("sourcebillid"));
                this.getView().showForm((FormShowParameter)para);
            } else {
                BillShowParameter showParameter = new BillShowParameter();
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setStatus(OperationStatus.VIEW);
                showParameter.setPkId((Object)row.getLong("sourcebillid"));
                showParameter.setFormId(row.getDynamicObject("billtype").getString("number"));
                this.getView().showForm((FormShowParameter)showParameter);
            }
        } else if ("billno".equals(fieldName)) {
            args.setCancel(true);
            BillListHyperLinkClickEvent e = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
            ListSelectedRow currentRow = e.getCurrentRow();
            Object pkId = currentRow.getPrimaryKeyValue();
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.setPkId(pkId);
            showParameter.setFormId("mrm_exrate_draft_data");
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        Long exratedraft = (Long)this.getView().getFormShowParameter().getCustomParam("exratedraft");
        BillShowParameter parameter = new BillShowParameter();
        switch (operateKey) {
            case "add": {
                parameter.setStatus(OperationStatus.ADDNEW);
                parameter.setFormId("mrm_exrate_draft_data");
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parameter.setCustomParam("exratedraft", (Object)exratedraft);
                this.getView().showForm((FormShowParameter)parameter);
                break;
            }
            case "mod": {
                Long selectedId = this.getSelectedId();
                if (EmptyUtil.isEmpty((Long)selectedId)) break;
                parameter.setStatus(OperationStatus.EDIT);
                parameter.setFormId("mrm_exrate_draft_data");
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parameter.setPkId((Object)selectedId);
                this.getView().showForm((FormShowParameter)parameter);
            }
        }
    }
}

