/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.formplugin.draft;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.JobClient;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcListPlugin;
import kd.tmc.mrm.common.enums.DraftLogTypeEnum;
import kd.tmc.mrm.common.enums.DraftStatusEnum;
import kd.tmc.mrm.common.enums.ExecTypeEnum;

public class ExRateDraftList
extends AbstractTmcListPlugin {
    public static final String EXEC_TASK = "exectask";
    public static final String UPDATE_DRAFT = "updatedraft";

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate op = (FormOperate)args.getSource();
        if (UPDATE_DRAFT.equals(op.getOperateKey())) {
            QFilter filter;
            DynamicObject draft;
            Long selectedId = this.getSelectedId();
            if (EmptyUtil.isEmpty((Long)selectedId)) {
                args.setCancel(true);
            }
            if ((draft = QueryServiceHelper.queryOne((String)"mrm_exrate_draft", (String)"draftcreatedate,draftstatus", (QFilter[])(filter = new QFilter("id", "=", (Object)selectedId)).toArray())) != null) {
                Date date = draft.getDate("draftcreatedate");
                if (!DateUtils.isSameDay((Date)DateUtils.getCurrentDate(), (Date)date)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u66f4\u65b0\u5e95\u7a3f\u53d6\u6570\u65e5\u671f\u4e3a\u5f53\u5929\u7684\u5e95\u7a3f\u3002", (String)"ExRateDraftList_3", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                String draftstatus = draft.getString("draftstatus");
                if (DraftStatusEnum.RUNNING.getValue().equals(draftstatus)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d6\u6570\u5931\u8d25\uff0c\u5b58\u5728\u6b63\u5728\u6267\u884c\u7684\u5e95\u7a3f\u53d6\u6570\u4efb\u52a1\uff0c\u8bf7\u7ed3\u675f\u540e\u518d\u8bd5\u3002", (String)"ExRateDraftList_4", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
            }
        }
        if (EXEC_TASK.equals(op.getOperateKey())) {
            QFilter filter = new QFilter("draftcreatedate", "=", (Object)DateUtils.getCurrentDate());
            DynamicObject draft = QueryServiceHelper.queryOne((String)"mrm_exrate_draft", (String)"billno,draftstatus", (QFilter[])filter.toArray());
            if (draft == null) {
                return;
            }
            String draftStatus = draft.getString("draftstatus");
            if (DraftStatusEnum.FINISH.getValue().equals(draftStatus)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7cfb\u7edf\u65e5\u671f\u5df2\u5b58\u5728\u6c47\u7387\u5e95\u7a3f\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u6267\u884c\u3002", (String)"ExRateDraftList_5", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            } else if (DraftStatusEnum.RUNNING.getValue().equals(draftStatus)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d6\u6570\u5931\u8d25\uff0c\u5b58\u5728\u6b63\u5728\u6267\u884c\u7684\u5e95\u7a3f\u53d6\u6570\u4efb\u52a1\uff0c\u8bf7\u7ed3\u675f\u540e\u518d\u8bd5\u3002", (String)"ExRateDraftList_4", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        if (EXEC_TASK.equals(key) && e.getOperationResult().isSuccess()) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("exectype", ExecTypeEnum.MANUAL.getValue());
            this.dispatchRealTimeJob(params);
            String tipMsg = ResManager.loadKDString((String)"\u5df2\u6267\u884c\u201c\u624b\u5de5\u6267\u884c\u53d6\u6570\u201d\uff0c\u540e\u53f0\u6267\u884c\u4e2d\uff0c\u8bf7\u7a0d\u540e\u67e5\u8be2\u3002", (String)"ExRateDraftList_0", (String)"tmc-mrm-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(tipMsg);
        }
        if (UPDATE_DRAFT.equals(key)) {
            FormShowParameter param = new FormShowParameter();
            param.setFormId("mrm_draft_ds_dialog");
            param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, UPDATE_DRAFT));
            param.getOpenStyle().setShowType(ShowType.Modal);
            param.setStatus(OperationStatus.EDIT);
            param.setCustomParam("entity", (Object)"mrm_exrate_draft_cfg");
            this.getView().showForm(param);
        }
    }

    private void dispatchRealTimeJob(Map<String, Object> params) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId("mrm");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName(ResManager.loadKDString((String)"\u6c47\u7387\u4e1a\u52a1\u5e95\u7a3f\u6570\u636e\u53d6\u6570\u4efb\u52a1", (String)"ExRateDraftList_6", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname("kd.tmc.mrm.business.task.ExRateDraftCreateTask");
        jobInfo.setRunConcurrently(false);
        jobInfo.setParams(params);
        JobClient.dispatch((JobInfo)jobInfo);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (!EmptyUtil.isEmpty((Object)returnData)) {
            switch (actionId) {
                case "updatedraft": {
                    Long draftId = this.getSelectedId();
                    DynamicObjectCollection sourcebills = ((DynamicObject)returnData).getDynamicObjectCollection("sourcebill");
                    if (sourcebills.isEmpty()) break;
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("exectype", ExecTypeEnum.UPDATE.getValue());
                    List sourceIds = sourcebills.stream().map(a -> a.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                    params.put("sourceIds", sourceIds);
                    params.put("draftId", draftId);
                    this.dispatchRealTimeJob(params);
                    String tipMsg = ResManager.loadKDString((String)"\u5df2\u6267\u884c\u201c\u66f4\u65b0\u5e95\u7a3f\u6570\u636e\u201d\uff0c\u540e\u53f0\u6267\u884c\u4e2d\uff0c\u8bf7\u7a0d\u540e\u67e5\u8be2\u3002", (String)"ExRateDraftList_1", (String)"tmc-mrm-formplugin", (Object[])new Object[0]);
                    this.getView().showTipNotification(tipMsg);
                    break;
                }
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        Long selectedId;
        super.billListHyperLinkClick(args);
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        if ("billno".equals(fieldName)) {
            args.setCancel(true);
            selectedId = this.getSelectedId();
            QFilter qFilter = new QFilter("exratedraft", "=", (Object)selectedId);
            ListShowParameter param = ShowFormHelper.createShowListForm((String)"mrm_exrate_draft_data", (boolean)true, (int)0, (boolean)false);
            ListFilterParameter filterParameter = new ListFilterParameter();
            filterParameter.setFilter(qFilter);
            param.setCustomParam("exratedraft", (Object)selectedId);
            param.setListFilterParameter(filterParameter);
            param.setShowTitle(false);
            this.getView().showForm((FormShowParameter)param);
        }
        if ("draftstatus".equals(fieldName)) {
            args.setCancel(true);
            selectedId = this.getSelectedId();
            QFilter filter = new QFilter("id", "=", (Object)selectedId);
            DynamicObject draft = QueryServiceHelper.queryOne((String)"mrm_exrate_draft", (String)"billno", (QFilter[])filter.toArray());
            QFilter qFilter = new QFilter("draftno", "=", (Object)draft.getString("billno"));
            qFilter.and("risktype", "=", (Object)DraftLogTypeEnum.EXRATE.getValue());
            ListShowParameter param = ShowFormHelper.createShowListForm((String)"mrm_rate_draft_log", (boolean)true, (int)0, (boolean)false);
            ListFilterParameter filterParameter = new ListFilterParameter();
            filterParameter.setFilter(qFilter);
            param.setListFilterParameter(filterParameter);
            param.setShowTitle(false);
            this.getView().showForm((FormShowParameter)param);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new MyListDataProvider());
    }

    static class MyListDataProvider
    extends ListDataProvider {
        MyListDataProvider() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection dataList = super.getData(start, limit);
            if (dataList.isEmpty()) {
                return dataList;
            }
            List ids = dataList.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
            QFilter qFilter = new QFilter("id", "in", ids);
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"mrm_exrate_draft", (String)"id,entryentity.datasource.number number,entryentity.datasource.name datasource,entryentity.count count", (QFilter[])qFilter.toArray());
            Map<Long, List<DynamicObject>> map = dynamicObjects.stream().collect(Collectors.groupingBy(e -> e.getLong("id")));
            for (DynamicObject data : dataList) {
                List<DynamicObject> list = map.get(data.getLong("id"));
                list.sort(Comparator.comparing(a -> a.getString("number")));
                ArrayList<String> summary = new ArrayList<String>(4);
                for (DynamicObject row : list) {
                    String sourcebillname = row.getString("datasource");
                    if (!EmptyUtil.isNoEmpty((String)sourcebillname)) continue;
                    long sum = row.getLong("count");
                    summary.add(sourcebillname + "\u3010" + sum + "\u3011");
                }
                if (summary.isEmpty()) continue;
                data.set("summary", (Object)String.join((CharSequence)", ", summary));
            }
            return dataList;
        }
    }
}

