/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.formplugin.draft;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RuleSelectPlugin
extends AbstractFormPlugin {
    public static final String SOURCE_ENTITY_NUMBER = "sourceEntityNumber";
    public static final String SOURCE_BOTP_ENTITY_NUMBER = "sourceBotpEntityNumber";
    public static final String TARGET_ENTITY_NUMBER = "targetEntityNumber";
    public static final String RULE_CACHE = "rulevalues";
    public static final String RULE_ID = "ruleid";
    public static final String RULE_TEXT = "ruletext";
    public static final String PRESET = "preset";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.buildRuleComb();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        if (customParams.containsKey(RULE_ID)) {
            String ruleId = (String)customParams.get(RULE_ID);
            this.getModel().setValue("rule", (Object)ruleId);
        }
        if (customParams.containsKey(PRESET)) {
            boolean preset = (Boolean)customParams.get(PRESET);
            this.getView().setEnable(Boolean.valueOf(!preset), new String[]{"rule"});
        }
    }

    private void buildRuleComb() {
        String sourceEntityNumber = (String)this.getView().getFormShowParameter().getCustomParam(SOURCE_ENTITY_NUMBER);
        String sourceBotpEntityNumber = (String)this.getView().getFormShowParameter().getCustomParam(SOURCE_BOTP_ENTITY_NUMBER);
        String targetEntityNumber = (String)this.getView().getFormShowParameter().getCustomParam(TARGET_ENTITY_NUMBER);
        List rules = ConvertMetaServiceHelper.loadRules((String)sourceBotpEntityNumber, (String)targetEntityNumber);
        rules = rules.stream().filter(rule -> rule.isEnabled() && (sourceEntityNumber.equals(rule.getSourceEntityNumber()) || sourceEntityNumber.equals(rule.getLinkEntityPolicy().getSourceLayout()))).collect(Collectors.toList());
        ArrayList<ComboItem> ruleItems = new ArrayList<ComboItem>(rules.size());
        HashMap<String, String> ruleMap = new HashMap<String, String>(1);
        for (ConvertRuleElement rule2 : rules) {
            ComboItem ruleItem = new ComboItem();
            ruleItem.setValue(rule2.getId());
            ruleItem.setCaption(rule2.getName());
            ruleItems.add(ruleItem);
            ruleMap.put(rule2.getId(), rule2.getName().getLocaleValue());
        }
        ComboEdit billEditor = (ComboEdit)this.getView().getControl("rule");
        billEditor.setComboItems(ruleItems);
        this.getView().getPageCache().put(RULE_CACHE, SerializationUtils.toJsonString(ruleMap));
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey().toLowerCase();
        if ("btnok".equals(key)) {
            String ruleId = (String)this.getModel().getValue("rule");
            if (EmptyUtil.isEmpty((String)ruleId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8f6c\u6362\u89c4\u5219\u3002", (String)"RuleSelectPlugin_1", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
                return;
            }
            String rules = this.getView().getPageCache().get(RULE_CACHE);
            Map ruleMap = (Map)SerializationUtils.fromJsonString((String)rules, Map.class);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(RULE_ID, ruleId);
            map.put(RULE_TEXT, (String)ruleMap.get(ruleId));
            this.getView().returnDataToParent(map);
            this.getView().close();
        }
    }
}

