/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.formplugin.exrateopen;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.field.AmountEdit;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;
import kd.tmc.mrm.business.service.exrateopen.ExRateGapAnalysisModel;
import kd.tmc.mrm.common.model.section.SectionCfgModel;

public class AbstractExRateGapAnalysisEdit
extends AbstractTmcBillEdit {
    protected static final String AMOUNT = "amount";
    protected static final int MAX_AMT_ROW_COUNT = 50;

    protected void generateReport(ExRateGapAnalysisModel gapAnalysisModel, DynamicObject subjectSystem, BigDecimal amtUnit, String[] titles) {
        HashMap<Long, Object> subjectId2SubjectName = new HashMap<Long, Object>(10);
        for (DynamicObject subjectTreeEntryRow : subjectSystem.getDynamicObjectCollection("subjecttreeentry")) {
            Object subjectName = ((OrmLocaleValue)subjectTreeEntryRow.getDynamicObject("subject").get("name")).getLocaleValue();
            if (EmptyUtil.isEmpty((String)subjectName)) {
                subjectName = ((OrmLocaleValue)subjectTreeEntryRow.getDynamicObject("subject").get("name")).getDefaultItem();
            }
            Long subjectId = subjectTreeEntryRow.getDynamicObject("subject").getLong("id");
            subjectId2SubjectName.put(subjectId, subjectName);
        }
        ArrayList<Integer> totalRowIndexList = new ArrayList<Integer>(8);
        this.getModel().deleteEntryData("gapanalysisentity");
        HashSet<Long> processedSubjects = new HashSet<Long>(8);
        for (DynamicObject row : subjectSystem.getDynamicObjectCollection("subjecttreeentry")) {
            List subSubjectIds;
            Long subjectId = row.getDynamicObject("subject").getLong("id");
            String subjectIdStr = String.valueOf(subjectId);
            if (!processedSubjects.contains(subjectId)) {
                int index = this.getModel().createNewEntryRow("gapanalysisentity");
                totalRowIndexList.add(index);
                this.getModel().setValue("subjectname", (Object)subjectIdStr, index);
                BigDecimal[] amounts = (BigDecimal[])gapAnalysisModel.getResultData().get(subjectId);
                for (int i = 0; i < amounts.length; ++i) {
                    this.getModel().setValue(AMOUNT + (i + 1), (Object)this.divide(amounts[i], amtUnit), index);
                }
                Optional<BigDecimal> optional = Arrays.stream(amounts).filter(Objects::nonNull).reduce(BigDecimal::add);
                BigDecimal totalAmt = optional.orElse(null);
                this.getModel().setValue("totalamt", (Object)this.divide(totalAmt, amtUnit), index);
                processedSubjects.add(subjectId);
            }
            if ((subSubjectIds = (List)gapAnalysisModel.getSubSubjectsMap().get(row.getLong("id"))) == null) continue;
            int parentIndex = -1;
            for (int i = 0; i < this.getModel().getEntryEntity("gapanalysisentity").size(); ++i) {
                if (!subjectIdStr.equals(this.getModel().getValue("subjectname", i))) continue;
                parentIndex = i;
                break;
            }
            if (parentIndex == -1) continue;
            for (Long subSubjectId : subSubjectIds) {
                if (processedSubjects.contains(subSubjectId)) continue;
                int childIndex = this.getModel().insertEntryRow("gapanalysisentity", parentIndex);
                String subSubjectIdStr = String.valueOf(subSubjectId);
                this.getModel().setValue("subjectname", (Object)subSubjectIdStr, childIndex);
                BigDecimal[] amounts = (BigDecimal[])gapAnalysisModel.getResultData().get(subSubjectId);
                for (int i = 0; i < amounts.length; ++i) {
                    this.getModel().setValue(AMOUNT + (i + 1), (Object)this.divide(amounts[i], amtUnit), childIndex);
                }
                Optional<BigDecimal> optional = Arrays.stream(amounts).filter(Objects::nonNull).reduce(BigDecimal::add);
                BigDecimal totalAmt = optional.orElse(null);
                this.getModel().setValue("totalamt", (Object)this.divide(totalAmt, amtUnit), childIndex);
                processedSubjects.add(subSubjectId);
            }
        }
        for (int i = 0; i < this.getModel().getEntryRowCount("gapanalysisentity"); ++i) {
            String subjectIdStr = (String)this.getModel().getValue("subjectname", i);
            String subjectName = (String)subjectId2SubjectName.get(Long.valueOf(subjectIdStr));
            this.getModel().setValue("subjectname", (Object)subjectName, i);
        }
        this.setValue_totalRow(gapAnalysisModel.getResultData(), amtUnit, totalRowIndexList);
        TreeEntryGrid treeGrid = (TreeEntryGrid)this.getView().getControl("gapanalysisentity");
        int[] totalRowIndexArray = totalRowIndexList.stream().mapToInt(Integer::valueOf).toArray();
        treeGrid.expand(totalRowIndexArray);
        treeGrid.setRowBackcolor("rgba(153,217,43,0.07)", totalRowIndexArray);
        this.dealColumns(titles);
    }

    private void setValue_totalRow(Map<Long, BigDecimal[]> resultData, BigDecimal amtUnit, List<Integer> totalRowIndexList) {
        int index = this.getModel().createNewEntryRow("gapanalysisentity");
        totalRowIndexList.add(index);
        this.getModel().setValue("subjectname", (Object)ResManager.loadKDString((String)"\u51c0\u655e\u53e3", (String)"ExRateGapAnalysisModel_3", (String)"tmc-mrm-business", (Object[])new Object[0]), index);
        BigDecimal[] amounts = resultData.get(ExRateGapAnalysisModel.TOTAL_ENTRY_ROW_ID);
        for (int i = 0; i < amounts.length; ++i) {
            this.getModel().setValue(AMOUNT + (i + 1), (Object)this.divide(amounts[i], amtUnit), index);
        }
        Optional<BigDecimal> optional = Arrays.stream(amounts).filter(Objects::nonNull).reduce(BigDecimal::add);
        BigDecimal totalAmt = optional.orElse(null);
        this.getModel().setValue("totalamt", (Object)this.divide(totalAmt, amtUnit), index);
    }

    private BigDecimal divide(BigDecimal amount, BigDecimal amtUnit) {
        if (amount == null) {
            return null;
        }
        return amount.divide(amtUnit, 2, RoundingMode.HALF_UP);
    }

    private void dealColumns(String[] titles) {
        String[] showColumnKeys = new String[titles.length];
        for (int i = 1; i <= titles.length; ++i) {
            ((AmountEdit)this.getView().getControl(AMOUNT + i)).setCaption(new LocaleString(SectionCfgModel.generateTitlesName((String)titles[i - 1])));
            showColumnKeys[i - 1] = AMOUNT + i;
        }
        this.getView().setVisible(Boolean.valueOf(true), showColumnKeys);
        if (50 > titles.length) {
            String[] hiddenColumnKeys = new String[50 - titles.length];
            for (int i = titles.length + 1; i <= 50; ++i) {
                hiddenColumnKeys[i - titles.length - 1] = AMOUNT + i;
            }
            this.getView().setVisible(Boolean.valueOf(false), hiddenColumnKeys);
        }
    }
}

