/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.formplugin.exrateopen;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.ListColumnCompareTypesSetEvent;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcListPlugin;
import kd.tmc.mrm.common.helper.QFilterHelper;
import kd.tmc.mrm.common.model.section.Section;
import kd.tmc.mrm.common.model.section.SectionCfgModel;

public class ExRateGapAnalysisDetailList
extends AbstractTmcListPlugin {
    public void listColumnCompareTypesSet(ListColumnCompareTypesSetEvent args) {
        super.listColumnCompareTypesSet(args);
        if ("section".equals(args.getListFieldKey())) {
            String[] titles;
            String titleStr = (String)this.getView().getFormShowParameter().getCustomParam("titleStr");
            if (EmptyUtil.isEmpty((String)titleStr)) {
                return;
            }
            for (String title : titles = titleStr.split("_")) {
                args.getComboItems().add(new ValueMapItem(null, title, new LocaleString(SectionCfgModel.generateTitlesName((String)title))));
            }
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        String titleStr = (String)this.getView().getFormShowParameter().getCustomParam("titleStr");
        if (EmptyUtil.isNoEmpty((String)titleStr)) {
            args.setListDataProvider((IListDataProvider)new MyListDataProvider());
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        if ("capcashflow".equals(fieldName) || "lncashflow".equals(fieldName)) {
            args.setCancel(true);
            Object selectedId = ((BillListHyperLinkClickEvent)args.getHyperLinkClickEvent()).getCurrentRow().getPrimaryKeyValue();
            DynamicObject selectRow = QueryServiceHelper.queryOne((String)"mrm_exrate_gap_detail", (String)"srcbill.currentanalysisobj.filterconditionstr_tag,srcbill.currentanalysisobj.draft,srcbill.currentanalysisobj.draft.draftcreatedate,srcbill.sectioncfg,srcbill.subjectsystem,sectionindex,subject,org,cashflowcurrency,gapamount", (QFilter[])new QFilter("id", "=", selectedId).toArray());
            if (selectRow == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5217\u8868\u6570\u636e\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u5148\u5237\u65b0\u5217\u8868\uff0c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ExRateGapAnalysisDetailList_0", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
            }
            BigDecimal gapAmount = selectRow.getBigDecimal("gapamount");
            Object draftId = selectRow.get("srcbill.currentanalysisobj.draft");
            Date draftCreateDate = selectRow.getDate("srcbill.currentanalysisobj.draft.draftcreatedate");
            Object sectionCfgId = selectRow.get("srcbill.sectioncfg");
            int sectionIndex = selectRow.getInt("sectionindex");
            long subjectId = selectRow.getLong("subject");
            Object orgId = selectRow.get("org");
            Object currencyId = selectRow.get("cashflowcurrency");
            HashSet<String> billTypeSet = new HashSet<String>(1);
            DynamicObject subjectSystem = BusinessDataServiceHelper.loadSingleFromCache((Object)selectRow.get("srcbill.subjectsystem"), (String)"mrm_subject_system");
            for (DynamicObject subjectTreeEntryRow : subjectSystem.getDynamicObjectCollection("subjecttreeentry")) {
                if (subjectId != subjectTreeEntryRow.getDynamicObject("subject").getLong("id") || !subjectTreeEntryRow.getBoolean("isleaf") || !EmptyUtil.isNoEmpty((String)subjectTreeEntryRow.getString("mapping_tag"))) continue;
                FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)subjectTreeEntryRow.getString("mapping_tag"), FilterCondition.class);
                List filterRow = condition.getFilterRow();
                SimpleFilterRow simpleFilterRows = (SimpleFilterRow)filterRow.get(0);
                List baseDataIds = simpleFilterRows.getBaseDataIds();
                for (FilterValue baseDataId : baseDataIds) {
                    String billType = (String)baseDataId.getValue();
                    billTypeSet.add(billType);
                }
            }
            DynamicObject sectionCfg = BusinessDataServiceHelper.loadSingle((Object)sectionCfgId, (String)"mrm_section_cfg");
            SectionCfgModel sectionCfgModel = new SectionCfgModel(sectionCfg, draftCreateDate);
            QFilter qFilter = new QFilter("exratedraft", "=", draftId).and("billtype.number", "in", billTypeSet).and("org", "=", orgId).and("currency", "=", currencyId);
            String filterStr = selectRow.getString("srcbill.currentanalysisobj.filterconditionstr_tag");
            QFilter schemaFilter = QFilterHelper.getFilter((String)"mrm_exrate_draft_data", (String)filterStr);
            if (schemaFilter != null) {
                qFilter.and(schemaFilter);
            }
            if ("capcashflow".equals(fieldName)) {
                this.connectCapCashFlowDateQFilter(sectionIndex, sectionCfgModel, qFilter);
            } else {
                this.connectInCashFlowDateQFilter(sectionIndex, sectionCfgModel, qFilter);
            }
            if (billTypeSet.contains("tm_forex") || billTypeSet.contains("tm_forex_forward") || billTypeSet.contains("tm_forex_swaps") || billTypeSet.contains("tm_forex_options")) {
                QFilter forexDirectQFilter = gapAmount.compareTo(BigDecimal.ZERO) > 0 ? new QFilter("fxcurrencydirect", "!=", (Object)"sell") : new QFilter("fxcurrencydirect", "!=", (Object)"buy");
                qFilter.and(forexDirectQFilter);
            }
            ListShowParameter param = ShowFormHelper.createShowListForm((String)("capcashflow".equals(fieldName) ? "mrm_exrate_draft_data_ca" : "mrm_exrate_draft_data_in"), (boolean)true, (int)0, (boolean)false);
            ListFilterParameter filterParameter = new ListFilterParameter();
            filterParameter.setFilter(qFilter);
            param.setListFilterParameter(filterParameter);
            param.setShowTitle(false);
            this.getView().showForm((FormShowParameter)param);
        }
    }

    private void connectCapCashFlowDateQFilter(int sectionIndex, SectionCfgModel sectionCfgModel, QFilter qFilter) {
        Section section = sectionCfgModel.getSection(sectionIndex);
        Date leftDate = section.getLeftDate();
        Date rightDate = section.getRightDate();
        String leftDateCp = section.isLeftClosed() ? ">=" : ">";
        String rightDateCp = section.isRightClosed() ? "<=" : "<";
        QFilter capDateFilter = rightDate == null ? QFilter.isNotNull((String)"capcashflowentry.capamount").and(QFilter.isNull((String)"capcashflowentry.capdate").or("capcashflowentry.capdate", leftDateCp, (Object)leftDate)) : new QFilter("capcashflowentry.capdate", leftDateCp, (Object)leftDate).and("capcashflowentry.capdate", rightDateCp, (Object)rightDate);
        qFilter.and(capDateFilter);
    }

    private void connectInCashFlowDateQFilter(int sectionIndex, SectionCfgModel sectionCfgModel, QFilter qFilter) {
        Section section = sectionCfgModel.getSection(sectionIndex);
        Date leftDate = section.getLeftDate();
        Date rightDate = section.getRightDate();
        String leftDateCp = section.isLeftClosed() ? ">=" : ">";
        String rightDateCp = section.isRightClosed() ? "<=" : "<";
        QFilter inDateFilter = rightDate == null ? QFilter.isNotNull((String)"incashflowtentry.inamount").and(QFilter.isNull((String)"incashflowtentry.indate").or("incashflowtentry.indate", leftDateCp, (Object)leftDate)) : new QFilter("incashflowtentry.indate", leftDateCp, (Object)leftDate).and("incashflowtentry.indate", rightDateCp, (Object)rightDate);
        qFilter.and(inDateFilter);
    }

    static class MyListDataProvider
    extends ListDataProvider {
        MyListDataProvider() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection dataList = super.getData(start, limit);
            if (dataList.isEmpty()) {
                return dataList;
            }
            HashMap<String, String> cache = new HashMap<String, String>(10);
            for (DynamicObject data : dataList) {
                if (!data.containsProperty("section")) continue;
                String section = data.getString("section");
                if (cache.containsKey(section)) {
                    data.set("section", cache.get(section));
                    continue;
                }
                String name = SectionCfgModel.generateTitlesName((String)section);
                data.set("section", (Object)name);
                cache.put(section, name);
            }
            return dataList;
        }
    }
}

