/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.formplugin.exrateopen;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeF7ViewDetailEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mrm.business.service.exrateopen.ExRateGapAnalysisModel;
import kd.tmc.mrm.common.helper.ExRateGapAnalysisHelper;
import kd.tmc.mrm.common.helper.OrgHelper;
import kd.tmc.mrm.formplugin.common.OperationResultHelper;
import kd.tmc.mrm.formplugin.exrateopen.AbstractExRateGapAnalysisEdit;

public class ExRateGapAnalysisEdit
extends AbstractExRateGapAnalysisEdit
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit orgs = (BasedataEdit)this.getView().getControl("orgs");
        orgs.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit currency = (BasedataEdit)this.getView().getControl("currency");
        currency.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit analysisObj = (BasedataEdit)this.getView().getControl("currentanalysisobj");
        analysisObj.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit forexquote = (BasedataEdit)this.getView().getControl("forexquote");
        Optional.ofNullable(forexquote).ifPresent(c -> c.addBeforeF7ViewDetailListener(this::beforeF7ViewDetail));
        BasedataEdit orgView = (BasedataEdit)this.getView().getControl("orgview");
        orgView.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        String titleStr = (String)this.getModel().getValue("amtcolumntitles");
        if (!titleStr.contains("_")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7248\u672c\u5347\u7ea7\u540e\uff0c\u5bf9\u4e8e\u5386\u53f2\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u8ba1\u7b97\u83b7\u53d6\u62a5\u8868\u7ed3\u679c\u3002", (String)"ExRateGapAnalysisEdit_4", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"buttonpanel", "gapanalysisentity"});
            return;
        }
        this.refreshReport();
        this.getModel().setDataChanged(false);
        this.changedPropsTip();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setLocalCurrencyByOrg();
        long id = DBServiceHelper.genGlobalLongId();
        this.getModel().setValue("id", (Object)id);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"buttonpanel", "gapanalysisentity"});
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.setLocalCurrencyByOrg();
        long id = DBServiceHelper.genGlobalLongId();
        this.getModel().setValue("id", (Object)id);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"buttonpanel", "gapanalysisentity"});
    }

    private void setLocalCurrencyByOrg() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            Map result = BaseDataServiceHelper.getBaseAccountingInfo((Long)org.getLong("id"));
            Long localCurrencyId = (Long)result.get("baseCurrencyID");
            this.getModel().setValue("reportcurrency", (Object)localCurrencyId);
        }
    }

    private void changedPropsTip() {
        List list = ExRateGapAnalysisHelper.getExRateGapChangedProps((DynamicObject)this.getModel().getDataEntity());
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                String prop = (String)list.get(i);
                list.set(i, "\u201c" + prop + "\u201d");
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"%s\u5df2\u53d1\u751f\u53d8\u52a8\uff0c\u8bf7\u91cd\u65b0\u8ba1\u7b97\u83b7\u53d6\u6700\u65b0\u7ed3\u679c\u3002", (String)"ExRateGapAnalysisEdit_0", (String)"tmc-mrm-formplugin", (Object[])new Object[]{String.join((CharSequence)"\u3001", list)}));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName;
        super.propertyChanged(e);
        switch (propertyName = e.getProperty().getName()) {
            case "orgview": {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"orgs", null);
                if (!this.validate()) break;
                this.refreshReport();
                break;
            }
            case "amtunit": 
            case "orgs": {
                if (!this.validate()) break;
                this.refreshReport();
                break;
            }
            case "currentanalysisobj": {
                this.setDraft();
                break;
            }
            case "currency": {
                if (OperationStatus.ADDNEW != this.getView().getFormShowParameter().getStatus() && EmptyUtil.isEmpty((Object)this.getModel().getValue("currency"))) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"buttonpanel", "gapanalysisentity"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"noreportdatapanel", "nochartdatapanel"});
                }
                if (!this.validate()) break;
                this.refreshReport();
            }
        }
    }

    private void setDraft() {
        DynamicObject analysisObj = (DynamicObject)this.getModel().getValue("currentanalysisobj");
        if (analysisObj != null) {
            DynamicObject draft = analysisObj.getDynamicObject("draft");
            this.getModel().setValue("draft", (Object)draft);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String property = evt.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        switch (property) {
            case "orgview": {
                DataSet ds = OrgHelper.getAuthorizedBankOrgViewDataSet((Long)RequestContext.get().getCurrUserId());
                HashSet<Long> ids = new HashSet<Long>(16);
                if (ds != null) {
                    while (ds.hasNext()) {
                        ids.add(ds.next().getLong("id"));
                    }
                }
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("treetype", "!=", (Object)OrgViewTypeEnum.IS_BANKROLL.getViewType()).or(new QFilter("treetype", "=", (Object)OrgViewTypeEnum.IS_BANKROLL.getViewType()).and("id", "in", ids)));
                break;
            }
            case "orgs": {
                String appId = this.getView().getFormShowParameter().getAppId();
                DynamicObject orgView = (DynamicObject)this.getModel().getValue("orgview");
                List orgIds = OrgHelper.getPermOrgIds((DynamicObject)orgView, null, null, (String)appId, (String)"mrm_exrate_gap_analysis");
                if (orgIds == null) break;
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)orgIds));
                break;
            }
            case "currency": {
                DynamicObject reportCurrency = (DynamicObject)this.getModel().getValue("reportcurrency");
                if (reportCurrency == null) break;
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "!=", reportCurrency.getPkValue()));
                break;
            }
            case "currentanalysisobj": {
                List orgIds = OrgHelper.getPermOrgIds(null, null, (String)OrgViewTypeEnum.IS_BANKROLL.getViewType(), (String)this.getView().getFormShowParameter().getServiceAppId(), (String)"mrm_exrate_analysisobj");
                if (orgIds == null) break;
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("org", "in", (Object)orgIds));
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("exportentry".equals(operateKey)) {
            int entryRowCount = this.getModel().getEntryRowCount("gapanalysisentity");
            int[] a = new int[entryRowCount];
            for (int i = 0; i < entryRowCount; ++i) {
                a[i] = i;
            }
            TreeEntryGrid treeGrid = (TreeEntryGrid)this.getView().getControl("gapanalysisentity");
            treeGrid.selectRows(a, 0);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        DynamicObject currency;
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        if ("bar_repricegap".equals(key) && e.getOperationResult().isSuccess()) {
            this.validateMustInput("billno");
            if (EmptyUtil.isEmpty((Object)this.getModel().getValue("reportcurrency"))) {
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                throw new KDBizException(ResManager.loadKDString((String)"\u672c\u4f4d\u5e01\u4e3a\u7a7a\uff0c\u201c%s\u201d\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7684\u672c\u4f4d\u5e01\u3002", (String)"ExRateGapAnalysisEdit_3", (String)"tmc-mrm-formplugin", (Object[])new Object[]{org.get("name")}));
            }
            this.validateMustInput("forexquote");
            this.validateMustInput("subjectsystem");
            this.validateMustInput("sectioncfg");
            this.validateMustInput("currentanalysisobj");
            this.validateMustInput("amtunit");
            this.validateMustInput("currency");
            this.setDraft();
            this.analysis();
        }
        if ("save".equals(key) && e.getOperationResult().isSuccess()) {
            this.refreshReport();
        }
        if ("viewreportdetail".equals(key) && e.getOperationResult().isSuccess() && (currency = (DynamicObject)this.getModel().getValue("currency")) != null) {
            QFilter qFilter = new QFilter("cashFlowCurrency", "=", currency.getPkValue());
            ExRateGapAnalysisHelper.showExRateGapDetailList((IFormView)this.getView(), (QFilter)qFilter);
        }
    }

    private boolean validate() {
        return !EmptyUtil.isAnyoneEmpty((Object[])new Object[]{this.getModel().getValue("amtunit"), this.getModel().getValue("currency")});
    }

    private void validateMustInput(String key) {
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue(key))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c%s\u201d\u3002", (String)"ExRateGapAnalysisEdit_1", (String)"tmc-mrm-formplugin", (Object[])new Object[]{this.getModel().getProperty(key).getDisplayName().getLocaleValue()}));
        }
    }

    private void analysis() {
        this.getModel().setValue("entrycurrency", this.getModel().getValue("reportcurrency"));
        DynamicObject subjectSystem = BusinessDataServiceHelper.loadSingleFromCache((Object)((DynamicObject)this.getModel().getValue("subjectsystem")).getPkValue(), (String)"mrm_subject_system");
        this.setObjModifyTime();
        ExRateGapAnalysisModel gapAnalysisModel = new ExRateGapAnalysisModel((DynamicObject)this.getModel().getValue("forexquote"), (DynamicObject)this.getModel().getValue("currentanalysisobj"), subjectSystem, (DynamicObject)this.getModel().getValue("sectioncfg"), (DynamicObject)this.getModel().getValue("reportcurrency"));
        gapAnalysisModel.analysis(this.getView().getFormShowParameter().getAppId());
        Set tipPairs = gapAnalysisModel.getTipPairs();
        if (!EmptyUtil.isEmpty((Collection)tipPairs)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d27\u5e01\u5bf9\u201c%1$s\u201d\u5728\u5916\u6c47\u62a5\u4ef7\u201c%2$s\u201d\u4e2d\u672a\u8bbe\u7f6e\u62a5\u4ef7\u65b9\u5f0f\uff0c\u8bf7\u5148\u8bbe\u7f6e\u3002", (String)"GapAnalysisModel_5", (String)"tmc-mrm-business", (Object[])new Object[0]), String.join((CharSequence)"\u3001", tipPairs), ((DynamicObject)this.getModel().getValue("forexquote")).getString("number")));
        }
        this.getModel().setValue("amtcolumntitles", (Object)String.join((CharSequence)"_", gapAnalysisModel.getTitles()));
        this.saveResult(gapAnalysisModel);
    }

    private void setObjModifyTime() {
        this.getModel().setValue("forexquotetime", ((DynamicObject)this.getModel().getValue("forexquote")).get("modifytime"));
        this.getModel().setValue("subjectsystemtime", ((DynamicObject)this.getModel().getValue("subjectsystem")).get("modifytime"));
        this.getModel().setValue("sectioncfgtime", ((DynamicObject)this.getModel().getValue("sectioncfg")).get("modifytime"));
        this.getModel().setValue("currentanalysisobjtime", ((DynamicObject)this.getModel().getValue("currentanalysisobj")).get("modifytime"));
        DynamicObject draft = (DynamicObject)this.getModel().getValue("draft");
        if (draft != null) {
            this.getModel().setValue("draftmodifytime", (Object)draft.getDate("modifytime"));
        }
    }

    private void saveResult(ExRateGapAnalysisModel gapAnalysisModel) {
        DynamicObject[] gapAnalysisQingDataBills;
        for (DynamicObject gapAnalysisQingDataBill : gapAnalysisQingDataBills = (DynamicObject[])gapAnalysisModel.getGapAnalysisDetails().values().stream().toArray(DynamicObject[]::new)) {
            gapAnalysisQingDataBill.set("srcbill", this.getModel().getValue("id"));
        }
        try (TXHandle tx = TX.requiresNew();){
            try {
                if (EmptyUtil.isNoEmpty((Object)this.getModel().getValue("id"))) {
                    DeleteServiceHelper.delete((String)"mrm_exrate_gap_detail", (QFilter[])new QFilter[]{new QFilter("srcbill", "=", this.getModel().getValue("id"))});
                }
                SaveServiceHelper.save((DynamicObject[])gapAnalysisQingDataBills);
                OperationResult saveOpResult = this.getView().invokeOperation("save");
                if (!saveOpResult.isSuccess()) {
                    StringBuilder errorMsg = OperationResultHelper.getErrorMsg(saveOpResult);
                    throw new KDBizException(errorMsg.toString());
                }
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    private void refreshReport() {
        if (BillOperationStatus.ADDNEW == ((BillShowParameter)this.getView().getFormShowParameter()).getBillStatus()) {
            return;
        }
        boolean isExistData_singleCurrency = this.generateReport();
        if (!isExistData_singleCurrency) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"buttonpanel", "gapanalysisentity"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"noreportdatapanel", "nochartdatapanel"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"buttonpanel", "gapanalysisentity"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"noreportdatapanel", "nochartdatapanel"});
        }
    }

    private boolean generateReport() {
        boolean isExistData_singleCurrency;
        ExRateGapAnalysisModel gapAnalysisModel = new ExRateGapAnalysisModel(this.getModel().getDataEntity().getPkValue());
        DynamicObject subjectSystem = gapAnalysisModel.getSubjectSystem();
        DynamicObject orgView = (DynamicObject)this.getModel().getValue("orgview");
        DynamicObjectCollection orgCol = (DynamicObjectCollection)this.getModel().getValue("orgs");
        String appId = this.getView().getFormShowParameter().getAppId();
        List orgIds = OrgHelper.getPermOrgIds((DynamicObject)orgView, (DynamicObjectCollection)orgCol, (String)((MulBasedataProp)((MulBasedataEdit)this.getView().getControl("orgs")).getProperty()).getOrgFunc(), (String)appId, (String)"mrm_exrate_gap_analysis");
        HashSet<Long> currencyIdSet = new HashSet<Long>();
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (currency != null) {
            currencyIdSet.add(currency.getLong("id"));
        }
        if (isExistData_singleCurrency = gapAnalysisModel.queryResult(currencyIdSet, orgIds, this.getModel().getValue("id"))) {
            BigDecimal amtUnit = new BigDecimal((String)this.getModel().getValue("amtunit"));
            String[] titles = ((String)this.getModel().getValue("amtcolumntitles")).split("_");
            this.generateReport(gapAnalysisModel, subjectSystem, amtUnit, titles);
        }
        this.getModel().setDataChanged(false);
        QFilter qFilter = new QFilter("srcbill", "=", this.getModel().getValue("id"));
        if (orgIds != null) {
            qFilter.and("org", "in", (Object)orgIds);
        }
        return isExistData_singleCurrency;
    }

    private void beforeF7ViewDetail(BeforeF7ViewDetailEvent event) {
        Object pkId = event.getPkId();
        BasedataEdit source = (BasedataEdit)event.getSource();
        String key = source.getKey();
        if ("forexquote".equals(key)) {
            event.setCancel(true);
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.setFormId("md_forexquote");
            billShowParameter.setPkId(pkId);
            billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            billShowParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)billShowParameter);
        }
    }
}

