/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.formplugin.exrateopen;

import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ChartClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mrm.common.helper.ExRateGapAnalysisHelper;

public class ExRateGapAnalysisMultiCurHistogramChartPlugin
extends AbstractBillPlugIn {
    private static final String CHART_PROP = "histogramChart2";
    List<String> categories;
    private BigDecimal[] in;
    private BigDecimal[] out;
    private BigDecimal[] net;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CHART_PROP});
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.refreshChart();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName;
        super.propertyChanged(e);
        switch (propertyName = e.getProperty().getName()) {
            case "orgview": 
            case "amtunit": 
            case "orgs": {
                if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{this.getModel().getValue("amtunit"), this.getModel().getValue("currency")})) break;
                this.refreshChart();
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("save".equals(e.getOperateKey())) {
            this.refreshChart();
        }
    }

    private void refreshChart() {
        if (BillOperationStatus.ADDNEW == ((BillShowParameter)this.getView().getFormShowParameter()).getBillStatus()) {
            return;
        }
        String titleStr = (String)this.getModel().getValue("amtcolumntitles");
        if (!titleStr.contains("_")) {
            return;
        }
        if (!RequestContext.get().getTraceId().equals(this.getView().getFormShowParameter().getCustomParam("currentRequestTraceId"))) {
            ExRateGapAnalysisHelper.queryAndCacheExRateGapChartData((IFormView)this.getView());
        }
        if (this.getView().getFormShowParameter().getCustomParam("currencyNumbers") instanceof List) {
            this.categories = (List)this.getView().getFormShowParameter().getCustomParam("currencyNumbers");
        }
        if (this.getView().getFormShowParameter().getCustomParam("MultiCurInArr") instanceof BigDecimal[]) {
            this.in = (BigDecimal[])this.getView().getFormShowParameter().getCustomParam("MultiCurInArr");
        }
        if (this.getView().getFormShowParameter().getCustomParam("MultiCurOutArr") instanceof BigDecimal[]) {
            this.out = (BigDecimal[])this.getView().getFormShowParameter().getCustomParam("MultiCurOutArr");
        }
        if (this.getView().getFormShowParameter().getCustomParam("MultiCurArr") instanceof BigDecimal[]) {
            this.net = (BigDecimal[])this.getView().getFormShowParameter().getCustomParam("MultiCurArr");
        }
        if (this.categories == null || this.in == null || this.out == null || this.net == null) {
            return;
        }
        HistogramChart chart = (HistogramChart)this.getControl(CHART_PROP);
        this.setStyle(chart);
        chart.clearData();
        this.createYAxis(chart);
        this.createXAxis(chart);
        this.setData(chart);
    }

    private void setStyle(HistogramChart chart) {
        chart.setMargin(Position.left, "30px");
        chart.setMargin(Position.right, "120px");
        chart.setMargin(Position.top, "30px");
        chart.setMargin(Position.bottom, "30px");
        chart.setShowLegend(true);
        chart.setLegendPropValue("itemWidth", (Object)10);
        chart.setLegendPropValue("itemHeight", (Object)10);
        chart.setLegendVertical(false);
        chart.setLegendAlign(XAlign.center, YAlign.top);
        chart.setShowTooltip(true);
    }

    private void createYAxis(HistogramChart chart) {
        Axis yAxis = chart.createYAxis("", AxisType.category);
        yAxis.setCategorys(this.categories);
        yAxis.setPosition(Position.bottom);
        yAxis.setPropValue("nameGap", (Object)"5");
        HashMap<String, int[]> map = new HashMap<String, int[]>();
        map.put("padding", new int[]{0, 55, 0, 0});
        yAxis.setPropValue("nameTextStyle", map);
        HashMap<String, Constable> axisTick = new HashMap<String, Constable>();
        axisTick.put("interval", Integer.valueOf(0));
        axisTick.put("show", Boolean.valueOf(false));
        yAxis.setPropValue("axisTick", axisTick);
        this.setLineColor(yAxis);
    }

    private void createXAxis(HistogramChart chart) {
        Axis xAxis = chart.createXAxis("", AxisType.value);
        xAxis.setPropValue("nameGap", (Object)"5");
        HashMap<String, int[]> map = new HashMap<String, int[]>();
        map.put("padding", new int[]{0, 0, 5, -45});
        xAxis.setPropValue("nameTextStyle", map);
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>();
        axisTick.put("show", false);
        xAxis.setPropValue("axisTick", axisTick);
        HashMap splitLine = new HashMap();
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        xAxis.setPropValue("splitLine", splitLine);
        this.setLineColor(xAxis);
        HashMap<String, Object> axisLabel = new HashMap<String, Object>();
        axisLabel.put("rotate", "-15");
        axisLabel.put("inside", false);
        axisLabel.put("margin", "6");
        xAxis.setPropValue("axisLabel", axisLabel);
    }

    private void setData(HistogramChart chart) {
        BarSeries barSeries1 = this.createBarSeries(chart, ResManager.loadKDString((String)"\u6d41\u5165", (String)"ExRateGapAnalysisHistogramChartPlugin_0", (String)"tmc-mrm-formplugin", (Object[])new Object[0]), "#20A7F0");
        barSeries1.setData((Number[])this.in);
        BarSeries barSeries2 = this.createBarSeries(chart, ResManager.loadKDString((String)"\u6d41\u51fa", (String)"ExRateGapAnalysisHistogramChartPlugin_1", (String)"tmc-mrm-formplugin", (Object[])new Object[0]), "#45DAD1");
        barSeries2.setData((Number[])this.out);
        BarSeries barSeries3 = this.createBarSeries(chart, ResManager.loadKDString((String)"\u51c0\u655e\u53e3", (String)"ExRateGapAnalysisHistogramChartPlugin_2", (String)"tmc-mrm-formplugin", (Object[])new Object[0]), "#A0D911");
        barSeries3.setData((Number[])this.net);
        chart.bindData(null);
    }

    private BarSeries createBarSeries(HistogramChart chart, String name, String color) {
        BarSeries barSeries = chart.createBarSeries(name);
        if (this.categories.size() <= 2) {
            barSeries.setBarWidth("15px");
        } else {
            barSeries.setBarWidth("10px");
        }
        barSeries.setAnimationDuration(1500);
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, HashMap<String, String>> itemStyle = new HashMap<String, HashMap<String, String>>();
        map.put("color", String.format("new echarts.graphic.LinearGradient(0, 0, 0, 1, [{\"offset\": 0,\"color\": '%s'}, {\"offset\": 1, \"color\": '%s'}])", color, color));
        itemStyle.put("normal", map);
        barSeries.setPropValue("itemStyle", itemStyle);
        ArrayList<String> list = new ArrayList<String>();
        list.add("itemStyle");
        list.add("normal");
        list.add("color");
        barSeries.addFuncPath(list);
        barSeries.setLabel(null);
        return barSeries;
    }

    private void setLineColor(Axis axis) {
        HashMap axisLineMap = new HashMap();
        HashMap<String, String> lineStyleMap = new HashMap<String, String>();
        lineStyleMap.put("color", "#999999");
        axisLineMap.put("lineStyle", lineStyleMap);
        axis.setPropValue("axisLine", axisLineMap);
    }

    public void click(EventObject evt) {
        String currencyNumber;
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (CHART_PROP.equalsIgnoreCase(key) && EmptyUtil.isNoEmpty((String)(currencyNumber = ((ChartClickEvent)evt).getName()))) {
            QFilter qFilter;
            String other = ResManager.loadKDString((String)"\u5176\u4ed6", (String)"ExRateGapMultiCurHistogramQingAnalysisPlugin_7", (String)"tmc-mrm-report", (Object[])new Object[0]);
            if (currencyNumber.equals(other)) {
                if (!RequestContext.get().getTraceId().equals(this.getView().getFormShowParameter().getCustomParam("currentRequestTraceId"))) {
                    ExRateGapAnalysisHelper.queryAndCacheExRateGapChartData((IFormView)this.getView());
                }
                this.categories = (List)this.getView().getFormShowParameter().getCustomParam("currencyNumbers");
                qFilter = new QFilter("cashFlowCurrency.number", "not in", this.categories);
            } else {
                qFilter = new QFilter("cashFlowCurrency.number", "=", (Object)currencyNumber);
            }
            ExRateGapAnalysisHelper.showExRateGapDetailList((IFormView)this.getView(), (QFilter)qFilter);
        }
    }
}

