/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.formplugin.exrateopen;

import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mrm.common.helper.ExRateGapAnalysisHelper;
import kd.tmc.mrm.common.model.section.SectionCfgModel;

public class ExRateGapAnalysisPointLineCardPlugin
extends AbstractBillPlugIn {
    List<String> categories;
    BigDecimal[] data1;
    BigDecimal[] data2;

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.refreshChart();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName;
        super.propertyChanged(e);
        switch (propertyName = e.getProperty().getName()) {
            case "orgview": 
            case "amtunit": 
            case "orgs": 
            case "currency": {
                if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{this.getModel().getValue("amtunit"), this.getModel().getValue("currency")})) break;
                this.refreshChart();
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("save".equals(e.getOperateKey())) {
            this.refreshChart();
        }
    }

    private void refreshChart() {
        if (BillOperationStatus.ADDNEW == ((BillShowParameter)this.getView().getFormShowParameter()).getBillStatus()) {
            return;
        }
        String titleStr = (String)this.getModel().getValue("amtcolumntitles");
        if (!titleStr.contains("_")) {
            return;
        }
        if (!RequestContext.get().getTraceId().equals(this.getView().getFormShowParameter().getCustomParam("currentRequestTraceId"))) {
            ExRateGapAnalysisHelper.queryAndCacheExRateGapChartData((IFormView)this.getView());
        }
        if (this.getView().getFormShowParameter().getCustomParam("arr") instanceof BigDecimal[]) {
            this.data1 = (BigDecimal[])this.getView().getFormShowParameter().getCustomParam("arr");
        }
        if (this.getView().getFormShowParameter().getCustomParam("sumArr") instanceof BigDecimal[]) {
            this.data2 = (BigDecimal[])this.getView().getFormShowParameter().getCustomParam("sumArr");
        }
        if (this.data1 == null || this.data2 == null) {
            return;
        }
        String[] titles = titleStr.split("_");
        this.categories = new ArrayList<String>(10);
        for (String title : titles) {
            this.categories.add(SectionCfgModel.generateTitlesName((String)title));
        }
        PointLineChart chart = (PointLineChart)this.getControl("pointLineChart");
        this.setStyle(chart);
        chart.clearData();
        this.createXAxis(chart);
        this.createYAxis(chart);
        this.setData(chart);
    }

    private void setStyle(PointLineChart chart) {
        chart.setMargin(Position.left, "30px");
        chart.setMargin(Position.right, "60px");
        chart.setMargin(Position.top, "22px");
        chart.setMargin(Position.bottom, "22px");
        chart.setShowTooltip(true);
        chart.setShowLegend(true);
        chart.setLegendAlign(XAlign.center, YAlign.top);
        chart.setLegendVertical(false);
    }

    private void createXAxis(PointLineChart chart) {
        Axis xAxis = chart.createXAxis("", AxisType.category);
        xAxis.setCategorys(this.categories);
        HashMap<String, Constable> axisTick = new HashMap<String, Constable>();
        axisTick.put("interval", Integer.valueOf(0));
        axisTick.put("show", Boolean.valueOf(false));
        xAxis.setPropValue("axisTick", axisTick);
        this.setLineColor(xAxis, "#999999");
        HashMap<String, String> axisLabel = new HashMap<String, String>();
        axisLabel.put("rotate", "-15");
        axisLabel.put("margin", "6");
        xAxis.setPropValue("axisLabel", axisLabel);
    }

    private void createYAxis(PointLineChart chart) {
        Axis yAxis = chart.createYAxis("", AxisType.value);
        HashMap splitLine = new HashMap();
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        yAxis.setPropValue("splitLine", splitLine);
        this.setLineColor(yAxis, "#999999");
    }

    private void setData(PointLineChart chart) {
        LineSeries series1 = chart.createSeries(ResManager.loadKDString((String)"\u51c0\u655e\u53e3", (String)"ExRateGapAnalysisPointLineCardPlugin_0", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
        series1.setItemColor("#A0D911");
        series1.setData((Number[])this.data1);
        LineSeries series2 = chart.createSeries(ResManager.loadKDString((String)"\u7d2f\u8ba1\u51c0\u655e\u53e3", (String)"ExRateGapAnalysisPointLineCardPlugin_1", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
        series2.setItemColor("#FFA940");
        series2.setData((Number[])this.data2);
        chart.bindData(null);
    }

    private void setLineColor(Axis axis, String color) {
        HashMap axisLineMap = new HashMap();
        HashMap<String, String> lineStyleMap = new HashMap<String, String>();
        lineStyleMap.put("color", color);
        axisLineMap.put("lineStyle", lineStyleMap);
        axis.setPropValue("axisLine", axisLineMap);
    }
}

