/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.formplugin.exscenariosimulation;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FieldTip;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.fieldtip.DeleteRule;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;
import kd.tmc.mrm.common.enums.ExScenarioMethodEnum;
import kd.tmc.mrm.common.enums.ExSectionTypeEnum;
import kd.tmc.mrm.common.enums.ExSimulateFormEnum;
import kd.tmc.mrm.common.helper.OrgHelper;
import kd.tmc.mrm.common.helper.TmcBaseDataServiceHelper;

public class ExScenarioSimulationEdit
extends AbstractTmcBillEdit
implements BeforeF7SelectListener,
RowClickEventListener,
CellClickListener {
    public static final String KEY_SIMULATESUBENTRY_COLUMN_INDEX = "key_simulatesubentry_column_index";
    public static final String KEY_SIMULATEENTRY_COLUMN_INDEX = "key_simulateentry_column_index";
    public static final int MAX_SIMULATE_EXRATE_COLUMN_COUNT = 5;
    public static final int MAX_SIMULATE_CURRENCY_COUNT = 10;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getView().getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid sectionentry = (EntryGrid)this.getView().getControl("sectionentry");
        sectionentry.addRowClickListener((RowClickEventListener)this);
        EntryGrid simulateentry = (EntryGrid)this.getView().getControl("simulateentry");
        simulateentry.addCellClickListener((CellClickListener)this);
        simulateentry.addRowClickListener((RowClickEventListener)this);
        EntryGrid simulatesubentry = (EntryGrid)this.getView().getControl("simulatesubentry");
        simulatesubentry.addRowClickListener((RowClickEventListener)this);
        simulatesubentry.addCellClickListener((CellClickListener)this);
        this.setNoChangeFields("simulatenum");
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setOrgAndLocalCurrency();
        this.initSimulateNum();
        this.createOneRowEntry();
    }

    private void createOneRowEntry() {
        String scenarioMethod = (String)this.getModel().getValue("scenariomethod");
        String sectionType = (String)this.getModel().getValue("sectiontype");
        if (!ExScenarioMethodEnum.isDefine((String)scenarioMethod) && !ExSectionTypeEnum.isMutilSection((String)sectionType)) {
            this.getModel().createNewEntryRow("simulateentry");
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.setOrgAndLocalCurrency();
        this.setSimulateColumn();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Object id = this.getModel().getValue("id");
        if (!EmptyUtil.isEmpty((Object)id)) {
            if (!BaseDataRefrenceHelper.isRefrenced((String)"mrm_ex_scenario_sim", (Object)id)) {
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"status", (Object)BillStatusEnum.SAVE.getValue());
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u88ab\u654f\u611f\u6027\u5206\u6790\u5355\u636e\u5f15\u7528\uff0c\u4e0d\u80fd\u4fee\u6539\u3002", (String)"ExScenarioSimulationEdit_18", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setSimulateColumn();
        this.controlRankCount();
        this.controlSectionValue();
        this.selectSectionFirstRow();
        this.setSimulateSubEntryLabel(0);
        this.setSimulateEntryLabel();
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String property;
        switch (property = evt.getProperty().getName()) {
            case "org": {
                this.orgF7Filter(evt);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        switch (operateKey = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "addsimulateexrate": 
            case "addsubsimulateexrate": {
                this.addSimulateExRateBeforeDoOp(args, operateKey);
                break;
            }
            case "buildsimulate": {
                this.buildSimulateBeforeDoOp(args);
                break;
            }
            case "buildsubsimulate": {
                this.buildSubSimulateBeforeDoOp(args);
                break;
            }
            case "delsimulateexrate": {
                this.delSimulateExRateBeforeDoOp(args);
                break;
            }
            case "delsubsimulateexrate": {
                this.delSubSimulateExRateBeforeDoOp(args);
                break;
            }
            case "addsimulatecurrency": {
                this.addSimulateCurrencyBeforeDoOp(args);
                break;
            }
            case "addsubsimulatecurrency": {
                this.addSubSimulateCurrencyBeforeDoOp(args);
                break;
            }
            case "delsimulatecurrency": {
                this.delSimulateCurrencyBeforeDoOp(args);
                break;
            }
            case "delsubsimulatecurrency": {
                this.delSubSimulateCurrencyBeforeDoOp(args);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey;
        super.afterDoOperation(e);
        switch (operateKey = e.getOperateKey()) {
            case "buildsimulate": 
            case "buildsubsimulate": {
                this.buildsimulateAfterDoOp(e);
                break;
            }
            case "addsimulateexrate": 
            case "addsubsimulateexrate": {
                this.addSimulateExrateAfterDoOp(e);
                break;
            }
            case "delsubsimulateexrate": {
                this.delSubsimulateExRateAfterDoOp(e);
                break;
            }
            case "delsimulateexrate": {
                this.delSimulateExRateAfterDoOp(e);
                break;
            }
            case "addsubsimulatecurrency": {
                this.addSubsimulateCurrencyAfterDoOp(e);
                break;
            }
            case "addsimulatecurrency": {
                this.addSimulateCurrencyAfterDoOp(e);
                break;
            }
            case "delsubsimulatecurrency": {
                this.delSubSimulateCurrencyAfterDoOp();
                break;
            }
            case "section_insert": {
                this.buildSubSimulateExRate();
                break;
            }
            case "simulatetest": {
                this.openSimulateTestPage();
                break;
            }
            case "save": {
                if (!e.getOperationResult().isSuccess()) break;
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        switch (e.getActionId()) {
            case "simulatecurrency": {
                this.simulateCurrClosedCallBack(e);
                break;
            }
            case "subsimulatecurrency": {
                this.subSimulateCurrClosedCallBack(e);
                break;
            }
            case "buildsimulate": {
                this.buildSimulateClosedCallBack(e);
                break;
            }
            case "buildsubsimulate": {
                this.buildSubSimulateClosedCallBack(e);
                break;
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        EntryProp entryProp = e.getEntryProp();
        String name = entryProp.getName();
        int insertRow = e.getInsertRow();
        if ("sectionentry".equals(name)) {
            if (insertRow > 0) {
                DynamicObject firstEntryRowEntity = this.getModel().getEntryRowEntity("sectionentry", 0);
                DynamicObjectCollection simulatesubentryList = firstEntryRowEntity.getDynamicObjectCollection("simulatesubentry");
                DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("sectionentry", insertRow);
                DynamicObjectCollection dynamicObjectCollection = entryRowEntity.getDynamicObjectCollection("simulatesubentry");
                for (int i = 0; i < simulatesubentryList.size(); ++i) {
                    DynamicObject dynamicObject = (DynamicObject)simulatesubentryList.get(i);
                    dynamicObjectCollection.add(i, (DynamicObject)dynamicObjectCollection.getDynamicObjectType().createInstance());
                    this.getModel().setValue("subsimulatecurrency", (Object)dynamicObject.getDynamicObject("subsimulatecurrency"), i, insertRow);
                    this.getModel().setValue("subkeyfield", (Object)"1", i, insertRow);
                }
            } else {
                this.buildSubSimulateExRate();
            }
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        EntryProp entryProp = e.getEntryProp();
        String name = entryProp.getName();
        if ("sectionentry".equals(name) && this.getModel().getEntryRowCount(name) - ((EntryGrid)this.getView().getControl(name)).getSelectRows().length < 2) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u591a\u533a\u95f4\u6bb5\u65f6\uff0c\u8bf7\u81f3\u5c11\u8bbe\u7f6e2\u4e2a\u533a\u95f4\u6bb5\u3002", (String)"ExScenarioSimulationEdit_2", (String)"tmc-mrm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            e.setCancel(true);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        int index = evt.getRow();
        if (index >= 0 && StringUtils.equals((CharSequence)"sectionentry", (CharSequence)entryGrid.getKey())) {
            int sectionEntryRowIndex = this.getSelectEntryRowIndex("sectionentry");
            this.setSimulateSubEntryLabel(sectionEntryRowIndex);
        }
    }

    public void cellClick(CellClickEvent cellClickEvent) {
        EntryGrid source = (EntryGrid)cellClickEvent.getSource();
        String entryKey = source.getEntryKey();
        String fieldKey = cellClickEvent.getFieldKey();
        if ("simulateentry".equals(entryKey) && fieldKey.startsWith("simulateexrate")) {
            this.getPageCache().put(KEY_SIMULATEENTRY_COLUMN_INDEX, fieldKey.substring(fieldKey.length() - 1));
        }
        if ("simulatesubentry".equals(entryKey) && fieldKey.startsWith("subsimulateexrate")) {
            this.getPageCache().put(KEY_SIMULATESUBENTRY_COLUMN_INDEX, fieldKey.substring(fieldKey.length() - 1));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        switch (propertyName) {
            case "scenariomethod": {
                this.onScenarioMethodChange();
                break;
            }
            case "simulateform": {
                EntryGrid sectionGrid;
                int[] selectRows;
                String sectionType = (String)this.getModel().getValue("sectiontype");
                if (ExSectionTypeEnum.isMutilSection((String)sectionType) && (selectRows = (sectionGrid = (EntryGrid)this.getControl("sectionentry")).getSelectRows()) != null && selectRows.length > 0) {
                    this.setSimulateSubEntryLabel(selectRows[0]);
                }
                this.clearSimulateExRate();
                this.setSimulateEntryLabel();
                break;
            }
            case "sectiontype": {
                String sectionTypeOldValue = (String)changeData[0].getOldValue();
                this.onSectionTypeChange(sectionTypeOldValue);
                break;
            }
            case "sectionvalue": {
                String oldValue = (String)changeData[0].getOldValue();
                this.checkSectionseValueFormat(oldValue);
                break;
            }
            case "left": 
            case "unit": 
            case "iscontains": {
                int selectEntryRowIndex = this.getSelectEntryRowIndex("sectionentry");
                this.setSimulateSubEntryLabel(selectEntryRowIndex);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (("delsimulateexrate".equals(callBackId) || "delsubsimulateexrate".equals(callBackId)) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.delSimulateExrate(callBackId);
        }
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Control source = (Control)e.getSource();
        String key = source.getKey();
        int parentRowIndex = e.getParentRowIndex();
        int rowIndex = e.getRowIndex();
        String simulateform = (String)this.getModel().getValue("simulateform");
        if ("rankcount".equals(key)) {
            this.rankCountBeforeFieldPostBack(e);
        }
        for (int i = 0; i < 5; ++i) {
            if (("simulateexrate" + (i + 1)).equals(key)) {
                this.simulateExRateBeforeFieldPostBack(e, simulateform, key, rowIndex);
                break;
            }
            if (!("subsimulateexrate" + (i + 1)).equals(key)) continue;
            this.subSimulateExRateBeforeFieldPostBack(e, simulateform, key, rowIndex, parentRowIndex);
            break;
        }
    }

    private void subSimulateExRateBeforeFieldPostBack(BeforeFieldPostBackEvent e, String simulateform, String key, int rowIndex, int parentRowIndex) {
        BigDecimal v1;
        BigDecimal bigDecimal = v1 = EmptyUtil.isEmpty((Object)e.getValue()) ? BigDecimal.ZERO : new BigDecimal((String)e.getValue());
        if (ExSimulateFormEnum.isPercent((String)simulateform)) {
            if (v1.compareTo(BigDecimal.valueOf(-100L)) < 0 || v1.compareTo(BigDecimal.valueOf(100L)) > 0) {
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f93\u5165\u6570\u503c\u8981\u5927\u4e8e\u7b49\u4e8e-100\u4e14\u5c0f\u4e8e\u7b49\u4e8e100\u3002", (String)"ExScenarioSimulationEdit_19", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
                this.getView().updateView(key, rowIndex, parentRowIndex);
            }
        } else if (v1.compareTo(BigDecimal.ZERO) <= 0) {
            e.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f93\u5165\u6570\u503c\u8981\u5927\u4e8e0\u3002", (String)"ExScenarioSimulationEdit_20", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
            this.getView().updateView(key, rowIndex, parentRowIndex);
        }
    }

    private void simulateExRateBeforeFieldPostBack(BeforeFieldPostBackEvent e, String simulateform, String field, int rowIndex) {
        BigDecimal v1;
        BigDecimal bigDecimal = v1 = EmptyUtil.isEmpty((Object)e.getValue()) ? BigDecimal.ZERO : new BigDecimal((String)e.getValue());
        if (ExSimulateFormEnum.isPercent((String)simulateform)) {
            if (v1.compareTo(BigDecimal.valueOf(-100L)) < 0 || v1.compareTo(BigDecimal.valueOf(100L)) > 0) {
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f93\u5165\u6570\u503c\u8981\u5927\u4e8e\u7b49\u4e8e-100\u4e14\u5c0f\u4e8e\u7b49\u4e8e100\u3002", (String)"ExScenarioSimulationEdit_19", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
                this.getView().updateView(field, rowIndex);
            }
        } else if (v1.compareTo(BigDecimal.ZERO) <= 0) {
            e.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f93\u5165\u6570\u503c\u8981\u5927\u4e8e0\u3002", (String)"ExScenarioSimulationEdit_20", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
            this.getView().updateView(field, rowIndex);
        }
    }

    private void rankCountBeforeFieldPostBack(BeforeFieldPostBackEvent e) {
        BigDecimal v = EmptyUtil.isEmpty((Object)e.getValue()) ? BigDecimal.ZERO : new BigDecimal((String)e.getValue());
        FieldTip tip = new FieldTip();
        tip.setFieldKey("rankcount");
        if (v.compareTo(BigDecimal.ZERO) <= 0 || v.compareTo(BigDecimal.valueOf(20L)) > 0) {
            tip.setLevel(FieldTip.FieldTipsLevel.Error);
            tip.setTip(ResManager.loadKDString((String)"\u8f93\u5165\u6570\u503c\u8981\u5927\u4e8e0\u4e14\u5c0f\u4e8e\u7b49\u4e8e20", (String)"ExScenarioSimulationEdit_5", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
            this.getView().showFieldTip(tip);
            e.setCancel(true);
            this.getView().updateView("rankcount");
        } else {
            DeleteRule deleteRule = new DeleteRule();
            deleteRule.setFields(Collections.singletonList("rankcount"));
            tip.setDeleteRule(deleteRule);
            tip.setSuccess(true);
            this.getView().showFieldTip(tip);
        }
    }

    private void selectSectionFirstRow() {
        int entryRowCount = this.getModel().getEntryRowCount("sectionentry");
        if (entryRowCount > 0) {
            EntryGrid sectionentry = (EntryGrid)this.getControl("sectionentry");
            sectionentry.selectRows(0);
        }
    }

    private void controlSectionValue() {
        String sectionType = (String)this.getModel().getValue("sectiontype");
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)ExSectionTypeEnum.isSingleSection((String)sectionType), (String[])new String[]{"sectionvalue"});
    }

    private void controlRankCount() {
        String scenarioMethod = (String)this.getModel().getValue("scenariomethod");
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)ExScenarioMethodEnum.isRank((String)scenarioMethod), (String[])new String[]{"rankcount"});
    }

    private void setSimulateColumn() {
        int simulatenum = (Integer)this.getModel().getValue("simulatenum");
        String sectionset = (String)this.getModel().getValue("sectiontype");
        if (ExSectionTypeEnum.isMutilSection((String)sectionset)) {
            int i;
            EntryGrid subSimulateEntry = (EntryGrid)this.getControl("simulatesubentry");
            for (i = 0; i < simulatenum; ++i) {
                subSimulateEntry.setColumnProperty("subsimulateexrate" + (i + 1), "visible", (Object)true);
            }
            for (i = simulatenum; i < 5; ++i) {
                subSimulateEntry.setColumnProperty("subsimulateexrate" + (i + 1), "visible", (Object)false);
            }
        } else {
            int i;
            EntryGrid simulateentry = (EntryGrid)this.getControl("simulateentry");
            for (i = 0; i < simulatenum; ++i) {
                simulateentry.setColumnProperty("simulateexrate" + (i + 1), "visible", (Object)true);
            }
            for (i = simulatenum; i < 5; ++i) {
                simulateentry.setColumnProperty("simulateexrate" + (i + 1), "visible", (Object)false);
            }
        }
    }

    private void initSimulateNum() {
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"simulatenum", (Object)1);
    }

    private void setNoChangeFields(String ... fields) {
        for (String field : fields) {
            DynamicProperty prop = this.getModel().getDataEntity().getDynamicObjectType().getProperty(field);
            this.getModel().getDataEntity().getDataEntityState().setBizChanged(prop.getOrdinal(), false);
            FieldEdit fieldEdit = (FieldEdit)this.getControl(field);
            this.getModel().getDataEntity().getDataEntityState().setDirty((ISimpleProperty)fieldEdit.getProperty(), true);
        }
    }

    private void orgF7Filter(BeforeF7SelectEvent evt) {
        String appId = this.getView().getFormShowParameter().getAppId();
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        List orgIds = OrgHelper.getPermOrgIds(null, null, null, (String)appId, (String)"mrm_ex_scenario_sim");
        if (orgIds != null) {
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)orgIds));
        }
    }

    private void buildSimulateClosedCallBack(ClosedCallBackEvent e) {
        Map data = (Map)e.getReturnData();
        if (EmptyUtil.isNoEmpty((Object)data)) {
            BigDecimal leftsimulateexrate = (BigDecimal)data.get("leftsimulateexrate");
            BigDecimal rightsimulateexrate = (BigDecimal)data.get("rightsimulateexrate");
            int interval = (Integer)data.get("interval");
            this.fastFillSimulateEntry(leftsimulateexrate, rightsimulateexrate, interval);
        }
    }

    private void buildSubSimulateClosedCallBack(ClosedCallBackEvent e) {
        Map data = (Map)e.getReturnData();
        if (EmptyUtil.isNoEmpty((Object)data)) {
            BigDecimal leftsimulateexrate = (BigDecimal)data.get("leftsimulateexrate");
            BigDecimal rightsimulateexrate = (BigDecimal)data.get("rightsimulateexrate");
            int interval = (Integer)data.get("interval");
            this.fastFillSimulateSubEntry(leftsimulateexrate, rightsimulateexrate, interval);
        }
    }

    private void simulateCurrClosedCallBack(ClosedCallBackEvent e) {
        ListSelectedRowCollection returnDatas = (ListSelectedRowCollection)e.getReturnData();
        if (returnDatas == null || returnDatas.size() == 0) {
            return;
        }
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity("simulateentry");
        int size = dynamicObjectCollection.size();
        if (returnDatas.size() + dynamicObjectCollection.size() > 10) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u591a\u53ef\u81ea\u5b9a\u4e4910\u4e2a\u5e01\u79cd\u8fdb\u884c\u6c47\u7387\u6a21\u62df\u3002", (String)"ExScenarioSimulationEdit_13", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
        } else {
            for (int g = 0; g < returnDatas.size(); ++g) {
                ListSelectedRow returnData = returnDatas.get(g);
                DynamicObject instance = (DynamicObject)dynamicObjectCollection.getDynamicObjectType().createInstance();
                this.getModel().createNewEntryRow("simulateentry", size + g, instance);
                this.getModel().setValue("simulatecurrency", returnData.getPrimaryKeyValue(), size + g);
            }
            this.getView().updateView("simulateentry");
        }
    }

    private void subSimulateCurrClosedCallBack(ClosedCallBackEvent e) {
        ListSelectedRowCollection returnDatas = (ListSelectedRowCollection)e.getReturnData();
        if (returnDatas == null || returnDatas.size() == 0) {
            return;
        }
        DynamicObjectCollection sectionEntryList = this.getModel().getEntryEntity("sectionentry");
        for (int i = 0; i < sectionEntryList.size(); ++i) {
            DynamicObject sectionEntry = (DynamicObject)sectionEntryList.get(i);
            DynamicObjectCollection dynamicObjectCollection = sectionEntry.getDynamicObjectCollection("simulatesubentry");
            int size = dynamicObjectCollection.size();
            if (i == 0 && returnDatas.size() + dynamicObjectCollection.size() > 10) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u591a\u53ef\u81ea\u5b9a\u4e4910\u4e2a\u5e01\u79cd\u8fdb\u884c\u6c47\u7387\u6a21\u62df\u3002", (String)"ExScenarioSimulationEdit_13", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
                return;
            }
            for (int j = 0; j < returnDatas.size(); ++j) {
                ListSelectedRow returnData = returnDatas.get(j);
                dynamicObjectCollection.add(size + j, (DynamicObject)dynamicObjectCollection.getDynamicObjectType().createInstance());
                this.getModel().setValue("subsimulatecurrency", returnData.getPrimaryKeyValue(), size + j, i);
            }
            this.getView().updateView("simulatesubentry");
        }
    }

    private DynamicObjectCollection getCurrentSectionSubEntry(IDataModel entryOperate, int parentRow) {
        DynamicObject entryRowEntity = entryOperate.getEntryRowEntity("sectionentry", parentRow);
        return entryRowEntity.getDynamicObjectCollection("simulatesubentry");
    }

    private void fastFillSimulateEntry(BigDecimal leftsimulateexrate, BigDecimal rightsimulateexrate, int interval) {
        DynamicObjectCollection simulateentry = this.getModel().getEntryEntity("simulateentry");
        List<BigDecimal> list = this.getFastFillSimulateExrateList(leftsimulateexrate, rightsimulateexrate, interval);
        for (DynamicObject dynamicObject : simulateentry) {
            for (int i = 0; i < list.size(); ++i) {
                dynamicObject.set("simulateexrate" + (i + 1), (Object)list.get(i));
            }
            for (int j = list.size(); j < 5; ++j) {
                dynamicObject.set("simulateexrate" + (j + 1), (Object)0);
            }
        }
        EntryGrid simulateEntryGrid = (EntryGrid)this.getControl("simulateentry");
        for (int i = 0; i < list.size(); ++i) {
            simulateEntryGrid.setColumnProperty("simulateexrate" + (i + 1), "visible", (Object)true);
        }
        for (int z = list.size(); z < 5; ++z) {
            simulateEntryGrid.setColumnProperty("simulateexrate" + (z + 1), "visible", (Object)false);
        }
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"simulatenum", (Object)list.size());
        this.getView().updateView("simulateentry");
    }

    private List<BigDecimal> getFastFillSimulateExrateList(BigDecimal leftsimulateexrate, BigDecimal rightsimulateexrate, int interval) {
        ArrayList<BigDecimal> list = new ArrayList<BigDecimal>();
        list.add(leftsimulateexrate);
        while (leftsimulateexrate.compareTo(rightsimulateexrate) < 0) {
            if ((leftsimulateexrate = leftsimulateexrate.add(BigDecimal.valueOf(interval))).compareTo(rightsimulateexrate) < 0) {
                list.add(leftsimulateexrate);
                continue;
            }
            list.add(rightsimulateexrate);
        }
        return list;
    }

    private void fastFillSimulateSubEntry(BigDecimal leftsimulateexrate, BigDecimal rightsimulateexrate, int interval) {
        DynamicObjectCollection entryEntityList = this.getModel().getEntryEntity("sectionentry");
        List<BigDecimal> list = this.getFastFillSimulateExrateList(leftsimulateexrate, rightsimulateexrate, interval);
        for (DynamicObject dynamicObject : entryEntityList) {
            DynamicObjectCollection simulatesubentryList = dynamicObject.getDynamicObjectCollection("simulatesubentry");
            if (simulatesubentryList.size() == 0) {
                simulatesubentryList.addNew();
            }
            for (DynamicObject simulatesubentry : simulatesubentryList) {
                for (int i = 0; i < list.size(); ++i) {
                    simulatesubentry.set("subsimulateexrate" + (i + 1), (Object)list.get(i));
                }
                for (int j = list.size(); j < 5; ++j) {
                    simulatesubentry.set("subsimulateexrate" + (j + 1), (Object)0);
                }
            }
        }
        EntryGrid subSimulateEntryGrid = (EntryGrid)this.getControl("simulatesubentry");
        for (int i = 0; i < list.size(); ++i) {
            subSimulateEntryGrid.setColumnProperty("subsimulateexrate" + (i + 1), "visible", (Object)true);
        }
        for (int z = list.size(); z < 5; ++z) {
            subSimulateEntryGrid.setColumnProperty("subsimulateexrate" + (z + 1), "visible", (Object)false);
        }
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"simulatenum", (Object)list.size());
        this.getView().updateView("simulatesubentry");
    }

    private void setSimulateSubEntryLabel(int index) {
        DynamicObject entryRowEntity;
        if (index >= 0 && (entryRowEntity = this.getModel().getEntryRowEntity("sectionentry", index)) != null) {
            String sectiondesc = entryRowEntity.getString("sectiondesc");
            Label simulatesubentrylabel = (Label)this.getControl("simulatesubentrylabel");
            String simulateForm = (String)this.getModel().getValue("simulateform");
            if (ExSimulateFormEnum.isPercent((String)simulateForm)) {
                simulatesubentrylabel.setText(String.format(ResManager.loadKDString((String)"\u533a\u95f4\u6bb5%1$s\u6c47\u7387\u6a21\u62df%2$s\uff1a", (String)"ExScenarioSimulationEdit_3", (String)"tmc-mrm-formplugin", (Object[])new Object[0]), sectiondesc, "(%)"));
            } else {
                simulatesubentrylabel.setText(String.format(ResManager.loadKDString((String)"\u533a\u95f4\u6bb5%s\u6c47\u7387\u6a21\u62df\uff1a", (String)"ExScenarioSimulationEdit_4", (String)"tmc-mrm-formplugin", (Object[])new Object[0]), sectiondesc));
            }
        }
    }

    private void setSimulateEntryLabel() {
        Label simulateentrylabel = (Label)this.getControl("simulateentrylabel");
        String simulateForm = (String)this.getModel().getValue("simulateform");
        if (ExSimulateFormEnum.isPercent((String)simulateForm)) {
            simulateentrylabel.setText(String.format(ResManager.loadKDString((String)"\u6c47\u7387\u6a21\u62df%1$s\uff1a", (String)"ExScenarioSimulationEdit_21", (String)"tmc-mrm-formplugin", (Object[])new Object[0]), "(%)"));
        } else {
            simulateentrylabel.setText(ResManager.loadKDString((String)"\u6c47\u7387\u6a21\u62df\uff1a", (String)"ExScenarioSimulationEdit_22", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
        }
    }

    private void setOrgAndLocalCurrency() {
        Map result;
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null && !EmptyUtil.isEmpty((Object)(result = TmcBaseDataServiceHelper.getBaseAccountingInfo((Long)org.getLong("id"))))) {
            Long localCurrencyId = (Long)result.get("baseCurrencyID");
            this.getModel().setValue("currency", (Object)localCurrencyId);
        }
    }

    private void clearSimulateExRate() {
        int simulatenum = (Integer)this.getModel().getValue("simulatenum");
        String sectionType = (String)this.getModel().getValue("sectiontype");
        if (ExSectionTypeEnum.isMutilSection((String)sectionType)) {
            DynamicObjectCollection sectionEntryList = this.getModel().getEntryEntity("sectionentry");
            for (int i = 0; i < sectionEntryList.size(); ++i) {
                DynamicObject sectionEntry = (DynamicObject)sectionEntryList.get(i);
                DynamicObjectCollection simulatesubentryList = sectionEntry.getDynamicObjectCollection("simulatesubentry");
                for (int j = 0; j < simulatesubentryList.size(); ++j) {
                    for (int z = 0; z < simulatenum; ++z) {
                        this.getModel().setValue("subsimulateexrate" + (z + 1), (Object)BigDecimal.ZERO, j, i);
                    }
                }
                this.getView().updateView("simulatesubentry");
            }
        } else {
            DynamicObjectCollection simulateEntry = this.getModel().getEntryEntity("simulateentry");
            if (!EmptyUtil.isEmpty((DynamicObjectCollection)simulateEntry)) {
                for (int i = 0; i < simulateEntry.size(); ++i) {
                    for (int j = 0; j < simulatenum; ++j) {
                        this.getModel().setValue("simulateexrate" + (j + 1), (Object)BigDecimal.ZERO, i);
                    }
                }
                this.getView().updateView("simulateentry");
            }
        }
    }

    private void onScenarioMethodChange() {
        Label simulatesubentrylabel;
        String sectionType = (String)this.getModel().getValue("sectiontype");
        String scenarioMethod = (String)this.getModel().getValue("scenariomethod");
        if (ExSectionTypeEnum.isMutilSection((String)sectionType)) {
            this.getView().getModel().deleteEntryData("sectionentry");
            simulatesubentrylabel = (Label)this.getControl("simulatesubentrylabel");
            simulatesubentrylabel.setText(null);
        }
        if (ExSectionTypeEnum.isNoSection((String)sectionType) || ExSectionTypeEnum.isSingleSection((String)sectionType)) {
            this.getModel().deleteEntryData("simulateentry");
            if (!ExScenarioMethodEnum.isDefine((String)scenarioMethod) && this.getModel().getEntryRowCount("simulateentry") == 0) {
                this.getModel().createNewEntryRow("simulateentry");
            }
            this.initSimulateNum();
            this.setSimulateColumn();
        }
        if (ExSectionTypeEnum.isMutilSection((String)sectionType)) {
            this.getView().getModel().deleteEntryData("sectionentry");
            simulatesubentrylabel = (Label)this.getControl("simulatesubentrylabel");
            simulatesubentrylabel.setText(null);
            this.initSimulateNum();
            this.setSimulateColumn();
        }
        if (!ExScenarioMethodEnum.isRank((String)scenarioMethod)) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"rankcount", (Object)0);
        }
        this.controlRankCount();
        this.setSimulateForm();
    }

    private void setSimulateForm() {
        this.getModel().setValue("simulateform", (Object)ExSimulateFormEnum.PERCENT.getValue());
    }

    private void onSectionTypeChange(String sectionTypeOldValue) {
        this.controlSectionValue();
        String sectionType = (String)this.getModel().getValue("sectiontype");
        if (ExSectionTypeEnum.isNoSection((String)sectionType)) {
            TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String[])new String[]{"sectionvalue"});
        }
        if ((ExSectionTypeEnum.isNoSection((String)sectionType) || ExSectionTypeEnum.isSingleSection((String)sectionType)) && !ExSectionTypeEnum.isNoSection((String)sectionTypeOldValue) && !ExSectionTypeEnum.isSingleSection((String)sectionTypeOldValue)) {
            this.getView().getModel().deleteEntryData("sectionentry");
            Label simulatesubentrylabel = (Label)this.getControl("simulatesubentrylabel");
            simulatesubentrylabel.setText(null);
            this.initSimulateNum();
            this.setSimulateColumn();
            String scenarioMethod = (String)this.getModel().getValue("scenariomethod");
            if (!ExScenarioMethodEnum.isDefine((String)scenarioMethod) && this.getModel().getEntryRowCount("simulateentry") == 0) {
                this.getModel().createNewEntryRow("simulateentry");
            }
        }
        if (ExSectionTypeEnum.isMutilSection((String)sectionType)) {
            TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String[])new String[]{"sectionvalue"});
            this.getModel().deleteEntryData("simulateentry");
            this.initSimulateNum();
            this.setSimulateColumn();
        }
    }

    private void addSimulateExRateBeforeDoOp(BeforeDoOperationEventArgs args, String operateKey) {
        boolean validate = this.validateAddSimulate(operateKey);
        if (!validate) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u591a\u53ef\u8bbe\u7f6e5\u4e2a\u6c47\u7387\u6a21\u62df\u60c5\u666f\u3002", (String)"ExScenarioSimulationEdit_6", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void buildSimulateBeforeDoOp(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection simulateEntryList = this.getModel().getEntryEntity("simulateentry");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)simulateEntryList)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fd8\u672a\u6dfb\u52a0\u5e01\u79cd\uff0c\u8bf7\u6dfb\u52a0\u3002", (String)"ExScenarioSimulationEdit_8", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void delSubSimulateCurrencyBeforeDoOp(BeforeDoOperationEventArgs args) {
        IDataModel model = this.getModel();
        int entryRowCount = model.getEntryRowCount("sectionentry");
        if (entryRowCount <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fd8\u672a\u6dfb\u52a0\u533a\u95f4\u6bb5\uff0c\u8bf7\u6dfb\u52a0\u3002", (String)"ExScenarioSimulationEdit_7", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        int rowIndex = this.getSelectEntryRowIndex("simulatesubentry");
        if (rowIndex < 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fd8\u672a\u9009\u62e9\u5220\u9664\u7684\u5e01\u79cd\uff0c\u8bf7\u9009\u62e9\u3002", (String)"ExScenarioSimulationEdit_16", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        EntryGrid sectionGrid = (EntryGrid)this.getControl("sectionentry");
        int[] selectRows = sectionGrid.getSelectRows();
        if (selectRows == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u655e\u53e3\u5e01\u79cd\u65f6\uff0c\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u5e01\u79cd\u6a21\u62df\u6c47\u7387\u3002", (String)"ExScenarioSimulationEdit_15", (String)"tmc-mrm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            args.setCancel(true);
        } else {
            DynamicObjectCollection subEntry = this.getCurrentSectionSubEntry(model, selectRows[0]);
            if (subEntry.size() == 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u655e\u53e3\u5e01\u79cd\u65f6\uff0c\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u5e01\u79cd\u6a21\u62df\u6c47\u7387\u3002", (String)"ExScenarioSimulationEdit_15", (String)"tmc-mrm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                args.setCancel(true);
            }
        }
    }

    private void delSimulateCurrencyBeforeDoOp(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("simulateentry");
        if (entryEntity.size() == 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u655e\u53e3\u5e01\u79cd\u65f6\uff0c\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u5e01\u79cd\u6a21\u62df\u6c47\u7387\u3002", (String)"ExScenarioSimulationEdit_15", (String)"tmc-mrm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            args.setCancel(true);
        }
    }

    private void addSubSimulateCurrencyBeforeDoOp(BeforeDoOperationEventArgs args) {
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (currency == null) {
            if (org != null) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5206\u6790\u4e3b\u4f53\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7684\u672c\u4f4d\u5e01\uff0c\u8bf7\u5148\u7ef4\u62a4\u672c\u4f4d\u5e01\u3002", (String)"ExScenarioSimulationEdit_11", (String)"tmc-mrm-formplugin", (Object[])new Object[0]), org.getString("name")));
                args.setCancel(true);
                return;
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u6790\u4e3b\u4f53\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u7ef4\u62a4\u5206\u6790\u4e3b\u4f53\u3002", (String)"ExScenarioSimulationEdit_12", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        int entryRowCount = this.getModel().getEntryRowCount("sectionentry");
        if (entryRowCount <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fd8\u672a\u6dfb\u52a0\u533a\u95f4\u6bb5\uff0c\u8bf7\u6dfb\u52a0\u3002", (String)"ExScenarioSimulationEdit_7", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void addSimulateCurrencyBeforeDoOp(BeforeDoOperationEventArgs args) {
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (currency == null) {
            if (org != null) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5206\u6790\u4e3b\u4f53\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7684\u672c\u4f4d\u5e01\uff0c\u8bf7\u5148\u7ef4\u62a4\u672c\u4f4d\u5e01\u3002", (String)"ExScenarioSimulationEdit_11", (String)"tmc-mrm-formplugin", (Object[])new Object[0]), org.getString("name")));
                args.setCancel(true);
                return;
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u6790\u4e3b\u4f53\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u7ef4\u62a4\u5206\u6790\u4e3b\u4f53\u3002", (String)"ExScenarioSimulationEdit_12", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        int entryRowCount = this.getModel().getEntryRowCount("simulateentry");
        if (entryRowCount >= 10) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u591a\u53ef\u81ea\u5b9a\u4e4910\u4e2a\u5e01\u79cd\u8fdb\u884c\u6c47\u7387\u6a21\u62df\u3002", (String)"ExScenarioSimulationEdit_13", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void delSubSimulateExRateBeforeDoOp(BeforeDoOperationEventArgs args) {
        String simulateSubEntryColumnIndexStr = this.getPageCache().get(KEY_SIMULATESUBENTRY_COLUMN_INDEX);
        if (EmptyUtil.isEmpty((String)simulateSubEntryColumnIndexStr)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fd8\u672a\u9009\u62e9\u5220\u9664\u7684\u6a21\u62df\u6c47\u7387\uff0c\u8bf7\u9009\u62e9\u3002", (String)"ExScenarioSimulationEdit_9", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        int simulatenum = (Integer)this.getModel().getValue("simulatenum");
        if (simulatenum <= 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u4fdd\u7559\u4e00\u5217\u6a21\u62df\u6c47\u7387\u3002", (String)"ExScenarioSimulationEdit_10", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void delSimulateExRateBeforeDoOp(BeforeDoOperationEventArgs args) {
        String simulateEntryColumnIndexStr = this.getPageCache().get(KEY_SIMULATEENTRY_COLUMN_INDEX);
        if (EmptyUtil.isEmpty((String)simulateEntryColumnIndexStr)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fd8\u672a\u9009\u62e9\u5220\u9664\u7684\u6a21\u62df\u6c47\u7387\uff0c\u8bf7\u9009\u62e9\u3002", (String)"ExScenarioSimulationEdit_9", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        int simulatenum = (Integer)this.getModel().getValue("simulatenum");
        if (simulatenum <= 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u4fdd\u7559\u4e00\u5217\u6a21\u62df\u6c47\u7387\u3002", (String)"ExScenarioSimulationEdit_10", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void buildSubSimulateBeforeDoOp(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("sectionentry");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)entryEntity)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fd8\u672a\u6dfb\u52a0\u533a\u95f4\u6bb5\uff0c\u8bf7\u6dfb\u52a0\u3002", (String)"ExScenarioSimulationEdit_7", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        } else {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(0);
            DynamicObjectCollection simulatesubentryList = dynamicObject.getDynamicObjectCollection("simulatesubentry");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)simulatesubentryList)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fd8\u672a\u6dfb\u52a0\u5e01\u79cd\uff0c\u8bf7\u6dfb\u52a0\u3002", (String)"ExScenarioSimulationEdit_8", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    private void delSubSimulateCurrencyAfterDoOp() {
        int index = this.getSelectEntryRowIndex("simulatesubentry");
        DynamicObjectCollection sectionEntryList = this.getModel().getEntryEntity("sectionentry");
        for (DynamicObject sectionEntry : sectionEntryList) {
            DynamicObjectCollection dynamicObjectCollection = sectionEntry.getDynamicObjectCollection("simulatesubentry");
            dynamicObjectCollection.remove(index);
        }
        this.getView().updateView("simulatesubentry");
    }

    private void addSimulateCurrencyAfterDoOp(AfterDoOperationEventArgs e) {
        if (e.getOperationResult().isSuccess()) {
            ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"bd_currency", (boolean)true);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "simulatecurrency"));
            showParameter.setShowTitle(false);
            QFilter qFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
            DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity("simulateentry");
            List simulatecurrencys = dynamicObjectCollection.stream().filter(a -> a.getDynamicObject("simulatecurrency") != null).map(d -> d.getDynamicObject("simulatecurrency").getLong("id")).collect(Collectors.toList());
            ArrayList currIds = new ArrayList(simulatecurrencys);
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
            currIds.add(currency.getLong("id"));
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "not in", currIds));
            showParameter.getListFilterParameter().getQFilters().add(qFilter);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private void addSubsimulateCurrencyAfterDoOp(AfterDoOperationEventArgs e) {
        if (e.getOperationResult().isSuccess()) {
            ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"bd_currency", (boolean)true);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "subsimulatecurrency"));
            showParameter.setShowTitle(false);
            QFilter qFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
            IDataModel entryOperate = this.getModel();
            DynamicObject entryRowEntity = entryOperate.getEntryRowEntity("sectionentry", 0);
            DynamicObjectCollection dynamicObjectCollection = entryRowEntity.getDynamicObjectCollection("simulatesubentry");
            List simulatecurrencys = dynamicObjectCollection.stream().filter(a -> a.getDynamicObject("subsimulatecurrency") != null).map(d -> d.getDynamicObject("subsimulatecurrency").getLong("id")).collect(Collectors.toList());
            ArrayList currIds = new ArrayList(simulatecurrencys);
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
            currIds.add(currency.getLong("id"));
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "not in", currIds));
            showParameter.getListFilterParameter().getQFilters().add(qFilter);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private void delSimulateExRateAfterDoOp(AfterDoOperationEventArgs e) {
        if (e.getOperationResult().isSuccess()) {
            String operateKey = e.getOperateKey();
            int index = Integer.parseInt(this.getPageCache().get(KEY_SIMULATEENTRY_COLUMN_INDEX));
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u786e\u8ba4\u8981\u5220\u9664\u6a21\u62df\u6c47\u7387%s\uff1f", (String)"ExScenarioSimulationEdit_17", (String)"tmc-mrm-formplugin", (Object[])new Object[0]), index), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(operateKey, (IFormPlugin)this));
        }
    }

    private void delSubsimulateExRateAfterDoOp(AfterDoOperationEventArgs e) {
        if (e.getOperationResult().isSuccess()) {
            String operateKey = e.getOperateKey();
            int index = Integer.parseInt(this.getPageCache().get(KEY_SIMULATESUBENTRY_COLUMN_INDEX));
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u786e\u8ba4\u8981\u5220\u9664\u6a21\u62df\u6c47\u7387%s\uff1f", (String)"ExScenarioSimulationEdit_17", (String)"tmc-mrm-formplugin", (Object[])new Object[0]), index), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(operateKey, (IFormPlugin)this));
        }
    }

    private void openSimulateTestPage() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("mrm_ex_scenario_sim_test");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        formShowParameter.setCustomParam("scenarioSimulationData", (Object)this.getJsonStr(dataEntity));
        this.getView().showForm(formShowParameter);
    }

    public String getJsonStr(DynamicObject dynamicObject) {
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        option.setIncludeComplexProperty(true);
        MainEntityType subMainType = EntityMetadataCache.getDataEntityType((String)"mrm_ex_scenario_sim");
        return DynamicObjectSerializeUtil.serialize((Object[])new DynamicObject[]{dynamicObject}, (DynamicObjectType)subMainType);
    }

    private void buildSubSimulateExRate() {
        String scenarioMethod = (String)this.getModel().getValue("scenariomethod");
        if (!ExScenarioMethodEnum.isDefine((String)scenarioMethod)) {
            DynamicObjectCollection sectionentryList = this.getModel().getEntryEntity("sectionentry");
            for (int i = 0; i < sectionentryList.size(); ++i) {
                DynamicObject sectionEntry = (DynamicObject)sectionentryList.get(i);
                DynamicObjectCollection simulatesubentryList = sectionEntry.getDynamicObjectCollection("simulatesubentry");
                if (!EmptyUtil.isEmpty((DynamicObjectCollection)simulatesubentryList)) continue;
                simulatesubentryList.add(0, (DynamicObject)simulatesubentryList.getDynamicObjectType().createInstance());
                this.getModel().setValue("subkeyfield", (Object)"1", 0, i);
            }
        }
        EntryGrid sectionentry = (EntryGrid)this.getControl("sectionentry");
        sectionentry.selectRows(0);
        this.setSimulateSubEntryLabel(0);
        this.getView().updateView("simulatesubentry");
    }

    private boolean validateAddSimulate(String opAddsimulateexrate) {
        if ("addsimulateexrate".equals(opAddsimulateexrate) || "addsubsimulateexrate".equals(opAddsimulateexrate)) {
            int subsimulatenum = (Integer)this.getModel().getValue("simulatenum");
            return subsimulatenum < 5;
        }
        return true;
    }

    private void delSimulateExrate(String operateKey) {
        if ("delsimulateexrate".equals(operateKey)) {
            String simulateentryColumnIndexStr = this.getPageCache().get(KEY_SIMULATEENTRY_COLUMN_INDEX);
            int simulateentryColumnIndex = Integer.parseInt(simulateentryColumnIndexStr);
            int simulatenum = (Integer)this.getModel().getValue("simulatenum");
            EntryGrid simulateentry = (EntryGrid)this.getControl("simulateentry");
            simulateentry.setColumnProperty("simulateexrate" + simulatenum, "visible", (Object)false);
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"simulatenum", (Object)(simulatenum - 1));
            DynamicObjectCollection simulateentryList = this.getModel().getEntryEntity("simulateentry");
            for (DynamicObject dynamicObject : simulateentryList) {
                for (int i = simulateentryColumnIndex; i < simulatenum; ++i) {
                    dynamicObject.set("simulateexrate" + i, dynamicObject.get("simulateexrate" + (i + 1)));
                }
                dynamicObject.set("simulateexrate" + simulatenum, (Object)0);
            }
            this.getPageCache().remove(KEY_SIMULATEENTRY_COLUMN_INDEX);
            this.getView().updateView("simulateentry");
        }
        if ("delsubsimulateexrate".equals(operateKey)) {
            String subsimulateentryColumnIndexStr = this.getPageCache().get(KEY_SIMULATESUBENTRY_COLUMN_INDEX);
            int subsimulateentryColumnIndex = Integer.parseInt(subsimulateentryColumnIndexStr);
            int subsimulatenum = (Integer)this.getModel().getValue("simulatenum");
            EntryGrid subsimulateentry = (EntryGrid)this.getControl("simulatesubentry");
            subsimulateentry.setColumnProperty("subsimulateexrate" + subsimulatenum, "visible", (Object)false);
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"simulatenum", (Object)(subsimulatenum - 1));
            DynamicObjectCollection sectionList = this.getModel().getEntryEntity("sectionentry");
            for (DynamicObject section : sectionList) {
                DynamicObjectCollection simulateentryList = section.getDynamicObjectCollection("simulatesubentry");
                for (DynamicObject dynamicObject : simulateentryList) {
                    for (int i = subsimulateentryColumnIndex; i < subsimulatenum; ++i) {
                        dynamicObject.set("subsimulateexrate" + i, dynamicObject.get("subsimulateexrate" + (i + 1)));
                    }
                    dynamicObject.set("subsimulateexrate" + subsimulatenum, (Object)0);
                }
            }
            this.getPageCache().remove(KEY_SIMULATESUBENTRY_COLUMN_INDEX);
            this.getView().updateView("simulatesubentry");
        }
    }

    private void addSimulateExrateAfterDoOp(AfterDoOperationEventArgs e) {
        if (e.getOperationResult().isSuccess()) {
            String opBuildsimulate = e.getOperateKey();
            if ("addsimulateexrate".equals(opBuildsimulate)) {
                int simulatenum = (Integer)this.getModel().getValue("simulatenum");
                EntryGrid simulateentry = (EntryGrid)this.getControl("simulateentry");
                simulateentry.setColumnProperty("simulateexrate" + (simulatenum + 1), "visible", (Object)true);
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"simulatenum", (Object)(simulatenum + 1));
                this.getView().updateView("simulateentry");
            }
            if ("addsubsimulateexrate".equals(opBuildsimulate)) {
                int subsimulatenum = (Integer)this.getModel().getValue("simulatenum");
                EntryGrid subsimulateentry = (EntryGrid)this.getControl("simulatesubentry");
                subsimulateentry.setColumnProperty("subsimulateexrate" + (subsimulatenum + 1), "visible", (Object)true);
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"simulatenum", (Object)(subsimulatenum + 1));
            }
        }
    }

    private void buildsimulateAfterDoOp(AfterDoOperationEventArgs e) {
        if (e.getOperationResult().isSuccess()) {
            String operateKey = e.getOperateKey();
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("mrm_ex_scenario_sim_build");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setStatus(OperationStatus.ADDNEW);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, operateKey));
            this.getView().showForm(formShowParameter);
        }
    }

    private void checkSectionseValueFormat(String oldValue) {
        String term = (String)this.getModel().getValue("sectionvalue");
        boolean rightFormat = ExScenarioSimulationEdit.isRightFormat(this.getView(), term);
        if (!rightFormat) {
            this.getModel().setValue("sectionvalue", (Object)oldValue);
        }
    }

    public static boolean isRightFormat(IFormView view, String value) {
        Matcher matcher = TermHelper.getMatcher((String)value);
        if (!matcher.matches()) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u6c47\u7387\u6ce2\u52a8\u533a\u95f4\u9700\u6309\u7167**y**m**d\u683c\u5f0f\u5f55\u5165\u3002", (String)"ExScenarioSimulationEdit_1", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private int getSelectEntryRowIndex(String entryName) {
        int[] selectRows = ((EntryGrid)this.getControl(entryName)).getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            return -1;
        }
        return selectRows[0];
    }
}

