/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.formplugin.exscenariosimulation;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeBasedataSetValueEvent;
import kd.bos.form.field.events.BeforeBasedataSetValueListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeF7ViewDetailEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.helper.service.MarketDataServiceHelper;
import kd.tmc.fbp.common.model.ForexQuoteInfo;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mrm.common.enums.ExScenarioMethodEnum;
import kd.tmc.mrm.common.enums.ExSectionTypeEnum;
import kd.tmc.mrm.common.enums.ExSimulateFormEnum;

public class ExScenarioSimulationTestEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener,
RowClickEventListener,
BeforeBasedataSetValueListener {
    public static final String FOREXPRICE = "forexprice";
    public static final String TESTCURRENCY = "testcurrency";
    public static final String EXRATE = "exrate";
    public static final String SUBEXRATE = "subexrate";
    public static String SKIP_SCENARIO_PROPERTY_CHANGED_EVENT = "skip_scenario_property_changed_event";
    private final List<BigDecimal> musimulateExRateList = new ArrayList<BigDecimal>(5);
    private final List<List<BigDecimal>> subMusimulateExRateList = new ArrayList<List<BigDecimal>>(10);

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.fillData();
        this.setSimulateColumn();
        this.setSimulateSubEntryLabel(0);
        this.setSimulateEntryLabel();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.selectSectionFirstRow();
    }

    public void registerListener(EventObject e) {
        BasedataEdit currency = (BasedataEdit)this.getView().getControl("currency");
        currency.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit testCurrency = (BasedataEdit)this.getView().getControl(TESTCURRENCY);
        testCurrency.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        testCurrency.addBeforeBasedataSetValueListener((BeforeBasedataSetValueListener)this);
        testCurrency.setBatchFirePropChanged(false);
        EntryGrid sectionentry = (EntryGrid)this.getView().getControl("sectionentry");
        sectionentry.addRowClickListener((RowClickEventListener)this);
        BasedataEdit forexquote = (BasedataEdit)this.getView().getControl(FOREXPRICE);
        Optional.ofNullable(forexquote).ifPresent(c -> c.addBeforeF7ViewDetailListener(this::beforeF7ViewDetail));
        Optional.ofNullable(forexquote).ifPresent(c -> c.addBeforeBasedataSetValueListener((BeforeBasedataSetValueListener)this));
    }

    private void selectSectionFirstRow() {
        int entryRowCount = this.getModel().getEntryRowCount("sectionentry");
        if (entryRowCount > 0) {
            EntryGrid sectionentry = (EntryGrid)this.getControl("sectionentry");
            sectionentry.selectRows(0);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        int index = evt.getRow();
        if (index >= 0 && StringUtils.equals((CharSequence)"sectionentry", (CharSequence)entryGrid.getKey())) {
            this.setSimulateSubEntryLabel(index);
        }
    }

    private void beforeF7ViewDetail(BeforeF7ViewDetailEvent event) {
        Object pkId = event.getPkId();
        BasedataEdit source = (BasedataEdit)event.getSource();
        String key = source.getKey();
        if (FOREXPRICE.equals(key)) {
            event.setCancel(true);
            BillShowParameter billShowParameter = new BillShowParameter();
            String formid = "md_forexquote";
            billShowParameter.setFormId(formid);
            billShowParameter.setPkId(pkId);
            billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            billShowParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)billShowParameter);
        }
    }

    private void setSimulateSubEntryLabel(int index) {
        DynamicObject entryRowEntity;
        if (index >= 0 && (entryRowEntity = this.getModel().getEntryRowEntity("sectionentry", index)) != null) {
            String sectiondesc = entryRowEntity.getString("sectiondesc");
            Label simulatesubentrylabel = (Label)this.getControl("simulatesubentrylabel");
            simulatesubentrylabel.setText(String.format(ResManager.loadKDString((String)"\u533a\u95f4\u6bb5%s\u6c47\u7387\u6a21\u62df\u6d4b\u8bd5\uff1a", (String)"ExScenarioSimulationTestEdit_1", (String)"tmc-mrm-formplugin", (Object[])new Object[0]), sectiondesc));
        }
    }

    private void setSimulateEntryLabel() {
        Label simulateEntrylabel = (Label)this.getControl("simulateentrylabel");
        simulateEntrylabel.setText(ResManager.loadKDString((String)"\u6c47\u7387\u6a21\u62df\u6d4b\u8bd5\uff1a", (String)"ExScenarioSimulationTestEdit_2", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String property = evt.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        switch (property) {
            case "testcurrency": {
                showParameter.setMultiSelect(true);
                String sectionType = (String)this.getModel().getValue("sectiontype");
                if (ExSectionTypeEnum.isMutilSection((String)sectionType)) {
                    DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
                    EntryGrid sectionEntryGrid = (EntryGrid)this.getControl("sectionentry");
                    int[] selectRows = sectionEntryGrid.getSelectRows();
                    if (selectRows == null || selectRows.length <= 0) break;
                    ArrayList<Long> currIds = new ArrayList<Long>(1);
                    if (currency == null) {
                        if (org != null) {
                            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5206\u6790\u4e3b\u4f53\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7684\u672c\u4f4d\u5e01\uff0c\u8bf7\u5148\u7ef4\u62a4\u672c\u4f4d\u5e01\u3002", (String)"ExScenarioSimulationEdit_11", (String)"tmc-mrm-formplugin", (Object[])new Object[0]), org.getString("name")));
                            evt.setCancel(true);
                            return;
                        }
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u6790\u4e3b\u4f53\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u7ef4\u62a4\u5206\u6790\u4e3b\u4f53\u3002", (String)"ExScenarioSimulationEdit_12", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
                        evt.setCancel(true);
                        return;
                    }
                    currIds.add(currency.getLong("id"));
                    showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "not in", currIds));
                    break;
                }
                DynamicObject curr = (DynamicObject)this.getModel().getValue("currency");
                ArrayList<Long> currIdList = new ArrayList<Long>(1);
                if (curr == null) {
                    if (org != null) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5206\u6790\u4e3b\u4f53\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7684\u672c\u4f4d\u5e01\uff0c\u8bf7\u5148\u7ef4\u62a4\u672c\u4f4d\u5e01\u3002", (String)"ExScenarioSimulationEdit_11", (String)"tmc-mrm-formplugin", (Object[])new Object[0]), org.getString("name")));
                        evt.setCancel(true);
                        return;
                    }
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u6790\u4e3b\u4f53\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u7ef4\u62a4\u5206\u6790\u4e3b\u4f53\u3002", (String)"ExScenarioSimulationEdit_12", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                currIdList.add(curr.getLong("id"));
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "not in", currIdList));
                break;
            }
        }
    }

    private Map<Long, BigDecimal> getForexPriceExRate(List<DynamicObject> currencyList) {
        HashMap<Long, BigDecimal> map = new HashMap<Long, BigDecimal>(currencyList.size() * 2);
        if (!EmptyUtil.isEmpty(currencyList)) {
            DynamicObject forexPrice = (DynamicObject)this.getModel().getValue(FOREXPRICE);
            DynamicObject localCurrency = (DynamicObject)this.getModel().getValue("currency");
            LinkedHashSet<String> tipPairs = new LinkedHashSet<String>(16);
            if (localCurrency != null) {
                String currencyNumber = localCurrency.getString("number");
                for (DynamicObject currency : currencyList) {
                    BigDecimal exRate = BigDecimal.ZERO;
                    if (forexPrice != null) {
                        String simulateCurrencyNumber = currency.getString("number");
                        String pair = simulateCurrencyNumber + "/" + currencyNumber;
                        ForexQuoteInfo fQuoteInfo = MarketDataServiceHelper.getForexQuoteInfoWithoutThrow((Long)((Long)forexPrice.getPkValue()), (String)pair, null, null);
                        if (fQuoteInfo == null) {
                            tipPairs.add(pair);
                        } else {
                            exRate = pair.equals(fQuoteInfo.getFxquote()) ? fQuoteInfo.getBuyPrice() : BigDecimal.ONE.divide(fQuoteInfo.getSellPrice(), 19, RoundingMode.HALF_UP);
                        }
                    }
                    map.put(currency.getLong("id"), exRate);
                }
                if (forexPrice != null && !EmptyUtil.isEmpty(tipPairs)) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8d27\u5e01\u5bf9\u201c%1$s\u201d\u5728\u5916\u6c47\u62a5\u4ef7\u201c%2$s\u201d\u4e2d\u672a\u8bbe\u7f6e\u62a5\u4ef7\u65b9\u5f0f\uff0c\u8bf7\u8bbe\u7f6e\u62a5\u4ef7\u65b9\u5f0f\u6765\u83b7\u53d6\u5f53\u524d\u6c47\u7387\u3002", (String)"ExScenarioSimulationTestEdit_0", (String)"tmc-mrm-formplugin", (Object[])new Object[0]), String.join((CharSequence)"\u3001", tipPairs), forexPrice.getString("number")));
                }
            }
        }
        return map;
    }

    private List<DynamicObject> toCurrencyList(DynamicObjectCollection testCurrList) {
        ArrayList<DynamicObject> currencyList = new ArrayList<DynamicObject>(testCurrList.size());
        for (DynamicObject testCurr : testCurrList) {
            currencyList.add(testCurr.getDynamicObject("fbasedataid"));
        }
        return currencyList;
    }

    private void fillData() {
        block11: {
            DynamicObject scenarioSimulationData;
            this.musimulateExRateList.clear();
            this.subMusimulateExRateList.clear();
            String data = (String)this.getView().getFormShowParameter().getCustomParam("scenarioSimulationData");
            if (EmptyUtil.isEmpty((String)data) || (scenarioSimulationData = this.toDynamicObjectByJsonStr(data)) == null) break block11;
            String scenarioMethod = (String)scenarioSimulationData.get("scenariomethod");
            String sectionType = (String)scenarioSimulationData.get("sectiontype");
            String simulateForm = (String)scenarioSimulationData.get("simulateform");
            int simulatenum = (Integer)scenarioSimulationData.get("simulatenum");
            DynamicObject currency = (DynamicObject)scenarioSimulationData.get("currency");
            DynamicObject org = (DynamicObject)scenarioSimulationData.get("org");
            boolean isValueSimulateFormEnum = ExSimulateFormEnum.isValue((String)simulateForm);
            this.getModel().setValue("scenariomethod", (Object)scenarioMethod);
            this.getModel().setValue("sectiontype", (Object)sectionType);
            this.getModel().setValue("simulateform", (Object)simulateForm);
            this.getModel().setValue("simulatenum", (Object)simulatenum);
            this.getModel().setValue("currency", (Object)currency);
            this.getModel().setValue("org", (Object)org);
            if (ExSectionTypeEnum.isMutilSection((String)sectionType)) {
                DynamicObjectCollection sectionEntryList = scenarioSimulationData.getDynamicObjectCollection("sectionentry");
                for (int i = 0; i < sectionEntryList.size(); ++i) {
                    DynamicObject sectionEntry = (DynamicObject)sectionEntryList.get(i);
                    int newEntryRow = this.getModel().createNewEntryRow("sectionentry");
                    this.getModel().setValue("sectiondesc", sectionEntry.get("sectiondesc"), newEntryRow);
                    this.getModel().setValue("left", sectionEntry.get("left"), newEntryRow);
                    this.getModel().setValue("unit", sectionEntry.get("unit"), newEntryRow);
                    this.getModel().setValue("iscontains", sectionEntry.get("iscontains"), newEntryRow);
                    boolean define = ExScenarioMethodEnum.isDefine((String)scenarioMethod);
                    ArrayList<BigDecimal> list = new ArrayList<BigDecimal>(5);
                    DynamicObjectCollection simulatesubentryList = sectionEntry.getDynamicObjectCollection("simulatesubentry");
                    DynamicObject newSectionEntry = this.getModel().getEntryRowEntity("sectionentry", i);
                    DynamicObjectCollection newSimulatesubentryList = newSectionEntry.getDynamicObjectCollection("simulatesubentry");
                    for (int j = 0; j < simulatesubentryList.size(); ++j) {
                        DynamicObject dynamicObject = (DynamicObject)simulatesubentryList.get(j);
                        newSimulatesubentryList.addNew();
                        this.getModel().setValue("subsimulatecurrency", dynamicObject.get("subsimulatecurrency"), j, i);
                        for (int z = 0; z < 5; ++z) {
                            BigDecimal subSimulateExRate = (BigDecimal)dynamicObject.get("subsimulateexrate" + (z + 1));
                            if (!define) {
                                list.add(subSimulateExRate);
                            }
                            if (isValueSimulateFormEnum) {
                                this.getModel().setValue("subsimulateexrate" + (z + 1), (Object)subSimulateExRate, j, i);
                            }
                            this.getModel().setValue("subsimulateexrate" + (z + 1) + "_ori", (Object)subSimulateExRate, j, i);
                        }
                        this.subMusimulateExRateList.add(list);
                    }
                }
            } else {
                DynamicObjectCollection simulateentryList = scenarioSimulationData.getDynamicObjectCollection("simulateentry");
                boolean define = ExScenarioMethodEnum.isDefine((String)scenarioMethod);
                for (DynamicObject dynamicObject : simulateentryList) {
                    int newEntryRow = this.getModel().createNewEntryRow("simulateentry");
                    this.getModel().setValue("simulatecurrency", dynamicObject.get("simulatecurrency"), newEntryRow);
                    for (int i = 0; i < 5; ++i) {
                        BigDecimal simulateexrate = dynamicObject.getBigDecimal("simulateexrate" + (i + 1));
                        if (!define) {
                            this.musimulateExRateList.add(simulateexrate);
                        }
                        if (isValueSimulateFormEnum) {
                            this.getModel().setValue("simulateexrate" + (i + 1), (Object)simulateexrate, newEntryRow);
                        }
                        this.getModel().setValue("simulateexrate" + (i + 1) + "_ori", (Object)simulateexrate, newEntryRow);
                    }
                }
            }
        }
    }

    private void initSimulateExrateList() {
        block7: {
            DynamicObject scenarioSimulationData;
            this.musimulateExRateList.clear();
            this.subMusimulateExRateList.clear();
            String data = (String)this.getView().getFormShowParameter().getCustomParam("scenarioSimulationData");
            if (EmptyUtil.isEmpty((String)data) || (scenarioSimulationData = this.toDynamicObjectByJsonStr(data)) == null) break block7;
            String scenarioMethod = (String)scenarioSimulationData.get("scenariomethod");
            String sectionType = (String)scenarioSimulationData.get("sectiontype");
            if (ExSectionTypeEnum.isMutilSection((String)sectionType)) {
                DynamicObjectCollection sectionEntryList = scenarioSimulationData.getDynamicObjectCollection("sectionentry");
                for (int i = 0; i < sectionEntryList.size(); ++i) {
                    DynamicObject sectionEntry = (DynamicObject)sectionEntryList.get(i);
                    boolean define = ExScenarioMethodEnum.isDefine((String)scenarioMethod);
                    ArrayList<BigDecimal> list = new ArrayList<BigDecimal>(5);
                    DynamicObjectCollection simulatesubentryList = sectionEntry.getDynamicObjectCollection("simulatesubentry");
                    for (int j = 0; j < simulatesubentryList.size(); ++j) {
                        DynamicObject dynamicObject = (DynamicObject)simulatesubentryList.get(j);
                        for (int z = 0; z < 5; ++z) {
                            BigDecimal subSimulateExRate = (BigDecimal)dynamicObject.get("subsimulateexrate" + (z + 1));
                            if (define) continue;
                            list.add(subSimulateExRate);
                        }
                        this.subMusimulateExRateList.add(list);
                    }
                }
            } else {
                DynamicObjectCollection simulateentryList = scenarioSimulationData.getDynamicObjectCollection("simulateentry");
                boolean define = ExScenarioMethodEnum.isDefine((String)scenarioMethod);
                for (DynamicObject dynamicObject : simulateentryList) {
                    for (int i = 0; i < 5; ++i) {
                        BigDecimal simulateexrate = dynamicObject.getBigDecimal("simulateexrate" + (i + 1));
                        if (define) continue;
                        this.musimulateExRateList.add(simulateexrate);
                    }
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        switch (propertyName) {
            case "exrate": {
                this.onExrateChange((BigDecimal)changeData[0].getNewValue());
                break;
            }
            case "subexrate": {
                this.onSubExrateChange((BigDecimal)changeData[0].getNewValue());
                break;
            }
            case "forexprice": {
                this.onForexPriceChange((DynamicObject)changeData[0].getNewValue());
                break;
            }
            case "testcurrency": {
                this.onTestCurrChange((DynamicObjectCollection)changeData[0].getNewValue(), (DynamicObjectCollection)changeData[0].getOldValue());
            }
        }
    }

    private void onTestCurrChange(DynamicObjectCollection testCurrencyList, DynamicObjectCollection oldTestCurrencyList) {
        String traceId = RequestContext.get().getTraceId();
        if (SKIP_SCENARIO_PROPERTY_CHANGED_EVENT.equals(this.getView().getPageCache().get(traceId))) {
            return;
        }
        this.getView().getPageCache().put(traceId, SKIP_SCENARIO_PROPERTY_CHANGED_EVENT);
        this.initSimulateExrateList();
        String scenarioMethod = (String)this.getModel().getValue("scenariomethod");
        String sectionType = (String)this.getModel().getValue("sectiontype");
        String simulateForm = (String)this.getModel().getValue("simulateform");
        boolean define = ExScenarioMethodEnum.isDefine((String)scenarioMethod);
        boolean percent = ExSimulateFormEnum.isPercent((String)simulateForm);
        if (ExSectionTypeEnum.isMutilSection((String)sectionType)) {
            if (testCurrencyList.size() == 0) {
                DynamicObjectCollection sectionEntryList = this.getModel().getEntryEntity("sectionentry");
                IDataModel model = this.getModel();
                for (int i = 0; i < sectionEntryList.size(); ++i) {
                    model.setEntryCurrentRowIndex("sectionentry", i);
                    model.deleteEntryData("simulatesubentry");
                }
                this.getView().updateView("simulatesubentry");
                return;
            }
            if (testCurrencyList.size() > 10) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)TESTCURRENCY, (Object)oldTestCurrencyList);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u591a\u53ef\u81ea\u5b9a\u4e4910\u4e2a\u5e01\u79cd\u8fdb\u884c\u6c47\u7387\u6a21\u62df\u3002", (String)"ExScenarioSimulationEdit_13", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
                return;
            }
            List<DynamicObject> currencyList = this.toCurrencyList(testCurrencyList);
            Map<Long, BigDecimal> exRateMap = this.getForexPriceExRate(currencyList);
            DynamicObjectCollection sectionEntryList = this.getModel().getEntryEntity("sectionentry");
            this.getModel().beginInit();
            for (int i = 0; i < sectionEntryList.size(); ++i) {
                List<BigDecimal> list = this.subMusimulateExRateList.get(i);
                DynamicObject sectionEntry = (DynamicObject)sectionEntryList.get(i);
                DynamicObjectCollection dynamicObjectCollection = sectionEntry.getDynamicObjectCollection("simulatesubentry");
                dynamicObjectCollection.clear();
                for (int j = 0; j < currencyList.size(); ++j) {
                    DynamicObject testCurr = currencyList.get(j);
                    dynamicObjectCollection.add(j, (DynamicObject)dynamicObjectCollection.getDynamicObjectType().createInstance());
                    this.getModel().setValue("subsimulatecurrency", testCurr.getPkValue(), j, i);
                    int simulatenum = (Integer)this.getModel().getValue("simulatenum");
                    BigDecimal exrate = exRateMap.get(testCurr.getLong("id"));
                    this.getModel().setValue(SUBEXRATE, (Object)exrate, j, i);
                    if (!percent) continue;
                    for (int z = 0; z < simulatenum; ++z) {
                        if (!define) {
                            this.getModel().setValue("subsimulateexrate" + (z + 1), (Object)exrate.multiply(BigDecimal.ONE.add(list.get(z).divide(BigDecimal.valueOf(100L), RoundingMode.HALF_UP))), j, i);
                            continue;
                        }
                        BigDecimal subSimulateexRate = (BigDecimal)this.getModel().getValue("simulateexrate" + (j + 1) + "_ori", i);
                        if (subSimulateexRate == null) {
                            subSimulateexRate = BigDecimal.ZERO;
                        }
                        this.getModel().setValue("subsimulateexrate" + (z + 1), (Object)exrate.multiply(BigDecimal.ONE.add(subSimulateexRate.divide(BigDecimal.valueOf(100L), RoundingMode.HALF_UP))), j, i);
                    }
                }
            }
            this.getModel().endInit();
            this.getView().updateView("simulatesubentry");
        } else {
            if (testCurrencyList.size() == 0) {
                this.getModel().deleteEntryData("simulateentry");
                return;
            }
            if (testCurrencyList.size() > 10) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)TESTCURRENCY, (Object)oldTestCurrencyList);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u591a\u53ef\u81ea\u5b9a\u4e4910\u4e2a\u5e01\u79cd\u8fdb\u884c\u6c47\u7387\u6a21\u62df\u3002", (String)"ExScenarioSimulationEdit_13", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
                return;
            }
            List<DynamicObject> currencyList = this.toCurrencyList(testCurrencyList);
            Map<Long, BigDecimal> exRateMap = this.getForexPriceExRate(currencyList);
            DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity("simulateentry");
            this.getModel().deleteEntryData("simulateentry");
            dynamicObjectCollection.clear();
            this.getModel().beginInit();
            for (int g = 0; g < currencyList.size(); ++g) {
                DynamicObject testCurr = currencyList.get(g);
                DynamicObject instance = (DynamicObject)dynamicObjectCollection.getDynamicObjectType().createInstance();
                this.getModel().createNewEntryRow("simulateentry", g, instance);
                this.getModel().setValue("simulatecurrency", testCurr.getPkValue(), g);
                int simulatenum = (Integer)this.getModel().getValue("simulatenum");
                BigDecimal exrate = exRateMap.get(testCurr.getLong("id"));
                this.getModel().setValue(EXRATE, (Object)exrate, g);
                if (!percent) continue;
                for (int i = 0; i < simulatenum; ++i) {
                    if (!define) {
                        this.getModel().setValue("simulateexrate" + (i + 1), (Object)exrate.multiply(BigDecimal.ONE.add(this.musimulateExRateList.get(i).divide(BigDecimal.valueOf(100L), RoundingMode.HALF_UP))), g);
                        continue;
                    }
                    BigDecimal simulateexRate = (BigDecimal)this.getModel().getValue("simulateexrate" + (i + 1) + "_ori", g);
                    if (simulateexRate == null) {
                        simulateexRate = BigDecimal.ZERO;
                    }
                    this.getModel().setValue("simulateexrate" + (i + 1), (Object)exrate.multiply(BigDecimal.ONE.add(simulateexRate.divide(BigDecimal.valueOf(100L), RoundingMode.HALF_UP))), g);
                }
            }
            this.getModel().endInit();
            this.getView().updateView("simulateentry");
        }
    }

    private void onForexPriceChange(DynamicObject newForexPrice) {
        this.initSimulateExrateList();
        String sectionType = (String)this.getModel().getValue("sectiontype");
        String scenarioMethod = (String)this.getModel().getValue("scenariomethod");
        String simulateForm = (String)this.getModel().getValue("simulateform");
        int simulatenum = (Integer)this.getModel().getValue("simulatenum");
        boolean define = ExScenarioMethodEnum.isDefine((String)scenarioMethod);
        boolean percent = ExSimulateFormEnum.isPercent((String)simulateForm);
        DynamicObjectCollection testCurrency = (DynamicObjectCollection)this.getModel().getValue(TESTCURRENCY);
        if (!define && EmptyUtil.isEmpty((DynamicObjectCollection)testCurrency)) {
            return;
        }
        if (newForexPrice != null) {
            if (ExSectionTypeEnum.isMutilSection((String)sectionType)) {
                DynamicObjectCollection sectionEntryList = this.getModel().getEntryEntity("sectionentry");
                Map<Object, Object> forexPriceExRate = new HashMap(16);
                if (!ExScenarioMethodEnum.isDefine((String)scenarioMethod)) {
                    List<DynamicObject> testCurrencyList = testCurrency.stream().map(a -> a.getDynamicObject("fbasedataid")).collect(Collectors.toList());
                    forexPriceExRate = this.getForexPriceExRate(testCurrencyList);
                }
                for (int i = 0; i < sectionEntryList.size(); ++i) {
                    List<BigDecimal> list = this.subMusimulateExRateList.get(i);
                    DynamicObject sectionEntry = (DynamicObject)sectionEntryList.get(i);
                    DynamicObjectCollection simulateSubEntryList = sectionEntry.getDynamicObjectCollection("simulatesubentry");
                    if (i == 0 && ExScenarioMethodEnum.isDefine((String)scenarioMethod)) {
                        List<DynamicObject> subsimulatecurrency = simulateSubEntryList.stream().map(a -> a.getDynamicObject("subsimulatecurrency")).collect(Collectors.toList());
                        forexPriceExRate = this.getForexPriceExRate(subsimulatecurrency);
                    }
                    for (int j = 0; j < simulateSubEntryList.size(); ++j) {
                        DynamicObject simulateSubEntry = (DynamicObject)simulateSubEntryList.get(j);
                        DynamicObject subSimulateCurrency = simulateSubEntry.getDynamicObject("subsimulatecurrency");
                        BigDecimal exrate = (BigDecimal)forexPriceExRate.get(subSimulateCurrency.getLong("id"));
                        this.getModel().setValue(SUBEXRATE, (Object)exrate, j, i);
                        if (!percent) continue;
                        for (int z = 0; z < simulatenum; ++z) {
                            if (!define) {
                                this.getModel().setValue("subsimulateexrate" + (z + 1), (Object)exrate.multiply(BigDecimal.ONE.add(list.get(z).divide(BigDecimal.valueOf(100L), RoundingMode.HALF_UP))), j, i);
                                continue;
                            }
                            BigDecimal subSimulateexRate = (BigDecimal)this.getModel().getValue("subsimulateexrate" + (z + 1) + "_ori", j, i);
                            if (subSimulateexRate == null) {
                                subSimulateexRate = BigDecimal.ZERO;
                            }
                            this.getModel().setValue("subsimulateexrate" + (z + 1), (Object)exrate.multiply(BigDecimal.ONE.add(subSimulateexRate.divide(BigDecimal.valueOf(100L), RoundingMode.HALF_UP))), j, i);
                        }
                    }
                    this.getView().updateView("simulatesubentry");
                }
            } else {
                DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
                LinkedHashSet<String> tipPairs = new LinkedHashSet<String>(16);
                if (currency != null) {
                    String currencyNumber = currency.getString("number");
                    DynamicObjectCollection simulateentryList = this.getModel().getEntryEntity("simulateentry");
                    for (int i = 0; i < simulateentryList.size(); ++i) {
                        DynamicObject simulateentry = (DynamicObject)simulateentryList.get(i);
                        DynamicObject simulateCurrency = simulateentry.getDynamicObject("simulatecurrency");
                        if (simulateCurrency == null) continue;
                        String simulateCurrencyNumber = simulateCurrency.getString("number");
                        String pair = simulateCurrencyNumber + "/" + currencyNumber;
                        ForexQuoteInfo fQuoteInfo = MarketDataServiceHelper.getForexQuoteInfoWithoutThrow((Long)((Long)newForexPrice.getPkValue()), (String)pair, null, null);
                        BigDecimal exRate = BigDecimal.ZERO;
                        if (fQuoteInfo == null) {
                            tipPairs.add(pair);
                        } else {
                            exRate = pair.equals(fQuoteInfo.getFxquote()) ? fQuoteInfo.getBuyPrice() : BigDecimal.ONE.divide(fQuoteInfo.getSellPrice(), 19, RoundingMode.HALF_UP);
                        }
                        this.getModel().setValue(EXRATE, (Object)exRate, i);
                        if (!percent) continue;
                        for (int j = 0; j < simulatenum; ++j) {
                            if (!define) {
                                this.getModel().setValue("simulateexrate" + (j + 1), (Object)exRate.multiply(BigDecimal.ONE.add(this.musimulateExRateList.get(j).divide(BigDecimal.valueOf(100L), RoundingMode.HALF_UP))), i);
                                continue;
                            }
                            BigDecimal simulateexRate = (BigDecimal)this.getModel().getValue("simulateexrate" + (j + 1) + "_ori", i);
                            this.getModel().setValue("simulateexrate" + (j + 1), (Object)exRate.multiply(BigDecimal.ONE.add(simulateexRate.divide(BigDecimal.valueOf(100L), RoundingMode.HALF_UP))), i);
                        }
                    }
                    if (!EmptyUtil.isEmpty(tipPairs)) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8d27\u5e01\u5bf9\u201c%1$s\u201d\u5728\u5916\u6c47\u62a5\u4ef7\u201c%2$s\u201d\u4e2d\u672a\u8bbe\u7f6e\u62a5\u4ef7\u65b9\u5f0f\uff0c\u8bf7\u8bbe\u7f6e\u62a5\u4ef7\u65b9\u5f0f\u6765\u83b7\u53d6\u5f53\u524d\u6c47\u7387\u3002", (String)"ExScenarioSimulationTestEdit_0", (String)"tmc-mrm-formplugin", (Object[])new Object[0]), String.join((CharSequence)"\u3001", tipPairs), newForexPrice.getString("number")));
                    }
                }
            }
        } else {
            this.clearSimulateExrate();
        }
    }

    private void clearSimulateExrate() {
        String sectionType = (String)this.getModel().getValue("sectiontype");
        int simulatenum = (Integer)this.getModel().getValue("simulatenum");
        String simulateform = (String)this.getModel().getValue("simulateform");
        boolean percent = ExSimulateFormEnum.isPercent((String)simulateform);
        if (ExSectionTypeEnum.isMutilSection((String)sectionType)) {
            DynamicObjectCollection sectionEntryList = this.getModel().getEntryEntity("sectionentry");
            for (int i = 0; i < sectionEntryList.size(); ++i) {
                DynamicObject sectionEntry = (DynamicObject)sectionEntryList.get(i);
                DynamicObjectCollection simulateSubEntryList = sectionEntry.getDynamicObjectCollection("simulatesubentry");
                for (int j = 0; j < simulateSubEntryList.size(); ++j) {
                    this.getModel().setValue(SUBEXRATE, (Object)BigDecimal.ZERO, j, i);
                    if (!percent) continue;
                    for (int z = 0; z < simulatenum; ++z) {
                        this.getModel().setValue("subsimulateexrate" + (z + 1), (Object)BigDecimal.ZERO, j, i);
                    }
                }
                this.getView().updateView("simulatesubentry");
            }
        } else {
            DynamicObjectCollection simulateentryList = this.getModel().getEntryEntity("simulateentry");
            for (int i = 0; i < simulateentryList.size(); ++i) {
                this.getModel().setValue(EXRATE, (Object)BigDecimal.ZERO, i);
                if (!percent) continue;
                for (int j = 0; j < simulatenum; ++j) {
                    this.getModel().setValue("simulateexrate" + (j + 1), (Object)BigDecimal.ZERO, i);
                }
            }
        }
    }

    private void onSubExrateChange(BigDecimal exrate) {
        this.initSimulateExrateList();
        String scenarioMethod = (String)this.getModel().getValue("scenariomethod");
        String simulateForm = (String)this.getModel().getValue("simulateform");
        int simulatenum = (Integer)this.getModel().getValue("simulatenum");
        boolean define = ExScenarioMethodEnum.isDefine((String)scenarioMethod);
        boolean percent = ExSimulateFormEnum.isPercent((String)simulateForm);
        if (!percent) {
            return;
        }
        EntryGrid sectionEntryGrid = (EntryGrid)this.getControl("sectionentry");
        int[] rows = sectionEntryGrid.getSelectRows();
        if (rows != null && rows.length > 0) {
            int parentRow = rows[0];
            List<BigDecimal> list = this.subMusimulateExRateList.get(parentRow);
            EntryGrid subsimulateentry = (EntryGrid)this.getControl("simulatesubentry");
            int[] subSelectRows = subsimulateentry.getSelectRows();
            if (subSelectRows != null && subSelectRows.length > 0) {
                int subSelectRow = subSelectRows[0];
                for (int z = 0; z < simulatenum; ++z) {
                    if (!define) {
                        this.getModel().setValue("subsimulateexrate" + (z + 1), (Object)exrate.multiply(BigDecimal.ONE.add(list.get(z).divide(BigDecimal.valueOf(100L), RoundingMode.HALF_UP))), subSelectRow, parentRow);
                        continue;
                    }
                    BigDecimal subSimulateexRate = (BigDecimal)this.getModel().getValue("subsimulateexrate" + (z + 1) + "_ori", subSelectRow, parentRow);
                    if (subSimulateexRate == null) {
                        subSimulateexRate = BigDecimal.ZERO;
                    }
                    this.getModel().setValue("subsimulateexrate" + (z + 1), (Object)exrate.multiply(BigDecimal.ONE.add(subSimulateexRate.divide(BigDecimal.valueOf(100L), RoundingMode.HALF_UP))), subSelectRow, parentRow);
                }
            }
        }
    }

    private void onExrateChange(BigDecimal exrate) {
        this.initSimulateExrateList();
        String scenarioMethod = (String)this.getModel().getValue("scenariomethod");
        String simulateForm = (String)this.getModel().getValue("simulateform");
        int simulatenum = (Integer)this.getModel().getValue("simulatenum");
        boolean define = ExScenarioMethodEnum.isDefine((String)scenarioMethod);
        boolean percent = ExSimulateFormEnum.isPercent((String)simulateForm);
        if (!percent) {
            return;
        }
        EntryGrid simulateentry = (EntryGrid)this.getControl("simulateentry");
        int[] selectRows = simulateentry.getSelectRows();
        if (selectRows != null && selectRows.length > 0) {
            int row = selectRows[0];
            for (int i = 0; i < simulatenum; ++i) {
                if (!define) {
                    this.getModel().setValue("simulateexrate" + (i + 1), (Object)exrate.multiply(BigDecimal.ONE.add(this.musimulateExRateList.get(i).divide(BigDecimal.valueOf(100L), RoundingMode.HALF_UP))), row);
                    continue;
                }
                BigDecimal simulateexRate = (BigDecimal)this.getModel().getValue("simulateexrate" + (i + 1) + "_ori", row);
                this.getModel().setValue("simulateexrate" + (i + 1), (Object)exrate.multiply(BigDecimal.ONE.add(simulateexRate.divide(BigDecimal.valueOf(100L), RoundingMode.HALF_UP))), row);
            }
        }
    }

    private DynamicObject toDynamicObjectByJsonStr(String json) {
        MainEntityType subMainType = EntityMetadataCache.getDataEntityType((String)"mrm_ex_scenario_sim");
        Object[] deserialize = DynamicObjectSerializeUtil.deserialize((String)json, (DynamicObjectType)subMainType);
        if (deserialize.length > 0) {
            return (DynamicObject)deserialize[0];
        }
        return null;
    }

    private void setSimulateColumn() {
        int simulatenum = (Integer)this.getModel().getValue("simulatenum");
        String sectionset = (String)this.getModel().getValue("sectiontype");
        if (ExSectionTypeEnum.isMutilSection((String)sectionset)) {
            int i;
            EntryGrid subSimulateEntry = (EntryGrid)this.getControl("simulatesubentry");
            for (i = 0; i < simulatenum; ++i) {
                subSimulateEntry.setColumnProperty("subsimulateexrate" + (i + 1), "visible", (Object)true);
            }
            for (i = simulatenum; i < 5; ++i) {
                subSimulateEntry.setColumnProperty("subsimulateexrate" + (i + 1), "visible", (Object)false);
            }
        } else {
            int i;
            EntryGrid simulateentry = (EntryGrid)this.getControl("simulateentry");
            for (i = 0; i < simulatenum; ++i) {
                simulateentry.setColumnProperty("simulateexrate" + (i + 1), "visible", (Object)true);
            }
            for (i = simulatenum; i < 5; ++i) {
                simulateentry.setColumnProperty("simulateexrate" + (i + 1), "visible", (Object)false);
            }
        }
    }

    public void beforeBasedataSetValue(BeforeBasedataSetValueEvent event) {
        ListSelectedRowCollection testCurrs;
        BasedataEdit source = (BasedataEdit)event.getSource();
        String key = source.getKey();
        if (TESTCURRENCY.equals(key) && (testCurrs = (ListSelectedRowCollection)event.getValue()).size() > 10) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u591a\u53ef\u81ea\u5b9a\u4e4910\u4e2a\u5e01\u79cd\u8fdb\u884c\u6c47\u7387\u6a21\u62df\u3002", (String)"ExScenarioSimulationEdit_13", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
        }
        if (FOREXPRICE.equals(key)) {
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (currency == null) {
                if (org != null) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5206\u6790\u4e3b\u4f53\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7684\u672c\u4f4d\u5e01\uff0c\u8bf7\u5148\u7ef4\u62a4\u672c\u4f4d\u5e01\u3002", (String)"ExScenarioSimulationEdit_11", (String)"tmc-mrm-formplugin", (Object[])new Object[0]), org.getString("name")));
                    event.setCancel(true);
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u6790\u4e3b\u4f53\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u7ef4\u62a4\u5206\u6790\u4e3b\u4f53\u3002", (String)"ExScenarioSimulationEdit_12", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
                    event.setCancel(true);
                }
            }
        }
    }
}

