/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.formplugin.license;

import java.util.Collections;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class MrmLicenseControlPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(MrmLicenseControlPlugin.class);
    private static final String APP_TM_ID = "0MRLNB/GDEG9";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        String version = LicenseServiceHelper.getProductVersion();
        if (EmptyUtil.isEmpty((String)version)) {
            return;
        }
        String mainVersion = version.substring(0, version.indexOf("."));
        if (Integer.parseInt(mainVersion) < 7) {
            logger.info("license version:{}", (Object)version);
            return;
        }
        LicenseCheckResult licenseCheckResult = LicenseServiceHelper.checkLicenseModules((String)APP_TM_ID);
        if (licenseCheckResult != null && !licenseCheckResult.getHasLicense().booleanValue()) {
            e.setCancel(true);
            e.setCancelMessage(licenseCheckResult.getMsg());
            FormShowParameter parameter = LicenseServiceHelper.buildNoticeFormShowParameter((String)licenseCheckResult.getMsg(), Collections.singletonList(ResManager.loadKDString((String)"\u65e0\u91d1\u878d\u4ea4\u6613\u7ba1\u7406\u6a21\u5757\u8bb8\u53ef\u3002", (String)"MrmLicenseControlPlugin_0", (String)"tmc-mrm-formplugin", (Object[])new Object[0])));
            e.setCancelFormShowParameter(parameter.toString());
        }
    }
}

