/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.formplugin.predict;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.workflow.bpmn.converter.util.CollectionUtils;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.model.interest.PlanCallResult;
import kd.tmc.fbp.common.model.interest.RepayPlanRequest;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.fbp.service.inst.plan.RepayPlanCallStragety;
import kd.tmc.mrm.common.bean.IntBillExtInfo;
import kd.tmc.mrm.common.enums.RateBillTypeEnum;
import kd.tmc.mrm.common.helper.DepositHelper;
import kd.tmc.mrm.common.helper.InterestCalHelper;
import kd.tmc.mrm.common.helper.RateAdjustHelper;
import kd.tmc.mrm.common.helper.RevenuePlanCalHelper;
import kd.tmc.mrm.formplugin.predict.AbstractPredictDataEdit;
import org.apache.commons.lang3.tuple.Pair;

public class CashflowTabPlugin
extends AbstractPredictDataEdit {
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "calcashflow": {
                if (!args.getOperationResult().isSuccess()) break;
                this.calCashFlow();
                break;
            }
            case "checkinterest": {
                this.checkinterestShowForm();
            }
        }
    }

    private void calCashFlow() {
        DynamicObject bill = this.getModel().getDataEntity();
        DynamicObject billType = (DynamicObject)this.getModel().getValue("billtype");
        if (billType != null) {
            String billTypeNumber = billType.getString("number");
            if (RateBillTypeEnum.isCfmBIllType((String)billTypeNumber)) {
                this.calCashFlowForCfm();
            } else if (RateBillTypeEnum.isCimBIllType((String)billTypeNumber)) {
                this.calCashFlowForCim(bill);
            }
        }
    }

    private void calCashFlowForCfm() {
        this.calCapCashFlowForCfm();
        this.calRateAdjustForCfm();
        this.calInsCashFlowForCfm();
    }

    private void calCashFlowForCim(DynamicObject bill) {
        this.calCapCashFlowForCim(bill);
        this.calInCashFlowForCim(bill);
    }

    private void calInCashFlowForCim(DynamicObject bill) {
        String billTypeNumber = this.getBillTypeNumber();
        if (RateBillTypeEnum.CIM_FINSUBSCRIBE.getValue().equals(billTypeNumber)) {
            RevenuePlanCalHelper.calRevenuePlan((DynamicObject)bill);
        } else {
            DepositHelper.calIntPlan((DynamicObject)bill);
        }
        this.getView().updateView("incashflowtentry");
    }

    private void calCapCashFlowForCim(DynamicObject bill) {
        this.getModel().deleteEntryData("capcashflowentry");
        DynamicObjectCollection capCashFlows = bill.getDynamicObjectCollection("capcashflowentry");
        DynamicObject capCashFlow = capCashFlows.addNew();
        capCashFlow.set("capdate", this.getModel().getValue("enddate"));
        capCashFlow.set("capamount", this.getModel().getValue("amount"));
        capCashFlow.set("capmodifydate", (Object)TcDateUtils.getCurrentTime());
        this.getView().updateView("capcashflowentry");
    }

    private void calCapCashFlowForCfm() {
        RepayPlanRequest request = this.genRepayPlanRequest();
        List repayPlanList = new RepayPlanCallStragety().callPlan(request);
        if (CollectionUtils.isNotEmpty((Collection)repayPlanList)) {
            IDataModel model = this.getModel();
            this.updateRepayPlanByAdjustRule(model, repayPlanList);
            model.deleteEntryData("capcashflowentry");
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("seq", new Object[0]).addField("capdate", new Object[0]).addField("capamount", new Object[0]).addField("capmodifydate", new Object[0]);
            int count = 1;
            for (PlanCallResult repayPlan : repayPlanList) {
                vs.addRow(new Object[]{count, repayPlan.getBizDate(), repayPlan.getPrinciple(), TcDateUtils.getCurrentTime()});
            }
            AbstractFormDataModel dataModel = (AbstractFormDataModel)model;
            dataModel.beginInit();
            dataModel.batchCreateNewEntryRow("capcashflowentry", vs);
            dataModel.endInit();
            this.getView().updateView("capcashflowentry");
        }
    }

    private void calInsCashFlowForCfm() {
        Pair intBills = null;
        intBills = InterestCalHelper.callIntCashFlow((DynamicObject)this.getModel().getDataEntity());
        CashflowTabPlugin.loanBillWriteBack((Pair<BigDecimal, List<IntBillExtInfo>>)intBills, this.getModel().getDataEntity());
        this.getView().updateView("incashflowtentry");
        this.getView().updateView("incashflowtsubentry");
    }

    private void calRateAdjustForCfm() {
        RateAdjustHelper.updateRateAdjustList((DynamicObject)this.getModel().getDataEntity());
        this.getView().updateView("rateadjustentry");
    }

    public static void loanBillWriteBack(Pair<BigDecimal, List<IntBillExtInfo>> interestCals, DynamicObject loanBill) {
        String basis = loanBill.getString("basis");
        int yearDay = TermHelper.getBasis_YearDay((int)1, (BasisEnum)BasisEnum.getEnum((String)basis));
        List intBills = (List)interestCals.getValue();
        DynamicObjectCollection interestEntryDC = loanBill.getDynamicObjectCollection("incashflowtentry");
        interestEntryDC.clear();
        for (IntBillExtInfo intBill : intBills) {
            DynamicObject interestEntryDO = interestEntryDC.addNew();
            Date interestDate = intBill.getBizDate();
            BigDecimal interestAmount = intBill.getAmount();
            interestEntryDO.set("seq", (Object)intBill.getSeq());
            interestEntryDO.set("indate", (Object)interestDate);
            interestEntryDO.set("inamount", (Object)interestAmount);
            List details = intBill.getExtDetails();
            DynamicObjectCollection interestSubEntryDC = interestEntryDO.getDynamicObjectCollection("incashflowtsubentry");
            interestSubEntryDC.clear();
            for (IntBillExtInfo.IntBillDetailExtInfo detail : details) {
                Date beginDate = detail.getBeginDate();
                Date endDate = detail.getEndDate();
                int days = detail.getDays();
                BigDecimal principle = detail.getPrinciple();
                BigDecimal yearRate = detail.getRate();
                BigDecimal rateAmount = detail.getAmount();
                DynamicObject interestSubEntryDO = interestSubEntryDC.addNew();
                interestSubEntryDO.set("seq", (Object)detail.getSeq());
                interestSubEntryDO.set("intereststartdate", (Object)beginDate);
                interestSubEntryDO.set("interestenddate", (Object)endDate);
                interestSubEntryDO.set("interestdates", (Object)days);
                interestSubEntryDO.set("interestbalance", (Object)principle);
                interestSubEntryDO.set("interestrate", (Object)yearRate);
                interestSubEntryDO.set("interestdays", (Object)yearDay);
                interestSubEntryDO.set("interestamount", (Object)rateAmount);
                interestSubEntryDO.set("interestway", (Object)detail.getIntType().getValue());
                interestSubEntryDO.set("floatint", (Object)detail.getFloatInt());
                interestSubEntryDO.set("floatrate", (Object)detail.getFloatRate());
                interestSubEntryDO.set("lasttotalint", (Object)detail.getLastTotalInt());
                interestSubEntryDO.set("curtotalint", (Object)detail.getCurTotalInt());
                Date beginConfirmDate = detail.getBeginConfirmDate();
                Date endConfirmDate = detail.getEndConfirmDate();
                if (beginConfirmDate == null || endConfirmDate == null) continue;
                Integer lookDays = detail.getConfirmDays();
                interestSubEntryDO.set("confirmratedate", (Object)beginConfirmDate);
                interestSubEntryDO.set("lookdays", (Object)lookDays);
            }
        }
    }

    private void checkinterestShowForm() {
        IDataModel model = this.getModel();
        DynamicObject interest_entry = (DynamicObject)model.getEntryEntity("incashflowtentry").get(model.getEntryCurrentRowIndex("incashflowtentry"));
        HashMap<String, Object> param = new HashMap<String, Object>();
        boolean isSofrRate = (Boolean)this.getModel().getValue("issofrrate");
        if (isSofrRate) {
            param.put("formId", "mrm_intcaldetailsofrcard");
        } else {
            param.put("formId", "mrm_intcaldetailcard");
        }
        param.put("loanBillId", this.getModel().getDataEntity().getPkValue());
        param.put("seq", interest_entry.getInt("seq"));
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(param);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void updateRepayPlanByAdjustRule(IDataModel model, List<PlanCallResult> repayPlanList) {
        String adjustRule = (String)model.getValue("loanexpireadjustrule");
        DynamicObjectCollection workCalendars = (DynamicObjectCollection)model.getValue("workcalendar");
        InterestCalHelper.updatePlanListByAdjustRule(repayPlanList, (String)adjustRule, (DynamicObjectCollection)workCalendars);
    }

    private RepayPlanRequest genRepayPlanRequest() {
        RepayPlanRequest request = new RepayPlanRequest();
        request.setLoanAmount((BigDecimal)this.getModel().getValue("amount"));
        request.setLoanDate((Date)this.getModel().getValue("startdate"));
        request.setExpiredate((Date)this.getModel().getValue("enddate"));
        request.setRepayScheme((DynamicObject)this.getModel().getValue("stageplan"));
        request.setRepayWay(RepaymentWayEnum.valueOf((String)((String)this.getModel().getValue("repaymentway"))));
        request.setCurrency((DynamicObject)this.getModel().getValue("currency"));
        return request;
    }
}

