/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.formplugin.predict;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.tmc.fbp.common.enums.IntCalMethodEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.enums.SettleIntModeEnum;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mrm.common.enums.CalcIntWayEnum;
import kd.tmc.mrm.common.enums.LookBackTypeEnum;
import kd.tmc.mrm.common.enums.PostPositionTypeEnum;
import kd.tmc.mrm.common.enums.RateBillTypeEnum;
import kd.tmc.mrm.common.enums.RateTypeEnum;
import kd.tmc.mrm.formplugin.predict.AbstractPredictDataEdit;

public class PredictDataEdit
extends AbstractPredictDataEdit {
    @Override
    public void beforeF7Select(BeforeF7SelectEvent event) {
        String name;
        super.beforeF7Select(event);
        switch (name = event.getProperty().getName()) {
            case "counterparty": {
                String counterpartytype = (String)this.getModel().getValue("counterpartytype");
                if (!"bos_org".equals(counterpartytype)) break;
                ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
                showParameter.setCustomParam("orgViewSchemeNumber", (Object)"08");
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.controlMustInput();
        this.controlComboValueForRateType();
        this.controlVisiable();
        this.controleRateType();
        this.controlEntryOperation();
        OperationStatus status = this.getView().getFormShowParameter().getShowParameter().getStatus();
        if (status == OperationStatus.EDIT || status == OperationStatus.ADDNEW) {
            this.initIntCalBox();
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.getModel().setValue("startdate", null);
        this.clearEntry();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setDefaultRateresetdays();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        switch (name = e.getProperty().getName()) {
            case "billtype": {
                this.setMustForBillType();
                this.setMustForRateType();
                this.setMustForInterest();
                this.setMustForAdjustRule();
                this.controlVisiable();
                this.controlStagePlanVisiable();
                this.clearEntry();
                this.clearFieldsByBillType(this.getBillTypeNumber());
                this.controleRateType();
                this.controlInterestSettledPlanVisiable();
                this.controlEntryOperation();
                break;
            }
            case "term": {
                ChangeData[] changeData = e.getChangeSet();
                String oldValue = (String)changeData[0].getOldValue();
                this.checkTermIsRight(oldValue);
                this.calEndDate();
                break;
            }
            case "interestdate": {
                this.calEndDate();
                this.controlEndDateRange();
                break;
            }
            case "enddate": {
                this.calTerm();
                break;
            }
            case "ratetype": {
                this.controleRateType();
                this.setMustForRateType();
                this.controlComboValueForRateType();
                this.controlSofrVisiable();
                this.controlRateresetdays();
                break;
            }
            case "fixrate": {
                this.controlComboValueForRateType();
                break;
            }
            case "repaymentway": {
                this.setSettleIntModeByRepayWay();
                this.controlStagePlanVisiable();
                this.controlInterestSettledPlanVisiable();
                this.clearStagePlan();
                this.clearEntry();
                this.controlEntryOperation();
                break;
            }
            case "issofrrate": {
                this.setCalcintWay();
                break;
            }
            case "iscallcompint": {
                this.initIntCalBox();
                break;
            }
            case "calcintway": {
                this.initPostpositiontype();
                this.initIntCalBox();
                this.setMustForInterest();
                this.setDefaultRateresetdays();
                break;
            }
            case "postpositiontype": {
                this.initLookbacktype();
                this.setMustForInterest();
                this.setDefaultRateresetdays();
                break;
            }
            case "counterpartytype": {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"counterpartytext", null);
                break;
            }
            case "counterparty": {
                DynamicObject counterparty = (DynamicObject)this.getModel().getValue("counterparty");
                if (counterparty == null || !counterparty.containsProperty("name")) break;
                String counterpartyName = counterparty.getString("name");
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"counterpartytext", (Object)counterpartyName);
            }
        }
    }

    private void clearFieldsByBillType(String billType) {
        if (RateBillTypeEnum.CIM_FINSUBSCRIBE.getValue().equals(billType)) {
            TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String[])new String[]{"basepoint"});
        } else {
            TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String[])new String[]{"planrevenue"});
        }
    }

    private void controlEntryOperation() {
        String billTypeNumber = this.getBillTypeNumber();
        if (EmptyUtil.isEmpty((String)billTypeNumber)) {
            return;
        }
        String repaymentWay = (String)this.getModel().getValue("repaymentway");
        if (!RepaymentWayEnum.zdyhk.getValue().equals(repaymentWay) || RateBillTypeEnum.isCimBIllType((String)billTypeNumber)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"addentry", "delentry"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"addentry", "delentry"});
        }
    }

    private void controleRateType() {
        String billTypeNumber = this.getBillTypeNumber();
        boolean isCimBIllType = RateBillTypeEnum.isCimBIllType((String)billTypeNumber);
        if (isCimBIllType) {
            String rateType = (String)this.getModel().getValue("ratetype");
            if (RateBillTypeEnum.isFinsubscribeBIllType((String)billTypeNumber)) {
                if (RateTypeEnum.FIXED.getValue().equals(rateType)) {
                    TmcViewInputHelper.registerVisibleStatus((IFormView)this.getView(), (String[])new String[]{"planrevenue", "basepoint", "referencerate", "rateadjustdate", "rateadjustcycletype", "rateadjustcycle"}, (boolean)Boolean.FALSE);
                    TmcViewInputHelper.registerVisibleStatus((IFormView)this.getView(), (String[])new String[]{"fixrate"}, (boolean)Boolean.TRUE);
                } else {
                    TmcViewInputHelper.registerVisibleStatus((IFormView)this.getView(), (String[])new String[]{"fixrate", "basepoint", "referencerate", "rateadjustdate", "rateadjustcycletype", "rateadjustcycle"}, (boolean)Boolean.FALSE);
                    TmcViewInputHelper.registerVisibleStatus((IFormView)this.getView(), (String[])new String[]{"planrevenue"}, (boolean)Boolean.TRUE);
                }
            } else if (RateTypeEnum.FIXED.getValue().equals(rateType)) {
                TmcViewInputHelper.registerVisibleStatus((IFormView)this.getView(), (String[])new String[]{"planrevenue", "basepoint", "referencerate", "rateadjustdate", "rateadjustcycletype", "rateadjustcycle"}, (boolean)Boolean.FALSE);
                TmcViewInputHelper.registerVisibleStatus((IFormView)this.getView(), (String[])new String[]{"fixrate"}, (boolean)Boolean.TRUE);
            } else {
                TmcViewInputHelper.registerVisibleStatus((IFormView)this.getView(), (String[])new String[]{"planrevenue", "fixrate", "basepoint", "referencerate", "rateadjustdate", "rateadjustcycletype", "rateadjustcycle"}, (boolean)Boolean.FALSE);
                TmcViewInputHelper.registerVisibleStatus((IFormView)this.getView(), (String[])new String[]{"basepoint", "referencerate"}, (boolean)Boolean.TRUE);
            }
        } else {
            String rateType = (String)this.getModel().getValue("ratetype");
            if (RateTypeEnum.FIXED.getValue().equals(rateType)) {
                TmcViewInputHelper.registerVisibleStatus((IFormView)this.getView(), (String[])new String[]{"fixrate"}, (boolean)Boolean.TRUE);
                TmcViewInputHelper.registerVisibleStatus((IFormView)this.getView(), (String[])new String[]{"planrevenue", "basepoint", "referencerate", "rateadjustdate", "rateadjustcycletype", "rateadjustcycle"}, (boolean)Boolean.FALSE);
            } else {
                TmcViewInputHelper.registerVisibleStatus((IFormView)this.getView(), (String[])new String[]{"planrevenue", "fixrate"}, (boolean)Boolean.FALSE);
                TmcViewInputHelper.registerVisibleStatus((IFormView)this.getView(), (String[])new String[]{"basepoint", "referencerate", "rateadjustdate", "rateadjustcycletype", "rateadjustcycle"}, (boolean)Boolean.TRUE);
            }
        }
    }

    private void clearStagePlan() {
        HashSet<String> repayWayLSBQ = new HashSet<String>(5);
        repayWayLSBQ.add(RepaymentWayEnum.dqhblsbq.getValue());
        repayWayLSBQ.add(RepaymentWayEnum.dqhbdqhx.getValue());
        repayWayLSBQ.add(RepaymentWayEnum.debx.getValue());
        repayWayLSBQ.add(RepaymentWayEnum.debj.getValue());
        repayWayLSBQ.add(RepaymentWayEnum.dbdx.getValue());
        String repayWay = (String)this.getModel().getValue("repaymentway");
        if (!repayWayLSBQ.contains(repayWay)) {
            this.getModel().setValue("stageplan", null);
        }
    }

    private void checkTermIsRight(Object oldValue) {
        String term = (String)this.getModel().getValue("term");
        boolean rightFormat = TermHelper.isRightFormat((IDataModel)this.getModel(), (IFormView)this.getView(), (String)term);
        if (!rightFormat) {
            this.getModel().setValue("term", oldValue);
        }
    }

    private void calTerm() {
        Date startDate = (Date)this.getModel().getValue("interestdate");
        Date endDate = (Date)this.getModel().getValue("enddate");
        if (EmptyUtil.isNoEmpty((Object)startDate) && EmptyUtil.isNoEmpty((Object)endDate)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"term", (Object)TermHelper.callTermLargeEqualZore((Date)startDate, (Date)endDate));
        }
    }

    private void calEndDate() {
        Date startDate = (Date)this.getModel().getValue("interestdate");
        String term = (String)this.getModel().getValue("term");
        if (EmptyUtil.isNoEmpty((Object)startDate) && !"".equals(term)) {
            Date endDate = TermHelper.getDateByBaseDate4ymd((String)term, (Date)startDate);
            this.getModel().setValue("enddate", (Object)endDate);
        }
    }

    private void controlEndDateRange() {
        Date interestDate = (Date)this.getModel().getValue("interestdate");
        if (interestDate == null) {
            return;
        }
        DateEdit endDate = (DateEdit)this.getControl("enddate");
        endDate.setMinDate(interestDate);
    }

    private void setSettleIntModeByRepayWay() {
        String repayWay = (String)this.getModel().getValue("repaymentway");
        HashSet<String> repayWayLSBQ = new HashSet<String>(8);
        repayWayLSBQ.add(RepaymentWayEnum.bqhblsbq.getValue());
        repayWayLSBQ.add(RepaymentWayEnum.dqhblsbq.getValue());
        repayWayLSBQ.add(RepaymentWayEnum.debx.getValue());
        repayWayLSBQ.add(RepaymentWayEnum.debj.getValue());
        repayWayLSBQ.add(RepaymentWayEnum.dbdx.getValue());
        HashSet<String> repayWayFIX = new HashSet<String>(4);
        repayWayFIX.add(RepaymentWayEnum.dqhbdqhx.getValue());
        repayWayFIX.add(RepaymentWayEnum.bqhbdqhx.getValue());
        if (repayWayLSBQ.contains(repayWay)) {
            this.getModel().setValue("settleintmode", (Object)SettleIntModeEnum.lsbq.getValue());
        } else if (repayWayFIX.contains(repayWay)) {
            this.getModel().setValue("settleintmode", (Object)SettleIntModeEnum.gdpljx.getValue());
        } else if (RepaymentWayEnum.zdyhk.getValue().equals(repayWay)) {
            this.getModel().setValue("settleintmode", (Object)SettleIntModeEnum.gdpljx.getValue());
        }
    }

    private void controlComboValueForRateType() {
        String rateType = (String)this.getModel().getValue("ratetype");
        ComboEdit rateTypeCombo = (ComboEdit)this.getControl("repaymentway");
        if (RateTypeEnum.FIXED.getValue().equals(rateType)) {
            BigDecimal fixRate = (BigDecimal)this.getModel().getValue("fixrate");
            if (BigDecimal.ZERO.compareTo(fixRate) == 0) {
                ArrayList<ComboItem> data = new ArrayList<ComboItem>(6);
                data.add(new ComboItem(new LocaleString(RepaymentWayEnum.bqhblsbq.getName()), RepaymentWayEnum.bqhblsbq.getValue()));
                data.add(new ComboItem(new LocaleString(RepaymentWayEnum.dqhblsbq.getName()), RepaymentWayEnum.dqhblsbq.getValue()));
                data.add(new ComboItem(new LocaleString(RepaymentWayEnum.bqhbdqhx.getName()), RepaymentWayEnum.bqhbdqhx.getValue()));
                data.add(new ComboItem(new LocaleString(RepaymentWayEnum.dqhbdqhx.getName()), RepaymentWayEnum.dqhbdqhx.getValue()));
                data.add(new ComboItem(new LocaleString(RepaymentWayEnum.zdyhk.getName()), RepaymentWayEnum.zdyhk.getValue()));
                rateTypeCombo.setComboItems(data);
            } else {
                rateTypeCombo.setComboItems(this.getRepaymentWayComboItem());
            }
        } else {
            rateTypeCombo.setComboItems(this.getRepaymentWayComboItem());
        }
        String repaymentway = (String)this.getModel().getValue("repaymentway");
        if (EmptyUtil.isEmpty((String)repaymentway)) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"repaymentway", (Object)RepaymentWayEnum.bqhblsbq.getValue());
        }
    }

    private List<ComboItem> getRepaymentWayComboItem() {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(16);
        items.add(new ComboItem(new LocaleString(RepaymentWayEnum.bqhblsbq.getName()), RepaymentWayEnum.bqhblsbq.getValue()));
        items.add(new ComboItem(new LocaleString(RepaymentWayEnum.dqhblsbq.getName()), RepaymentWayEnum.dqhblsbq.getValue()));
        items.add(new ComboItem(new LocaleString(RepaymentWayEnum.bqhbdqhx.getName()), RepaymentWayEnum.bqhbdqhx.getValue()));
        items.add(new ComboItem(new LocaleString(RepaymentWayEnum.dqhbdqhx.getName()), RepaymentWayEnum.dqhbdqhx.getValue()));
        items.add(new ComboItem(new LocaleString(RepaymentWayEnum.debx.getName()), RepaymentWayEnum.debx.getValue()));
        items.add(new ComboItem(new LocaleString(RepaymentWayEnum.debj.getName()), RepaymentWayEnum.debj.getValue()));
        items.add(new ComboItem(new LocaleString(RepaymentWayEnum.dbdx.getName()), RepaymentWayEnum.dbdx.getValue()));
        items.add(new ComboItem(new LocaleString(RepaymentWayEnum.zdyhk.getName()), RepaymentWayEnum.zdyhk.getValue()));
        return items;
    }

    private void controlMustInput() {
        this.setMustForBillType();
        this.setMustForRateType();
        this.setMustForInterest();
        this.setMustForAdjustRule();
    }

    private void setMustForRateType() {
        String billType = this.getBillTypeNumber();
        if (EmptyUtil.isEmpty((String)billType)) {
            return;
        }
        if (RateBillTypeEnum.isFinsubscribeBIllType((String)billType)) {
            String rateType = (String)this.getModel().getValue("ratetype");
            if (RateTypeEnum.FIXED.getValue().equals(rateType)) {
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"fixrate"});
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"planrevenue"});
            } else {
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"fixrate"});
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"planrevenue"});
            }
        } else {
            String rateType = (String)this.getModel().getValue("ratetype");
            if (RateTypeEnum.FIXED.getValue().equals(rateType)) {
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"fixrate"});
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"referencerate"});
            } else {
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"fixrate"});
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"referencerate"});
            }
            if (RateBillTypeEnum.isCfmBIllType((String)billType)) {
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (!RateTypeEnum.FIXED.getValue().equals(rateType) ? 1 : 0) != 0, (String[])new String[]{"rateadjustdate", "rateadjustcycletype", "rateadjustcycle"});
            }
        }
    }

    private void setMustForBillType() {
        String billTypeNumber = this.getBillTypeNumber();
        if (EmptyUtil.isNoEmpty((String)billTypeNumber)) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)RateBillTypeEnum.isBond((String)billTypeNumber), (String[])new String[]{"publishprice", "ticketamt"});
        }
    }

    private void controlVisiable() {
        this.controlAboutRateVisiable();
        this.controlStagePlanVisiable();
        this.controlInterestSettledPlanVisiable();
        this.controlAdjustRule();
        this.controlRateresetdays();
        this.controlSofrVisiable();
    }

    private void controlSofrVisiable() {
        String billTypeNumber = this.getBillTypeNumber();
        boolean isShowAboutRate = RateBillTypeEnum.isCfmBIllType((String)billTypeNumber);
        if (isShowAboutRate) {
            Object rateType = this.getModel().getValue("ratetype");
            if (RateTypeEnum.FLOAT.getValue().equals(rateType)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"issofrrate"});
            } else {
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"issofrrate", (Object)false);
                this.getView().setVisible(Boolean.FALSE, new String[]{"issofrrate"});
            }
        } else {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"issofrrate", (Object)false);
            this.getView().setVisible(Boolean.FALSE, new String[]{"issofrrate"});
        }
    }

    private void controlRateresetdays() {
        String billTypeNumber = this.getBillTypeNumber();
        if (EmptyUtil.isNoEmpty((String)billTypeNumber)) {
            boolean cfmBIllType = RateBillTypeEnum.isCfmBIllType((String)billTypeNumber);
            if (cfmBIllType) {
                String rateType = (String)this.getModel().getValue("ratetype");
                if (RateTypeEnum.FIXED.getValue().equals(rateType)) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"rateresetdays"});
                } else {
                    String postpositiontype = (String)this.getModel().getValue("postpositiontype");
                    if (PostPositionTypeEnum.isLookback((String)postpositiontype)) {
                        this.getView().setVisible(Boolean.TRUE, new String[]{"rateresetdays"});
                    } else {
                        this.getView().setVisible(Boolean.FALSE, new String[]{"rateresetdays"});
                    }
                }
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"rateresetdays"});
            }
        }
    }

    private void controlAboutRateVisiable() {
        String billTypeNumber = this.getBillTypeNumber();
        if (EmptyUtil.isNoEmpty((String)billTypeNumber)) {
            boolean isShowAboutRate = RateBillTypeEnum.isCfmBIllType((String)billTypeNumber);
            if (isShowAboutRate) {
                this.showAboutRate(Boolean.TRUE);
            } else {
                this.showAboutRate(Boolean.FALSE);
            }
        } else {
            this.showAboutRate(Boolean.FALSE);
        }
    }

    private void controlStagePlanVisiable() {
        HashSet<String> repayWayLSBQ = new HashSet<String>(5);
        repayWayLSBQ.add(RepaymentWayEnum.dqhblsbq.getValue());
        repayWayLSBQ.add(RepaymentWayEnum.dqhbdqhx.getValue());
        repayWayLSBQ.add(RepaymentWayEnum.debx.getValue());
        repayWayLSBQ.add(RepaymentWayEnum.debj.getValue());
        repayWayLSBQ.add(RepaymentWayEnum.dbdx.getValue());
        String billType = this.getBillTypeNumber();
        if (RateBillTypeEnum.isCfmBIllType((String)billType)) {
            String repayWay = (String)this.getModel().getValue("repaymentway");
            if (repayWayLSBQ.contains(repayWay)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"stageplan"});
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"stageplan"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"stageplan"});
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"stageplan"});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"stageplan"});
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"stageplan"});
        }
    }

    private void controlInterestSettledPlanVisiable() {
        String billTypeNumber = this.getBillTypeNumber();
        if (EmptyUtil.isNoEmpty((String)billTypeNumber)) {
            if (RateBillTypeEnum.isCfmBIllType((String)billTypeNumber)) {
                String repayWay = (String)this.getModel().getValue("repaymentway");
                HashSet<String> repayWayLSBQ = new HashSet<String>(5);
                repayWayLSBQ.add(RepaymentWayEnum.bqhbdqhx.getValue());
                repayWayLSBQ.add(RepaymentWayEnum.dqhbdqhx.getValue());
                repayWayLSBQ.add(RepaymentWayEnum.zdyhk.getValue());
                if (repayWayLSBQ.contains(repayWay)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"interestsettledplan"});
                    TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)Boolean.TRUE, (String[])new String[]{"interestsettledplan"});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"interestsettledplan"});
                    TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)Boolean.FALSE, (String[])new String[]{"interestsettledplan"});
                }
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"interestsettledplan"});
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)Boolean.TRUE, (String[])new String[]{"interestsettledplan"});
            }
        }
    }

    private void controlAdjustRule() {
        String billTypeNumber = this.getBillTypeNumber();
        if (EmptyUtil.isNoEmpty((String)billTypeNumber)) {
            if (RateBillTypeEnum.isCfmBIllType((String)billTypeNumber)) {
                this.showAboutAdjustRule(Boolean.TRUE);
            } else {
                this.showAboutAdjustRule(Boolean.FALSE);
            }
        } else {
            this.showAboutAdjustRule(Boolean.FALSE);
        }
    }

    private void showAboutRate(Boolean visible) {
        List<String> aboutRateFields = Arrays.asList("rateadjustdate", "rateadjustcycle", "rateadjustcycletype", "repaymentway", "settleintmode", "iscallcompint", "issofrrate", "calcintway", "lookbacktype", "postpositiontype", "intcalmethod");
        this.getView().setVisible(visible, aboutRateFields.toArray(new String[0]));
    }

    private void showAboutAdjustRule(Boolean visible) {
        List<String> aboutRateFields = Arrays.asList("loanexpireadjustrule", "rateresetadjustrule");
        this.getView().setVisible(visible, aboutRateFields.toArray(new String[0]));
    }

    private ComboItem createComboItem(IntCalMethodEnum intCalMethod) {
        return this.createComboItem(intCalMethod.getValue(), intCalMethod.getName());
    }

    private ComboItem createComboItem(String value, String caption) {
        ComboItem comboItem = new ComboItem();
        comboItem.setValue(value);
        comboItem.setCaption(new LocaleString(caption));
        return comboItem;
    }

    private void initIntCalBox() {
        boolean isNotComp;
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(3);
        String calcIntWay = (String)this.getModel().getValue("calcintway");
        Boolean isCompInt = (Boolean)this.getModel().getValue("iscallcompint");
        boolean bl = isNotComp = CalcIntWayEnum.isForward((String)calcIntWay) || CalcIntWayEnum.isPostposition((String)calcIntWay) && isCompInt == false;
        if (CalcIntWayEnum.isPostposition((String)calcIntWay) && !isNotComp) {
            comboItems.add(this.createComboItem(IntCalMethodEnum.compcallint));
            this.getModel().setValue("intcalmethod", (Object)IntCalMethodEnum.compcallint.getValue());
        } else {
            comboItems.add(this.createComboItem(IntCalMethodEnum.onecallint));
            comboItems.add(this.createComboItem(IntCalMethodEnum.totalcallint));
            comboItems.add(this.createComboItem(IntCalMethodEnum.periodcallint));
            this.getModel().setValue("intcalmethod", (Object)IntCalMethodEnum.totalcallint.getValue());
        }
        ((ComboEdit)this.getControl("intcalmethod")).setComboItems(comboItems);
    }

    private void setCalcintWay() {
        boolean isSofrRate = (Boolean)this.getModel().getValue("issofrrate");
        if (isSofrRate) {
            this.getModel().setValue("calcintway", (Object)CalcIntWayEnum.POSTPOSITION.getValue());
        } else {
            this.getModel().setValue("calcintway", (Object)CalcIntWayEnum.FORWARD.getValue());
        }
    }

    private void initPostpositiontype() {
        String calcIntWay = (String)this.getModel().getValue("calcintway");
        boolean isPostposition = CalcIntWayEnum.isPostposition((String)calcIntWay);
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)isPostposition, (String[])new String[]{"postpositiontype"});
        this.getModel().setValue("postpositiontype", (Object)(isPostposition ? PostPositionTypeEnum.LOOKBACK.getValue() : null));
    }

    private void initLookbacktype() {
        String postpositiontype = (String)this.getModel().getValue("postpositiontype");
        boolean isLookback = PostPositionTypeEnum.isLookback((String)postpositiontype);
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)isLookback, (String[])new String[]{"lookbacktype"});
        this.getModel().setValue("lookbacktype", (Object)(isLookback ? LookBackTypeEnum.NOOBSERVE.getValue() : null));
    }

    private void setMustForInterest() {
        String billTypeNumber = this.getBillTypeNumber();
        if (EmptyUtil.isNoEmpty((String)billTypeNumber)) {
            boolean isShowAboutRate = RateBillTypeEnum.isCfmBIllType((String)billTypeNumber);
            if (isShowAboutRate) {
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"calcintway", "intcalmethod"});
                String calcIntWay = (String)this.getModel().getValue("calcintway");
                boolean isPostposition = CalcIntWayEnum.isPostposition((String)calcIntWay);
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)isPostposition, (String[])new String[]{"postpositiontype"});
                String postpositiontype = (String)this.getModel().getValue("postpositiontype");
                boolean isLookback = PostPositionTypeEnum.isLookback((String)postpositiontype);
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)isLookback, (String[])new String[]{"lookbacktype"});
            } else {
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"calcintway", "postpositiontype", "lookbacktype"});
            }
        }
    }

    private void setMustForAdjustRule() {
        String billTypeNumber = this.getBillTypeNumber();
        if (EmptyUtil.isNoEmpty((String)billTypeNumber)) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)RateBillTypeEnum.isCfmBIllType((String)billTypeNumber), (String[])new String[]{"loanexpireadjustrule", "rateresetadjustrule"});
        }
    }

    private void setDefaultRateresetdays() {
        String calcintway = (String)this.getModel().getValue("calcintway");
        String postpositiontype = (String)this.getModel().getValue("postpositiontype");
        if (CalcIntWayEnum.isPostposition((String)calcintway) && PostPositionTypeEnum.isLookback((String)postpositiontype)) {
            this.getModel().setValue("rateresetdays", (Object)5);
        } else {
            this.getModel().setValue("rateresetdays", (Object)0);
        }
    }
}

