/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.formplugin.predict;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcListPlugin;
import kd.tmc.mrm.common.enums.AnalysisObjTypeEnum;
import kd.tmc.mrm.common.enums.RateBillTypeEnum;

public class PredictDataList
extends AbstractTmcListPlugin
implements BeforeFilterF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        FilterContainer filterContainer = (FilterContainer)this.getView().getControl("filtercontainerap");
        filterContainer.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent event) {
        String fieldName = event.getFieldName();
        if ("billtype.number".equals(fieldName) || "billtype.name".equals(fieldName)) {
            List qfilters = event.getQfilters();
            qfilters.add(new QFilter("number", "in", (Object)RateBillTypeEnum.getValues().stream().filter(e -> !e.equals("bei_bankbalance") && !e.equals("ifm_accountbalance")).toArray()));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if ("buildobj".equals(operateKey)) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            ArrayList<Long> selectedIdList = new ArrayList<Long>(selectedRows.size());
            if (!selectedRows.isEmpty()) {
                for (ListSelectedRow listSelectedRowValue : selectedRows) {
                    selectedIdList.add((Long)listSelectedRowValue.getPrimaryKeyValue());
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9884\u6d4b\u4e1a\u52a1\u6570\u636e\u518d\u6784\u5efa\u5bf9\u8c61\u3002", (String)"PredictDataList_1", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
                return;
            }
            Long rateDraftId = 0L;
            BillShowParameter parameter = new BillShowParameter();
            parameter.setCustomParam("ratedraft", (Object)rateDraftId);
            parameter.setCustomParam("ratedraftid", selectedIdList);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setFormId("mrm_analysisobj");
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "buildobj"));
            parameter.setCaption(ResManager.loadKDString((String)"\u6784\u5efa\u5206\u6790\u5bf9\u8c61", (String)"PredictDataList_2", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
            this.getView().showForm((FormShowParameter)parameter);
        }
        if ("addobj".equals(operateKey)) {
            if (EmptyUtil.isEmpty((Collection)this.getSelectedIdList())) {
                return;
            }
            Long rateDraftId = 0L;
            QFilter qFilter = new QFilter("scheme", "=", (Object)0L).or("scheme", "is null", null).and("objtype", "=", (Object)AnalysisObjTypeEnum.FUTURE.getValue()).and(new QFilter("draftid", "=", (Object)rateDraftId).or("draftid", "=", (Object)0L).or("draftid", "is null", null));
            ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"mrm_analysisobj", (boolean)false, (int)1, (boolean)true);
            ListFilterParameter filterParameter = new ListFilterParameter();
            filterParameter.setFilter(qFilter);
            parameter.setListFilterParameter(filterParameter);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addobj"));
            parameter.setCaption(ResManager.loadKDString((String)"\u52a0\u5165\u5206\u6790\u5bf9\u8c61", (String)"PredictDataList_3", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
            parameter.setFormId("bos_listf7");
            parameter.setMustInput(true);
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object rtn = e.getReturnData();
        if (rtn != null && "addobj".equals(e.getActionId())) {
            List selectedIdList = this.getSelectedIdList();
            Long rateDraftId = 0L;
            DynamicObject rateDraft = BusinessDataServiceHelper.loadSingle((String)"mrm_rate_draft", (String)"billno,draftcreatetime", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)rateDraftId)});
            String props = String.join((CharSequence)",", "modifytime", "draftdatabillno", "drafttime", "draftid", "draftdataentry.seq", "draftno");
            DynamicObject analysisObj = BusinessDataServiceHelper.loadSingle((Object)((ListSelectedRowCollection)rtn).get(0).getPrimaryKeyValue(), (String)"mrm_analysisobj", (String)props);
            if (rateDraft != null) {
                analysisObj.set("drafttime", rateDraft.get("draftcreatetime"));
                analysisObj.set("draftno", rateDraft.get("billno"));
                analysisObj.set("draftid", (Object)rateDraft.getLong("id"));
            }
            Set idSet = analysisObj.getDynamicObjectCollection("draftdataentry").stream().map(o -> {
                if (o.getDynamicObject("draftdatabillno") != null) {
                    return o.getDynamicObject("draftdatabillno").getLong("id");
                }
                return null;
            }).collect(Collectors.toSet());
            Set addSet = selectedIdList.stream().filter(o -> !idSet.contains(o)).collect(Collectors.toSet());
            Optional<Integer> seqOptional = analysisObj.getDynamicObjectCollection("draftdataentry").stream().map(o -> o.getInt("seq")).reduce(Integer::max);
            int seq = seqOptional.orElse(0);
            for (Long selectedId : addSet) {
                DynamicObject row = analysisObj.getDynamicObjectCollection("draftdataentry").addNew();
                row.set("draftdatabillno", (Object)selectedId);
                row.set("seq", (Object)(++seq));
            }
            analysisObj.set("modifytime", (Object)new Date());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{analysisObj});
            if (addSet.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u6570\u636e\u90fd\u5df2\u7ecf\u52a0\u5165\u8fc7\u6240\u9009\u7684\u5206\u6790\u5bf9\u8c61\uff0c\u4e0d\u8981\u91cd\u590d\u52a0\u5165\u3002", (String)"PredictDataList_4", (String)"tmc-mrm-formplugin", (Object[])new Object[]{selectedIdList.size() - addSet.size()}));
            } else if (selectedIdList.size() > addSet.size()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728%s\u6761\u91cd\u590d\u6570\u636e\uff0c\u5df2\u5bf9\u91cd\u590d\u6570\u636e\u5254\u9664\u3002", (String)"PredictDataList_5", (String)"tmc-mrm-formplugin", (Object[])new Object[]{selectedIdList.size() - addSet.size()}));
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u52a0\u5165\u6210\u529f\u3002", (String)"PredictDataList_6", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        qFilters.add(QFilter.isNull((String)"ratedraft").or("ratedraft", "=", (Object)0));
        qFilters.add(new QFilter("predict", "=", (Object)true));
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        String fieldName = args.getFieldName();
        if ("billtype.name".equals(fieldName)) {
            List qFilters = args.getQFilters();
            qFilters.add(new QFilter("number", "in", (Object)RateBillTypeEnum.getValues().stream().filter(e -> !e.equals("bei_bankbalance") && !e.equals("ifm_accountbalance")).toArray()));
        }
    }
}

