/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.formplugin.rateopen;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.AmountEdit;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeF7ViewDetailEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;
import kd.tmc.mrm.business.service.rateopen.GapAnalysisModel;
import kd.tmc.mrm.common.enums.AnalysisObjTypeEnum;
import kd.tmc.mrm.common.helper.GapAnalysisHelper;
import kd.tmc.mrm.common.helper.OrgHelper;
import kd.tmc.mrm.common.model.section.SectionCfgModel;
import kd.tmc.mrm.formplugin.common.OperationResultHelper;

public class GapAnalysisEdit
extends AbstractTmcBillEdit
implements BeforeF7SelectListener {
    private static final String AMOUNT = "amount";
    private static final int MAX_AMT_ROW_COUNT = 50;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit orgView = (BasedataEdit)this.getView().getControl("orgview");
        orgView.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit org = (BasedataEdit)this.getView().getControl("orgs");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit subjects = (BasedataEdit)this.getView().getControl("subjects");
        subjects.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit forexquote = (BasedataEdit)this.getView().getControl("forexquote");
        Optional.ofNullable(forexquote).ifPresent(c -> c.addBeforeF7ViewDetailListener(this::beforeF7ViewDetail));
        BasedataEdit counterPartyOrgs = (BasedataEdit)this.getView().getControl("counterpartyorgs");
        counterPartyOrgs.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit analysisObj = (BasedataEdit)this.getView().getControl("currentanalysisobj");
        analysisObj.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit futureAnalysisObj = (BasedataEdit)this.getView().getControl("futureanalysisobj");
        futureAnalysisObj.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        long id = DBServiceHelper.genGlobalLongId();
        this.getModel().setValue("id", (Object)id);
        this.getView().setVisible(Boolean.FALSE, new String[]{"buttonpanel", "gapanalysisentity"});
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        long id = DBServiceHelper.genGlobalLongId();
        this.getModel().setValue("id", (Object)id);
        this.getView().setVisible(Boolean.FALSE, new String[]{"buttonpanel", "gapanalysisentity"});
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        String titleStr = (String)this.getModel().getValue("amtcolumntitles");
        if (titleStr.contains("_")) {
            this.changedPropsTip();
            this.refreshReport();
            this.getModel().setDataChanged(false);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7248\u672c\u5347\u7ea7\u540e\uff0c\u5bf9\u4e8e\u5386\u53f2\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u8ba1\u7b97\u83b7\u53d6\u62a5\u8868\u7ed3\u679c\u3002", (String)"ExRateGapAnalysisEdit_4", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.FALSE, new String[]{"buttonpanel", "gapanalysisentity"});
        }
    }

    private void changedPropsTip() {
        List list = GapAnalysisHelper.getChangedProps((DynamicObject)this.getModel().getDataEntity());
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                String prop = (String)list.get(i);
                list.set(i, "\u201c" + prop + "\u201d");
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"%s\u5df2\u53d1\u751f\u53d8\u52a8\uff0c\u8bf7\u91cd\u65b0\u8ba1\u7b97\u83b7\u53d6\u6700\u65b0\u7ed3\u679c\u3002", (String)"GapAnalysisEdit_11", (String)"tmc-mrm-formplugin", (Object[])new Object[]{String.join((CharSequence)"\u3001", list)}));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName;
        super.propertyChanged(e);
        switch (propertyName = e.getProperty().getName()) {
            case "orgview": {
                long orgViewId = 0L;
                DynamicObject orgView = (DynamicObject)this.getModel().getValue("orgview");
                if (EmptyUtil.isNoEmpty((DynamicObject)orgView)) {
                    orgViewId = orgView.getLong("id");
                }
                if (orgViewId != 0L) {
                    Long permRootOrgId = TmcOrgDataHelper.getPermRootOrgId((Long)RequestContext.get().getCurrUserId(), (String)this.getView().getFormShowParameter().getAppId(), (String)this.getModel().getDataEntity().getDynamicObjectType().getName(), (String)"47150e89000000ac", (Long)orgViewId);
                    if (EmptyUtil.isNoEmpty((Long)permRootOrgId)) {
                        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"orgs", (Object)new Object[]{permRootOrgId});
                        this.getPageCache().put("orgs", String.valueOf(permRootOrgId));
                    } else {
                        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"orgs", null);
                        this.getPageCache().put("orgs", null);
                    }
                }
                if (!EmptyUtil.isNoEmpty((Object)this.getModel().getValue("amtunit")) || BillOperationStatus.ADDNEW == ((BillShowParameter)this.getView().getFormShowParameter()).getBillStatus()) break;
                this.refreshReport();
                break;
            }
            case "amtunit": 
            case "currency": 
            case "referencerate": 
            case "orgs": 
            case "iscalcbalance_ext": 
            case "subjects": {
                if (!EmptyUtil.isNoEmpty((Object)this.getModel().getValue("amtunit")) || BillOperationStatus.ADDNEW == ((BillShowParameter)this.getView().getFormShowParameter()).getBillStatus()) break;
                this.refreshReport();
                break;
            }
            case "counterpartytype": {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"counterpartyfinorgs", null);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"counterpartybizpartners", null);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"counterpartyorgs", null);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"counterpartyother", (Object)"");
                break;
            }
            case "subjectsystem": {
                this.getModel().setValue("subjects", null);
                break;
            }
            case "currentanalysisobj": {
                this.setDraft();
                break;
            }
        }
    }

    private void setDraft() {
        DynamicObject analysisObj = (DynamicObject)this.getModel().getValue("currentanalysisobj");
        if (analysisObj != null) {
            DynamicObject draft = analysisObj.getDynamicObject("draft");
            this.getModel().setValue("draft", (Object)draft);
            this.getView().updateView("draftdateprop");
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String property = evt.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        switch (property) {
            case "orgview": {
                DataSet ds = TmcOrgDataHelper.getAuthorizedBankOrgViewDataSet((Long)RequestContext.get().getCurrUserId());
                HashSet<Long> ids = new HashSet<Long>(16);
                if (ds != null) {
                    while (ds.hasNext()) {
                        ids.add(ds.next().getLong("id"));
                    }
                }
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", ids));
                break;
            }
            case "orgs": {
                List orgIds;
                String appId = this.getView().getFormShowParameter().getAppId();
                List<Object> list = orgIds = OrgHelper.getPermOrgIds(null, null, (String)((MulBasedataProp)((MulBasedataEdit)this.getView().getControl("orgs")).getProperty()).getOrgFunc(), (String)appId, (String)"mrm_gap_analysis");
                DynamicObject orgView = (DynamicObject)this.getModel().getValue("orgview");
                if (orgView != null) {
                    Long orgViewId = orgView.getLong("id");
                    String rootOrgId = this.getPageCache().get("orgs");
                    if (EmptyUtil.isNoEmpty((String)rootOrgId)) {
                        List allOrgIds = TmcOrgDataHelper.getAllSubordinateOrgs((Long)orgViewId, Collections.singletonList(Long.valueOf(rootOrgId)), (boolean)true, (boolean)false);
                        allOrgIds.add(Long.valueOf(rootOrgId));
                        list = orgIds == null ? allOrgIds : orgIds.stream().filter(allOrgIds::contains).collect(Collectors.toList());
                    } else {
                        list.clear();
                    }
                }
                if (list == null) break;
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)list));
                break;
            }
            case "subjects": {
                List<Object> subjectIds = this.getSubjectIds();
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", subjectIds));
                break;
            }
            case "counterpartyorgs": {
                showParameter.setCustomParam("orgViewSchemeNumber", (Object)OrgViewTypeEnum.IS_BANKROLL.getViewType());
                List orgIds = OrgHelper.getPermOrgIds(null, null, (String)OrgViewTypeEnum.IS_BANKROLL.getViewType(), (String)this.getView().getFormShowParameter().getAppId(), (String)"mrm_gap_analysis");
                if (orgIds == null) break;
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)orgIds));
                break;
            }
            case "currentanalysisobj": 
            case "futureanalysisobj": {
                List orgIds = OrgHelper.getPermOrgIds(null, null, (String)OrgViewTypeEnum.IS_BANKROLL.getViewType(), (String)this.getView().getFormShowParameter().getAppId(), (String)"mrm_analysisobj");
                if (orgIds == null) break;
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("org", "in", (Object)orgIds));
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        if ("bar_repricegap".equals(key)) {
            DynamicObjectCollection futureanalysisobj = this.getModel().getDataEntity().getDynamicObjectCollection("futureanalysisobj");
            int size = futureanalysisobj.size();
            if (size > 6) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u6d4b\u4e1a\u52a1\u5206\u6790\u5bf9\u8c61\u6700\u591a\u53ef\u9009\u62e96\u4e2a\u3002", (String)"GapAnalysisEdit_8", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObject analysisObj = (DynamicObject)this.getModel().getValue("currentanalysisobj");
            if (analysisObj != null && !AnalysisObjTypeEnum.CURRENT.getValue().equals(analysisObj.get("objtype"))) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6240\u9009\u7684\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"GapAnalysisEdit_24", (String)"tmc-mrm-formplugin", (Object[])new Object[0]), ((IDataEntityProperty)this.getModel().getDataEntity().getDataEntityType().getProperties().get((Object)"currentanalysisobj")).getDisplayName().getLocaleValue(), ((IDataEntityProperty)analysisObj.getDataEntityType().getProperties().get((Object)"objtype")).getDisplayName().getLocaleValue()));
                args.setCancel(true);
                return;
            }
            for (DynamicObject e : futureanalysisobj) {
                DynamicObject obj = e.getDynamicObject("fbasedataid");
                if (AnalysisObjTypeEnum.FUTURE.getValue().equals(obj.get("objtype"))) continue;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6240\u9009\u7684\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"GapAnalysisEdit_24", (String)"tmc-mrm-formplugin", (Object[])new Object[0]), ((IDataEntityProperty)this.getModel().getDataEntity().getDataEntityType().getProperties().get((Object)"futureanalysisobj")).getDisplayName().getLocaleValue(), ((IDataEntityProperty)obj.getDataEntityType().getProperties().get((Object)"objtype")).getDisplayName().getLocaleValue()));
                args.setCancel(true);
                return;
            }
        }
        if ("exportentry".equals(key)) {
            int entryRowCount = this.getModel().getEntryRowCount("gapanalysisentity");
            int[] a = new int[entryRowCount];
            for (int i = 0; i < entryRowCount; ++i) {
                a[i] = i;
            }
            TreeEntryGrid treeGrid = (TreeEntryGrid)this.getView().getControl("gapanalysisentity");
            treeGrid.selectRows(a, 0);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        if ("bar_repricegap".equals(key)) {
            this.validateMustInput("billno");
            this.validateMustInput("reportcurrency");
            this.validateMustInput("forexquote");
            this.validateMustInput("subjectsystem");
            this.validateMustInput("sectioncfg");
            this.validateMustInput("currentanalysisobj");
            this.validateMustInput("amtunit");
            this.setDraft();
            this.analysis();
        }
        if ("save".equals(key) && e.getOperationResult().isSuccess()) {
            this.refreshReport();
        }
        if ("viewreportdetail".equals(key) && e.getOperationResult().isSuccess()) {
            GapAnalysisHelper.showGapAnalysisDetail((IFormView)this.getView(), null);
        }
    }

    private void validateMustInput(String key) {
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue(key))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c%s\u201d\u3002", (String)"GapAnalysisEdit_22", (String)"tmc-mrm-formplugin", (Object[])new Object[]{this.getModel().getProperty(key).getDisplayName().getLocaleValue()}));
        }
    }

    private void analysis() {
        this.getModel().setValue("entrycurrency", this.getModel().getValue("reportcurrency"));
        DynamicObject subjectSystem = this.queryFullSubjectSystemInfo();
        DynamicObject analysisObj = this.setObjModifyTime();
        GapAnalysisModel gapAnalysisModel = new GapAnalysisModel(this.getModel().getDataEntity(), analysisObj, subjectSystem, this.getView().getFormShowParameter().getAppId());
        try {
            gapAnalysisModel.analysis();
        }
        catch (Exception e) {
            DynamicObject[] gapAnalysisQingDataBills = (DynamicObject[])gapAnalysisModel.getGapAnalysisDetails().values().stream().toArray(DynamicObject[]::new);
            Object[] pIds = Arrays.stream(gapAnalysisQingDataBills).map(o -> o.get("id")).toArray();
            DeleteServiceHelper.delete((String)"mrm_gap_analysis_detail_e", (QFilter[])new QFilter[]{new QFilter("pid", "in", (Object)pIds)});
            throw e;
        }
        this.getModel().setValue("amtcolumntitles", (Object)String.join((CharSequence)"_", gapAnalysisModel.getTitles()));
        this.saveResult(gapAnalysisModel);
    }

    private DynamicObject queryFullSubjectSystemInfo() {
        this.validateMustInput("subjectsystem");
        return BusinessDataServiceHelper.loadSingleFromCache((Object)((DynamicObject)this.getModel().getValue("subjectsystem")).getPkValue(), (String)"mrm_subject_system");
    }

    private DynamicObject setObjModifyTime() {
        this.getModel().setValue("forexquotetime", ((DynamicObject)this.getModel().getValue("forexquote")).get("modifytime"));
        this.getModel().setValue("subjectsystemtime", ((DynamicObject)this.getModel().getValue("subjectsystem")).get("modifytime"));
        this.getModel().setValue("sectioncfgtime", ((DynamicObject)this.getModel().getValue("sectioncfg")).get("modifytime"));
        DynamicObject analysisObj = (DynamicObject)this.getModel().getValue("currentanalysisobj");
        analysisObj = BusinessDataServiceHelper.loadSingle((Object)analysisObj.getPkValue(), (String)"mrm_analysisobj");
        DynamicObject draft = (DynamicObject)this.getModel().getValue("draft");
        if (draft == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u5206\u6790\u5bf9\u8c61\u91cc\u7684%s\u4e3a\u7a7a\u3002", (String)"GapAnalysisEdit_23", (String)"tmc-mrm-formplugin", (Object[])new Object[]{((IDataEntityProperty)analysisObj.getDataEntityType().getProperties().get((Object)"draft")).getDisplayName().getLocaleValue()}));
        }
        this.getModel().setValue("currentanalysisobjtime", analysisObj.get("modifytime"));
        this.getModel().setValue("drafttime", draft.get("modifytime"));
        this.getModel().deleteEntryData("entryentity");
        DynamicObjectCollection futureAnalysisObjCol = (DynamicObjectCollection)this.getModel().getValue("futureanalysisobj");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)futureAnalysisObjCol)) {
            for (DynamicObject futureAnalysisObj : futureAnalysisObjCol) {
                int index = this.getModel().createNewEntryRow("entryentity");
                this.getModel().setValue("e_futureanalysisobj", (Object)futureAnalysisObj.getDynamicObject("fbasedataid"), index);
                this.getModel().setValue("e_futureanalysisobjtime", futureAnalysisObj.getDynamicObject("fbasedataid").get("modifytime"), index);
            }
        }
        return analysisObj;
    }

    private void saveResult(GapAnalysisModel gapAnalysisModel) {
        DynamicObject[] gapAnalysisQingDataBills;
        for (DynamicObject gapAnalysisQingDataBill : gapAnalysisQingDataBills = (DynamicObject[])gapAnalysisModel.getGapAnalysisDetails().values().stream().toArray(DynamicObject[]::new)) {
            gapAnalysisQingDataBill.set("srcbillid", this.getModel().getValue("id"));
        }
        try (TXHandle tx = TX.requiresNew();){
            try {
                if (EmptyUtil.isNoEmpty((Object)this.getModel().getValue("id"))) {
                    DeleteServiceHelper.delete((String)"mrm_gap_analysis_detail", (QFilter[])new QFilter[]{new QFilter("srcbillid", "=", this.getModel().getValue("id"))});
                }
                SaveServiceHelper.save((DynamicObject[])gapAnalysisQingDataBills);
                OperationResult saveOpResult = this.getView().invokeOperation("save");
                if (!saveOpResult.isSuccess()) {
                    StringBuilder errorMsg = OperationResultHelper.getErrorMsg(saveOpResult);
                    throw new KDBizException(errorMsg.toString());
                }
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
        catch (Exception e) {
            Object[] pIds = Arrays.stream(gapAnalysisQingDataBills).map(o -> o.get("id")).toArray();
            DeleteServiceHelper.delete((String)"mrm_gap_analysis_detail_e", (QFilter[])new QFilter[]{new QFilter("pid", "in", (Object)pIds)});
            throw e;
        }
    }

    private void refreshReport() {
        boolean isExistData = this.generateReport();
        if (!isExistData) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"buttonpanel", "gapanalysisentity"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"noreportdatapanel", "nochartdatapanel"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"buttonpanel", "gapanalysisentity"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"noreportdatapanel", "nochartdatapanel"});
        }
    }

    private boolean generateReport() {
        String appId = this.getView().getFormShowParameter().getAppId();
        GapAnalysisModel gapAnalysisModel = new GapAnalysisModel(this.getModel().getDataEntity().getPkValue(), appId);
        boolean isExistData = gapAnalysisModel.queryResult(this.getModel().getDataEntity(), appId);
        if (isExistData) {
            this.generateReport(gapAnalysisModel);
        }
        this.getModel().setDataChanged(false);
        return isExistData;
    }

    private void generateReport(GapAnalysisModel gapAnalysisModel) {
        Map subjectId2SubjectName = gapAnalysisModel.getSubjectId2SubjectName();
        ArrayList<Integer> totalRowIndexList = new ArrayList<Integer>();
        BigDecimal amtUnit = new BigDecimal((String)this.getModel().getValue("amtunit"));
        this.getModel().deleteEntryData("gapanalysisentity");
        HashSet<Long> processedSubjects = new HashSet<Long>(8);
        for (DynamicObject row : gapAnalysisModel.getSubjectSystem().getDynamicObjectCollection("subjecttreeentry")) {
            List subSubjectIds;
            Long subjectId = row.getDynamicObject("subject").getLong("id");
            String subjectIdStr = String.valueOf(subjectId);
            if (!processedSubjects.contains(subjectId)) {
                BigDecimal[] amounts = (BigDecimal[])gapAnalysisModel.getResultData().get(subjectId);
                if (amounts == null) continue;
                int index = this.getModel().createNewEntryRow("gapanalysisentity");
                totalRowIndexList.add(index);
                this.getModel().setValue("subjectname", (Object)subjectIdStr, index);
                for (int i = 0; i < amounts.length; ++i) {
                    this.getModel().setValue(AMOUNT + (i + 1), (Object)this.divide(amounts[i], amtUnit), index);
                }
                Optional<BigDecimal> optional = Arrays.stream(amounts).filter(Objects::nonNull).reduce(BigDecimal::add);
                BigDecimal totalAmt = optional.orElse(null);
                this.getModel().setValue("totalamt", (Object)this.divide(totalAmt, amtUnit), index);
                processedSubjects.add(subjectId);
            }
            if ((subSubjectIds = (List)gapAnalysisModel.getSubSubjectsMap().get(subjectId)) == null) continue;
            int parentIndex = -1;
            for (int i = 0; i < this.getModel().getEntryEntity("gapanalysisentity").size(); ++i) {
                if (!subjectIdStr.equals(this.getModel().getValue("subjectname", i))) continue;
                parentIndex = i;
                break;
            }
            if (parentIndex == -1) continue;
            for (Long subSubjectId : subSubjectIds) {
                if (processedSubjects.contains(subSubjectId)) continue;
                String subSubjectIdStr = String.valueOf(subSubjectId);
                int childIndex = this.getModel().insertEntryRow("gapanalysisentity", parentIndex);
                this.getModel().setValue("subjectname", (Object)subSubjectIdStr, childIndex);
                BigDecimal[] amounts = (BigDecimal[])gapAnalysisModel.getResultData().get(subSubjectId);
                for (int i = 0; i < amounts.length; ++i) {
                    this.getModel().setValue(AMOUNT + (i + 1), (Object)this.divide(amounts[i], amtUnit), childIndex);
                }
                Optional<BigDecimal> optional = Arrays.stream(amounts).filter(Objects::nonNull).reduce(BigDecimal::add);
                BigDecimal totalAmt = optional.orElse(null);
                this.getModel().setValue("totalamt", (Object)this.divide(totalAmt, amtUnit), childIndex);
                processedSubjects.add(subSubjectId);
            }
        }
        for (int i = 0; i < this.getModel().getEntryRowCount("gapanalysisentity"); ++i) {
            String subjectIdStr = (String)this.getModel().getValue("subjectname", i);
            String subjectName = (String)subjectId2SubjectName.get(Long.valueOf(subjectIdStr));
            this.getModel().setValue("subjectname", (Object)subjectName, i);
        }
        this.setValue_totalRow(gapAnalysisModel, amtUnit, totalRowIndexList);
        TreeEntryGrid treeGrid = (TreeEntryGrid)this.getView().getControl("gapanalysisentity");
        int[] totalRowIndexArray = totalRowIndexList.stream().mapToInt(Integer::valueOf).toArray();
        treeGrid.expand(totalRowIndexArray);
        treeGrid.setRowBackcolor("rgba(153,217,43,0.07)", totalRowIndexArray);
        this.dealColumns(gapAnalysisModel.getTitles());
    }

    private BigDecimal divide(BigDecimal amount, BigDecimal amtUnit) {
        if (amount == null) {
            return null;
        }
        return amount.divide(amtUnit, 2, RoundingMode.HALF_UP);
    }

    private void setValue_totalRow(GapAnalysisModel gapAnalysisModel, BigDecimal amtUnit, List<Integer> totalRowIndexList) {
        Map resultData = gapAnalysisModel.getResultData();
        Long totalRowSubjectId = gapAnalysisModel.getTotalRowSubjectId();
        int index = this.getModel().createNewEntryRow("gapanalysisentity");
        totalRowIndexList.add(index);
        this.getModel().setValue("subjectname", gapAnalysisModel.getSubjectId2SubjectName().get(totalRowSubjectId), index);
        BigDecimal[] amounts = (BigDecimal[])resultData.get(totalRowSubjectId);
        for (int i = 0; i < amounts.length; ++i) {
            this.getModel().setValue(AMOUNT + (i + 1), (Object)this.divide(amounts[i], amtUnit), index);
        }
        Optional<BigDecimal> optional = Arrays.stream(amounts).filter(Objects::nonNull).reduce(BigDecimal::add);
        BigDecimal totalAmt = optional.orElse(null);
        this.getModel().setValue("totalamt", (Object)this.divide(totalAmt, amtUnit), index);
    }

    private void dealColumns(String[] titles) {
        String[] showColumnKeys = new String[titles.length];
        for (int i = 1; i <= titles.length; ++i) {
            ((AmountEdit)this.getView().getControl(AMOUNT + i)).setCaption(new LocaleString(SectionCfgModel.generateTitlesName((String)titles[i - 1])));
            showColumnKeys[i - 1] = AMOUNT + i;
        }
        this.getView().setVisible(Boolean.TRUE, showColumnKeys);
        if (50 > titles.length) {
            String[] hiddenColumnKeys = new String[50 - titles.length];
            for (int i = titles.length + 1; i <= 50; ++i) {
                hiddenColumnKeys[i - titles.length - 1] = AMOUNT + i;
            }
            this.getView().setVisible(Boolean.FALSE, hiddenColumnKeys);
        }
    }

    private void beforeF7ViewDetail(BeforeF7ViewDetailEvent event) {
        Object pkId = event.getPkId();
        BasedataEdit source = (BasedataEdit)event.getSource();
        String key = source.getKey();
        if ("forexquote".equals(key)) {
            event.setCancel(true);
            BillShowParameter billShowParameter = new BillShowParameter();
            String formid = "md_forexquote";
            billShowParameter.setFormId(formid);
            billShowParameter.setPkId(pkId);
            billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            billShowParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)billShowParameter);
        }
    }

    private List<Object> getSubjectIds() {
        DynamicObject subjectSystem = this.queryFullSubjectSystemInfo();
        ArrayList<Object> subjectIds = new ArrayList<Object>(6);
        for (DynamicObject subjectTreeEntryRow : subjectSystem.getDynamicObjectCollection("subjecttreeentry")) {
            if (!subjectTreeEntryRow.getBoolean("isleaf")) continue;
            Object id = subjectTreeEntryRow.getDynamicObject("subject").getPkValue();
            subjectIds.add(id);
        }
        return subjectIds;
    }
}

