/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.formplugin.rateopen;

import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ChartClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mrm.common.helper.GapAnalysisHelper;
import kd.tmc.mrm.common.model.section.SectionCfgModel;

public class GapAnalysisHistogramChartPlugin
extends AbstractBillPlugIn
implements TabSelectListener {
    private static final String CHART_PROP = "histogramChart";
    private static final String EMPTY_CHART_PANEL = "emptychartpanel";
    private static final String CHART_PANEL = "chartpanel";
    List<String> categories;
    private BigDecimal[] in;
    private BigDecimal[] out;
    private BigDecimal[] net;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ((Tab)this.getView().getControl("tabAp")).addTabSelectListener((TabSelectListener)this);
        this.addClickListeners(new String[]{CHART_PROP});
        this.addClickListeners(new String[]{"sum"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{CHART_PANEL});
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{CHART_PANEL});
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.refreshChart();
    }

    public void tabSelected(TabSelectEvent e) {
        this.refreshChart();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName;
        super.propertyChanged(e);
        switch (propertyName = e.getProperty().getName()) {
            case "amtunit": 
            case "currency": 
            case "referencerate": 
            case "orgview": 
            case "orgs": 
            case "iscalcbalance_ext": 
            case "subjects": {
                if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{this.getModel().getValue("amtunit")})) break;
                this.refreshChart();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("save".equals(e.getOperateKey())) {
            this.refreshChart();
        }
    }

    private void refreshChart() {
        String[] titles;
        if (BillOperationStatus.ADDNEW == ((BillShowParameter)this.getView().getFormShowParameter()).getBillStatus() || !"tabPageChart".equalsIgnoreCase(((Tab)this.getView().getControl("tabAp")).getCurrentTab())) {
            return;
        }
        String titleStr = (String)this.getModel().getValue("amtcolumntitles");
        if (!titleStr.contains("_")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{EMPTY_CHART_PANEL});
            this.getView().setVisible(Boolean.FALSE, new String[]{CHART_PANEL});
            return;
        }
        if (!RequestContext.get().getTraceId().equals(this.getView().getFormShowParameter().getCustomParam("currentRequestTraceId"))) {
            GapAnalysisHelper.queryAndCacheGapChartData((IFormView)this.getView());
        }
        if ("YES".equals(this.getView().getFormShowParameter().getCustomParam("EmptyChartData"))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{EMPTY_CHART_PANEL});
            this.getView().setVisible(Boolean.FALSE, new String[]{CHART_PANEL});
            return;
        }
        this.categories = new ArrayList<String>(10);
        for (String title : titles = titleStr.split("_")) {
            this.categories.add(SectionCfgModel.generateTitlesName((String)title));
        }
        this.in = (BigDecimal[])this.getView().getFormShowParameter().getCustomParam("inArr");
        this.out = (BigDecimal[])this.getView().getFormShowParameter().getCustomParam("outArr");
        this.net = (BigDecimal[])this.getView().getFormShowParameter().getCustomParam("arr");
        HistogramChart chart = (HistogramChart)this.getControl(CHART_PROP);
        this.setStyle(chart);
        chart.clearData();
        this.createYAxis(chart);
        this.createXAxis(chart);
        this.setData(chart);
        this.getView().setVisible(Boolean.TRUE, new String[]{CHART_PANEL});
        this.getView().setVisible(Boolean.FALSE, new String[]{EMPTY_CHART_PANEL});
    }

    private void setStyle(HistogramChart chart) {
        chart.setMargin(Position.left, "30px");
        chart.setMargin(Position.right, "120px");
        chart.setMargin(Position.top, "22px");
        chart.setMargin(Position.bottom, "22px");
        chart.setShowLegend(true);
        chart.setLegendPropValue("itemWidth", (Object)10);
        chart.setLegendPropValue("itemHeight", (Object)10);
        chart.setLegendAlign(XAlign.center, YAlign.top);
        chart.setLegendVertical(false);
        chart.setShowTooltip(true);
    }

    private void createYAxis(HistogramChart chart) {
        Axis xAxis = chart.createXAxis("", AxisType.category);
        xAxis.setCategorys(this.categories);
        xAxis.setPropValue("nameGap", (Object)"5");
        HashMap<String, Object> axisLabel = new HashMap<String, Object>();
        axisLabel.put("rotate", "-15");
        axisLabel.put("inside", false);
        axisLabel.put("margin", "6");
        xAxis.setPropValue("axisLabel", axisLabel);
        HashMap<String, Constable> axisTick = new HashMap<String, Constable>();
        axisTick.put("interval", Integer.valueOf(0));
        axisTick.put("show", Boolean.valueOf(false));
        xAxis.setPropValue("axisTick", axisTick);
        this.setLineColor(xAxis);
    }

    private void createXAxis(HistogramChart chart) {
        Axis yAxis = chart.createYAxis("", AxisType.value);
        yAxis.setPropValue("nameGap", (Object)"5");
        HashMap<String, int[]> map = new HashMap<String, int[]>();
        map.put("padding", new int[]{0, 0, 5, -45});
        yAxis.setPropValue("nameTextStyle", map);
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>();
        axisTick.put("show", false);
        yAxis.setPropValue("axisTick", axisTick);
        HashMap splitLine = new HashMap();
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        yAxis.setPropValue("splitLine", splitLine);
        this.setLineColor(yAxis);
    }

    private void setData(HistogramChart chart) {
        BarSeries barSeries1 = this.createBarSeries(chart, ResManager.loadKDString((String)"\u6d41\u5165", (String)"GapAnalysisHistogramChartPlugin_0", (String)"tmc-mrm-formplugin", (Object[])new Object[0]), "#20A7F0");
        barSeries1.setData((Number[])this.in);
        BarSeries barSeries2 = this.createBarSeries(chart, ResManager.loadKDString((String)"\u6d41\u51fa", (String)"GapAnalysisHistogramChartPlugin_1", (String)"tmc-mrm-formplugin", (Object[])new Object[0]), "#45DAD1");
        barSeries2.setData((Number[])this.out);
        BarSeries barSeries3 = this.createBarSeries(chart, ResManager.loadKDString((String)"\u7f3a\u53e3", (String)"GapAnalysisHistogramChartPlugin_2", (String)"tmc-mrm-formplugin", (Object[])new Object[0]), "#A0D911");
        barSeries3.setData((Number[])this.net);
        chart.bindData(null);
    }

    private BarSeries createBarSeries(HistogramChart chart, String name, String color) {
        BarSeries barSeries = chart.createBarSeries(name);
        if (this.categories.size() <= 4) {
            barSeries.setBarWidth("25px");
        } else if (this.categories.size() <= 8) {
            barSeries.setBarWidth("20px");
        } else if (this.categories.size() <= 12) {
            barSeries.setBarWidth("15px");
        } else {
            barSeries.setBarWidth("10px");
        }
        barSeries.setAnimationDuration(1500);
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, HashMap<String, String>> itemStyle = new HashMap<String, HashMap<String, String>>();
        map.put("color", String.format("new echarts.graphic.LinearGradient(0, 0, 0, 1, [{\"offset\": 0,\"color\": '%s'}, {\"offset\": 1, \"color\": '%s'}])", color, color));
        itemStyle.put("normal", map);
        barSeries.setPropValue("itemStyle", itemStyle);
        ArrayList<String> list = new ArrayList<String>();
        list.add("itemStyle");
        list.add("normal");
        list.add("color");
        barSeries.addFuncPath(list);
        barSeries.setLabel(null);
        return barSeries;
    }

    private void setLineColor(Axis axis) {
        HashMap axisLineMap = new HashMap();
        HashMap<String, String> lineStyleMap = new HashMap<String, String>();
        lineStyleMap.put("color", "#999999");
        axisLineMap.put("lineStyle", lineStyleMap);
        axis.setPropValue("axisLine", axisLineMap);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (CHART_PROP.equalsIgnoreCase(key)) {
            String section = ((ChartClickEvent)evt).getName();
            if (EmptyUtil.isEmpty((String)section)) {
                return;
            }
            String titleStr = (String)this.getModel().getValue("amtcolumntitles");
            String[] titles = titleStr.split("_");
            this.categories = new ArrayList<String>();
            for (int i = 0; i < titles.length; ++i) {
                String title = titles[i];
                if (!section.equals(SectionCfgModel.generateTitlesName((String)title))) continue;
                QFilter qFilter = new QFilter("section", "=", (Object)title);
                GapAnalysisHelper.showGapAnalysisDetail((IFormView)this.getView(), (QFilter)qFilter);
                break;
            }
        }
        if ("sum".equalsIgnoreCase(key)) {
            GapAnalysisHelper.showGapAnalysisDetail((IFormView)this.getView(), null);
        }
    }
}

