/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.formplugin.rateopen;

import java.text.NumberFormat;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mrm.common.helper.GapAnalysisHelper;

public class GapAnalysisLabelChartPlugin
extends AbstractBillPlugIn
implements TabSelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ((Tab)this.getView().getControl("tabAp")).addTabSelectListener((TabSelectListener)this);
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.refreshChart();
    }

    public void tabSelected(TabSelectEvent e) {
        this.refreshChart();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName;
        super.propertyChanged(e);
        switch (propertyName = e.getProperty().getName()) {
            case "amtunit": 
            case "currency": 
            case "referencerate": 
            case "orgview": 
            case "orgs": 
            case "iscalcbalance_ext": 
            case "subjects": {
                if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{this.getModel().getValue("amtunit")})) break;
                this.refreshChart();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("save".equals(e.getOperateKey())) {
            this.refreshChart();
        }
    }

    private void refreshChart() {
        if (BillOperationStatus.ADDNEW == ((BillShowParameter)this.getView().getFormShowParameter()).getBillStatus() || !"tabPageChart".equalsIgnoreCase(((Tab)this.getView().getControl("tabAp")).getCurrentTab())) {
            return;
        }
        String titleStr = (String)this.getModel().getValue("amtcolumntitles");
        if (!titleStr.contains("_")) {
            return;
        }
        if (!RequestContext.get().getTraceId().equals(this.getView().getFormShowParameter().getCustomParam("currentRequestTraceId"))) {
            GapAnalysisHelper.queryAndCacheGapChartData((IFormView)this.getView());
        }
        if ("YES".equals(this.getView().getFormShowParameter().getCustomParam("EmptyChartData"))) {
            return;
        }
        Object sumIn = this.getView().getFormShowParameter().getCustomParam("sumIn");
        Object sumOut = this.getView().getFormShowParameter().getCustomParam("sumOut");
        Object sum = this.getView().getFormShowParameter().getCustomParam("sum");
        ((Label)this.getView().getControl("sumIn")).setText(EmptyUtil.isEmpty((Object)sumIn) ? "0.00" : NumberFormat.getInstance().format(sumIn));
        String sumOutStr = NumberFormat.getInstance().format(sumOut);
        ((Label)this.getView().getControl("sumOut")).setText(sumOutStr.contains(".") ? sumOutStr : sumOutStr + ".00");
        String sumStr = NumberFormat.getInstance().format(sum);
        ((Label)this.getView().getControl("sum")).setText(sumStr.contains(".") ? sumStr : sumStr + ".00");
    }
}

