/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.formplugin.rateopen;

import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SectionCfgEdit
extends AbstractBasePlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"section_fill"});
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter formShowParameter = e.getFormShowParameter();
        if (formShowParameter instanceof BaseShowParameter) {
            String s;
            if (BillOperationStatus.AUDIT == ((BaseShowParameter)formShowParameter).getBillStatus()) {
                ((BaseShowParameter)formShowParameter).setBillStatus(BillOperationStatus.EDIT);
            }
            if (OperationStatus.EDIT == formShowParameter.getStatus() && (s = this.validateReference(((BaseShowParameter)formShowParameter).getPkId())) != null) {
                formShowParameter.setStatus(OperationStatus.VIEW);
                formShowParameter.setCustomParam("tipStr", (Object)s);
            }
        }
    }

    public void afterBindData(EventObject e) {
        String s;
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (OperationStatus.VIEW == formShowParameter.getStatus() && (s = (String)formShowParameter.getCustomParam("tipStr")) != null) {
            this.getView().showTipNotification(s);
        }
        if (OperationStatus.EDIT == formShowParameter.getStatus()) {
            this.setEnable();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (propertyName) {
            case "left": {
                this.refreshEntry();
                break;
            }
            case "unit": {
                for (int i = 1; i < this.getModel().getEntryRowCount("sectionentry"); ++i) {
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"unit", (Object)newValue, (int)i);
                }
                this.refreshEntry();
                break;
            }
            case "iscontains": {
                String currentRowDesc = (String)this.getModel().getValue("sectiondesc", rowIndex);
                String nextRowDesc = (String)this.getModel().getValue("sectiondesc", rowIndex + 1);
                if (((Boolean)newValue).booleanValue()) {
                    currentRowDesc = currentRowDesc.replace('\uff09', '\u3011');
                    nextRowDesc = nextRowDesc.replace('\u3010', '\uff08');
                } else {
                    currentRowDesc = currentRowDesc.replace('\u3011', '\uff09');
                    nextRowDesc = nextRowDesc.replace('\uff08', '\u3010');
                }
                this.getModel().setValue("sectiondesc", (Object)currentRowDesc, rowIndex);
                this.getModel().setValue("sectiondesc", (Object)nextRowDesc, rowIndex + 1);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("section_fill".equals(e.getOperateKey())) {
            this.showSectionBuild();
        }
        if ("section_insert".equals(e.getOperateKey())) {
            int[] selectRows = ((EntryGrid)this.getControl("sectionentry")).getSelectRows();
            if (selectRows.length > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u591a\u9009\uff0c\u8bf7\u9009\u4e2d\u4e00\u6761\u6570\u636e\u3002", (String)"SectionCfgEdit_1", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
            } else if (selectRows.length == 0) {
                if (this.getModel().getEntryRowCount("sectionentry") == 0) {
                    this.getModel().batchCreateNewEntryRow("sectionentry", 2);
                } else if (this.getModel().getEntryRowCount("sectionentry") > 0) {
                    int index = this.getModel().getEntryRowCount("sectionentry");
                    this.getModel().insertEntryRow("sectionentry", index);
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"unit", (Object)this.getModel().getValue("unit", 0), (int)index);
                }
                this.refreshEntry();
                this.setEnable();
            } else {
                int index = selectRows[0] + 1;
                this.getModel().insertEntryRow("sectionentry", index);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"unit", (Object)this.getModel().getValue("unit", 0), (int)index);
                this.refreshEntry();
                this.setEnable();
            }
        }
    }

    private void showSectionBuild() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("mrm_section_build");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setStatus(OperationStatus.ADDNEW);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "mrm_section_build"));
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Map data;
        super.closedCallBack(event);
        if ("mrm_section_build".equals(event.getActionId()) && EmptyUtil.isNoEmpty((Object)(data = (Map)event.getReturnData()))) {
            int gap = (Integer)data.get("gap");
            String gapunit = (String)data.get("gapunit");
            int sectioncount = (Integer)data.get("sectioncount");
            this.getModel().deleteEntryData("sectionentry");
            this.fastFill(gap, gapunit, sectioncount);
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        String name = e.getEntryProp().getName();
        if ("sectionentry".equals(name)) {
            for (int rowIndex : e.getRowIndexs()) {
                if (rowIndex != 0) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u5220\u9664\u7b2c\u4e00\u884c\u3002", (String)"SectionCfgEdit_5", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        String name = e.getEntryProp().getName();
        if ("sectionentry".equals(name)) {
            int entryRowCount = this.getModel().getEntryRowCount("sectionentry");
            if (((Boolean)this.getModel().getValue("iscontains", entryRowCount - 1)).booleanValue()) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"iscontains", (Object)false, (int)(entryRowCount - 1));
                String sectionDesc = (String)this.getModel().getValue("sectiondesc", entryRowCount - 1);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"sectiondesc", (Object)sectionDesc.replace('\u3011', '\uff09'), (int)(entryRowCount - 1));
            }
            this.refreshEntry();
            this.setEnable();
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Control source = (Control)e.getSource();
        String key = source.getKey();
        if ("sectioncount".equals(key) || "gap".equals(key)) {
            int v;
            int n = v = EmptyUtil.isEmpty((Object)e.getValue()) ? 0 : Integer.parseInt((String)e.getValue());
            if (v == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5927\u4e8e0\u7684\u6570\u503c\u3002", (String)"SectionCfgEdit_4", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
                this.getView().updateView(key);
                e.setCancel(true);
            }
        } else if ("left".equals(key)) {
            int left = e.getValue() == null ? 0 : Integer.parseInt((String)e.getValue());
            int lastLeft = 0;
            for (int i = e.getRowIndex() - 1; i >= 0 && (lastLeft = ((Integer)this.getModel().getValue("left", i)).intValue()) == 0; --i) {
            }
            if (left <= lastLeft) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u5927\u4e8e%s\u7684\u6570\u3002", (String)"SectionCfgEdit_2", (String)"tmc-mrm-formplugin", (Object[])new Object[]{lastLeft}));
                this.getView().updateView("left", e.getRowIndex());
                e.setCancel(true);
            }
            int nextLeft = 0;
            for (int i = e.getRowIndex() + 1; i < this.getModel().getEntryRowCount("sectionentry") && (nextLeft = ((Integer)this.getModel().getValue("left", i)).intValue()) == 0; ++i) {
            }
            if (nextLeft == 0) {
                return;
            }
            if (left >= nextLeft) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u5c0f\u4e8e%s\u7684\u6570\u3002", (String)"SectionCfgEdit_3", (String)"tmc-mrm-formplugin", (Object[])new Object[]{nextLeft}));
                this.getView().updateView("left", e.getRowIndex());
                e.setCancel(true);
            }
        }
    }

    private void refreshEntry() {
        int entryRowCount = this.getModel().getEntryRowCount("sectionentry");
        String unit = (String)this.getModel().getValue("unit", 0);
        if (unit == null) {
            unit = "";
        }
        StringBuilder descBuffer = new StringBuilder();
        for (int i = 0; i < entryRowCount; ++i) {
            descBuffer.delete(0, descBuffer.length());
            String leftSymbol = i == 0 || (Boolean)this.getModel().getValue("iscontains", i - 1) == false ? "\u3010" : "\uff08";
            descBuffer.append(leftSymbol);
            int x = (Integer)this.getModel().getValue("left", i);
            descBuffer.append(x == 0 && i != 0 ? " " : Integer.valueOf(x));
            descBuffer.append(x != 0 ? unit : " ");
            descBuffer.append("\uff0c");
            if (i == entryRowCount - 1) {
                descBuffer.append("+\u221e");
            } else {
                int y = (Integer)this.getModel().getValue("left", i + 1);
                descBuffer.append(y == 0 ? " " : Integer.valueOf(y));
                descBuffer.append(y == 0 ? " " : unit);
            }
            String rightSymbol = (Boolean)this.getModel().getValue("iscontains", i) != false ? "\u3011" : "\uff09";
            descBuffer.append(rightSymbol);
            String newDesc = descBuffer.toString();
            if (newDesc.equals(this.getModel().getValue("sectiondesc", i))) continue;
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"sectiondesc", (Object)newDesc, (int)i);
        }
    }

    private void fastFill(int gap, String gapUnit, int sectionCount) {
        StringBuilder descBuffer = new StringBuilder();
        for (int i = 0; i < sectionCount; ++i) {
            descBuffer.delete(0, descBuffer.length());
            int index = this.getModel().createNewEntryRow("sectionentry");
            descBuffer.append("\u3010");
            int x = i * gap;
            descBuffer.append(x);
            descBuffer.append(x != 0 ? gapUnit : " ");
            descBuffer.append("\uff0c");
            if (i == sectionCount - 1) {
                descBuffer.append("+\u221e");
            } else {
                descBuffer.append((i + 1) * gap);
                descBuffer.append(gapUnit);
            }
            descBuffer.append("\uff09");
            this.getModel().setValue("sectiondesc", (Object)descBuffer.toString(), index);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"left", (Object)x, (int)index);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"unit", (Object)gapUnit, (int)index);
        }
        this.setEnable();
    }

    private void setEnable() {
        if (this.getModel().getEntryRowCount("sectionentry") > 0) {
            int i;
            this.getView().setEnable(Boolean.valueOf(false), 0, new String[]{"left"});
            this.getView().setEnable(Boolean.valueOf(true), 0, new String[]{"unit"});
            this.getView().setEnable(Boolean.valueOf(false), this.getModel().getEntryRowCount("sectionentry") - 1, new String[]{"iscontains"});
            for (i = 1; i < this.getModel().getEntryRowCount("sectionentry"); ++i) {
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"unit"});
                this.getView().setEnable(Boolean.valueOf(true), i, new String[]{"left"});
            }
            for (i = 0; i < this.getModel().getEntryRowCount("sectionentry") - 1; ++i) {
                this.getView().setEnable(Boolean.valueOf(true), i, new String[]{"iscontains"});
            }
        }
    }

    private String validateReference(Object id) {
        List list;
        if (EmptyUtil.isNoEmpty((Object)id) && !(list = BaseDataRefrenceHelper.getAllRefs((String)"mrm_section_cfg", (Object)id)).isEmpty()) {
            Set refEntitySet = list.stream().map(o -> o.getRefEntityKey()).collect(Collectors.toSet());
            Set<String> bills = new HashSet<String>(3);
            if (refEntitySet.contains("mrm_gap_analysis")) {
                bills.add(MetadataServiceHelper.getDataEntityType((String)"mrm_gap_analysis").getDisplayName().getLocaleValue());
            }
            if (refEntitySet.contains("mrm_sensitivity")) {
                bills.add(MetadataServiceHelper.getDataEntityType((String)"mrm_sensitivity").getDisplayName().getLocaleValue());
            }
            if (refEntitySet.contains("mrm_exrate_gap_analysis")) {
                bills.add(MetadataServiceHelper.getDataEntityType((String)"mrm_exrate_gap_analysis").getDisplayName().getLocaleValue());
            }
            if (refEntitySet.contains("mrm_exrate_sensitivity")) {
                bills.add(MetadataServiceHelper.getDataEntityType((String)"mrm_exrate_sensitivity").getDisplayName().getLocaleValue());
            }
            if (!bills.isEmpty()) {
                bills = bills.stream().map(o -> "\u201c" + o + "\u201d").collect(Collectors.toSet());
                return ResManager.loadKDString((String)"\u8be5\u7f3a\u53e3\u533a\u95f4\u6bb5\u914d\u7f6e\u5df2\u88ab%s\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"SectionCfgSaveValidator_6", (String)"tmc-mrm-business", (Object[])new Object[]{String.join((CharSequence)"\u3001", bills)});
            }
        }
        return null;
    }
}

