/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.formplugin.scenariosimulation;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.Series;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.fbp.common.util.TermUtils;
import kd.tmc.fbp.formplugin.chart.AbstractLineChartEdit;
import kd.tmc.mrm.common.enums.RateChangeModeEnum;
import kd.tmc.mrm.common.enums.ScenarioTypeEnum;
import kd.tmc.mrm.common.helper.YieldCurveCreatorHelper;

public class YieldCurveChartPlugin
extends AbstractLineChartEdit {
    public static final String COLOR_BASE_YIELD = "#3dccc0";
    public static final String COLOR_AFTER_YIELD = "#ff854d";
    private static final Log logger = LogFactory.getLog(YieldCurveChartPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap2"});
    }

    protected String getChartCtlName() {
        return "chartap";
    }

    public void afterBindData(EventObject e) {
        DynamicObject yield;
        super.afterBindData(e);
        String scenariotype = (String)this.getModel().getValue("scenariotype");
        if (ScenarioTypeEnum.INTEREST_AND_CHANGE.getValue().equals(scenariotype) && (yield = (DynamicObject)this.getModel().getValue("yieldcurve")) != null) {
            this.drawYieldChart();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        switch (name = e.getProperty().getName()) {
            case "yieldcurve": 
            case "yieldcurveupordown": 
            case "yieldcurvebp": {
                this.drawYieldChart();
            }
        }
    }

    private void drawYieldChart() {
        DynamicObject yield = (DynamicObject)this.getModel().getValue("yieldcurve");
        if (yield != null) {
            Timestamp startDate = TcDateUtils.getCurrentTime();
            this.drawChart();
            Timestamp endDate = TcDateUtils.getCurrentTime();
            logger.info("draw yield chart cost " + (((Date)endDate).getTime() - ((Date)startDate).getTime()) + " ms");
        } else {
            PointLineChart chart = (PointLineChart)this.getControl("chartap");
            chart.clearData();
            chart.clearGraphic();
            chart.refresh();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("refreshchart".equals(itemKey)) {
            this.drawYieldChart();
        }
    }

    protected String getXTitleName() {
        return ResManager.loadKDString((String)"\u65e5\u671f", (String)"YieldCurveChartPlugin_0", (String)"tmc-mrm-formplugin", (Object[])new Object[0]);
    }

    protected String getYTitleName() {
        return ResManager.loadKDString((String)"\u96f6\u606f\u5229\u7387(%)", (String)"YieldCurveChartPlugin_1", (String)"tmc-mrm-formplugin", (Object[])new Object[0]);
    }

    protected String[] getXValue() {
        List<Date> xDateList = this.getXDateList();
        String[] xValue = new String[xDateList.size()];
        for (int i = 0; i < xDateList.size(); ++i) {
            xValue[i] = TcDateUtils.formatString((Date)xDateList.get(i), (String)"yyyy-MM-dd");
        }
        return xValue;
    }

    protected List<Object> getSeriesValue() {
        DynamicObject yield = this.getyieldCurve();
        if (yield == null) {
            return new ArrayList<Object>(0);
        }
        Date referdate = TcDateUtils.getCurrentDate();
        DynamicObjectCollection entry_struct = yield.getDynamicObjectCollection("structentry");
        ArrayList dateList = new ArrayList(entry_struct.size());
        HashMap result = new HashMap(entry_struct.size());
        List<Date> xDateList = this.getXDateList();
        ArrayList<Object> allLine = new ArrayList<Object>(2);
        List yList = YieldCurveCreatorHelper.chart_getY(xDateList, (DynamicObject)yield, (Date)referdate, dateList, result);
        allLine.add(yList);
        String ratechangemode = (String)this.getModel().getValue("ratechangemode");
        if (RateChangeModeEnum.PARALLEL.getValue().equals(ratechangemode)) {
            ArrayList<BigDecimal> ayList = new ArrayList<BigDecimal>(yList);
            String yieldcurveupordown = (String)this.getModel().getValue("yieldcurveupordown");
            BigDecimal yieldcurvebp = (BigDecimal)this.getModel().getValue("yieldcurvebp");
            yieldcurvebp = yieldcurvebp.divide(BigDecimal.valueOf(100L), RoundingMode.HALF_UP);
            for (int i = 0; i < ayList.size(); ++i) {
                BigDecimal value = (BigDecimal)yList.get(i);
                ayList.set(i, "up".equals(yieldcurveupordown) ? value.add(yieldcurvebp) : value.subtract(yieldcurvebp));
            }
            allLine.add(ayList);
        } else {
            Date date = xDateList.get(0);
            DynamicObjectCollection cardEntries = this.getModel().getEntryEntity("entryentity3");
            if (!cardEntries.isEmpty()) {
                DynamicObject cardEntry = (DynamicObject)cardEntries.get(0);
                DynamicObjectCollection entryentity4 = cardEntry.getDynamicObjectCollection("entryentity4");
                if (entryentity4.isEmpty()) {
                    return allLine;
                }
                Date[][] sectionDateArray = new Date[entryentity4.size()][2];
                boolean[][] sectionBooleanArray = new boolean[entryentity4.size()][2];
                this.assemble(date, entryentity4, sectionDateArray, sectionBooleanArray);
                List byList = YieldCurveCreatorHelper.chart_getOffsetY(xDateList, (DynamicObject)yield, (Date)referdate, dateList, result, (DynamicObjectCollection)entryentity4, (Date[][])sectionDateArray, (boolean[][])sectionBooleanArray);
                allLine.add(byList);
            }
        }
        return allLine;
    }

    private void assemble(Date draftTime, DynamicObjectCollection sectionEntry, Date[][] sectionDateArray, boolean[][] sectionBooleanArray) {
        String unit = ((DynamicObject)sectionEntry.get(0)).getString("unit");
        sectionBooleanArray[0][0] = true;
        for (int i = 0; i < sectionEntry.size(); ++i) {
            DynamicObject row = (DynamicObject)sectionEntry.get(i);
            int x = row.getInt("left");
            Date leftDate = "m".equals(unit) ? TcDateUtils.getNextMonth((Date)draftTime, (int)x) : ("d".equals(unit) ? TcDateUtils.getNextDay((Date)draftTime, (int)x) : TcDateUtils.getNextYear((Date)draftTime, (int)x));
            sectionDateArray[i][0] = leftDate;
            sectionBooleanArray[i][1] = ((DynamicObject)sectionEntry.get(i)).getBoolean("iscontains");
            if (i > 0) {
                sectionDateArray[i - 1][1] = leftDate;
            }
            if (i >= sectionEntry.size() - 1) continue;
            sectionBooleanArray[i + 1][0] = !((DynamicObject)sectionEntry.get(i)).getBoolean("iscontains");
        }
    }

    protected String getSeriesTitleName(int index) {
        String[] seriesTitleNames = new String[]{ResManager.loadKDString((String)"\u57fa\u51c6\u6536\u76ca\u66f2\u7ebf", (String)"YieldCurveChartPlugin_2", (String)"tmc-mrm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u60c5\u666f\u8bbe\u7f6e\u540e\u6536\u76ca\u66f2\u7ebf", (String)"YieldCurveChartPlugin_3", (String)"tmc-mrm-formplugin", (Object[])new Object[0])};
        return seriesTitleNames[index];
    }

    protected void initSeriesStyle(int index, Chart chart, Series series, String color) {
        String[] LineColor = new String[]{COLOR_BASE_YIELD, COLOR_AFTER_YIELD};
        chart.setMargin(Position.left, "80px");
        chart.setMargin(Position.right, "100px");
        chart.setMargin(Position.top, "50px");
        series.setAnimationDuration(2000);
        series.setItemColor(LineColor[index]);
        chart.setShowTooltip(true);
    }

    public List<Date> getXDateList() {
        DynamicObject yield = this.getyieldCurve();
        if (yield == null) {
            return new ArrayList<Date>(0);
        }
        Date referdate = TcDateUtils.getCurrentDate();
        DynamicObjectCollection fintoolentry = yield.getDynamicObjectCollection("fintoolentry");
        Date maxdate = referdate;
        for (int i = 0; i < fintoolentry.size(); ++i) {
            Date temp;
            String term = ((DynamicObject)fintoolentry.get(i)).getString("term_fin");
            if (!((DynamicObject)fintoolentry.get(i)).getBoolean("isforcurve_fin") || !(temp = TermUtils.getDateByTerm((String)term, (Date)referdate)).after(maxdate)) continue;
            maxdate = temp;
        }
        String betweenTerm = "1d";
        if (maxdate.after(TermUtils.getDateByTerm((String)"2y", (Date)referdate))) {
            betweenTerm = "1m";
        }
        Date enddate = TermUtils.getDateByTerm((String)"1y", (Date)maxdate);
        ArrayList<Date> xList = new ArrayList<Date>(fintoolentry.size());
        Date point = referdate;
        point = TermUtils.getDateByTerm((String)betweenTerm, (Date)point);
        while (point.before(enddate)) {
            xList.add(point);
            point = TermUtils.getDateByTerm((String)betweenTerm, (Date)point);
        }
        xList.add(enddate);
        return xList;
    }

    private DynamicObject getyieldCurve() {
        DynamicObject yieldline;
        DynamicObject yield = (DynamicObject)this.getModel().getValue("yieldcurve");
        if (yield != null && (yieldline = TmcDataServiceHelper.loadSingle((Object)yield.getPkValue(), (String)"md_yieldline")) != null) {
            YieldCurveCreatorHelper.generateStructEntry((DynamicObject)yieldline);
            return yieldline;
        }
        return null;
    }
}

