/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.formplugin.sensitivityanalysis;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.mrm.business.service.exrateopen.ExRateGapAnalysisModel;
import kd.tmc.mrm.formplugin.exrateopen.AbstractExRateGapAnalysisEdit;

public class ExRateSensGapFormPlugin
extends AbstractExRateGapAnalysisEdit
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit currency = (BasedataEdit)this.getControl("currency");
        currency.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setVisible();
    }

    private void setVisible() {
        this.getModel().deleteEntryData("gapanalysisentity");
        String[] hiddenColumnKeys = new String[52];
        for (int i = 1; i <= 50; ++i) {
            hiddenColumnKeys[i - 1] = "amount" + i;
        }
        hiddenColumnKeys[50] = "subjectname";
        hiddenColumnKeys[51] = "totalamt";
        this.getView().setVisible(Boolean.valueOf(false), hiddenColumnKeys);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        switch (name = e.getProperty().getName()) {
            case "currency": {
                DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
                if (currency != null) {
                    IFormView parentView = this.getView().getParentView();
                    DynamicObject subjectSystem = BusinessDataServiceHelper.loadSingleFromCache((Object)((DynamicObject)parentView.getModel().getValue("subjectsystem")).getPkValue(), (String)"mrm_subject_system");
                    ExRateGapAnalysisModel gapAnalysisModel = new ExRateGapAnalysisModel((DynamicObject)parentView.getModel().getValue("forexquote"), (DynamicObject)parentView.getModel().getValue("currentanalysisobj"), subjectSystem, (DynamicObject)parentView.getModel().getValue("sectioncfg"), (DynamicObject)parentView.getModel().getValue("basecurrency"));
                    gapAnalysisModel.analysis(this.getView().getFormShowParameter().getAppId(), currency.getPkValue());
                    String[] titles = gapAnalysisModel.getTitles();
                    if (this.isEmpty(gapAnalysisModel.getResultData())) {
                        this.setVisible();
                        break;
                    }
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"subjectname", "totalamt"});
                    BigDecimal amtUnit = new BigDecimal((String)parentView.getModel().getValue("amtunit"));
                    this.generateReport(gapAnalysisModel, subjectSystem, amtUnit, titles);
                    break;
                }
                this.getModel().deleteEntryData("gapanalysisentity");
                this.setVisible();
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        if ("exportEntry".equalsIgnoreCase(key)) {
            int entryRowCount = this.getModel().getEntryRowCount("gapanalysisentity");
            int[] a = new int[entryRowCount];
            for (int i = 0; i < entryRowCount; ++i) {
                a[i] = i;
            }
            TreeEntryGrid treeGrid = (TreeEntryGrid)this.getView().getControl("gapanalysisentity");
            treeGrid.selectRows(a, 0);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        DynamicObject baseCurrency;
        String property = event.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        if ("currency".equals(property) && (baseCurrency = (DynamicObject)this.getView().getParentView().getModel().getValue("basecurrency")) != null) {
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "!=", baseCurrency.getPkValue()));
        }
    }

    private boolean isEmpty(Map<Long, BigDecimal[]> resultData) {
        for (Map.Entry<Long, BigDecimal[]> e : resultData.entrySet()) {
            for (BigDecimal amt : e.getValue()) {
                if (amt == null || amt.compareTo(BigDecimal.ZERO) == 0) continue;
                return false;
            }
        }
        return true;
    }
}

