/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.formplugin.sensitivityanalysis;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.EventObject;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.mvc.bill.BillView;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mrm.business.service.exrateopen.ExRateSensitivityAnalysisModel;
import kd.tmc.mrm.common.helper.OrgHelper;
import kd.tmc.mrm.common.model.section.SectionCfgModel;
import kd.tmc.mrm.formplugin.exrateopen.AbstractExRateGapAnalysisEdit;

public class ExRateSensSectionDetailFormPlugin
extends AbstractExRateGapAnalysisEdit {
    protected static final int MAX_AMT_ROW_COUNT = 50;

    public void afterBindData(EventObject e) {
        int i;
        super.afterBindData(e);
        String titleStr = this.getPageCache().get("titles");
        String[] titles = titleStr.split("_");
        int index = titles.length;
        String[] ss = new String[50 - index];
        for (i = index + 1; i <= 50; ++i) {
            ss[i - (index + 1)] = "amount" + i;
        }
        for (i = 0; i < titles.length; ++i) {
            ((EntryGrid)this.getView().getControl("entryentity")).setColumnProperty("amount" + (i + 1), "header", (Object)new LocaleString(SectionCfgModel.generateTitlesName((String)titles[i])));
        }
        this.getView().setVisible(Boolean.valueOf(false), ss);
    }

    public void afterCreateNewData(EventObject e) {
        int i;
        super.afterCreateNewData(e);
        Object srcBillId = this.getView().getFormShowParameter().getCustomParams().get("srcBillId");
        Object currencyId = this.getView().getFormShowParameter().getCustomParams().get("currencyId");
        String amtUnit = (String)this.getView().getFormShowParameter().getCustomParams().get("amtunit");
        BigDecimal unit = EmptyUtil.isNoEmpty((String)amtUnit) ? new BigDecimal(amtUnit) : BigDecimal.ONE;
        String fieldName = (String)this.getView().getFormShowParameter().getCustomParams().get("fieldName");
        this.getModel().batchCreateNewEntryRow("entryentity", 9);
        this.getModel().setValue("direct", (Object)"in", 0);
        this.getModel().setValue("direct", (Object)"out", 3);
        this.getModel().setValue("direct", (Object)"netValue", 6);
        this.getModel().setValue("type", (Object)"act", 0);
        this.getModel().setValue("type", (Object)"simulation", 1);
        this.getModel().setValue("type", (Object)"pl", 2);
        this.getModel().setValue("type", (Object)"act", 3);
        this.getModel().setValue("type", (Object)"simulation", 4);
        this.getModel().setValue("type", (Object)"pl", 5);
        this.getModel().setValue("type", (Object)"act", 6);
        this.getModel().setValue("type", (Object)"simulation", 7);
        this.getModel().setValue("type", (Object)"pl", 8);
        Object baseCurrency = this.getView().getParentView().getModel().getValue("basecurrency");
        for (int i2 = 0; i2 < 9; ++i2) {
            this.getModel().setValue("currency", baseCurrency, i2);
        }
        ExRateSensitivityAnalysisModel model = new ExRateSensitivityAnalysisModel(srcBillId, currencyId);
        DynamicObject orgView = null;
        DynamicObjectCollection orgCol = null;
        String orgFunc = null;
        if (this.getView().getParentView() instanceof BillView) {
            orgView = (DynamicObject)this.getView().getParentView().getModel().getValue("orgview");
            orgCol = (DynamicObjectCollection)this.getView().getParentView().getModel().getValue("orgs");
            orgFunc = ((MulBasedataProp)((MulBasedataEdit)this.getView().getParentView().getControl("orgs")).getProperty()).getOrgFunc();
        }
        List orgIds = OrgHelper.getPermOrgIds((DynamicObject)orgView, orgCol, orgFunc, (String)this.getView().getFormShowParameter().getAppId(), (String)"mrm_exrate_sensitivity");
        DataSet dataSet = model.analysis(currencyId, orgIds);
        CharSequence[] titles = model.getTitles();
        this.getPageCache().put("titles", String.join((CharSequence)"_", titles));
        BigDecimal sumPlIn = BigDecimal.ZERO;
        BigDecimal sumPlOut = BigDecimal.ZERO;
        BigDecimal[] sumPl = new BigDecimal[titles.length];
        for (int i3 = 0; i3 < titles.length; ++i3) {
            sumPl[i3] = BigDecimal.ZERO;
        }
        BigDecimal sumBalanceIn = BigDecimal.ZERO;
        BigDecimal sumBalanceOut = BigDecimal.ZERO;
        BigDecimal[] sumBalance = new BigDecimal[titles.length];
        for (int i4 = 0; i4 < titles.length; ++i4) {
            sumBalance[i4] = BigDecimal.ZERO;
        }
        BigDecimal sumGapIn = BigDecimal.ZERO;
        BigDecimal sumGapOut = BigDecimal.ZERO;
        BigDecimal[] sumGap = new BigDecimal[titles.length];
        for (int i5 = 0; i5 < titles.length; ++i5) {
            sumGap[i5] = BigDecimal.ZERO;
        }
        boolean isExistIn = false;
        boolean isExistOut = false;
        if (dataSet.isEmpty()) {
            return;
        }
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            int sectionIndex = row.getInteger("sectionIndex");
            Object inOrOut = row.get("inOrOut");
            BigDecimal pl = row.getBigDecimal(fieldName);
            String balanceProp = "balance" + fieldName.substring(2, 3);
            BigDecimal balance = row.getBigDecimal(balanceProp);
            BigDecimal reportGapAmount = row.getBigDecimal("reportGapAmount");
            if ("in".equals(inOrOut)) {
                isExistIn = true;
                this.getModel().setValue("amount" + (sectionIndex + 1), (Object)reportGapAmount.divide(unit, 10, RoundingMode.HALF_UP), 0);
                this.getModel().setValue("amount" + (sectionIndex + 1), (Object)balance.divide(unit, 10, RoundingMode.HALF_UP), 1);
                this.getModel().setValue("amount" + (sectionIndex + 1), (Object)pl.divide(unit, 10, RoundingMode.HALF_UP), 2);
                BigDecimal oldPl = sumPl[sectionIndex];
                sumPl[sectionIndex] = oldPl.add(pl);
                sumPlIn = sumPlIn.add(pl);
                BigDecimal oldBalance = sumBalance[sectionIndex];
                sumBalance[sectionIndex] = oldBalance.add(balance);
                sumBalanceIn = sumBalanceIn.add(balance);
                BigDecimal oldGap = sumGap[sectionIndex];
                sumGap[sectionIndex] = oldGap.add(reportGapAmount);
                sumGapIn = sumGapIn.add(reportGapAmount);
                continue;
            }
            if (!"out".equals(inOrOut)) continue;
            isExistOut = true;
            this.getModel().setValue("amount" + (sectionIndex + 1), (Object)reportGapAmount.divide(unit, 10, RoundingMode.HALF_UP), 3);
            this.getModel().setValue("amount" + (sectionIndex + 1), (Object)balance.divide(unit, 10, RoundingMode.HALF_UP), 4);
            this.getModel().setValue("amount" + (sectionIndex + 1), (Object)pl.divide(unit, 10, RoundingMode.HALF_UP), 5);
            BigDecimal oldPl = sumPl[sectionIndex];
            sumPl[sectionIndex] = oldPl.add(pl);
            sumPlOut = sumPlOut.add(pl);
            BigDecimal oldBalance = sumBalance[sectionIndex];
            sumBalance[sectionIndex] = oldBalance.add(balance);
            sumBalanceOut = sumBalanceOut.add(balance);
            BigDecimal oldGap = sumGap[sectionIndex];
            sumGap[sectionIndex] = oldGap.add(reportGapAmount);
            sumGapOut = sumGapOut.add(reportGapAmount);
        }
        this.getModel().setValue("total", (Object)sumGapIn.divide(unit, 10, RoundingMode.HALF_UP), 0);
        this.getModel().setValue("total", (Object)sumBalanceIn.divide(unit, 10, RoundingMode.HALF_UP), 1);
        this.getModel().setValue("total", (Object)sumPlIn.divide(unit, 10, RoundingMode.HALF_UP), 2);
        this.getModel().setValue("total", (Object)sumGapOut.divide(unit, 10, RoundingMode.HALF_UP), 3);
        this.getModel().setValue("total", (Object)sumBalanceOut.divide(unit, 10, RoundingMode.HALF_UP), 4);
        this.getModel().setValue("total", (Object)sumPlOut.divide(unit, 10, RoundingMode.HALF_UP), 5);
        this.getModel().setValue("total", (Object)sumGapIn.add(sumGapOut).divide(unit, 10, RoundingMode.HALF_UP), 6);
        this.getModel().setValue("total", (Object)sumBalanceIn.add(sumBalanceOut).divide(unit, 10, RoundingMode.HALF_UP), 7);
        this.getModel().setValue("total", (Object)sumPlIn.add(sumPlOut).divide(unit, 10, RoundingMode.HALF_UP), 8);
        for (i = 0; i < sumGap.length; ++i) {
            this.getModel().setValue("amount" + (i + 1), (Object)sumGap[i].divide(unit, 10, RoundingMode.HALF_UP), 6);
        }
        for (i = 0; i < sumBalance.length; ++i) {
            this.getModel().setValue("amount" + (i + 1), (Object)sumBalance[i].divide(unit, 10, RoundingMode.HALF_UP), 7);
        }
        for (i = 0; i < sumPl.length; ++i) {
            this.getModel().setValue("amount" + (i + 1), (Object)sumPl[i].divide(unit, 10, RoundingMode.HALF_UP), 8);
        }
        if (!isExistIn) {
            this.getModel().deleteEntryRows("entryentity", new int[]{0, 1, 2});
        }
        if (!isExistOut) {
            this.getModel().deleteEntryRows("entryentity", new int[]{3, 4, 5});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate op = (FormOperate)args.getSource();
        if ("exportEntry".equalsIgnoreCase(op.getOperateKey())) {
            int entryRowCount = this.getModel().getEntryRowCount("entryentity");
            int[] a = new int[entryRowCount];
            for (int i = 0; i < entryRowCount; ++i) {
                a[i] = i;
            }
            EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
            grid.selectRows(a, 0);
        }
    }
}

