/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.formplugin.sensitivityanalysis;

import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.IFormView;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.AmountUnitEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mrm.business.service.scenariosimulation.ExScenarioSimulationService;
import kd.tmc.mrm.common.enums.ExScenarioMethodEnum;
import kd.tmc.mrm.common.helper.OrgHelper;

public class ExRateSensitivityAnalysisCardPlugin
extends AbstractFormPlugin
implements TabSelectListener {
    private static final String CHART_PROP = "chart";
    private String xAxisName;
    private String yAxisName;
    List<String> categories;
    private BigDecimal[] currentBalances;
    private BigDecimal[] simulationPls;
    private BigDecimal[] simulationBalances;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ((Tab)this.getView().getControl("tabAp")).addTabSelectListener((TabSelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"chartpanel"});
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"chartpanel"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.refreshChart();
    }

    public void tabSelected(TabSelectEvent e) {
        this.refreshChart();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("gapdirectfilter".equals(name) || "amtunit".equals(name) || "orgview".equals(name) || "orgs".equals(name)) {
            this.refreshChart();
        }
        if ("chartcurrencyfilter".equals(name) && this.getModel().getValue("chartcurrencyfilter") != null) {
            this.refreshChart();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("save".equals(e.getOperateKey())) {
            this.refreshChart();
        }
    }

    private void refreshChart() {
        if (BillOperationStatus.ADDNEW == ((BillShowParameter)this.getView().getFormShowParameter()).getBillStatus() || !"tabPageChart".equalsIgnoreCase(((Tab)this.getView().getControl("tabAp")).getCurrentTab())) {
            return;
        }
        this.queryCategories();
        boolean b = this.queryData();
        if (!b) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"chartpanel"});
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"chartpanel"});
        HistogramChart chart = (HistogramChart)this.getControl(CHART_PROP);
        this.setStyle(chart);
        chart.clearData();
        this.createYAxis(chart);
        this.createXAxis(chart);
        this.setData(chart);
    }

    private void setStyle(HistogramChart chart) {
        chart.setMargin(Position.left, "60px");
        chart.setMargin(Position.right, "60px");
        chart.setMargin(Position.top, "30px");
        chart.setMargin(Position.bottom, "30px");
        chart.setShowLegend(true);
        chart.setLegendPropValue("itemWidth", (Object)10);
        chart.setLegendPropValue("itemHeight", (Object)10);
        chart.setLegendAlign(XAlign.center, YAlign.top);
        chart.setShowTooltip(true);
    }

    private void queryCategories() {
        this.categories = new ArrayList<String>();
        DynamicObject dbObj = BusinessDataServiceHelper.loadSingle((Object)this.getModel().getDataEntity().getPkValue(), (String)this.getModel().getDataEntityType().getName(), (String)"scenariosimulation");
        DynamicObject scenarioSimulation = dbObj.getDynamicObject("scenariosimulation");
        ExScenarioSimulationService exScenarioSimulationService = new ExScenarioSimulationService(Long.valueOf(scenarioSimulation.getLong("id")), new Date());
        String[] simulateNameArr = exScenarioSimulationService.getSimulateNameArr();
        Collections.addAll(this.categories, simulateNameArr);
    }

    private boolean queryData() {
        String amtUnit = (String)this.getModel().getValue("amtunit");
        BigDecimal unit = EmptyUtil.isNoEmpty((String)amtUnit) ? new BigDecimal(amtUnit) : BigDecimal.ONE;
        this.xAxisName = AmountUnitEnum.getName((String)amtUnit);
        this.yAxisName = "";
        DynamicObject chartCurrencyFilter = (DynamicObject)this.getModel().getValue("chartcurrencyfilter");
        String gapDirectFilter = (String)this.getModel().getValue("gapdirectfilter");
        if (EmptyUtil.isEmpty((String)gapDirectFilter)) {
            gapDirectFilter = "sum";
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"gapdirectfilter", (Object)"sum");
        }
        QFilter qFilter = new QFilter("srcBillId", "=", this.getModel().getDataEntity().getPkValue()).and("inOrOut", "in", (Object)gapDirectFilter);
        DynamicObject orgView = (DynamicObject)this.getModel().getValue("orgview");
        DynamicObjectCollection orgCol = (DynamicObjectCollection)this.getModel().getValue("orgs");
        String appId = this.getView().getFormShowParameter().getAppId();
        List orgIds = OrgHelper.getPermOrgIds((DynamicObject)orgView, (DynamicObjectCollection)orgCol, (String)((MulBasedataProp)((MulBasedataEdit)this.getView().getControl("orgs")).getProperty()).getOrgFunc(), (String)appId, (String)"mrm_exrate_sensitivity");
        if (orgIds != null) {
            qFilter.and("org", "in", (Object)orgIds);
        }
        DynamicObject dbObj = QueryServiceHelper.queryOne((String)this.getModel().getDataEntityType().getName(), (String)"scenarioSimulation.scenarioMethod,scenarioSimulation.rankCount", (QFilter[])new QFilter("id", "=", this.getModel().getDataEntity().getPkValue()).toArray());
        String scenarioMethod = dbObj.getString("scenarioSimulation.scenarioMethod");
        int rankCount = dbObj.getInt("scenarioSimulation.rankCount");
        if (ExScenarioMethodEnum.RANK.getValue().equals(scenarioMethod) && rankCount > 0) {
            DataSet ds = QueryServiceHelper.queryDataSet((String)"ExRateSensitivityAnalysisEdit.rpt", (String)"mrm_exrate_sens_detail", (String)"cashFlowCurrency,reportGapAmount", (QFilter[])qFilter.toArray(), (String)"");
            ds = ds.groupBy(new String[]{"cashFlowCurrency"}).sum("reportGapAmount").finish().addField("abs(reportGapAmount)", "sumAmount").orderBy(new String[]{"sumAmount desc"});
            HashSet<Object> currencySet = new HashSet<Object>(8);
            while (ds.hasNext() && currencySet.size() < rankCount) {
                Row row = ds.next();
                currencySet.add(row.get("cashFlowCurrency"));
            }
            ds.close();
            qFilter.and("cashFlowCurrency", "in", currencySet);
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)chartCurrencyFilter)) {
            qFilter = qFilter.and("cashFlowCurrency", "=", chartCurrencyFilter.getPkValue());
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"ExRateSensitivityAnalysisEdit.rpt", (String)"mrm_exrate_sens_detail", (String)"id,cashFlowCurrency,reportGapAmount,balance1,pl1,balance2,pl2,balance3,pl3,balance4,pl4,balance5,pl5", (QFilter[])qFilter.toArray(), (String)"");
        GroupbyDataSet groupedDataSet = dataSet.groupBy(new String[]{"cashFlowCurrency"}).sum("reportGapAmount");
        int simulationCount = this.categories.size();
        for (int i = 1; i <= simulationCount; ++i) {
            groupedDataSet.sum("balance" + i).sum("pl" + i);
        }
        dataSet = groupedDataSet.finish();
        dataSet = dataSet.addField("abs(reportGapAmount)", "sumAmount").orderBy(new String[]{"sumAmount desc"});
        this.currentBalances = new BigDecimal[simulationCount];
        this.simulationPls = new BigDecimal[simulationCount];
        this.simulationBalances = new BigDecimal[simulationCount];
        if (dataSet.isEmpty()) {
            return false;
        }
        if (dataSet.hasNext()) {
            Row row = dataSet.next();
            Long cashFlowCurrency = row.getLong("cashFlowCurrency");
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"chartcurrencyfilter", (Object)cashFlowCurrency);
            DynamicObject currency = QueryServiceHelper.queryOne((String)"bd_currency", (String)"amtPrecision", (QFilter[])new QFilter("id", "=", ((DynamicObject)this.getModel().getValue("basecurrency")).getPkValue()).toArray());
            int amtPrecision = currency.getInt("amtPrecision");
            for (int i = 0; i < simulationCount; ++i) {
                this.currentBalances[i] = row.getBigDecimal("reportGapAmount").divide(unit, amtPrecision, RoundingMode.HALF_UP);
                this.simulationPls[i] = row.getBigDecimal("pl" + (i + 1)).divide(unit, amtPrecision, RoundingMode.HALF_UP);
                this.simulationBalances[i] = row.getBigDecimal("balance" + (i + 1)).divide(unit, amtPrecision, RoundingMode.HALF_UP);
            }
        }
        dataSet.close();
        return true;
    }

    private void createYAxis(HistogramChart chart) {
        Axis yAxis = chart.createYAxis(this.yAxisName, AxisType.category);
        yAxis.setCategorys(this.categories);
        yAxis.setPosition(Position.bottom);
        yAxis.setPropValue("nameGap", (Object)"5");
        HashMap<String, int[]> map = new HashMap<String, int[]>();
        map.put("padding", new int[]{0, 55, 0, 0});
        yAxis.setPropValue("nameTextStyle", map);
        HashMap<String, Constable> axisTick = new HashMap<String, Constable>();
        axisTick.put("interval", Integer.valueOf(0));
        axisTick.put("show", Boolean.valueOf(false));
        yAxis.setPropValue("axisTick", axisTick);
        this.setLineColor(yAxis);
    }

    private void createXAxis(HistogramChart chart) {
        Axis xAxis = chart.createXAxis(this.xAxisName, AxisType.value);
        xAxis.setPropValue("nameGap", (Object)"5");
        HashMap<String, int[]> map = new HashMap<String, int[]>();
        map.put("padding", new int[]{0, 0, 5, -45});
        xAxis.setPropValue("nameTextStyle", map);
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>();
        axisTick.put("show", false);
        xAxis.setPropValue("axisTick", axisTick);
        HashMap splitLine = new HashMap();
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        xAxis.setPropValue("splitLine", splitLine);
        this.setLineColor(xAxis);
    }

    private void setData(HistogramChart chart) {
        BarSeries barSeries1 = this.createBarSeries(chart, ResManager.loadKDString((String)"\u5f53\u524d\u4f59\u989d", (String)"ExRateSensitivityAnalysisCardPlugin_1", (String)"tmc-mrm-formplugin", (Object[])new Object[0]), "#20A7F0");
        barSeries1.setData((Number[])this.currentBalances);
        BarSeries barSeries2 = this.createBarSeries(chart, ResManager.loadKDString((String)"\u635f\u76ca", (String)"ExRateSensitivityAnalysisCardPlugin_2", (String)"tmc-mrm-formplugin", (Object[])new Object[0]), "#45DAD1");
        barSeries2.setData((Number[])this.simulationPls);
        BarSeries barSeries3 = this.createBarSeries(chart, ResManager.loadKDString((String)"\u4f59\u989d", (String)"ExRateSensitivityAnalysisCardPlugin_3", (String)"tmc-mrm-formplugin", (Object[])new Object[0]), "#A0D911");
        barSeries3.setData((Number[])this.simulationBalances);
        chart.bindData(null);
    }

    private BarSeries createBarSeries(HistogramChart chart, String name, String color) {
        BarSeries barSeries = chart.createBarSeries(name);
        barSeries.setBarWidth("20px");
        barSeries.setAnimationDuration(1500);
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, HashMap<String, String>> itemStyle = new HashMap<String, HashMap<String, String>>();
        map.put("color", String.format("new echarts.graphic.LinearGradient(0, 0, 0, 1, [{\"offset\": 0,\"color\": '%s'}, {\"offset\": 1, \"color\": '%s'}])", color, color));
        itemStyle.put("normal", map);
        barSeries.setPropValue("itemStyle", itemStyle);
        ArrayList<String> list = new ArrayList<String>();
        list.add("itemStyle");
        list.add("normal");
        list.add("color");
        barSeries.addFuncPath(list);
        barSeries.setLabel(null);
        return barSeries;
    }

    private void setLineColor(Axis axis) {
        HashMap axisLineMap = new HashMap();
        HashMap<String, String> lineStyleMap = new HashMap<String, String>();
        lineStyleMap.put("color", "#999999");
        axisLineMap.put("lineStyle", lineStyleMap);
        axis.setPropValue("axisLine", axisLineMap);
    }
}

