/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.formplugin.sensitivityanalysis;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.RefBillEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeF7ViewDetailEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;
import kd.tmc.mrm.business.service.scenariosimulation.ExScenarioSimulationService;
import kd.tmc.mrm.common.enums.ExScenarioMethodEnum;
import kd.tmc.mrm.common.helper.OrgHelper;
import kd.tmc.mrm.common.helper.TmcBaseDataServiceHelper;
import kd.tmc.mrm.formplugin.common.Validator;

public class ExRateSensitivityAnalysisEdit
extends AbstractTmcBillEdit
implements BeforeF7SelectListener,
HyperLinkClickListener {
    private static final String[] RPT_SCENARIO_SIMULATION_PROPS = new String[]{"pl1", "pl2", "pl3", "pl4", "pl5", "balance1", "balance2", "balance3", "balance4", "balance5"};
    private static final String[] RPT_PROPS = new String[]{"tippanel", "reporttoolbar", "report", "reportcurrency", "currentexrate", "gapdirect", "balance"};
    private static final String[] IGNORE_PROPS = new String[]{"draft", "orgview", "orgs", "rptcurrencyfilter", "chartcurrencyfilter", "gapdirectfilter"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entry = (EntryGrid)this.getControl("report");
        if (entry != null) {
            entry.addHyperClickListener((HyperLinkClickListener)this);
        }
        MulBasedataEdit rptCurrencyFilter = (MulBasedataEdit)this.getControl("rptcurrencyfilter");
        rptCurrencyFilter.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit chartCurrencyFilter = (BasedataEdit)this.getControl("chartcurrencyfilter");
        chartCurrencyFilter.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit orgView = (BasedataEdit)this.getView().getControl("orgview");
        orgView.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit org = (BasedataEdit)this.getView().getControl("orgs");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit forexQuote = (BasedataEdit)this.getView().getControl("forexquote");
        Optional.ofNullable(forexQuote).ifPresent(c -> c.addBeforeF7ViewDetailListener(this::beforeF7ViewDetail));
        RefBillEdit gap = (RefBillEdit)this.getView().getControl("exrategap");
        Optional.ofNullable(gap).ifPresent(c -> c.addBeforeF7SelectListener((BeforeF7SelectListener)this));
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setBaseCurrency();
        this.getView().setVisible(Boolean.FALSE, RPT_PROPS);
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.setBaseCurrency();
        this.setDraft();
        this.getView().setVisible(Boolean.FALSE, RPT_PROPS);
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.refreshRpt();
        this.checkChangedProps();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        switch (name = e.getProperty().getName()) {
            case "exrategap": {
                DynamicObject gap = (DynamicObject)this.getModel().getValue("exrategap");
                if (gap != null) {
                    gap = QueryServiceHelper.queryOne((String)gap.getDataEntityType().getName(), (String)"subjectSystem,sectionCfg,currentAnalysisObj,forexQuote", (QFilter[])new QFilter("id", "=", gap.getPkValue()).toArray());
                    this.getModel().setValue("subjectsystem", gap.get("subjectsystem"));
                    this.getModel().setValue("sectioncfg", gap.get("sectioncfg"));
                    this.getModel().setValue("currentanalysisobj", gap.get("currentanalysisobj"));
                    this.getModel().setValue("forexquote", gap.get("forexquote"));
                    break;
                }
                this.getModel().setValue("subjectsystem", null);
                this.getModel().setValue("sectioncfg", null);
                this.getModel().setValue("currentanalysisobj", null);
                this.getModel().setValue("forexquote", null);
                break;
            }
            case "currentanalysisobj": {
                this.setDraft();
                break;
            }
            case "useexsitgap": {
                if (((Boolean)this.getModel().getValue("useexsitgap")).booleanValue()) break;
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"exrategap", null);
                break;
            }
            case "orgview": {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"orgs", null);
                this.refreshRpt();
                break;
            }
            case "amtunit": 
            case "orgs": 
            case "rptcurrencyfilter": {
                this.refreshRpt();
                break;
            }
            case "org": {
                this.setBaseCurrency();
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate op = (FormOperate)args.getSource();
        if ("save".equals(op.getOperateKey())) {
            DynamicObject gap;
            boolean b = false;
            if (((Boolean)this.getModel().getValue("useexsitgap")).booleanValue() && (gap = (DynamicObject)this.getModel().getValue("exrategap")) != null) {
                gap = QueryServiceHelper.queryOne((String)gap.getDataEntityType().getName(), (String)"subjectSystem,sectionCfg,currentAnalysisObj,forexQuote", (QFilter[])new QFilter("id", "=", gap.getPkValue()).toArray());
                this.getModel().setValue("subjectsystem", gap.get("subjectsystem"));
                this.getModel().setValue("sectioncfg", gap.get("sectioncfg"));
                this.getModel().setValue("currentanalysisobj", gap.get("currentanalysisobj"));
                b = true;
            }
            if (!b) {
                this.setDraft();
            }
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"rptcurrencyfilter", null);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"chartcurrencyfilter", null);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"gapdirectfilter", (Object)"sum");
        }
        if ("exportEntry".equalsIgnoreCase(op.getOperateKey())) {
            int entryRowCount = this.getModel().getEntryRowCount("report");
            int[] a = new int[entryRowCount];
            for (int i = 0; i < entryRowCount; ++i) {
                a[i] = i;
            }
            EntryGrid grid = (EntryGrid)this.getView().getControl("report");
            grid.selectRows(a, 0);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("save".equals(e.getOperateKey()) && e.getOperationResult().isSuccess()) {
            this.refreshRpt();
        }
        if ("viewReportDetail".equalsIgnoreCase(e.getOperateKey())) {
            String appId = this.getView().getFormShowParameter().getAppId();
            if (!PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"mrm_exrate_sens_detail", (String)"47150e89000000ac")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0%s\u67e5\u8be2\u6743\u9650\uff0c\u8bf7\u5148\u914d\u7f6e\u6743\u9650\u3002", (String)"ExRateSensitivityAnalysisEdit_3", (String)"tmc-mrm-formplugin", (Object[])new Object[]{MetadataServiceHelper.getDataEntityType((String)"mrm_exrate_sens_detail").getDisplayName().getLocaleValue()}));
                return;
            }
            ListShowParameter param = ShowFormHelper.createShowListForm((String)"mrm_exrate_sens_detail", (boolean)true, (int)0, (boolean)false);
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            ListFilterParameter filterParameter = new ListFilterParameter();
            DynamicObjectCollection col = (DynamicObjectCollection)this.getModel().getValue("rptcurrencyfilter");
            List currencyIds = col.stream().map(o -> o.getDynamicObject("fBaseDataId").getLong("id")).collect(Collectors.toList());
            QFilter qFilter = new QFilter("srcbillid", "=", this.getModel().getDataEntity().getPkValue()).and("inorout", "=", (Object)"sum");
            if (EmptyUtil.isNoEmpty(currencyIds)) {
                qFilter = qFilter.and("cashflowcurrency", "in", currencyIds);
            } else {
                Long[] rankCurrencySet = null;
                String currencyStrArr = this.getView().getPageCache().get("rankCurrencySet");
                if (currencyStrArr != null) {
                    rankCurrencySet = (Long[])Arrays.stream(currencyStrArr.split(",")).map(Long::valueOf).toArray(Long[]::new);
                }
                if (EmptyUtil.isNoEmpty(rankCurrencySet)) {
                    qFilter.and("cashflowcurrency", "in", rankCurrencySet);
                }
            }
            DynamicObject orgView = (DynamicObject)this.getModel().getValue("orgview");
            DynamicObjectCollection orgCol = (DynamicObjectCollection)this.getModel().getValue("orgs");
            String orgFunc = ((MulBasedataProp)((MulBasedataEdit)this.getControl("orgs")).getProperty()).getOrgFunc();
            List orgIds = OrgHelper.getPermOrgIds((DynamicObject)orgView, (DynamicObjectCollection)orgCol, (String)orgFunc, (String)this.getView().getFormShowParameter().getAppId(), (String)"mrm_exrate_sensitivity");
            if (orgIds != null) {
                qFilter.and("org", "in", (Object)orgIds);
            }
            filterParameter.setFilter(qFilter);
            param.setListFilterParameter(filterParameter);
            DynamicObject dbObj = QueryServiceHelper.queryOne((String)this.getModel().getDataEntityType().getName(), (String)"scenariosimulation", (QFilter[])new QFilter("id", "=", this.getModel().getDataEntity().getPkValue()).toArray());
            param.setCustomParam("scenarioSimulationId", dbObj.get("scenariosimulation"));
            this.getView().showForm((FormShowParameter)param);
        }
        if ("calcAndView".equalsIgnoreCase(e.getOperateKey())) {
            this.validateBaseCurrency();
            this.validateMustInputForGapView("amtunit");
            this.validateMustInputForGapView("subjectsystem");
            this.validateMustInputForGapView("sectioncfg");
            this.validateMustInputForGapView("currentanalysisobj");
            this.validateMustInputForGapView("forexquote");
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("mrm_exrate_sens_gap");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setStatus(OperationStatus.EDIT);
            this.getView().showForm(showParameter);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String property = event.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        switch (property) {
            case "rptcurrencyfilter": 
            case "chartcurrencyfilter": {
                Long scenarioSimulationId;
                if (!Validator.validateMustInput(this.getView(), this.getModel(), "scenariosimulation")) {
                    event.setCancel(true);
                    return;
                }
                this.validateBaseCurrency();
                if (EmptyUtil.isNoEmpty((Object)this.getModel().getDataEntity().getPkValue())) {
                    DynamicObject dbObj = QueryServiceHelper.queryOne((String)this.getModel().getDataEntityType().getName(), (String)"scenariosimulation", (QFilter[])new QFilter("id", "=", this.getModel().getDataEntity().getPkValue()).toArray());
                    scenarioSimulationId = dbObj.getLong("scenariosimulation");
                } else {
                    DynamicObject scenarioSimulation = (DynamicObject)this.getModel().getValue("scenariosimulation");
                    scenarioSimulationId = scenarioSimulation.getLong("id");
                }
                ExScenarioSimulationService exScenarioSimulationService = new ExScenarioSimulationService(scenarioSimulationId, new Date());
                Set currencySet = exScenarioSimulationService.getCurrencySet();
                DynamicObject baseCurrency = (DynamicObject)this.getModel().getValue("basecurrency");
                if (EmptyUtil.isNoEmpty((Object)currencySet)) {
                    currencySet.remove(baseCurrency.getLong("id"));
                    showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)currencySet));
                    break;
                }
                Long[] rankCurrencySet = null;
                String currencyStrArr = this.getView().getPageCache().get("rankCurrencySet");
                if (currencyStrArr != null) {
                    rankCurrencySet = (Long[])Arrays.stream(currencyStrArr.split(",")).map(Long::valueOf).toArray(Long[]::new);
                }
                if (EmptyUtil.isNoEmpty(rankCurrencySet)) {
                    showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)rankCurrencySet));
                    break;
                }
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "!=", baseCurrency.getPkValue()));
                break;
            }
            case "exrategap": {
                List orgIds = OrgHelper.getPermOrgIds(null, null, (String)OrgViewTypeEnum.IS_BANKROLL.getViewType(), (String)this.getView().getFormShowParameter().getServiceAppId(), (String)"mrm_exrate_gap_analysis");
                if (orgIds == null) break;
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("org", "in", (Object)orgIds));
                break;
            }
            case "orgview": {
                this.validateBaseCurrency();
                DataSet ds = OrgHelper.getAuthorizedBankOrgViewDataSet((Long)RequestContext.get().getCurrUserId());
                HashSet<Long> ids = new HashSet<Long>(16);
                if (ds != null) {
                    while (ds.hasNext()) {
                        ids.add(ds.next().getLong("id"));
                    }
                }
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("treeType", "!=", (Object)OrgViewTypeEnum.IS_BANKROLL.getViewType()).or(new QFilter("treeType", "=", (Object)OrgViewTypeEnum.IS_BANKROLL.getViewType()).and("id", "in", ids)));
                break;
            }
            case "orgs": {
                this.validateBaseCurrency();
                String appId = this.getView().getFormShowParameter().getAppId();
                DynamicObject orgView = (DynamicObject)this.getModel().getValue("orgview");
                List orgIds = OrgHelper.getPermOrgIds((DynamicObject)orgView, null, null, (String)appId, (String)"mrm_exrate_sensitivity");
                if (orgIds == null) break;
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)orgIds));
                break;
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName;
        switch (fieldName = evt.getFieldName()) {
            case "pl1": 
            case "pl2": 
            case "pl3": 
            case "pl4": 
            case "pl5": {
                String gapDirect = (String)this.getModel().getValue("gapdirect", evt.getRowIndex());
                if (!"sum".equals(gapDirect)) break;
                DynamicObject reportCurrency = (DynamicObject)this.getModel().getValue("reportcurrency", evt.getRowIndex() - 1);
                if (reportCurrency == null) {
                    reportCurrency = (DynamicObject)this.getModel().getValue("reportcurrency", evt.getRowIndex() - 2);
                }
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("mrm_exrate_sens_section_d");
                showParameter.setCustomParam("currencyId", reportCurrency.getPkValue());
                showParameter.setCustomParam("srcBillId", this.getModel().getDataEntity().getPkValue());
                showParameter.setCustomParam("fieldName", (Object)fieldName);
                showParameter.setCustomParam("amtunit", this.getModel().getValue("amtunit"));
                showParameter.setCaption(ResManager.loadKDString((String)"%1$s%2$s\u533a\u95f4\u660e\u7ec6", (String)"ExRateSensitivityAnalysisEdit_2", (String)"tmc-mrm-formplugin", (Object[])new Object[]{reportCurrency.getString("name"), this.getPageCache().get("group" + fieldName.charAt(2))}));
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setStatus(OperationStatus.VIEW);
                this.getView().showForm(showParameter);
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        DataEntityState dataEntityState = this.getModel().getDataEntity().getDataEntityState();
        Iterable bizChangedProperties = dataEntityState.getBizChangedProperties();
        HashSet changedProps = new HashSet();
        bizChangedProperties.forEach(o -> changedProps.add(o.getName().split("_")[0]));
        Arrays.asList(IGNORE_PROPS).forEach(changedProps::remove);
        this.getModel().setDataChanged(false);
        if (!changedProps.isEmpty()) {
            for (String changedProp : changedProps) {
                Object value = this.getModel().getValue(changedProp);
                if (!(value instanceof OrmLocaleValue)) {
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)changedProp, null);
                }
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)changedProp, (Object)value);
            }
        }
    }

    private void checkChangedProps() {
        DynamicObject exRateGapBill;
        Date GapBillModifyTime;
        List<String> changedColumnPropList = new ArrayList<String>(1);
        if (((Boolean)this.getModel().getValue("useexsitgap")).booleanValue() && (GapBillModifyTime = (exRateGapBill = QueryServiceHelper.queryOne((String)"mrm_exrate_gap_analysis", (String)"modifyTime", (QFilter[])new QFilter("id", "=", ((DynamicObject)this.getModel().getValue("exrategap")).getPkValue()).toArray())).getDate("modifyTime")).getTime() / 1000L != ((Date)this.getModel().getValue("gaptime")).getTime() / 1000L) {
            changedColumnPropList.add(((IDataEntityProperty)this.getModel().getDataEntity().getDataEntityType().getProperties().get((Object)"exrategap")).getDisplayName().getLocaleValue());
        }
        if (((DynamicObject)this.getModel().getValue("currentanalysisobj")).getDate("modifyTime").getTime() / 1000L != ((Date)this.getModel().getValue("currentanalysisobjtime")).getTime() / 1000L) {
            changedColumnPropList.add(((IDataEntityProperty)this.getModel().getDataEntity().getDataEntityType().getProperties().get((Object)"currentanalysisobj")).getDisplayName().getLocaleValue());
        }
        if (((DynamicObject)this.getModel().getValue("forexquote")).getDate("modifyTime").getTime() / 1000L != ((Date)this.getModel().getValue("forexquotetime")).getTime() / 1000L) {
            changedColumnPropList.add(((IDataEntityProperty)this.getModel().getDataEntity().getDataEntityType().getProperties().get((Object)"forexquote")).getDisplayName().getLocaleValue());
        }
        if (((DynamicObject)this.getModel().getValue("scenariosimulation")).getDate("modifyTime").getTime() / 1000L != ((Date)this.getModel().getValue("scenariosimulationtime")).getTime() / 1000L) {
            changedColumnPropList.add(((IDataEntityProperty)this.getModel().getDataEntity().getDataEntityType().getProperties().get((Object)"scenariosimulation")).getDisplayName().getLocaleValue());
        }
        if (changedColumnPropList.size() > 0) {
            changedColumnPropList = changedColumnPropList.stream().map(o -> "\u201c" + o + "\u201d").collect(Collectors.toList());
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u5df2\u53d1\u751f\u53d8\u52a8\uff0c\u8bf7\u91cd\u65b0\u8ba1\u7b97\u83b7\u53d6\u6700\u65b0\u7ed3\u679c\u3002", (String)"ExRateSensitivityAnalysisEdit_0", (String)"tmc-mrm-formplugin", (Object[])new Object[0]), String.join((CharSequence)"\u3001", changedColumnPropList)));
        }
    }

    private void beforeF7ViewDetail(BeforeF7ViewDetailEvent event) {
        Object pkId = event.getPkId();
        BasedataEdit source = (BasedataEdit)event.getSource();
        String key = source.getKey();
        if ("forexquote".equals(key)) {
            event.setCancel(true);
            BillShowParameter billShowParameter = new BillShowParameter();
            String formId = "md_forexQuote";
            billShowParameter.setFormId(formId);
            billShowParameter.setPkId(pkId);
            billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            billShowParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)billShowParameter);
        }
    }

    private void refreshRpt() {
        int i;
        BigDecimal unit;
        if (BillOperationStatus.ADDNEW == ((BillShowParameter)this.getView().getFormShowParameter()).getBillStatus()) {
            return;
        }
        DynamicObject dbObj = QueryServiceHelper.queryOne((String)this.getModel().getDataEntityType().getName(), (String)"scenarioSimulation,scenarioSimulation.scenarioMethod,scenarioSimulation.rankCount", (QFilter[])new QFilter("id", "=", this.getModel().getDataEntity().getPkValue()).toArray());
        ExScenarioSimulationService exScenarioSimulationService = new ExScenarioSimulationService(Long.valueOf(dbObj.getLong("scenariosimulation")), new Date());
        String[] simulateNameArr = exScenarioSimulationService.getSimulateNameArr();
        for (int i2 = 0; i2 < simulateNameArr.length; ++i2) {
            ((EntryGrid)this.getView().getControl("report")).setColumnProperty("group" + (i2 + 1), "header", (Object)new LocaleString(simulateNameArr[i2]));
            this.getPageCache().put("group" + (i2 + 1), simulateNameArr[i2]);
        }
        int simulationCount = simulateNameArr.length;
        MulBasedataDynamicObjectCollection currencyCol = (MulBasedataDynamicObjectCollection)this.getModel().getValue("rptcurrencyfilter");
        Set currencyIdSet = currencyCol.stream().map(o -> o.getDynamicObject("fBaseDataId").getLong("id")).collect(Collectors.toSet());
        DynamicObject orgView = (DynamicObject)this.getModel().getValue("orgview");
        DynamicObjectCollection orgCol = (DynamicObjectCollection)this.getModel().getValue("orgs");
        String appId = this.getView().getFormShowParameter().getAppId();
        List orgIds = OrgHelper.getPermOrgIds((DynamicObject)orgView, (DynamicObjectCollection)orgCol, (String)((MulBasedataProp)((MulBasedataEdit)this.getView().getControl("orgs")).getProperty()).getOrgFunc(), (String)appId, (String)"mrm_exrate_sensitivity");
        QFilter qFilter = new QFilter("srcBillId", "=", this.getModel().getDataEntity().getPkValue()).and("inOrOut", "in", (Object)new String[]{"in", "out"});
        if (orgIds != null) {
            qFilter.and("org", "in", (Object)orgIds);
        }
        String scenarioMethod = dbObj.getString("scenarioSimulation.scenarioMethod");
        int rankCount = dbObj.getInt("scenarioSimulation.rankCount");
        if (ExScenarioMethodEnum.RANK.getValue().equals(scenarioMethod) && rankCount > 0) {
            DataSet ds = QueryServiceHelper.queryDataSet((String)"ExRateSensitivityAnalysisEdit.rpt", (String)"mrm_exrate_sens_detail", (String)"cashFlowCurrency,reportGapAmount", (QFilter[])qFilter.toArray(), (String)"");
            ds = ds.groupBy(new String[]{"cashFlowCurrency"}).sum("reportGapAmount").finish().addField("abs(reportGapAmount)", "sumAmount").orderBy(new String[]{"sumAmount desc"});
            HashSet<Object> currencySet = new HashSet<Object>(8);
            while (ds.hasNext() && currencySet.size() < rankCount) {
                Row row = ds.next();
                currencySet.add(row.get("cashFlowCurrency"));
            }
            ds.close();
            qFilter.and("cashFlowCurrency", "in", currencySet);
            Set currencyStrArr = currencySet.stream().map(o -> o + "").collect(Collectors.toSet());
            this.getView().getPageCache().put("rankCurrencySet", String.join((CharSequence)",", currencyStrArr));
        } else {
            this.getView().getPageCache().remove("rankCurrencySet");
        }
        if (EmptyUtil.isNoEmpty(currencyIdSet)) {
            qFilter = qFilter.and("cashFlowCurrency", "in", currencyIdSet);
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"ExRateSensitivityAnalysisEdit.rpt", (String)"mrm_exrate_sens_detail", (String)"id,cashFlowCurrency,exRate,inOrOut,gapAmount,reportGapAmount,balance1,pl1,balance2,pl2,balance3,pl3,balance4,pl4,balance5,pl5", (QFilter[])qFilter.toArray(), (String)"");
        GroupbyDataSet groupedDataSet = dataSet.groupBy(new String[]{"cashFlowCurrency", "inOrOut"}).max("exRate").sum("gapAmount").sum("reportGapAmount");
        for (int i3 = 1; i3 <= simulationCount; ++i3) {
            groupedDataSet.sum("balance" + i3).sum("pl" + i3);
        }
        dataSet = groupedDataSet.finish();
        GroupbyDataSet groupedSumDataSet = dataSet.copy().groupBy(new String[]{"cashFlowCurrency"}).max("exRate").sum("gapAmount").sum("reportGapAmount");
        for (int i4 = 1; i4 <= simulationCount; ++i4) {
            groupedSumDataSet.sum("balance" + i4).sum("pl" + i4);
        }
        DataSet sumDataSet = groupedSumDataSet.finish();
        String[] ss = new String[simulationCount * 2 + 5];
        ss[0] = "cashFlowCurrency";
        ss[1] = "inOrOut";
        ss[2] = "exRate";
        ss[3] = "gapAmount";
        ss[4] = "reportGapAmount";
        for (int i5 = 1; i5 <= simulationCount; ++i5) {
            ss[i5 * 2 + 3] = "balance" + i5;
            ss[i5 * 2 + 4] = "pl" + i5;
        }
        sumDataSet = sumDataSet.addField("'sum'", "inOrOut").select(ss);
        dataSet = dataSet.union(sumDataSet);
        if ((dataSet = dataSet.rightJoin(sumDataSet).on("cashFlowCurrency", "cashFlowCurrency").select(ss, new String[]{"abs(reportGapAmount) as sumAmount"}).finish().orderBy(new String[]{"sumAmount desc", "cashFlowCurrency", "inOrOut"})).isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, RPT_PROPS);
            return;
        }
        this.getView().setVisible(Boolean.TRUE, RPT_PROPS);
        this.getModel().deleteEntryData("report");
        long currencyId = -1L;
        String amtUnit = (String)this.getModel().getValue("amtunit");
        BigDecimal bigDecimal = unit = EmptyUtil.isNoEmpty((String)amtUnit) ? new BigDecimal(amtUnit) : BigDecimal.ONE;
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            i = this.getModel().createNewEntryRow("report");
            long cashFlowCurrencyId = row.getLong("cashFlowCurrency");
            if (currencyId != cashFlowCurrencyId) {
                currencyId = cashFlowCurrencyId;
                this.getModel().setValue("reportcurrency", (Object)cashFlowCurrencyId, i);
                this.getModel().setValue("currentexrate", row.get("exRate"), i);
            }
            this.getModel().setValue("gapcurrency", (Object)row.getLong("cashFlowCurrency"), i);
            this.getModel().setValue("gapdirect", row.get("inOrOut"), i);
            this.getModel().setValue("gapamount", row.get("gapAmount"), i);
            this.getModel().setValue("balance", (Object)row.getBigDecimal("reportGapAmount").divide(unit, 10, RoundingMode.HALF_UP), i);
            for (int j = 1; j <= simulationCount; ++j) {
                this.getModel().setValue("balance" + j, (Object)row.getBigDecimal("balance" + j).divide(unit, 10, RoundingMode.HALF_UP), i);
                this.getModel().setValue("pl" + j, (Object)row.getBigDecimal("pl" + j).divide(unit, 10, RoundingMode.HALF_UP), i);
            }
        }
        dataSet.close();
        this.getView().setVisible(Boolean.TRUE, RPT_SCENARIO_SIMULATION_PROPS);
        if (simulationCount < 5) {
            String[] hiddenProps = new String[(5 - simulationCount) * 2];
            for (i = simulationCount + 1; i <= 5; ++i) {
                hiddenProps[(i - simulationCount - 1) * 2] = "pl" + i;
                hiddenProps[(i - simulationCount - 1) * 2 + 1] = "balance" + i;
            }
            this.getView().setVisible(Boolean.FALSE, hiddenProps);
        }
    }

    private void setDraft() {
        DynamicObject analysisObj = (DynamicObject)this.getModel().getValue("currentanalysisobj");
        if (analysisObj != null) {
            DynamicObject draft = analysisObj.getDynamicObject("draft");
            this.getModel().setValue("draft", (Object)draft);
        } else {
            this.getModel().setValue("draft", null);
        }
    }

    private void validateMustInputForGapView(String key) {
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue(key))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c%s\u201d\u672a\u9009\u62e9\uff0c\u8bf7\u9009\u62e9\u540e\u518d\u8ba1\u7b97\u6c47\u7387\u655e\u53e3\u3002", (String)"ExRateSensitivityAnalysisEdit_1", (String)"tmc-mrm-formplugin", (Object[])new Object[]{this.getModel().getProperty(key).getDisplayName().getLocaleValue()}));
        }
    }

    private void setBaseCurrency() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            return;
        }
        Map result = TmcBaseDataServiceHelper.getBaseAccountingInfo((Long)org.getLong("id"));
        if (EmptyUtil.isNoEmpty((Object)result) && EmptyUtil.isNoEmpty((Long)((Long)result.get("baseCurrencyID")))) {
            Long localCurrencyId = (Long)result.get("baseCurrencyID");
            this.getModel().setValue("basecurrency", (Object)localCurrencyId);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c%s\u201d\u5206\u6790\u4e3b\u4f53\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7684\u672c\u4f4d\u5e01\uff0c\u8bf7\u5148\u7ef4\u62a4\u672c\u4f4d\u5e01\u3002", (String)"ExScenarioSimulationEdit_11", (String)"tmc-mrm-formplugin", (Object[])new Object[]{org.getString("name")}));
        }
    }

    private void validateBaseCurrency() {
        Validator.validateMustInput(this.getModel(), "org");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (this.getModel().getValue("basecurrency") == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c%s\u201d\u5206\u6790\u4e3b\u4f53\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7684\u672c\u4f4d\u5e01\uff0c\u8bf7\u5148\u7ef4\u62a4\u672c\u4f4d\u5e01\u3002", (String)"ExScenarioSimulationEdit_11", (String)"tmc-mrm-formplugin", (Object[])new Object[]{org.getString("name")}));
        }
    }
}

