/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.formplugin.sensitivityanalysis;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeF7ViewDetailEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;
import kd.tmc.mrm.business.service.scenariosimulation.ScenarioSimulationService;
import kd.tmc.mrm.business.service.sensitivityanalysis.SensitivityAnalysisService;
import kd.tmc.mrm.common.enums.ScenarioTypeEnum;
import kd.tmc.mrm.common.enums.SensitivityAnalysisDescEnum;
import kd.tmc.mrm.common.helper.GapAnalysisHelper;
import kd.tmc.mrm.common.helper.OrgHelper;
import kd.tmc.mrm.common.helper.SensitivityAnalysisHelper;

public class SensitivityAnalysisEdit
extends AbstractTmcBillEdit
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(SensitivityAnalysisEdit.class);
    private static final String[] IGNORE_PROPS = new String[]{"draft", "orgview", "orgs", "currency", "referencerate", "subjecttypefilter"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        MulBasedataEdit scenarioSimulation = (MulBasedataEdit)this.getControl("scenariosimulation");
        scenarioSimulation.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit gapanalysis = (BasedataEdit)this.getControl("gapanalysis");
        gapanalysis.addBeforeF7ViewDetailListener(this::beforeF7ViewDetail);
        BasedataEdit orgView = (BasedataEdit)this.getView().getControl("orgview");
        orgView.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit org = (BasedataEdit)this.getView().getControl("orgs");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit forexquote = (BasedataEdit)this.getView().getControl("forexquote");
        Optional.ofNullable(forexquote).ifPresent(c -> c.addBeforeF7ViewDetailListener(this::beforeF7ViewDetail));
        gapanalysis.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    private void beforeF7ViewDetail(BeforeF7ViewDetailEvent event) {
        Object pkId = event.getPkId();
        BasedataEdit source = (BasedataEdit)event.getSource();
        String key = source.getKey();
        if ("gapanalysis".equals(key)) {
            event.setCancel(true);
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.setFormId("mrm_gap_analysis");
            billShowParameter.setPkId(pkId);
            billShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            billShowParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)billShowParameter);
        } else if ("forexquote".equals(key)) {
            event.setCancel(true);
            BillShowParameter billShowParameter = new BillShowParameter();
            String formid = "md_forexquote";
            billShowParameter.setFormId(formid);
            billShowParameter.setPkId(pkId);
            billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            billShowParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)billShowParameter);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"entryentity1", "entryentity2"});
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("reporttitiles"))) {
            this.refreshReport();
            this.changedPropsTip();
            this.getModel().setDataChanged(false);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7248\u672c\u5347\u7ea7\u540e\uff0c\u5bf9\u4e8e\u5386\u53f2\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u8ba1\u7b97\u83b7\u53d6\u62a5\u8868\u7ed3\u679c\u3002", (String)"ExRateGapAnalysisEdit_4", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"entryentity1", "entryentity2"});
        }
        this.initPeriodItems();
        this.setBackScenarioType();
    }

    private void setBackScenarioType() {
        DynamicObjectCollection scenariosimulations;
        String scenariotype = (String)this.getModel().getDataEntity().get("scenariotype");
        if (EmptyUtil.isEmpty((String)scenariotype) && !(scenariosimulations = this.getModel().getDataEntity().getDynamicObjectCollection("scenariosimulation")).isEmpty()) {
            DynamicObject scenariosimulation = (DynamicObject)scenariosimulations.get(0);
            DynamicObject simulation = TmcDataServiceHelper.loadSingle((Object)scenariosimulation.getDynamicObject("fbasedataid").get("id"), (String)"mrm_scenario_simulation", (String)"scenariotype");
            String type = simulation.getString("scenariotype");
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"scenariotype", (Object)type);
        }
    }

    private void initPeriodItems() {
        String periodItemStr = (String)this.getModel().getValue("perioditems");
        String[] itemArray = periodItemStr.split(",");
        ArrayList<ComboItem> periodItem = new ArrayList<ComboItem>(itemArray.length);
        for (String itemStr : itemArray) {
            periodItem.add(new ComboItem(new LocaleString(itemStr), itemStr));
        }
        ComboEdit periodControl = (ComboEdit)this.getControl("period");
        periodControl.setComboItems(periodItem);
    }

    private void changedPropsTip() {
        ArrayList<String> changedColumnPropList = new ArrayList<String>(1);
        if (((DynamicObject)this.getModel().getValue("gapanalysis")).getDate("modifytime").getTime() / 1000L != ((Date)this.getModel().getValue("gapanalysistime")).getTime() / 1000L) {
            changedColumnPropList.add("\u201c" + ((IDataEntityProperty)this.getModel().getDataEntity().getDataEntityType().getProperties().get((Object)"gapanalysis")).getDisplayName() + "\u201c");
        }
        if (((DynamicObject)this.getModel().getValue("forexquote")).getDate("modifytime").getTime() / 1000L != ((Date)this.getModel().getValue("forexquotetime")).getTime() / 1000L) {
            changedColumnPropList.add("\u201c" + ((IDataEntityProperty)this.getModel().getDataEntity().getDataEntityType().getProperties().get((Object)"forexquote")).getDisplayName() + "\u201c");
        }
        DynamicObjectCollection scenarioSimulationCol = (DynamicObjectCollection)this.getModel().getValue("scenariosimulation");
        boolean isScenarioSimulationChanged = false;
        for (int index = 0; index < scenarioSimulationCol.size(); ++index) {
            if (((DynamicObject)scenarioSimulationCol.get(index)).getDynamicObject("fbasedataid").getDate("modifytime").getTime() / 1000L == ((Date)this.getModel().getValue("e_scenariosimulationtime", index)).getTime() / 1000L) continue;
            isScenarioSimulationChanged = true;
            break;
        }
        if (isScenarioSimulationChanged) {
            changedColumnPropList.add("\u201c" + ((IDataEntityProperty)this.getModel().getDataEntity().getDataEntityType().getProperties().get((Object)"scenariosimulation")).getDisplayName() + "\u201c");
        }
        if (changedColumnPropList.size() == 1) {
            String tipInfo = ResManager.loadKDString((String)"%s\u5df2\u53d1\u751f\u53d8\u52a8\uff0c\u8bf7\u91cd\u65b0\u8ba1\u7b97\u83b7\u53d6\u6700\u65b0\u7ed3\u679c\u3002", (String)"SensitivityAnalysisEdit_9", (String)"tmc-mrm-formplugin", (Object[])new Object[]{changedColumnPropList.get(0)});
            this.getView().showTipNotification(tipInfo);
        } else if (changedColumnPropList.size() == 2) {
            String tipInfo = ResManager.loadKDString((String)"%1$s\u3001%2$s\u5df2\u53d1\u751f\u53d8\u52a8\uff0c\u8bf7\u91cd\u65b0\u8ba1\u7b97\u83b7\u53d6\u6700\u65b0\u7ed3\u679c\u3002", (String)"SensitivityAnalysisEdit_8", (String)"tmc-mrm-formplugin", (Object[])new Object[]{changedColumnPropList.get(0), changedColumnPropList.get(1)});
            this.getView().showTipNotification(tipInfo);
        } else if (changedColumnPropList.size() == 3) {
            String tipInfo = ResManager.loadKDString((String)"%1$s\u3001%2$s\u3001%3$s\u5df2\u53d1\u751f\u53d8\u52a8\uff0c\u8bf7\u91cd\u65b0\u8ba1\u7b97\u83b7\u53d6\u6700\u65b0\u7ed3\u679c\u3002", (String)"SensitivityAnalysisEdit_7", (String)"tmc-mrm-formplugin", (Object[])new Object[]{changedColumnPropList.get(0), changedColumnPropList.get(1), changedColumnPropList.get(2)});
            this.getView().showTipNotification(tipInfo);
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.onChangeGapAnalysis();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"entryentity1", "entryentity2"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        switch (name) {
            case "gapanalysis": {
                this.onChangeGapAnalysis();
                break;
            }
            case "period": {
                this.setSection();
                break;
            }
            case "orgview": {
                long orgViewId = 0L;
                DynamicObject orgView = (DynamicObject)this.getModel().getValue("orgview");
                if (EmptyUtil.isNoEmpty((DynamicObject)orgView)) {
                    orgViewId = orgView.getLong("id");
                }
                if (EmptyUtil.isNoEmpty((Long)orgViewId)) {
                    Long permRootOrgId = TmcOrgDataHelper.getPermRootOrgId((Long)RequestContext.get().getCurrUserId(), (String)this.getView().getFormShowParameter().getAppId(), (String)this.getModel().getDataEntity().getDynamicObjectType().getName(), (String)"47150e89000000ac", (Long)orgViewId);
                    if (EmptyUtil.isNoEmpty((Long)permRootOrgId)) {
                        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"orgs", (Object)new Object[]{permRootOrgId});
                        this.getPageCache().put("orgs", String.valueOf(permRootOrgId));
                    } else {
                        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"orgs", null);
                        this.getPageCache().put("orgs", null);
                    }
                }
                if (!EmptyUtil.isNoEmpty((Object)this.getModel().getValue("amtunit"))) break;
                this.refreshReport();
                break;
            }
            case "amtunit": 
            case "currency": 
            case "referencerate": 
            case "orgs": {
                if (!EmptyUtil.isNoEmpty((Object)this.getModel().getValue("amtunit"))) break;
                this.refreshReport();
                break;
            }
            case "scenariosimulation": {
                if (EmptyUtil.isNoEmpty((Object)newValue)) {
                    DynamicObjectCollection col = (DynamicObjectCollection)newValue;
                    String onlyScenarioType = ((DynamicObject)((DynamicObject)col.get(0)).get("fbasedataid")).getString("scenariotype");
                    for (DynamicObject o : col) {
                        DynamicObject obj = (DynamicObject)o.get("fbasedataid");
                        String scenarioType = obj.getString("scenariotype");
                        if (StringUtils.equals((CharSequence)onlyScenarioType, (CharSequence)scenarioType)) continue;
                        throw new KDBizException(ResManager.loadKDString((String)"\u591a\u9009\u60c5\u666f\u65f6\u8bf7\u9009\u62e9\u540c\u4e00\u7c7b\u578b\u7684\u60c5\u666f\u3002", (String)"SensitivityAnalysisEdit_0", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
                    }
                    if (col.size() > 5) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u6700\u591a\u9009\u62e95\u4e2a\u3002", (String)"SensitivityAnalysisEdit_2", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
                    }
                    this.setScenariotype();
                    break;
                }
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"scenariotype", null);
            }
        }
    }

    private void setScenariotype() {
        DynamicObjectCollection scenariosimulations = this.getModel().getDataEntity().getDynamicObjectCollection("scenariosimulation");
        Set collect = scenariosimulations.stream().map(e -> e.getDynamicObject("fbasedataid").getString("scenariotype")).collect(Collectors.toSet());
        if (collect.size() == 1) {
            Optional first = collect.stream().findFirst();
            first.ifPresent(s -> TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"scenariotype", (Object)s));
        }
    }

    private void refreshReport() {
        if (BillOperationStatus.ADDNEW == ((BillShowParameter)this.getView().getFormShowParameter()).getBillStatus()) {
            return;
        }
        this.initReport();
        boolean isExistData = false;
        DynamicObject orgView = (DynamicObject)this.getModel().getValue("orgview");
        DynamicObjectCollection orgCol = (DynamicObjectCollection)this.getModel().getValue("orgs");
        String appId = this.getView().getFormShowParameter().getAppId();
        List orgIds = OrgHelper.getPermOrgIds((DynamicObject)orgView, (DynamicObjectCollection)orgCol, (String)((MulBasedataProp)((MulBasedataEdit)this.getView().getControl("orgs")).getProperty()).getOrgFunc(), (String)appId, (String)"mrm_sensitivity");
        MulBasedataDynamicObjectCollection referenceRateCol = (MulBasedataDynamicObjectCollection)this.getModel().getValue("referencerate");
        Set<Long> referenceRateIdSet = referenceRateCol.stream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
        MulBasedataDynamicObjectCollection currencyCol = (MulBasedataDynamicObjectCollection)this.getModel().getValue("currency");
        Set<Long> currencyIdSet = currencyCol.stream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
        DynamicObject dbObj = BusinessDataServiceHelper.loadSingle((Object)this.getModel().getDataEntity().getPkValue(), (String)this.getModel().getDataEntityType().getName(), (String)"scenarioSimulation,reportCurrency");
        DynamicObjectCollection scenarioSimulationCol = dbObj.getDynamicObjectCollection("scenariosimulation");
        String[] titles = new String[scenarioSimulationCol.size()];
        int i = 0;
        for (DynamicObject scenarioSimulation : scenarioSimulationCol) {
            titles[i] = scenarioSimulation.getDynamicObject("fbasedataid").getString("number");
            ++i;
        }
        DynamicObject reportCurrency = dbObj.getDynamicObject("reportcurrency");
        int scenarioSimulationIndex = 0;
        for (DynamicObject scenarioSimulation : scenarioSimulationCol) {
            ++scenarioSimulationIndex;
            DataSet dataSet = this.queryReportDataSet(orgIds, referenceRateIdSet, currencyIdSet, scenarioSimulation);
            if ((dataSet = dataSet.groupBy(new String[]{"scenario", "subjecttype"}).sum("gapamount").sum("beforeamount").sum("afteramount").sum("changeamt").finish()).isEmpty()) continue;
            isExistData = true;
            int rowNo = 0;
            int count = dataSet.copy().count("subjecttype", false);
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                rowNo = count == 1 ? 2 : ++rowNo;
                this.fillReport(scenarioSimulationIndex, row, rowNo);
            }
        }
        this.setSubjectType();
        this.genTotalRow(scenarioSimulationCol.size());
        this.dealAmtUnit(scenarioSimulationCol.size(), reportCurrency);
        if (!isExistData) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"entryentity1", "entryentity2"});
        } else {
            this.setEntryColumnHeader(titles);
        }
    }

    private boolean isOnlyCalcInterestChange() {
        DynamicObject dbObj = QueryServiceHelper.queryOne((String)this.getModel().getDataEntityType().getName(), (String)"scenariotype", (QFilter[])new QFilter("id", "=", this.getModel().getDataEntity().getPkValue()).toArray());
        return ScenarioTypeEnum.INTEREST_CHANGE.getValue().equals(dbObj.get("scenariotype"));
    }

    private void fillReport(int scenarioSimulationIndex, Row row, int rowNo) {
        String subjectTypeProp;
        if (row.getBigDecimal("gapamount").compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        int rowIndex = row.getBigDecimal("gapamount").compareTo(BigDecimal.ZERO) > 0 ? 0 : 1;
        String string = subjectTypeProp = this.isOnlyCalcInterestChange() ? "subjecttype2" : "subjecttype";
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue(subjectTypeProp, rowIndex))) {
            String subjectType = null;
            if ("in".equals(row.get("subjecttype"))) {
                subjectType = ResManager.loadKDString((String)"\u6d41\u5165", (String)"SensitivityAnalysisEdit_11", (String)"tmc-mrm-formplugin", (Object[])new Object[0]);
            } else if ("out".equals(row.get("subjecttype"))) {
                subjectType = ResManager.loadKDString((String)"\u6d41\u51fa", (String)"SensitivityAnalysisEdit_12", (String)"tmc-mrm-formplugin", (Object[])new Object[0]);
            }
            this.getModel().setValue(subjectTypeProp, (Object)subjectType, rowIndex);
        }
        if (this.isOnlyCalcInterestChange()) {
            this.getModel().setValue("amount" + scenarioSimulationIndex, (Object)row.getBigDecimal("afteramount"), rowIndex);
            this.setInterestChangeDesc(scenarioSimulationIndex, row, rowNo, "amount", "desc");
        } else {
            this.getModel().setValue("beforeamount" + scenarioSimulationIndex, (Object)row.getBigDecimal("beforeamount"), rowIndex);
            this.getModel().setValue("afteramount" + scenarioSimulationIndex, (Object)row.getBigDecimal("afteramount"), rowIndex);
            this.getModel().setValue("changeamount" + scenarioSimulationIndex, (Object)row.getBigDecimal("changeamt"), rowIndex);
            this.setInterestChangeDesc(scenarioSimulationIndex, row, rowNo, "changeamount", "changedesc");
        }
    }

    private void setInterestChangeDesc(int colIndex, Row row, int rowNo, String interestChangeAmtProp, String interestChangeDescProp) {
        int netFlag;
        int rowIndex = row.getBigDecimal("gapamount").compareTo(BigDecimal.ZERO) > 0 ? 0 : 1;
        int cmp = ((BigDecimal)this.getModel().getValue(interestChangeAmtProp + colIndex, rowIndex)).compareTo(BigDecimal.ZERO);
        int n = netFlag = rowNo == 2 ? ((BigDecimal)this.getModel().getValue(interestChangeAmtProp + colIndex, 0)).add((BigDecimal)this.getModel().getValue(interestChangeAmtProp + colIndex, 1)).compareTo(BigDecimal.ZERO) : 0;
        if (rowIndex == 0) {
            if (cmp > 0) {
                this.getModel().setValue(interestChangeDescProp + colIndex, (Object)SensitivityAnalysisDescEnum.INTEREST_IN_UP.getName(), rowIndex);
            } else if (cmp < 0) {
                this.getModel().setValue(interestChangeDescProp + colIndex, (Object)SensitivityAnalysisDescEnum.INTEREST_IN_DOWN.getName(), rowIndex);
            }
        } else if (cmp > 0) {
            this.getModel().setValue(interestChangeDescProp + colIndex, (Object)SensitivityAnalysisDescEnum.INTEREST_OUT_DOWN.getName(), rowIndex);
        } else if (cmp < 0) {
            this.getModel().setValue(interestChangeDescProp + colIndex, (Object)SensitivityAnalysisDescEnum.INTEREST_OUT_UP.getName(), rowIndex);
        }
        if (((BigDecimal)this.getModel().getValue(interestChangeAmtProp + colIndex, 0)).compareTo(BigDecimal.ZERO) > 0 || ((BigDecimal)this.getModel().getValue(interestChangeAmtProp + colIndex, 1)).compareTo(BigDecimal.ZERO) < 0) {
            if (netFlag > 0) {
                this.getModel().setValue(interestChangeDescProp + colIndex, (Object)SensitivityAnalysisDescEnum.INTEREST_NET_IN_UP.getName(), 2);
            } else if (netFlag < 0) {
                this.getModel().setValue(interestChangeDescProp + colIndex, (Object)SensitivityAnalysisDescEnum.INTEREST_NET_OUT_UP.getName(), 2);
            }
        } else if (((BigDecimal)this.getModel().getValue(interestChangeAmtProp + colIndex, 0)).compareTo(BigDecimal.ZERO) < 0 || ((BigDecimal)this.getModel().getValue(interestChangeAmtProp + colIndex, 1)).compareTo(BigDecimal.ZERO) > 0) {
            if (netFlag > 0) {
                this.getModel().setValue(interestChangeDescProp + colIndex, (Object)SensitivityAnalysisDescEnum.INTEREST_NET_OUT_DOWN.getName(), 2);
            } else if (netFlag < 0) {
                this.getModel().setValue(interestChangeDescProp + colIndex, (Object)SensitivityAnalysisDescEnum.INTEREST_NET_IN_DOWN.getName(), 2);
            }
        }
    }

    private void genTotalRow(int scenarioSimulationCount) {
        if (this.isOnlyCalcInterestChange()) {
            for (int i = 1; i <= scenarioSimulationCount; ++i) {
                this.getModel().setValue("amount" + i, (Object)((BigDecimal)this.getModel().getValue("amount" + i, 0)).add((BigDecimal)this.getModel().getValue("amount" + i, 1)), 2);
            }
        } else {
            for (int i = 1; i <= scenarioSimulationCount; ++i) {
                this.getModel().setValue("beforeamount" + i, (Object)((BigDecimal)this.getModel().getValue("beforeamount" + i, 0)).add((BigDecimal)this.getModel().getValue("beforeamount" + i, 1)), 2);
                this.getModel().setValue("afteramount" + i, (Object)((BigDecimal)this.getModel().getValue("afteramount" + i, 0)).add((BigDecimal)this.getModel().getValue("afteramount" + i, 1)), 2);
                this.getModel().setValue("changeamount" + i, (Object)((BigDecimal)this.getModel().getValue("changeamount" + i, 0)).add((BigDecimal)this.getModel().getValue("changeamount" + i, 1)), 2);
            }
        }
    }

    private void dealAmtUnit(int scenarioSimulationCount, DynamicObject reportCurrency) {
        BigDecimal amtUnit = new BigDecimal((String)this.getModel().getValue("amtunit"));
        if (this.isOnlyCalcInterestChange()) {
            for (int i = 1; i <= scenarioSimulationCount; ++i) {
                this.getModel().setValue("amount" + i, (Object)this.divide((BigDecimal)this.getModel().getValue("amount" + i, 0), amtUnit), 0);
                this.getModel().setValue("amount" + i, (Object)this.divide((BigDecimal)this.getModel().getValue("amount" + i, 1), amtUnit), 1);
                this.getModel().setValue("amount" + i, (Object)this.divide((BigDecimal)this.getModel().getValue("amount" + i, 2), amtUnit), 2);
                this.assembleInterestChangeDesc(i, "amount", "desc", reportCurrency);
            }
        } else {
            for (int i = 1; i <= scenarioSimulationCount; ++i) {
                this.getModel().setValue("beforeamount" + i, (Object)this.divide((BigDecimal)this.getModel().getValue("beforeamount" + i, 0), amtUnit), 0);
                this.getModel().setValue("beforeamount" + i, (Object)this.divide((BigDecimal)this.getModel().getValue("beforeamount" + i, 1), amtUnit), 1);
                this.getModel().setValue("beforeamount" + i, (Object)this.divide((BigDecimal)this.getModel().getValue("beforeamount" + i, 2), amtUnit), 2);
                this.getModel().setValue("afteramount" + i, (Object)this.divide((BigDecimal)this.getModel().getValue("afteramount" + i, 0), amtUnit), 0);
                this.getModel().setValue("afteramount" + i, (Object)this.divide((BigDecimal)this.getModel().getValue("afteramount" + i, 1), amtUnit), 1);
                this.getModel().setValue("afteramount" + i, (Object)this.divide((BigDecimal)this.getModel().getValue("afteramount" + i, 2), amtUnit), 2);
                this.getModel().setValue("changeamount" + i, (Object)this.divide((BigDecimal)this.getModel().getValue("changeamount" + i, 0), amtUnit), 0);
                this.getModel().setValue("changeamount" + i, (Object)this.divide((BigDecimal)this.getModel().getValue("changeamount" + i, 1), amtUnit), 1);
                this.getModel().setValue("changeamount" + i, (Object)this.divide((BigDecimal)this.getModel().getValue("changeamount" + i, 2), amtUnit), 2);
                this.assembleInterestChangeDesc(i, "changeamount", "changedesc", reportCurrency);
            }
        }
    }

    private void assembleInterestChangeDesc(int colIndex, String interestChangeAmtProp, String interestChangeDescProp, DynamicObject reportCurrency) {
        String desc0 = null;
        String desc1 = null;
        String desc2 = null;
        DecimalFormat df = new DecimalFormat("###,###.##########");
        if (EmptyUtil.isNoEmpty((Object)this.getModel().getValue(interestChangeAmtProp + colIndex, 0))) {
            desc0 = (String)this.getModel().getValue(interestChangeDescProp + colIndex, 0) + reportCurrency.get("sign") + df.format(((BigDecimal)this.getModel().getValue(interestChangeAmtProp + colIndex, 0)).abs().stripTrailingZeros());
        }
        if (EmptyUtil.isNoEmpty((Object)this.getModel().getValue(interestChangeAmtProp + colIndex, 1))) {
            desc1 = (String)this.getModel().getValue(interestChangeDescProp + colIndex, 1) + reportCurrency.get("sign") + df.format(((BigDecimal)this.getModel().getValue(interestChangeAmtProp + colIndex, 1)).abs().stripTrailingZeros());
        }
        if (EmptyUtil.isNoEmpty((Object)this.getModel().getValue(interestChangeAmtProp + colIndex, 2))) {
            desc2 = (String)this.getModel().getValue(interestChangeDescProp + colIndex, 2) + reportCurrency.get("sign") + df.format(((BigDecimal)this.getModel().getValue(interestChangeAmtProp + colIndex, 2)).abs().stripTrailingZeros());
        }
        this.getModel().setValue(interestChangeDescProp + colIndex, desc0, 0);
        this.getModel().setValue(interestChangeDescProp + colIndex, desc1, 1);
        this.getModel().setValue(interestChangeDescProp + colIndex, desc2, 2);
    }

    private DataSet queryReportDataSet(List<Long> orgIds, Set<Long> referenceRateIdSet, Set<Long> currencyIdSet, DynamicObject scenarioSimulation) {
        QFilter qFilter = new QFilter("sensitivityanalysis", "=", this.getModel().getValue("id")).and("scenariosimulationf7.id", "=", (Object)scenarioSimulation.getDynamicObject("fbasedataid").getLong("id"));
        if (EmptyUtil.isNoEmpty(referenceRateIdSet)) {
            qFilter.and("entryentity.draftdata.referencerate", "in", referenceRateIdSet);
        }
        if (EmptyUtil.isNoEmpty(currencyIdSet)) {
            qFilter.and("entryentity.entrycurrency", "in", currencyIdSet);
        }
        if (orgIds != null) {
            qFilter.and("entryentity.draftdata.org", "in", orgIds);
        }
        qFilter.and("sectionindex", "<", (Object)this.getModel().getEntryEntity("entryentity").size());
        qFilter.and("entryEntity.changeAmt", "!=", (Object)0);
        logger.info("scenarioSimulationId={}", (Object)scenarioSimulation.getDynamicObject("fbasedataid").getLong("id"));
        logger.info("referenceRateIdSet.size()={}", (Object)referenceRateIdSet.size());
        logger.info("currencyIdSet.size()={}", (Object)currencyIdSet.size());
        logger.info("orgIds.size()={}", orgIds != null ? Integer.valueOf(orgIds.size()) : null);
        logger.info("sectionIndex={}", (Object)this.getModel().getEntryEntity("entryentity").size());
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"GapQingAnalysisDataPlugin", (String)"mrm_sens_analysis_detail", (String)String.join((CharSequence)",", "subjecttype", "scenariosimulationf7.number as scenario", "entryentity.gapamount as gapamount", "entryentity.beforeamount as beforeamount", "entryentity.afteramount as afteramount", "entryentity.changeamt as changeamt"), (QFilter[])qFilter.toArray(), null);
        return dataSet;
    }

    private void initReport() {
        if (this.isOnlyCalcInterestChange()) {
            this.getModel().deleteEntryData("entryentity2");
            this.getModel().batchCreateNewEntryRow("entryentity2", 3);
            this.getModel().setValue("subjecttype2", (Object)ResManager.loadKDString((String)"\u51c0\u503c", (String)"SensitivityAnalysisEdit_1", (String)"tmc-mrm-formplugin", (Object[])new Object[0]), 2);
        } else {
            this.getModel().deleteEntryData("entryentity1");
            this.getModel().batchCreateNewEntryRow("entryentity1", 3);
            this.getModel().setValue("subjecttype", (Object)ResManager.loadKDString((String)"\u51c0\u503c", (String)"SensitivityAnalysisEdit_1", (String)"tmc-mrm-formplugin", (Object[])new Object[0]), 2);
        }
    }

    private void setSubjectType() {
        String subjectTypeProp;
        String string = subjectTypeProp = this.isOnlyCalcInterestChange() ? "subjecttype2" : "subjecttype";
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{this.getModel().getValue(subjectTypeProp, 0), this.getModel().getValue(subjectTypeProp, 1)})) {
            this.getModel().setValue(subjectTypeProp, (Object)ResManager.loadKDString((String)"\u6d41\u5165", (String)"SensitivityAnalysisEdit_11", (String)"tmc-mrm-formplugin", (Object[])new Object[0]), 0);
            this.getModel().setValue(subjectTypeProp, (Object)ResManager.loadKDString((String)"\u6d41\u51fa", (String)"SensitivityAnalysisEdit_12", (String)"tmc-mrm-formplugin", (Object[])new Object[0]), 1);
        }
    }

    private BigDecimal divide(BigDecimal amount, BigDecimal amtUnit) {
        if (amount == null) {
            return null;
        }
        return amount.divide(amtUnit, 2, RoundingMode.HALF_UP);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operate = op.getOperateKey();
        if ("calc".equals(operate)) {
            DynamicObject gapAnalysis;
            DynamicObject gapAnalysisDetail;
            String section;
            DynamicObjectCollection col = (DynamicObjectCollection)this.getModel().getValue("scenariosimulation");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)col)) {
                return;
            }
            String onlyScenarioType = ((DynamicObject)((DynamicObject)col.get(0)).get("fbasedataid")).getString("scenariotype");
            for (DynamicObject o : col) {
                DynamicObject obj = (DynamicObject)o.get("fbasedataid");
                String scenarioType = obj.getString("scenariotype");
                if (StringUtils.equals((CharSequence)onlyScenarioType, (CharSequence)scenarioType)) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u591a\u9009\u60c5\u666f\u65f6\u8bf7\u9009\u62e9\u540c\u4e00\u7c7b\u578b\u7684\u60c5\u666f\u3002", (String)"SensitivityAnalysisEdit_0", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
            if (!(section = (gapAnalysisDetail = QueryServiceHelper.queryOne((String)"mrm_gap_analysis_detail", (String)"section", (QFilter[])new QFilter("srcbillid", "=", (gapAnalysis = (DynamicObject)this.getModel().getValue("gapanalysis")).getPkValue()).toArray())).getString("section")).contains(",") || section.split(",").length != 3) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7248\u672c\u5347\u7ea7\u540e\uff0c\u8bf7\u5148\u91cd\u65b0\u8ba1\u7b97\u5173\u8054\u7684\u91cd\u5b9a\u4ef7\u7f3a\u53e3\u518d\u8fdb\u884c\u654f\u611f\u6027\u5206\u6790\u8ba1\u7b97\u3002", (String)"SensitivityAnalysisEdit_13", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        OperationResult operationResult = e.getOperationResult();
        if ("calc".equals(e.getOperateKey()) && operationResult.isSuccess()) {
            this.validateMustInput("billno");
            this.validateMustInput("reportcurrency");
            this.validateMustInput("forexquote");
            this.validateMustInput("gapanalysis");
            this.validateMustInput("scenariosimulation");
            this.validateMustInput("period");
            DynamicObject gapAnalysis = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)this.getModel().getValue("gapanalysis")).getPkValue(), (String)"mrm_gap_analysis");
            List list = GapAnalysisHelper.getChangedProps((DynamicObject)gapAnalysis);
            if (list.size() > 0) {
                for (int i = 0; i < list.size(); ++i) {
                    String prop = (String)list.get(i);
                    list.set(i, "\u201c" + prop + "\u201d");
                }
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u91cd\u5b9a\u4ef7\u7f3a\u53e3\u5206\u6790\u201c%s\u201d\u5df2\u53d1\u751f\u53d8\u52a8\uff0c\u8bf7\u5148\u8ba1\u7b97\u5173\u8054\u7684\u91cd\u5b9a\u4ef7\u7f3a\u53e3\u518d\u8fdb\u884c\u654f\u611f\u6027\u5206\u6790\u8ba1\u7b97\u3002", (String)"SensitivityAnalysisEdit_5", (String)"tmc-mrm-formplugin", (Object[])new Object[]{String.join((CharSequence)"\u3001", list)}));
                return;
            }
            this.getModel().setValue("reporttitiles", (Object)"");
            this.setDraftDate();
            this.calc();
        }
        if ("save".equals(e.getOperateKey()) && e.getOperationResult().isSuccess()) {
            this.refreshReport();
        }
        if ("querydetail".equals(e.getOperateKey())) {
            SensitivityAnalysisHelper.showExRateGapDetailList((IFormView)this.getView(), null);
        }
    }

    private void setDraft() {
        DynamicObject gapAnalysis = (DynamicObject)this.getModel().getValue("gapanalysis");
        DynamicObject analysisObj = gapAnalysis.getDynamicObject("currentanalysisobj");
        if (analysisObj != null) {
            analysisObj = QueryServiceHelper.queryOne((String)"mrm_analysisobj", (String)"draft", (QFilter[])new QFilter("id", "=", analysisObj.getPkValue()).toArray());
            this.getModel().setValue("draft", analysisObj.get("draft"));
        }
    }

    private void validateMustInput(String key) {
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue(key))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c%s\u201d\u3002", (String)"SensitivityAnalysisEdit_10", (String)"tmc-mrm-formplugin", (Object[])new Object[]{this.getModel().getProperty(key).getDisplayName().getLocaleValue()}));
        }
    }

    private void calc() {
        this.setDraft();
        this.getModel().setValue("entrycurrency", this.getModel().getValue("reportcurrency"));
        DynamicObject gapAnalysis = (DynamicObject)this.getModel().getValue("gapanalysis");
        DynamicObject sectionCfg = gapAnalysis.getDynamicObject("sectioncfg");
        sectionCfg = TmcDataServiceHelper.loadSingle((Object)sectionCfg.getPkValue(), (String)"mrm_section_cfg");
        if (this.isSectionCfgChanged(sectionCfg)) {
            this.setPeriodAndSection();
        }
        this.setObjModifyTime();
        DynamicObjectCollection scenarioSimulationCol = (DynamicObjectCollection)this.getModel().getValue("scenariosimulation");
        DynamicObject[] gapAnalysisDetails = BusinessDataServiceHelper.load((String)"mrm_gap_analysis_detail", (String)"srcbillid,section,subject,subjecttype,sectionindex,currency,draftdata,datatype,entrycurrency,capcashflowno,date,nextdate,amount,ruledesc,gapamount,gapdate,gapamount", (QFilter[])new QFilter("srcbillid", "=", gapAnalysis.getPkValue()).toArray());
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("id"))) {
            this.getModel().setValue("id", (Object)DBServiceHelper.genGlobalLongId());
        }
        ArrayList<DynamicObject[]> senAnalysisDetailList = new ArrayList<DynamicObject[]>(4);
        DynamicObject analysisObj = gapAnalysis.getDynamicObject("currentanalysisobj");
        DynamicObjectCollection col = QueryServiceHelper.query((String)"mrm_analysisobj", (String)"draft.draftcreatetime", (QFilter[])new QFilter("id", "=", analysisObj.getPkValue()).toArray());
        Date draftTime = ((DynamicObject)col.get(0)).getDate("draft.draftcreatetime");
        Date draftDate = DateUtils.truncateDate((Date)draftTime);
        Date evaluateEndDate = this.getEvaluateEndDate(draftDate);
        boolean isContains = true;
        DynamicObjectCollection sectionEntry = sectionCfg.getDynamicObjectCollection("sectionentry");
        for (int i = 1; i < sectionEntry.size(); ++i) {
            if (!((DynamicObject)sectionEntry.get(i)).getString("left").equals(this.getModel().getValue("period"))) continue;
            isContains = ((DynamicObject)sectionEntry.get(i - 1)).getBoolean("iscontains");
        }
        String scenarioType = (String)this.getModel().getValue("scenariotype");
        ScenarioSimulationService scenarioSimulationService = null;
        boolean isEmpty = true;
        HashSet tipPairs = new HashSet(8);
        for (DynamicObject scenarioSimulation : scenarioSimulationCol) {
            DynamicObject[] senAnalysisDetails = new DynamicObject[gapAnalysisDetails.length];
            for (int i = 0; i < gapAnalysisDetails.length; ++i) {
                senAnalysisDetails[i] = BusinessDataServiceHelper.newDynamicObject((String)"mrm_sens_analysis_detail");
                senAnalysisDetails[i].set("srcbillid", gapAnalysisDetails[i].get("srcbillid"));
                senAnalysisDetails[i].set("section", gapAnalysisDetails[i].get("section"));
                senAnalysisDetails[i].set("subject", gapAnalysisDetails[i].get("subject"));
                senAnalysisDetails[i].set("currency", gapAnalysisDetails[i].get("currency"));
                senAnalysisDetails[i].set("subjecttype", gapAnalysisDetails[i].get("subjecttype"));
                senAnalysisDetails[i].set("sectionindex", gapAnalysisDetails[i].get("sectionindex"));
                senAnalysisDetails[i].set("sensitivityanalysis", this.getModel().getValue("id"));
                senAnalysisDetails[i].set("sensitivitycurrency", this.getModel().getValue("reportcurrency"));
            }
            long scenarioSimulationId = scenarioSimulation.getDynamicObject("fbasedataid").getLong("id");
            if (scenarioSimulationService == null) {
                scenarioSimulationService = new ScenarioSimulationService(draftDate, Long.valueOf(scenarioSimulationId));
            } else {
                scenarioSimulationService.changeScenario(Long.valueOf(scenarioSimulationId));
            }
            boolean b = SensitivityAnalysisService.analysis(tipPairs, (Date)draftDate, (Date)evaluateEndDate, (Boolean)isContains, (DynamicObject[])gapAnalysisDetails, (DynamicObject[])senAnalysisDetails, (ScenarioSimulationService)scenarioSimulationService, (Long)scenarioSimulationId, (String)scenarioType, (DynamicObject)((DynamicObject)this.getModel().getValue("reportcurrency")), (DynamicObject)((DynamicObject)this.getModel().getValue("forexquote")));
            senAnalysisDetailList.add(senAnalysisDetails);
            if (b) continue;
            isEmpty = false;
        }
        if (!tipPairs.isEmpty()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d27\u5e01\u5bf9\u201c%1$s\u201d\u5728\u5916\u6c47\u62a5\u4ef7\u201c%2$s\u201d\u4e2d\u672a\u8bbe\u7f6e\u62a5\u4ef7\u65b9\u5f0f\uff0c\u8bf7\u5148\u8bbe\u7f6e\u3002", (String)"GapAnalysisModel_5", (String)"tmc-mrm-business", (Object[])new Object[0]), String.join((CharSequence)"\u3001", tipPairs), ((DynamicObject)this.getModel().getValue("forexquote")).getString("number")));
        }
        if (isEmpty) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u654f\u611f\u6027\u8ba1\u7b97\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u91cd\u5b9a\u4ef7\u7f3a\u53e3\u5206\u6790\u62a5\u544a\u3002", (String)"SensitivityAnalysisEdit_3", (String)"tmc-mrm-formplugin", (Object[])new Object[0]));
        }
        this.saveResult(senAnalysisDetailList);
        this.getModel().setDataChanged(false);
    }

    private boolean isSectionCfgChanged(DynamicObject sectionCfg) {
        DynamicObjectCollection sectionEntry = sectionCfg.getDynamicObjectCollection("sectionentry");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)sectionEntry)) {
            return true;
        }
        if (!this.getModel().getValue("periodunit").equals(((DynamicObject)sectionEntry.get(0)).get("unit"))) {
            return true;
        }
        String periodItemStr = (String)this.getModel().getValue("perioditems");
        String[] itemArray = periodItemStr.split(",");
        if (itemArray.length != sectionEntry.size() - 1) {
            return true;
        }
        for (int i = 0; i < this.getModel().getEntryEntity("entryentity").size(); ++i) {
            if (this.getModel().getValue("sectiondesc", i).equals(((DynamicObject)sectionEntry.get(i)).getString("sectiondesc"))) continue;
            return true;
        }
        return false;
    }

    private void setObjModifyTime() {
        this.getModel().setValue("forexquotetime", ((DynamicObject)this.getModel().getValue("forexquote")).get("modifytime"));
        this.getModel().setValue("gapanalysistime", ((DynamicObject)this.getModel().getValue("gapanalysis")).get("modifytime"));
        this.getModel().deleteEntryData("scensimutimeentry");
        DynamicObjectCollection scenarioSimulationCol = (DynamicObjectCollection)this.getModel().getValue("scenariosimulation");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)scenarioSimulationCol)) {
            for (DynamicObject scenarioSimulation : scenarioSimulationCol) {
                int index = this.getModel().createNewEntryRow("scensimutimeentry");
                this.getModel().setValue("e_scenariosimulation", (Object)scenarioSimulation.getDynamicObject("fbasedataid"), index);
                this.getModel().setValue("e_scenariosimulationtime", scenarioSimulation.getDynamicObject("fbasedataid").get("modifytime"), index);
            }
        }
    }

    private void saveResult(List<DynamicObject[]> senAnalysisDetailList) {
        DeleteServiceHelper.delete((String)"mrm_sens_analysis_detail", (QFilter[])new QFilter("sensitivityanalysis", "=", this.getModel().getValue("id")).toArray());
        for (DynamicObject[] senAnalysisDetails : senAnalysisDetailList) {
            SaveServiceHelper.save((DynamicObject[])senAnalysisDetails);
        }
        this.getView().invokeOperation("save");
    }

    private Date getEvaluateEndDate(Date draftDate) {
        String unit = (String)this.getModel().getValue("periodunit");
        int period = Integer.parseInt((String)this.getModel().getValue("period"));
        if ("m".equals(unit)) {
            return DateUtils.getNextMonth((Date)draftDate, (int)period);
        }
        if ("d".equals(unit)) {
            return DateUtils.getNextDay((Date)draftDate, (int)period);
        }
        return DateUtils.getNextYear((Date)draftDate, (int)period);
    }

    private void setEntryColumnHeader(String[] titles) {
        if (titles == null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"entryentity1", "entryentity2"});
            return;
        }
        boolean b = this.isOnlyCalcInterestChange();
        this.getView().setVisible(Boolean.valueOf(b), new String[]{"entryentity2"});
        this.getView().setVisible(Boolean.valueOf(!b), new String[]{"entryentity1"});
        String entryKey = b ? "entryentity2" : "entryentity1";
        String columnKey = b ? "scen" : "scenariosi";
        String[] showColumnKeys = new String[titles.length];
        for (int i = 1; i <= titles.length; ++i) {
            ((EntryGrid)this.getView().getControl(entryKey)).setColumnProperty(columnKey + i, "header", (Object)new LocaleString(titles[i - 1]));
            showColumnKeys[i - 1] = columnKey + i;
        }
        this.getView().setVisible(Boolean.valueOf(true), showColumnKeys);
        int MAX_COUNT = 5;
        if (MAX_COUNT > titles.length) {
            String[] hiddenColumnKeys = new String[MAX_COUNT - titles.length];
            for (int i = titles.length + 1; i <= MAX_COUNT; ++i) {
                hiddenColumnKeys[i - titles.length - 1] = columnKey + i;
            }
            this.getView().setVisible(Boolean.valueOf(false), hiddenColumnKeys);
        }
    }

    private void onChangeGapAnalysis() {
        DynamicObject gapAnalysis = (DynamicObject)this.getModel().getValue("gapanalysis");
        if (gapAnalysis != null) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"reportcurrency", (Object)gapAnalysis.getDynamicObject("reportcurrency"));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"forexquote", (Object)gapAnalysis.getDynamicObject("forexquote"));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"amtunit", (Object)gapAnalysis.getString("amtunit"));
            this.setDraftDate();
            this.setPeriodAndSection();
        } else {
            TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String[])new String[]{"reportcurrency", "forexquote", "amtunit"});
        }
    }

    private void setDraftDate() {
        DynamicObject gapAnalysis = (DynamicObject)this.getModel().getValue("gapanalysis");
        if (gapAnalysis != null) {
            DynamicObject draft = QueryServiceHelper.queryOne((String)"mrm_gap_analysis", (String)"draft.draftcreatetime", (QFilter[])new QFilter("id", "=", gapAnalysis.getPkValue()).toArray());
            if (draft != null) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"draftdate", (Object)draft.get("draft.draftcreatetime"));
            } else {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"draftdate", null);
            }
        }
    }

    private void setPeriodAndSection() {
        DynamicObject gapAnalysis = (DynamicObject)this.getModel().getValue("gapanalysis");
        if (gapAnalysis == null) {
            return;
        }
        DynamicObject sectionCfg = gapAnalysis.getDynamicObject("sectioncfg");
        DynamicObjectCollection sectionEntry = (sectionCfg = TmcDataServiceHelper.loadSingle((Object)sectionCfg.getPkValue(), (String)"mrm_section_cfg")).getDynamicObjectCollection("sectionentry");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)sectionEntry)) {
            return;
        }
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"period", (Object)((DynamicObject)sectionEntry.get(sectionEntry.size() - 1)).get("left"));
        this.getModel().setValue("periodunit", ((DynamicObject)sectionEntry.get(0)).get("unit"));
        List periodItems = sectionEntry.stream().filter(e -> e.getInt("left") > 0).map(e -> e.getString("left")).collect(Collectors.toList());
        this.getModel().setValue("perioditems", (Object)String.join((CharSequence)",", periodItems));
        sectionEntry.remove(sectionEntry.size() - 1);
        List sections = sectionEntry.stream().map(e -> e.getString("sectiondesc")).collect(Collectors.toList());
        this.getModel().setValue("sections", (Object)String.join((CharSequence)";", sections));
        this.setSection();
        this.initPeriodItems();
    }

    private void setSection() {
        String periodItems = (String)this.getModel().getValue("perioditems");
        String sections = (String)this.getModel().getValue("sections");
        int period = Integer.parseInt((String)this.getModel().getValue("period"));
        String[] periodItemArray = periodItems.split(",");
        String[] sectionArray = sections.split(";");
        this.getModel().deleteEntryData("entryentity");
        for (int i = 0; i < periodItemArray.length; ++i) {
            if (period < Integer.parseInt(periodItemArray[i])) continue;
            int index = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("sectiondesc", (Object)sectionArray[i], index);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String property = event.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        switch (property) {
            case "orgview": {
                DataSet ds = TmcOrgDataHelper.getAuthorizedBankOrgViewDataSet((Long)RequestContext.get().getCurrUserId());
                HashSet<Long> ids = new HashSet<Long>(16);
                while (ds.hasNext()) {
                    ids.add(ds.next().getLong("id"));
                }
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", ids));
                break;
            }
            case "orgs": {
                List orgIds;
                String appId = this.getView().getFormShowParameter().getAppId();
                List<Object> list = orgIds = OrgHelper.getPermOrgIds(null, null, (String)OrgViewTypeEnum.IS_BANKROLL.getViewType(), (String)appId, (String)"mrm_sensitivity");
                DynamicObject orgView = (DynamicObject)this.getModel().getValue("orgview");
                if (orgView != null) {
                    Long orgViewId = orgView.getLong("id");
                    String rootOrgId = this.getPageCache().get("orgs");
                    if (EmptyUtil.isNoEmpty((String)rootOrgId)) {
                        List allOrgIds = TmcOrgDataHelper.getAllSubordinateOrgs((Long)orgViewId, Collections.singletonList(Long.valueOf(rootOrgId)), (boolean)true, (boolean)false);
                        allOrgIds.add(Long.valueOf(rootOrgId));
                        list = orgIds == null ? allOrgIds : orgIds.stream().filter(allOrgIds::contains).collect(Collectors.toList());
                    } else {
                        list.clear();
                    }
                }
                if (list == null) break;
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)list));
                break;
            }
            case "gapanalysis": 
            case "scenariosimulation": {
                List orgIds = OrgHelper.getPermOrgIds(null, null, (String)OrgViewTypeEnum.IS_BANKROLL.getViewType(), (String)this.getView().getFormShowParameter().getAppId(), (String)"mrm_gap_analysis");
                if (orgIds == null) break;
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("org", "in", (Object)orgIds));
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        DataEntityState dataEntityState = this.getModel().getDataEntity().getDataEntityState();
        Iterable bizChangedProperties = dataEntityState.getBizChangedProperties();
        HashSet changedProps = new HashSet();
        bizChangedProperties.forEach(o -> changedProps.add(o.getName().split("_")[0]));
        Arrays.asList(IGNORE_PROPS).forEach(changedProps::remove);
        this.getModel().setDataChanged(false);
        if (!changedProps.isEmpty()) {
            for (String changedProp : changedProps) {
                Object value = this.getModel().getValue(changedProp);
                if (!(value instanceof OrmLocaleValue)) {
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)changedProp, null);
                }
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)changedProp, (Object)value);
            }
        }
    }
}

