/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.formplugin.sensitivityanalysis;

import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.IFormView;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ChartClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mrm.common.enums.ScenarioTypeEnum;
import kd.tmc.mrm.common.helper.OrgHelper;
import kd.tmc.mrm.common.helper.SensitivityAnalysisHelper;

public class SensitivityHistogramChartPlugin
extends AbstractBillPlugIn
implements TabSelectListener {
    private static final String CHART_PROP = "chart";
    private static final String INTEREST_CHANGE_CHART_PROP = "interestchangechart";
    List<String> categories;
    private List<BigDecimal> before;
    private List<BigDecimal> after;
    private List<BigDecimal> changed;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ((Tab)this.getView().getControl("tabAp")).addTabSelectListener((TabSelectListener)this);
        this.addClickListeners(new String[]{CHART_PROP, INTEREST_CHANGE_CHART_PROP, "view"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"btnpanel", "chartpanel"});
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"btnpanel", "chartpanel"});
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.refreshChart();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void tabSelected(TabSelectEvent e) {
        this.refreshChart();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        switch (name = e.getProperty().getName()) {
            case "orgview": 
            case "amtunit": 
            case "currency": 
            case "referencerate": 
            case "orgs": 
            case "subjecttypefilter": {
                if (!EmptyUtil.isNoEmpty((Object)this.getModel().getValue("amtunit"))) break;
                this.refreshChart();
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("save".equals(e.getOperateKey())) {
            this.refreshChart();
        }
    }

    private void refreshChart() {
        HistogramChart chart;
        if (BillOperationStatus.ADDNEW == ((BillShowParameter)this.getView().getFormShowParameter()).getBillStatus() || !"tabpagechart".equalsIgnoreCase(((Tab)this.getView().getControl("tabAp")).getCurrentTab())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btnpanel", "chartpanel"});
            return;
        }
        if (EmptyUtil.isNoEmpty((Object)this.getModel().getValue("reporttitiles"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btnpanel", "chartpanel"});
            return;
        }
        DynamicObject dbObj = QueryServiceHelper.queryOne((String)this.getModel().getDataEntityType().getName(), (String)"scenariotype", (QFilter[])new QFilter("id", "=", this.getModel().getDataEntity().getPkValue()).toArray());
        boolean isOnlyCalcInterestChange = ScenarioTypeEnum.INTEREST_CHANGE.getValue().equals(dbObj.get("scenariotype"));
        boolean b = this.queryData();
        if (!b) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btnpanel", "chartpanel"});
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"btnpanel", "chartpanel"});
        if (isOnlyCalcInterestChange) {
            chart = (HistogramChart)this.getControl(INTEREST_CHANGE_CHART_PROP);
            this.getView().setVisible(Boolean.TRUE, new String[]{INTEREST_CHANGE_CHART_PROP});
            this.getView().setVisible(Boolean.FALSE, new String[]{CHART_PROP});
        } else {
            chart = (HistogramChart)this.getControl(CHART_PROP);
            this.getView().setVisible(Boolean.TRUE, new String[]{CHART_PROP});
            this.getView().setVisible(Boolean.FALSE, new String[]{INTEREST_CHANGE_CHART_PROP});
        }
        chart.clearData();
        this.setStyle(chart);
        this.createYAxis(chart);
        this.createXAxis(chart);
        this.setData(chart, isOnlyCalcInterestChange);
    }

    private void setStyle(HistogramChart chart) {
        chart.setMargin(Position.left, "30px");
        chart.setMargin(Position.right, "30px");
        chart.setMargin(Position.top, "50px");
        chart.setMargin(Position.bottom, "22px");
        chart.setShowLegend(true);
        chart.setLegendPropValue("itemWidth", (Object)10);
        chart.setLegendPropValue("itemHeight", (Object)10);
        chart.setLegendAlign(XAlign.center, YAlign.top);
        chart.setLegendVertical(false);
        chart.setShowTooltip(true);
    }

    private boolean queryData() {
        String appId = this.getView().getFormShowParameter().getServiceAppId();
        BigDecimal amtUnit = EmptyUtil.isNoEmpty((Object)this.getView().getModel().getValue("amtunit")) ? new BigDecimal((String)this.getView().getModel().getValue("amtunit")) : BigDecimal.ONE;
        DynamicObject orgView = (DynamicObject)this.getView().getModel().getValue("orgview");
        DynamicObjectCollection orgCol = (DynamicObjectCollection)this.getView().getModel().getValue("orgs");
        List orgIds = OrgHelper.getPermOrgIds((DynamicObject)orgView, (DynamicObjectCollection)orgCol, (String)((MulBasedataProp)((MulBasedataEdit)this.getView().getControl("orgs")).getProperty()).getOrgFunc(), (String)appId, (String)"mrm_sensitivity");
        MulBasedataDynamicObjectCollection referenceRateCol = (MulBasedataDynamicObjectCollection)this.getView().getModel().getValue("referencerate");
        Set referenceRateIdSet = referenceRateCol.stream().map(o -> o.getDynamicObject("fBaseDataId").getLong("id")).collect(Collectors.toSet());
        MulBasedataDynamicObjectCollection currencyCol = (MulBasedataDynamicObjectCollection)this.getView().getModel().getValue("currency");
        Set currencyIdSet = currencyCol.stream().map(o -> o.getDynamicObject("fBaseDataId").getLong("id")).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("sensitivityanalysis", "=", this.getView().getModel().getValue("id"));
        qFilter.and("sectionIndex", "<", (Object)this.getView().getModel().getEntryEntity("entryentity").size());
        String subjectTypeFilter = (String)this.getModel().getValue("subjectTypeFilter");
        if (EmptyUtil.isNoEmpty(referenceRateIdSet)) {
            qFilter.and("entryEntity.draftData.referenceRate", "in", referenceRateIdSet);
        }
        if (EmptyUtil.isNoEmpty(currencyIdSet)) {
            qFilter.and("entryEntity.entryCurrency", "in", currencyIdSet);
        }
        if (orgIds != null) {
            qFilter.and("entryEntity.draftData.org", "in", (Object)orgIds);
        }
        qFilter.and("entryEntity.changeAmt", "!=", (Object)0);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"GapQingAnalysisDataPlugin", (String)"mrm_sens_analysis_detail", (String)String.join((CharSequence)",", "subjectType", "sectionIndex", "scenarioSimulationF7.number as scenario", "entryEntity.beforeAmount as beforeAmount", "entryEntity.afterAmount as afterAmount", "entryEntity.changeAmt as changeAmt"), (QFilter[])qFilter.toArray(), null);
        if (dataSet.isEmpty()) {
            return false;
        }
        if (EmptyUtil.isNoEmpty((String)subjectTypeFilter)) {
            dataSet = dataSet.filter(String.format("subjectType = '%s'", subjectTypeFilter));
        }
        dataSet = dataSet.updateField("beforeAmount", "beforeAmount/" + amtUnit).updateField("afterAmount", "afterAmount/" + amtUnit).updateField("changeAmt", "changeAmt/" + amtUnit);
        dataSet = dataSet.groupBy(new String[]{"scenario"}).sum("beforeAmount").sum("afterAmount").sum("changeAmt").finish();
        this.categories = new ArrayList<String>(10);
        this.before = new ArrayList<BigDecimal>(10);
        this.after = new ArrayList<BigDecimal>(10);
        this.changed = new ArrayList<BigDecimal>(10);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            this.categories.add(row.getString("scenario"));
            this.before.add(row.getBigDecimal("beforeAmount"));
            this.after.add(row.getBigDecimal("afterAmount"));
            this.changed.add(row.getBigDecimal("changeAmt"));
        }
        return true;
    }

    private void createYAxis(HistogramChart chart) {
        Axis xAxis = chart.createXAxis("", AxisType.category);
        xAxis.setCategorys(this.categories);
        xAxis.setPropValue("nameGap", (Object)"5");
        HashMap<String, Constable> axisTick = new HashMap<String, Constable>();
        axisTick.put("interval", Integer.valueOf(0));
        axisTick.put("show", Boolean.valueOf(false));
        xAxis.setPropValue("axisTick", axisTick);
        this.setLineColor(xAxis);
    }

    private void createXAxis(HistogramChart chart) {
        Axis yAxis = chart.createYAxis("", AxisType.value);
        yAxis.setPropValue("nameGap", (Object)"5");
        HashMap<String, int[]> map = new HashMap<String, int[]>();
        map.put("padding", new int[]{0, 0, 5, -45});
        yAxis.setPropValue("nameTextStyle", map);
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>();
        axisTick.put("show", false);
        yAxis.setPropValue("axisTick", axisTick);
        HashMap splitLine = new HashMap();
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        yAxis.setPropValue("splitLine", splitLine);
        this.setLineColor(yAxis);
    }

    private void setData(HistogramChart chart, boolean isOnlyCalcInterestChange) {
        if (!isOnlyCalcInterestChange) {
            BarSeries barSeries1 = this.createBarSeries(chart, ResManager.loadKDString((String)"\u53d8\u52a8\u524d\u5229\u606f\u6536\u652f", (String)"SensitivityHistogramChartPlugin_0", (String)"tmc-mrm-formplugin", (Object[])new Object[0]), "#20A7F0");
            barSeries1.setData((Number[])this.before.toArray(new BigDecimal[0]));
            BarSeries barSeries2 = this.createBarSeries(chart, ResManager.loadKDString((String)"\u53d8\u52a8\u540e\u5229\u606f\u6536\u652f", (String)"SensitivityHistogramChartPlugin_1", (String)"tmc-mrm-formplugin", (Object[])new Object[0]), "#45DAD1");
            barSeries2.setData((Number[])this.after.toArray(new BigDecimal[0]));
        }
        BarSeries barSeries3 = this.createBarSeries(chart, ResManager.loadKDString((String)"\u5229\u606f\u53d8\u52a8\u503c", (String)"SensitivityHistogramChartPlugin_2", (String)"tmc-mrm-formplugin", (Object[])new Object[0]), "#A0D911");
        barSeries3.setData((Number[])this.changed.toArray(new BigDecimal[0]));
        chart.bindData(null);
    }

    private BarSeries createBarSeries(HistogramChart chart, String name, String color) {
        BarSeries barSeries = chart.createBarSeries(name);
        barSeries.setBarWidth("25px");
        barSeries.setAnimationDuration(1500);
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, HashMap<String, String>> itemStyle = new HashMap<String, HashMap<String, String>>();
        map.put("color", String.format("new echarts.graphic.LinearGradient(0, 0, 0, 1, [{\"offset\": 0,\"color\": '%s'}, {\"offset\": 1, \"color\": '%s'}])", color, color));
        itemStyle.put("normal", map);
        barSeries.setPropValue("itemStyle", itemStyle);
        ArrayList<String> list = new ArrayList<String>();
        list.add("itemStyle");
        list.add("normal");
        list.add("color");
        barSeries.addFuncPath(list);
        barSeries.setLabel(null);
        return barSeries;
    }

    private void setLineColor(Axis axis) {
        HashMap axisLineMap = new HashMap();
        HashMap<String, String> lineStyleMap = new HashMap<String, String>();
        lineStyleMap.put("color", "#999999");
        axisLineMap.put("lineStyle", lineStyleMap);
        axis.setPropValue("axisLine", axisLineMap);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (CHART_PROP.equalsIgnoreCase(key) || INTEREST_CHANGE_CHART_PROP.equalsIgnoreCase(key)) {
            String scenario = ((ChartClickEvent)evt).getName();
            if (EmptyUtil.isEmpty((String)scenario)) {
                return;
            }
            QFilter qFilter = new QFilter("scenarioSimulationF7.number", "=", (Object)scenario);
            SensitivityAnalysisHelper.showExRateGapDetailList((IFormView)this.getView(), (QFilter)qFilter);
        }
        if ("view".equalsIgnoreCase(key)) {
            SensitivityAnalysisHelper.showExRateGapDetailList((IFormView)this.getView(), null);
        }
    }
}

